/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.relauncher;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.asm.ASMTransformerWrapper;
import net.minecraftforge.fml.common.asm.transformers.ModAccessTransformer;
import net.minecraftforge.fml.common.launcher.FMLInjectionAndSortingTweaker;
import net.minecraftforge.fml.common.launcher.FMLTweaker;
import net.minecraftforge.fml.common.toposort.TopologicalSort;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.FMLRelaunchLog;
import net.minecraftforge.fml.relauncher.FileListHelper;
import net.minecraftforge.fml.relauncher.IFMLCallHook;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import net.minecraftforge.fml.relauncher.ModListHelper;
import org.apache.logging.log4j.Level;

public class CoreModManager {
    private static final Attributes.Name COREMODCONTAINSFMLMOD = new Attributes.Name("FMLCorePluginContainsFMLMod");
    private static final Attributes.Name MODTYPE = new Attributes.Name("ModType");
    private static final Attributes.Name MODSIDE = new Attributes.Name("ModSide");
    private static String[] rootPlugins = new String[]{"net.minecraftforge.fml.relauncher.FMLCorePlugin", "net.minecraftforge.classloading.FMLForgePlugin"};
    private static List<String> loadedCoremods = Lists.newArrayList();
    private static Map<String, List<String>> transformers = Maps.newHashMap();
    private static List<FMLPluginWrapper> loadPlugins;
    private static boolean deobfuscatedEnvironment;
    private static FMLTweaker tweaker;
    private static File mcDir;
    private static List<String> reparsedCoremods;
    private static List<String> accessTransformers;
    private static Set<String> rootNames;
    private static Method ADDURL;
    private static Map<String, Integer> tweakSorting;

    public static void handleLaunch(File mcDir, LaunchClassLoader classLoader, FMLTweaker tweaker) {
        CoreModManager.mcDir = mcDir;
        CoreModManager.tweaker = tweaker;
        try {
            byte[] bs = classLoader.getClassBytes("net.minecraft.world.World");
            if (bs != null) {
                FMLRelaunchLog.info("Managed to load a deobfuscated Minecraft name- we are in a deobfuscated environment. Skipping runtime deobfuscation", new Object[0]);
                deobfuscatedEnvironment = true;
            }
        }
        catch (IOException e1) {
            // empty catch block
        }
        if (!deobfuscatedEnvironment) {
            FMLRelaunchLog.fine("Enabling runtime deobfuscation", new Object[0]);
        }
        tweaker.injectCascadingTweak("net.minecraftforge.fml.common.launcher.FMLInjectionAndSortingTweaker");
        try {
            classLoader.registerTransformer("net.minecraftforge.fml.common.asm.transformers.PatchingTransformer");
        }
        catch (Exception e) {
            FMLRelaunchLog.log(Level.ERROR, e, "The patch transformer failed to load! This is critical, loading cannot continue!", new Object[0]);
            throw Throwables.propagate((Throwable)e);
        }
        loadPlugins = new ArrayList<FMLPluginWrapper>();
        for (String rootPluginName : rootPlugins) {
            CoreModManager.loadCoreMod(classLoader, rootPluginName, new File(FMLTweaker.getJarLocation()));
        }
        if (loadPlugins.isEmpty()) {
            throw new RuntimeException("A fatal error has occured - no valid fml load plugin was found - this is a completely corrupt FML installation.");
        }
        FMLRelaunchLog.fine("All fundamental core mods are successfully located", new Object[0]);
        String commandLineCoremods = System.getProperty("fml.coreMods.load", "");
        for (String coreModClassName : commandLineCoremods.split(",")) {
            if (coreModClassName.isEmpty()) continue;
            FMLRelaunchLog.info("Found a command line coremod : %s", coreModClassName);
            CoreModManager.loadCoreMod(classLoader, coreModClassName, null);
        }
        CoreModManager.discoverCoreMods(mcDir, classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void discoverCoreMods(File mcDir, LaunchClassLoader classLoader) {
        ModListHelper.parseModList(mcDir);
        FMLRelaunchLog.fine("Discovering coremods", new Object[0]);
        File coreMods = CoreModManager.setupCoreModDir(mcDir);
        FilenameFilter ff = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        };
        FilenameFilter derpfilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar.zip");
            }
        };
        File[] derplist = coreMods.listFiles(derpfilter);
        if (derplist != null && derplist.length > 0) {
            FMLRelaunchLog.severe("FML has detected several badly downloaded jar files,  which have been named as zip files. You probably need to download them again, or they may not work properly", new Object[0]);
            for (File f : derplist) {
                FMLRelaunchLog.severe("Problem file : %s", f.getName());
            }
        }
        Object[] coreModList = coreMods.listFiles(ff);
        File versionedModDir = new File(coreMods, FMLInjectionData.mccversion);
        if (versionedModDir.isDirectory()) {
            Object[] versionedCoreMods = versionedModDir.listFiles(ff);
            coreModList = (File[])ObjectArrays.concat((Object[])coreModList, (Object[])versionedCoreMods, File.class);
        }
        coreModList = (File[])ObjectArrays.concat((Object[])coreModList, (Object[])ModListHelper.additionalMods.values().toArray(new File[0]), File.class);
        for (Object coreMod : coreModList = FileListHelper.sortFileList((File[])coreModList)) {
            String modSide;
            ImmutableList modTypes;
            Attributes mfAttributes;
            FMLRelaunchLog.fine("Examining for coremod candidacy %s", ((File)coreMod).getName());
            JarFile jar = null;
            try {
                jar = new JarFile((File)coreMod);
                if (jar.getManifest() == null) continue;
                ModAccessTransformer.addJar(jar);
                mfAttributes = jar.getManifest().getMainAttributes();
            }
            catch (IOException ioe) {
                FMLRelaunchLog.log(Level.ERROR, ioe, "Unable to read the jar file %s - ignoring", ((File)coreMod).getName());
                continue;
            }
            finally {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException e) {}
                }
            }
            String cascadedTweaker = mfAttributes.getValue("TweakClass");
            if (cascadedTweaker != null) {
                FMLRelaunchLog.info("Loading tweaker %s from %s", cascadedTweaker, ((File)coreMod).getName());
                Integer sortOrder = Ints.tryParse((String)Strings.nullToEmpty((String)mfAttributes.getValue("TweakOrder")));
                sortOrder = sortOrder == null ? Integer.valueOf(0) : sortOrder;
                CoreModManager.handleCascadingTweak((File)coreMod, jar, cascadedTweaker, classLoader, sortOrder);
                loadedCoremods.add(((File)coreMod).getName());
                continue;
            }
            Object object = modTypes = mfAttributes.containsKey(MODTYPE) ? Arrays.asList(mfAttributes.getValue(MODTYPE).split(",")) : ImmutableList.of((Object)"FML");
            if (!modTypes.contains("FML")) {
                FMLRelaunchLog.fine("Adding %s to the list of things to skip. It is not an FML mod,  it has types %s", ((File)coreMod).getName(), modTypes);
                loadedCoremods.add(((File)coreMod).getName());
                continue;
            }
            String string = modSide = mfAttributes.containsKey(MODSIDE) ? mfAttributes.getValue(MODSIDE) : "BOTH";
            if (!"BOTH".equals(modSide) && !FMLLaunchHandler.side.name().equals(modSide)) {
                FMLRelaunchLog.fine("Mod %s has ModSide meta-inf value %s, and we're %s. It will be ignored", ((File)coreMod).getName(), modSide, FMLLaunchHandler.side.name());
                loadedCoremods.add(((File)coreMod).getName());
                continue;
            }
            String fmlCorePlugin = mfAttributes.getValue("FMLCorePlugin");
            if (fmlCorePlugin == null) {
                FMLRelaunchLog.fine("Not found coremod data in %s", ((File)coreMod).getName());
                continue;
            }
            try {
                classLoader.addURL(((File)coreMod).toURI().toURL());
                if (!mfAttributes.containsKey(COREMODCONTAINSFMLMOD)) {
                    FMLRelaunchLog.finer("Adding %s to the list of known coremods, it will not be examined again", ((File)coreMod).getName());
                    loadedCoremods.add(((File)coreMod).getName());
                } else {
                    FMLRelaunchLog.finer("Found FMLCorePluginContainsFMLMod marker in %s, it will be examined later for regular @Mod instances", ((File)coreMod).getName());
                    reparsedCoremods.add(((File)coreMod).getName());
                }
            }
            catch (MalformedURLException e) {
                FMLRelaunchLog.log(Level.ERROR, e, "Unable to convert file into a URL. weird", new Object[0]);
                continue;
            }
            CoreModManager.loadCoreMod(classLoader, fmlCorePlugin, (File)coreMod);
        }
    }

    private static void handleCascadingTweak(File coreMod, JarFile jar, String cascadedTweaker, LaunchClassLoader classLoader, Integer sortingOrder) {
        try {
            if (ADDURL == null) {
                ADDURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                ADDURL.setAccessible(true);
            }
            ADDURL.invoke((Object)classLoader.getClass().getClassLoader(), coreMod.toURI().toURL());
            classLoader.addURL(coreMod.toURI().toURL());
            tweaker.injectCascadingTweak(cascadedTweaker);
            tweakSorting.put(cascadedTweaker, sortingOrder);
        }
        catch (Exception e) {
            FMLRelaunchLog.log(Level.INFO, e, "There was a problem trying to load the mod dir tweaker %s", coreMod.getAbsolutePath());
        }
    }

    private static File setupCoreModDir(File mcDir) {
        File coreModDir = new File(mcDir, "mods");
        try {
            coreModDir = coreModDir.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unable to canonicalize the coremod dir at %s", mcDir.getName()), e);
        }
        if (!coreModDir.exists()) {
            coreModDir.mkdir();
        } else if (coreModDir.exists() && !coreModDir.isDirectory()) {
            throw new RuntimeException(String.format("Found a coremod file in %s that's not a directory", mcDir.getName()));
        }
        return coreModDir;
    }

    public static List<String> getLoadedCoremods() {
        return loadedCoremods;
    }

    public static Map<String, List<String>> getTransformers() {
        return transformers;
    }

    public static List<String> getReparseableCoremods() {
        return reparsedCoremods;
    }

    private static FMLPluginWrapper loadCoreMod(LaunchClassLoader classLoader, String coreModClass, File location) {
        String coreModName = coreModClass.substring(coreModClass.lastIndexOf(46) + 1);
        try {
            IFMLLoadingPlugin.SortingIndex index;
            FMLRelaunchLog.fine("Instantiating coremod class %s", coreModName);
            classLoader.addTransformerExclusion(coreModClass);
            Class<?> coreModClazz = Class.forName(coreModClass, true, (ClassLoader)classLoader);
            IFMLLoadingPlugin.Name coreModNameAnn = coreModClazz.getAnnotation(IFMLLoadingPlugin.Name.class);
            if (coreModNameAnn != null && !Strings.isNullOrEmpty((String)coreModNameAnn.value())) {
                coreModName = coreModNameAnn.value();
                FMLRelaunchLog.finer("coremod named %s is loading", coreModName);
            }
            IFMLLoadingPlugin.MCVersion requiredMCVersion = coreModClazz.getAnnotation(IFMLLoadingPlugin.MCVersion.class);
            if (!Arrays.asList(rootPlugins).contains(coreModClass) && (requiredMCVersion == null || Strings.isNullOrEmpty((String)requiredMCVersion.value()))) {
                FMLRelaunchLog.log(Level.WARN, "The coremod %s does not have a MCVersion annotation, it may cause issues with this version of Minecraft", coreModClass);
            } else {
                if (requiredMCVersion != null && !FMLInjectionData.mccversion.equals(requiredMCVersion.value())) {
                    FMLRelaunchLog.log(Level.ERROR, "The coremod %s is requesting minecraft version %s and minecraft is %s. It will be ignored.", coreModClass, requiredMCVersion.value(), FMLInjectionData.mccversion);
                    return null;
                }
                if (requiredMCVersion != null) {
                    FMLRelaunchLog.log(Level.DEBUG, "The coremod %s requested minecraft version %s and minecraft is %s. It will be loaded.", coreModClass, requiredMCVersion.value(), FMLInjectionData.mccversion);
                }
            }
            IFMLLoadingPlugin.TransformerExclusions trExclusions = coreModClazz.getAnnotation(IFMLLoadingPlugin.TransformerExclusions.class);
            if (trExclusions != null) {
                for (String st : trExclusions.value()) {
                    classLoader.addTransformerExclusion(st);
                }
            }
            IFMLLoadingPlugin.DependsOn deplist = coreModClazz.getAnnotation(IFMLLoadingPlugin.DependsOn.class);
            String[] dependencies = new String[]{};
            if (deplist != null) {
                dependencies = deplist.value();
            }
            int sortIndex = (index = coreModClazz.getAnnotation(IFMLLoadingPlugin.SortingIndex.class)) != null ? index.value() : 0;
            IFMLLoadingPlugin plugin = (IFMLLoadingPlugin)coreModClazz.newInstance();
            String accessTransformerClass = plugin.getAccessTransformerClass();
            if (accessTransformerClass != null) {
                FMLRelaunchLog.log(Level.DEBUG, "Added access transformer class %s to enqueued access transformers", accessTransformerClass);
                accessTransformers.add(accessTransformerClass);
            }
            FMLPluginWrapper wrap = new FMLPluginWrapper(coreModName, plugin, location, sortIndex, dependencies);
            loadPlugins.add(wrap);
            FMLRelaunchLog.fine("Enqueued coremod %s", coreModName);
            return wrap;
        }
        catch (ClassNotFoundException cnfe) {
            if (!Lists.newArrayList((Object[])rootPlugins).contains(coreModClass)) {
                FMLRelaunchLog.log(Level.ERROR, cnfe, "Coremod %s: Unable to class load the plugin %s", coreModName, coreModClass);
            } else {
                FMLRelaunchLog.fine("Skipping root plugin %s", coreModClass);
            }
        }
        catch (ClassCastException cce) {
            FMLRelaunchLog.log(Level.ERROR, cce, "Coremod %s: The plugin %s is not an implementor of IFMLLoadingPlugin", coreModName, coreModClass);
        }
        catch (InstantiationException ie2) {
            FMLRelaunchLog.log(Level.ERROR, ie2, "Coremod %s: The plugin class %s was not instantiable", coreModName, coreModClass);
        }
        catch (IllegalAccessException iae) {
            FMLRelaunchLog.log(Level.ERROR, iae, "Coremod %s: The plugin class %s was not accessible", coreModName, coreModClass);
        }
        return null;
    }

    private static void sortCoreMods() {
        TopologicalSort.DirectedGraph<FMLPluginWrapper> sortGraph = new TopologicalSort.DirectedGraph<FMLPluginWrapper>();
        HashMap pluginMap = Maps.newHashMap();
        for (FMLPluginWrapper plug : loadPlugins) {
            sortGraph.addNode(plug);
            pluginMap.put(plug.name, plug);
        }
        for (FMLPluginWrapper plug : loadPlugins) {
            for (String dep : plug.predepends) {
                if (!pluginMap.containsKey(dep)) {
                    FMLRelaunchLog.log(Level.ERROR, "Missing coremod dependency - the coremod %s depends on coremod %s which isn't present.", plug.name, dep);
                    throw new RuntimeException();
                }
                sortGraph.addEdge(plug, (FMLPluginWrapper)pluginMap.get(dep));
            }
        }
        try {
            loadPlugins = TopologicalSort.topologicalSort(sortGraph);
            FMLRelaunchLog.fine("Sorted coremod list %s", loadPlugins);
        }
        catch (Exception e) {
            FMLLog.log(Level.ERROR, e, "There was a problem performing the coremod sort", new Object[0]);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static void injectTransformers(LaunchClassLoader classLoader) {
        Launch.blackboard.put("fml.deobfuscatedEnvironment", deobfuscatedEnvironment);
        tweaker.injectCascadingTweak("net.minecraftforge.fml.common.launcher.FMLDeobfTweaker");
        tweakSorting.put("net.minecraftforge.fml.common.launcher.FMLDeobfTweaker", 1000);
    }

    public static void injectCoreModTweaks(FMLInjectionAndSortingTweaker fmlInjectionAndSortingTweaker) {
        List tweakers = (List)Launch.blackboard.get("Tweaks");
        tweakers.add(0, fmlInjectionAndSortingTweaker);
        for (FMLPluginWrapper wrapper : loadPlugins) {
            tweakers.add(wrapper);
        }
    }

    public static void sortTweakList() {
        List tweakers = (List)Launch.blackboard.get("Tweaks");
        ITweaker[] toSort = tweakers.toArray(new ITweaker[tweakers.size()]);
        Arrays.sort(toSort, new Comparator<ITweaker>(){

            @Override
            public int compare(ITweaker o1, ITweaker o2) {
                Integer first = null;
                Integer second = null;
                if (o1 instanceof FMLInjectionAndSortingTweaker) {
                    first = Integer.MIN_VALUE;
                }
                if (o2 instanceof FMLInjectionAndSortingTweaker) {
                    second = Integer.MIN_VALUE;
                }
                if (o1 instanceof FMLPluginWrapper) {
                    first = ((FMLPluginWrapper)o1).sortIndex;
                } else if (first == null) {
                    first = (Integer)tweakSorting.get(o1.getClass().getName());
                }
                if (o2 instanceof FMLPluginWrapper) {
                    second = ((FMLPluginWrapper)o2).sortIndex;
                } else if (second == null) {
                    second = (Integer)tweakSorting.get(o2.getClass().getName());
                }
                if (first == null) {
                    first = 0;
                }
                if (second == null) {
                    second = 0;
                }
                return Ints.saturatedCast((long)((long)first.intValue() - (long)second.intValue()));
            }
        });
        for (int j2 = 0; j2 < toSort.length; ++j2) {
            tweakers.set(j2, toSort[j2]);
        }
    }

    public static List<String> getAccessTransformers() {
        return accessTransformers;
    }

    public static void onCrash(StringBuilder builder) {
        if (!loadedCoremods.isEmpty() || !reparsedCoremods.isEmpty()) {
            builder.append("\nWARNING: coremods are present:\n");
            for (String coreMod : transformers.keySet()) {
                builder.append("  ").append(coreMod).append('\n');
            }
            builder.append("Contact their authors BEFORE contacting forge\n\n");
        }
    }

    static {
        reparsedCoremods = Lists.newArrayList();
        accessTransformers = Lists.newArrayList();
        rootNames = Sets.newHashSet();
        for (String cls : rootPlugins) {
            rootNames.add(cls.substring(cls.lastIndexOf(46) + 1));
        }
        tweakSorting = Maps.newHashMap();
    }

    private static class FMLPluginWrapper
    implements ITweaker {
        public final String name;
        public final IFMLLoadingPlugin coreModInstance;
        public final List<String> predepends;
        public final File location;
        public final int sortIndex;

        public FMLPluginWrapper(String name, IFMLLoadingPlugin coreModInstance, File location, int sortIndex, String ... predepends) {
            this.name = name;
            this.coreModInstance = coreModInstance;
            this.location = location;
            this.sortIndex = sortIndex;
            this.predepends = Lists.newArrayList((Object[])predepends);
        }

        public String toString() {
            return String.format("%s {%s}", this.name, this.predepends);
        }

        public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
        }

        public void injectIntoClassLoader(LaunchClassLoader classLoader) {
            FMLRelaunchLog.fine("Injecting coremod %s {%s} class transformers", this.name, this.coreModInstance.getClass().getName());
            ArrayList ts = Lists.newArrayList();
            if (this.coreModInstance.getASMTransformerClass() != null) {
                for (String transformer : this.coreModInstance.getASMTransformerClass()) {
                    FMLRelaunchLog.finer("Registering transformer %s", transformer);
                    classLoader.registerTransformer(ASMTransformerWrapper.getTransformerWrapper(classLoader, transformer, this.name));
                    ts.add(transformer);
                }
            }
            if (!rootNames.contains(this.name)) {
                String loc = this.location == null ? "unknown" : this.location.getName();
                transformers.put(this.name + " (" + loc + ")", ts);
            }
            FMLRelaunchLog.fine("Injection complete", new Object[0]);
            FMLRelaunchLog.fine("Running coremod plugin for %s {%s}", this.name, this.coreModInstance.getClass().getName());
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("mcLocation", mcDir);
            data.put("coremodList", loadPlugins);
            data.put("runtimeDeobfuscationEnabled", !deobfuscatedEnvironment);
            FMLRelaunchLog.fine("Running coremod plugin %s", this.name);
            data.put("coremodLocation", this.location);
            this.coreModInstance.injectData(data);
            String setupClass = this.coreModInstance.getSetupClass();
            if (setupClass != null) {
                try {
                    IFMLCallHook call = (IFMLCallHook)Class.forName(setupClass, true, (ClassLoader)classLoader).newInstance();
                    HashMap<String, Object> callData = new HashMap<String, Object>();
                    callData.put("runtimeDeobfuscationEnabled", !deobfuscatedEnvironment);
                    callData.put("mcLocation", mcDir);
                    callData.put("classLoader", classLoader);
                    callData.put("coremodLocation", this.location);
                    callData.put("deobfuscationFileName", FMLInjectionData.debfuscationDataName());
                    call.injectData(callData);
                    call.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            FMLRelaunchLog.fine("Coremod plugin class %s run successfully", this.coreModInstance.getClass().getSimpleName());
            String modContainer = this.coreModInstance.getModContainerClass();
            if (modContainer != null) {
                FMLInjectionData.containers.add(modContainer);
            }
        }

        public String getLaunchTarget() {
            return "";
        }

        public String[] getLaunchArguments() {
            return new String[0];
        }
    }
}

