/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasTransmitter;
import mekanism.api.gas.ITubeConnection;
import mekanism.api.transmitters.TransmissionType;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.grid.IGridNetwork;
import micdoodle8.mods.galacticraft.api.transmission.grid.IHydrogenNetwork;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkProvider;
import micdoodle8.mods.galacticraft.api.transmission.tile.ITransmitter;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerServer;
import micdoodle8.mods.galacticraft.planets.mars.tile.HydrogenNetwork;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityHydrogenPipe
extends TileEntity
implements ITransmitter {
    private IGridNetwork network;
    public TileEntity[] adjacentConnections = null;

    public boolean canUpdate() {
        return this.field_145850_b == null || !this.field_145850_b.field_72995_K;
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K) {
            TickHandlerServer.hydrogenTransmitterUpdates.add(this);
        }
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            this.getNetwork().split((Object)this);
        }
        super.func_145843_s();
    }

    public IGridNetwork getNetwork() {
        if (this.network == null) {
            this.resetNetwork();
        }
        return this.network;
    }

    public void onNetworkChanged() {
    }

    protected void resetNetwork() {
        HydrogenNetwork network = new HydrogenNetwork();
        network.getTransmitters().add(this);
        this.setNetwork((IGridNetwork)network);
    }

    public void setNetwork(IGridNetwork network) {
        this.network = network;
    }

    public void refresh() {
        if (!this.field_145850_b.field_72995_K) {
            this.adjacentConnections = null;
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tileEntity = new BlockVec3((TileEntity)this).getTileEntityOnSide(this.field_145850_b, side);
                if (tileEntity == null || tileEntity.getClass() != ((Object)((Object)this)).getClass() || !(tileEntity instanceof INetworkProvider) || this.getNetwork().equals(((INetworkProvider)tileEntity).getNetwork())) continue;
                this.setNetwork((IGridNetwork)this.getNetwork().merge((Object)((INetworkProvider)tileEntity).getNetwork()));
            }
            this.getNetwork().refresh();
        }
    }

    public TileEntity[] getAdjacentConnections() {
        if (this.adjacentConnections == null) {
            this.adjacentConnections = TileEntityHydrogenPipe.getAdjacentHydrogenConnections(this);
        }
        return this.adjacentConnections;
    }

    public static TileEntity[] getAdjacentHydrogenConnections(TileEntity tile) {
        TileEntity[] adjacentConnections = new TileEntity[ForgeDirection.VALID_DIRECTIONS.length];
        boolean isMekLoaded = EnergyConfigHandler.isMekanismLoaded();
        BlockVec3 thisVec = new BlockVec3(tile);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = thisVec.getTileEntityOnSide(tile.func_145831_w(), direction);
            if (tileEntity instanceof IConnector) {
                if (!((IConnector)tileEntity).canConnect(direction.getOpposite(), NetworkType.HYDROGEN)) continue;
                adjacentConnections[direction.ordinal()] = tileEntity;
                continue;
            }
            if (!isMekLoaded || !(tileEntity instanceof ITubeConnection) || tileEntity instanceof IGasTransmitter && !TransmissionType.checkTransmissionType((TileEntity)tileEntity, (TransmissionType)TransmissionType.GAS, (TileEntity)tileEntity) || !((ITubeConnection)tileEntity).canTubeConnect(direction)) continue;
            adjacentConnections[direction.ordinal()] = tileEntity;
        }
        return adjacentConnections;
    }

    public boolean canConnect(ForgeDirection direction, NetworkType type) {
        return type == NetworkType.HYDROGEN;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    public NetworkType getNetworkType() {
        return NetworkType.HYDROGEN;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="Mekanism")
    public int receiveGas(ForgeDirection side, GasStack stack) {
        if (!stack.getGas().getName().equals("hydrogen")) {
            return 0;
        }
        return stack.amount - (int)Math.floor(((IHydrogenNetwork)this.getNetwork()).produce((float)stack.amount, new TileEntity[]{this}));
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="Mekanism")
    public GasStack drawGas(ForgeDirection side, int amount) {
        return null;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="Mekanism")
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        return false;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.IGasHandler", modID="Mekanism")
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return type.getName().equals("hydrogen");
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.gas.ITubeConnection", modID="Mekanism")
    public boolean canTubeConnect(ForgeDirection side) {
        return this.canConnect(side, NetworkType.HYDROGEN);
    }
}

