/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.recipe.INasaWorkbenchRecipe;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.recipe.NasaWorkbenchRecipe;
import micdoodle8.mods.galacticraft.planets.IPlanetsModule;
import micdoodle8.mods.galacticraft.planets.asteroids.ConfigManagerAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.TeleportTypeAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.WorldProviderAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityAstroMiner;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityEntryPod;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityGrapple;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntitySmallAsteroid;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityTier3Rocket;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.player.AsteroidsPlayerHandler;
import micdoodle8.mods.galacticraft.planets.asteroids.event.AsteroidsEventHandler;
import micdoodle8.mods.galacticraft.planets.asteroids.inventory.ContainerShortRangeTelepad;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.asteroids.network.PacketSimpleAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.recipe.CanisterRecipes;
import micdoodle8.mods.galacticraft.planets.asteroids.recipe.RecipeManagerAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.schematic.SchematicTier3Rocket;
import micdoodle8.mods.galacticraft.planets.asteroids.tick.AsteroidsTickHandlerServer;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityBeamReceiver;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityBeamReflector;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityMinerBase;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityMinerBaseSingle;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityShortRangeTelepad;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityTelepadFake;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityTreasureChestAsteroids;
import micdoodle8.mods.galacticraft.planets.mars.MarsModule;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.RecipeSorter;

public class AsteroidsModule
implements IPlanetsModule {
    public static Planet planetAsteroids;
    public static final String ASSET_PREFIX = "galacticraftasteroids";
    public static final String TEXTURE_PREFIX = "galacticraftasteroids:";
    public static AsteroidsPlayerHandler playerHandler;
    public static Fluid fluidMethaneGas;
    public static Fluid fluidOxygenGas;
    public static Fluid fluidNitrogenGas;
    public static Fluid fluidLiquidMethane;
    public static Fluid fluidLiquidOxygen;
    public static Fluid fluidLiquidNitrogen;
    public static Fluid fluidLiquidArgon;
    public static Fluid fluidAtmosphericGases;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        new ConfigManagerAsteroids(new File(event.getModConfigurationDirectory(), "Galacticraft/asteroids.conf"));
        playerHandler = new AsteroidsPlayerHandler();
        MinecraftForge.EVENT_BUS.register((Object)playerHandler);
        FMLCommonHandler.instance().bus().register((Object)playerHandler);
        AsteroidsEventHandler eventHandler = new AsteroidsEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        FMLCommonHandler.instance().bus().register((Object)eventHandler);
        RecipeSorter.register((String)"galacticraftmars:canisterRecipe", CanisterRecipes.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        FluidRegistry.registerFluid((Fluid)new Fluid("methane").setDensity(1).setViscosity(11).setGaseous(true));
        FluidRegistry.registerFluid((Fluid)new Fluid("atmosphericgases").setDensity(1).setViscosity(13).setGaseous(true));
        FluidRegistry.registerFluid((Fluid)new Fluid("liquidmethane").setDensity(450).setViscosity(120).setTemperature(109));
        FluidRegistry.registerFluid((Fluid)new Fluid("liquidoxygen").setDensity(1141).setViscosity(140).setTemperature(90));
        FluidRegistry.registerFluid((Fluid)new Fluid("oxygen").setDensity(1).setViscosity(13).setGaseous(true));
        FluidRegistry.registerFluid((Fluid)new Fluid("liquidnitrogen").setDensity(808).setViscosity(130).setTemperature(90));
        FluidRegistry.registerFluid((Fluid)new Fluid("nitrogen").setDensity(1).setViscosity(12).setGaseous(true));
        FluidRegistry.registerFluid((Fluid)new Fluid("carbondioxide").setDensity(2).setViscosity(20).setGaseous(true));
        FluidRegistry.registerFluid((Fluid)new Fluid("hydrogen").setDensity(1).setViscosity(1).setGaseous(true));
        FluidRegistry.registerFluid((Fluid)new Fluid("argon").setDensity(1).setViscosity(4).setGaseous(true));
        FluidRegistry.registerFluid((Fluid)new Fluid("liquidargon").setDensity(900).setViscosity(100).setTemperature(87));
        FluidRegistry.registerFluid((Fluid)new Fluid("helium").setDensity(1).setViscosity(1).setGaseous(true));
        fluidMethaneGas = FluidRegistry.getFluid((String)"methane");
        fluidAtmosphericGases = FluidRegistry.getFluid((String)"atmosphericgases");
        fluidLiquidMethane = FluidRegistry.getFluid((String)"liquidmethane");
        fluidLiquidOxygen = FluidRegistry.getFluid((String)"liquidoxygen");
        fluidOxygenGas = FluidRegistry.getFluid((String)"oxygen");
        fluidLiquidNitrogen = FluidRegistry.getFluid((String)"liquidnitrogen");
        fluidLiquidArgon = FluidRegistry.getFluid((String)"liquidargon");
        fluidNitrogenGas = FluidRegistry.getFluid((String)"nitrogen");
        AsteroidBlocks.initBlocks();
        AsteroidBlocks.registerBlocks();
        AsteroidBlocks.setHarvestLevels();
        AsteroidBlocks.oreDictRegistration();
        AsteroidsItems.initItems();
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(fluidMethaneGas, 1000), new ItemStack(AsteroidsItems.methaneCanister, 1, 1), new ItemStack(GCItems.oilCanister, 1, 1001)));
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(fluidLiquidOxygen, 1000), new ItemStack(AsteroidsItems.canisterLOX, 1, 1), new ItemStack(GCItems.oilCanister, 1, 1001)));
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)new FluidContainerRegistry.FluidContainerData(new FluidStack(fluidLiquidNitrogen, 1000), new ItemStack(AsteroidsItems.canisterLN2, 1, 1), new ItemStack(GCItems.oilCanister, 1, 1001)));
    }

    @Override
    public void init(FMLInitializationEvent event) {
        this.registerMicroBlocks();
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier3Rocket());
        GalacticraftCore.packetPipeline.addDiscriminator(7, PacketSimpleAsteroids.class);
        AsteroidsTickHandlerServer eventHandler = new AsteroidsTickHandlerServer();
        FMLCommonHandler.instance().bus().register((Object)eventHandler);
        MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        this.registerEntities();
        RecipeManagerAsteroids.loadRecipes();
        planetAsteroids = new Planet("asteroids").setParentSolarSystem(GalacticraftCore.solarSystemSol);
        planetAsteroids.setDimensionInfo(ConfigManagerAsteroids.dimensionIDAsteroids, WorldProviderAsteroids.class).setTierRequired(3);
        planetAsteroids.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.375f, 1.375f)).setRelativeOrbitTime(45.0f).setPhaseShift((float)(Math.random() * (Math.PI * 2)));
        planetAsteroids.setBodyIcon(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/asteroid.png"));
        GalaxyRegistry.registerPlanet((Planet)planetAsteroids);
        GalacticraftRegistry.registerTeleportType(WorldProviderAsteroids.class, (ITeleportType)new TeleportTypeAsteroids());
        HashMap<Integer, ItemStack> input = new HashMap<Integer, ItemStack>();
        input.put(1, new ItemStack((Item)AsteroidsItems.heavyNoseCone));
        input.put(2, new ItemStack(AsteroidsItems.basicItem, 1, 0));
        input.put(3, new ItemStack(AsteroidsItems.basicItem, 1, 0));
        input.put(4, new ItemStack(AsteroidsItems.basicItem, 1, 0));
        input.put(5, new ItemStack(AsteroidsItems.basicItem, 1, 0));
        input.put(6, new ItemStack(AsteroidsItems.basicItem, 1, 0));
        input.put(7, new ItemStack(AsteroidsItems.basicItem, 1, 0));
        input.put(8, new ItemStack(AsteroidsItems.basicItem, 1, 0));
        input.put(9, new ItemStack(AsteroidsItems.basicItem, 1, 0));
        input.put(10, new ItemStack(AsteroidsItems.basicItem, 1, 0));
        input.put(11, new ItemStack(AsteroidsItems.basicItem, 1, 0));
        input.put(12, new ItemStack(GCItems.rocketEngine, 1, 1));
        input.put(13, new ItemStack(AsteroidsItems.basicItem, 1, 2));
        input.put(14, new ItemStack(AsteroidsItems.basicItem, 1, 2));
        input.put(15, new ItemStack(AsteroidsItems.basicItem, 1, 1));
        input.put(16, new ItemStack(GCItems.rocketEngine, 1, 1));
        input.put(17, new ItemStack(AsteroidsItems.basicItem, 1, 2));
        input.put(18, new ItemStack(AsteroidsItems.basicItem, 1, 2));
        input.put(19, null);
        input.put(20, null);
        input.put(21, null);
        GalacticraftRegistry.addT3RocketRecipe((INasaWorkbenchRecipe)new NasaWorkbenchRecipe(new ItemStack(AsteroidsItems.tier3Rocket, 1, 0), input));
        HashMap<Integer, ItemStack> input2 = new HashMap<Integer, ItemStack>(input);
        input2.put(19, new ItemStack((Block)Blocks.field_150486_ae));
        input2.put(20, null);
        input2.put(21, null);
        GalacticraftRegistry.addT3RocketRecipe((INasaWorkbenchRecipe)new NasaWorkbenchRecipe(new ItemStack(AsteroidsItems.tier3Rocket, 1, 1), input2));
        input2 = new HashMap(input);
        input2.put(19, null);
        input2.put(20, new ItemStack((Block)Blocks.field_150486_ae));
        input2.put(21, null);
        GalacticraftRegistry.addT3RocketRecipe((INasaWorkbenchRecipe)new NasaWorkbenchRecipe(new ItemStack(AsteroidsItems.tier3Rocket, 1, 1), input2));
        input2 = new HashMap(input);
        input2.put(19, null);
        input2.put(20, null);
        input2.put(21, new ItemStack((Block)Blocks.field_150486_ae));
        GalacticraftRegistry.addT3RocketRecipe((INasaWorkbenchRecipe)new NasaWorkbenchRecipe(new ItemStack(AsteroidsItems.tier3Rocket, 1, 1), input2));
        input2 = new HashMap(input);
        input2.put(19, new ItemStack((Block)Blocks.field_150486_ae));
        input2.put(20, new ItemStack((Block)Blocks.field_150486_ae));
        input2.put(21, null);
        GalacticraftRegistry.addT3RocketRecipe((INasaWorkbenchRecipe)new NasaWorkbenchRecipe(new ItemStack(AsteroidsItems.tier3Rocket, 1, 2), input2));
        input2 = new HashMap(input);
        input2.put(19, new ItemStack((Block)Blocks.field_150486_ae));
        input2.put(20, null);
        input2.put(21, new ItemStack((Block)Blocks.field_150486_ae));
        GalacticraftRegistry.addT3RocketRecipe((INasaWorkbenchRecipe)new NasaWorkbenchRecipe(new ItemStack(AsteroidsItems.tier3Rocket, 1, 2), input2));
        input2 = new HashMap(input);
        input2.put(19, null);
        input2.put(20, new ItemStack((Block)Blocks.field_150486_ae));
        input2.put(21, new ItemStack((Block)Blocks.field_150486_ae));
        GalacticraftRegistry.addT3RocketRecipe((INasaWorkbenchRecipe)new NasaWorkbenchRecipe(new ItemStack(AsteroidsItems.tier3Rocket, 1, 2), input2));
        input2 = new HashMap(input);
        input2.put(19, new ItemStack((Block)Blocks.field_150486_ae));
        input2.put(20, new ItemStack((Block)Blocks.field_150486_ae));
        input2.put(21, new ItemStack((Block)Blocks.field_150486_ae));
        GalacticraftRegistry.addT3RocketRecipe((INasaWorkbenchRecipe)new NasaWorkbenchRecipe(new ItemStack(AsteroidsItems.tier3Rocket, 1, 3), input2));
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Override
    public void serverStarting(FMLServerStartingEvent event) {
    }

    @Override
    public void serverInit(FMLServerStartedEvent event) {
        AsteroidsTickHandlerServer.restart();
    }

    @Override
    public void getGuiIDs(List<Integer> idList) {
        idList.add(3);
    }

    @Override
    public Object getGuiElement(Side side, int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        switch (ID) {
            case 3: {
                if (!(tile instanceof TileEntityShortRangeTelepad)) break;
                return new ContainerShortRangeTelepad(player.field_71071_by, (TileEntityShortRangeTelepad)tile);
            }
        }
        return null;
    }

    private void registerEntities() {
        this.registerCreatures();
        this.registerNonMobEntities();
        this.registerTileEntities();
    }

    private void registerCreatures() {
    }

    private void registerNonMobEntities() {
        MarsModule.registerGalacticraftNonMobEntity(EntitySmallAsteroid.class, "SmallAsteroidGC", 150, 3, true);
        MarsModule.registerGalacticraftNonMobEntity(EntityGrapple.class, "GrappleHookGC", 150, 1, true);
        MarsModule.registerGalacticraftNonMobEntity(EntityTier3Rocket.class, "Tier3RocketGC", 150, 1, false);
        MarsModule.registerGalacticraftNonMobEntity(EntityEntryPod.class, "EntryPodAsteroids", 150, 1, true);
        MarsModule.registerGalacticraftNonMobEntity(EntityAstroMiner.class, "AstroMiner", 80, 1, true);
    }

    private void registerMicroBlocks() {
        try {
            Class<?> clazz = Class.forName("codechicken.microblock.MicroMaterialRegistry");
            if (clazz != null) {
                Method[] methodz;
                Method registerMethod = null;
                for (Method m : methodz = clazz.getMethods()) {
                    if (!m.getName().equals("registerMaterial")) continue;
                    registerMethod = m;
                    break;
                }
                Class<?> clazzbm = Class.forName("codechicken.microblock.BlockMicroMaterial");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(AsteroidBlocks.blockBasic, 0), "tile.asteroidsBlock.asteroid0");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(AsteroidBlocks.blockBasic, 1), "tile.asteroidsBlock.asteroid1");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(AsteroidBlocks.blockBasic, 2), "tile.asteroidsBlock.asteroid2");
                registerMethod.invoke(null, clazzbm.getConstructor(Block.class, Integer.TYPE).newInstance(AsteroidBlocks.blockDenseIce, 0), "tile.denseIce");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityBeamReflector.class, (String)"Beam Reflector");
        GameRegistry.registerTileEntity(TileEntityBeamReceiver.class, (String)"Beam Receiver");
        GameRegistry.registerTileEntity(TileEntityShortRangeTelepad.class, (String)"Short Range Telepad");
        GameRegistry.registerTileEntity(TileEntityTelepadFake.class, (String)"Fake Short Range Telepad");
        GameRegistry.registerTileEntity(TileEntityTreasureChestAsteroids.class, (String)"Asteroids Treasure Chest");
        GameRegistry.registerTileEntity(TileEntityMinerBaseSingle.class, (String)"Astro Miner Base Builder");
        GameRegistry.registerTileEntity(TileEntityMinerBase.class, (String)"Astro Miner Base");
    }

    @Override
    public Configuration getConfiguration() {
        return ConfigManagerAsteroids.config;
    }

    @Override
    public void syncConfig() {
        ConfigManagerAsteroids.syncConfig(false);
    }
}

