/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.network;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.NetworkUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityGrapple;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityMinerBase;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityShortRangeTelepad;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;

public class PacketSimpleAsteroids
implements IPacket {
    private EnumSimplePacketAsteroids type;
    private List<Object> data;

    public PacketSimpleAsteroids() {
    }

    public PacketSimpleAsteroids(EnumSimplePacketAsteroids packetType, Object[] data) {
        this(packetType, Arrays.asList(data));
    }

    public PacketSimpleAsteroids(EnumSimplePacketAsteroids packetType, List<Object> data) {
        if (packetType.getDecodeClasses().length != data.size()) {
            GCLog.info((String)"Simple Packet found data length different than packet type");
        }
        this.type = packetType;
        this.data = data;
    }

    public void encodeInto(ChannelHandlerContext context, ByteBuf buffer) {
        buffer.writeInt(this.type.ordinal());
        try {
            NetworkUtil.encodeData((ByteBuf)buffer, this.data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void decodeInto(ChannelHandlerContext context, ByteBuf buffer) {
        this.type = EnumSimplePacketAsteroids.values()[buffer.readInt()];
        if (this.type.getDecodeClasses().length > 0) {
            this.data = NetworkUtil.decodeData((Class[])this.type.getDecodeClasses(), (ByteBuf)buffer);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        EntityClientPlayerMP playerBaseClient = null;
        if (player instanceof EntityClientPlayerMP) {
            playerBaseClient = (EntityClientPlayerMP)player;
        }
        switch (this.type) {
            case C_TELEPAD_SEND: {
                Entity entity = playerBaseClient.field_70170_p.func_73045_a(((Integer)this.data.get(1)).intValue());
                if (entity == null || !(entity instanceof EntityLivingBase)) break;
                BlockVec3 pos = (BlockVec3)this.data.get(0);
                entity.func_70107_b((double)pos.x + 0.5, (double)pos.y + 2.2, (double)pos.z + 0.5);
                break;
            }
            case C_UPDATE_GRAPPLE_POS: {
                Entity entity = playerBaseClient.field_70170_p.func_73045_a(((Integer)this.data.get(0)).intValue());
                if (entity == null || !(entity instanceof EntityGrapple)) break;
                Vector3 vec = (Vector3)this.data.get(1);
                entity.func_70107_b(vec.x, vec.y, vec.z);
                break;
            }
            case C_UPDATE_MINERBASE_FACING: {
                TileEntity tile = player.field_70170_p.func_147438_o(((Integer)this.data.get(0)).intValue(), ((Integer)this.data.get(1)).intValue(), ((Integer)this.data.get(2)).intValue());
                int facingNew = (Integer)this.data.get(3);
                if (!(tile instanceof TileEntityMinerBase)) break;
                ((TileEntityMinerBase)tile).facing = facingNew;
                ((TileEntityMinerBase)tile).setMainBlockPos((Integer)this.data.get(4), (Integer)this.data.get(5), (Integer)this.data.get(6));
                break;
            }
        }
    }

    public void handleServerSide(EntityPlayer player) {
        EntityPlayerMP playerBase = PlayerUtil.getPlayerBaseServerFromPlayer((EntityPlayer)player, (boolean)false);
        block0 : switch (this.type) {
            case S_UPDATE_ADVANCED_GUI: {
                TileEntity tile = player.field_70170_p.func_147438_o(((Integer)this.data.get(1)).intValue(), ((Integer)this.data.get(2)).intValue(), ((Integer)this.data.get(3)).intValue());
                switch ((Integer)this.data.get(0)) {
                    case 0: {
                        if (!(tile instanceof TileEntityShortRangeTelepad)) break block0;
                        TileEntityShortRangeTelepad launchController = (TileEntityShortRangeTelepad)tile;
                        launchController.setAddress((Integer)this.data.get(4));
                        break block0;
                    }
                    case 1: {
                        if (!(tile instanceof TileEntityShortRangeTelepad)) break block0;
                        TileEntityShortRangeTelepad launchController = (TileEntityShortRangeTelepad)tile;
                        launchController.setTargetAddress((Integer)this.data.get(4));
                        break block0;
                    }
                }
                break;
            }
            case S_REQUEST_MINERBASE_FACING: {
                TileEntity tile = player.field_70170_p.func_147438_o(((Integer)this.data.get(0)).intValue(), ((Integer)this.data.get(1)).intValue(), ((Integer)this.data.get(2)).intValue());
                if (!(tile instanceof TileEntityMinerBase)) break;
                ((TileEntityMinerBase)tile).updateClientFlag = true;
                break;
            }
        }
    }

    public static enum EnumSimplePacketAsteroids {
        S_UPDATE_ADVANCED_GUI(Side.SERVER, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class),
        S_REQUEST_MINERBASE_FACING(Side.CLIENT, Integer.class, Integer.class, Integer.class),
        C_TELEPAD_SEND(Side.CLIENT, BlockVec3.class, Integer.class),
        C_UPDATE_GRAPPLE_POS(Side.CLIENT, Integer.class, Vector3.class),
        C_UPDATE_MINERBASE_FACING(Side.CLIENT, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class);

        private Side targetSide;
        private Class<?>[] decodeAs;

        private EnumSimplePacketAsteroids(Side targetSide, Class<?> ... decodeAs) {
            this.targetSide = targetSide;
            this.decodeAs = decodeAs;
        }

        public Side getTargetSide() {
            return this.targetSide;
        }

        public Class<?>[] getDecodeClasses() {
            return this.decodeAs;
        }
    }
}

