/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.planets.IPlanetsModuleClient;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.client.FluidTexturesGC;
import micdoodle8.mods.galacticraft.planets.asteroids.client.fx.EntityFXTeleport;
import micdoodle8.mods.galacticraft.planets.asteroids.client.gui.GuiShortRangeTelepad;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.block.BlockRendererTier3TreasureChest;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.block.BlockRendererWalkway;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.entity.RenderEntryPod;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.entity.RenderGrapple;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.entity.RenderSmallAsteroid;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.entity.RenderTier3Rocket;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.item.ItemRendererBeamReceiver;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.item.ItemRendererBeamReflector;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.item.ItemRendererGrappleHook;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.item.ItemRendererHeavyNoseCone;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.item.ItemRendererShortRangeTelepad;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.item.ItemRendererThermalArmor;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.item.ItemRendererTier3Rocket;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.tile.TileEntityBeamReceiverRenderer;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.tile.TileEntityBeamReflectorRenderer;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.tile.TileEntityShortRangeTelepadRenderer;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.tile.TileEntityTreasureChestRenderer;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityEntryPod;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityGrapple;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntitySmallAsteroid;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityTier3Rocket;
import micdoodle8.mods.galacticraft.planets.asteroids.event.AsteroidsEventHandlerClient;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityBeamReceiver;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityBeamReflector;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityShortRangeTelepad;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityTreasureChestAsteroids;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.common.MinecraftForge;

public class AsteroidsModuleClient
implements IPlanetsModuleClient {
    private static int walkwayRenderID;
    private static int treasureChestID;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
    }

    @Override
    public void init(FMLInitializationEvent event) {
        walkwayRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererWalkway(walkwayRenderID));
        treasureChestID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererTier3TreasureChest(treasureChestID));
        AsteroidsEventHandlerClient clientEventHandler = new AsteroidsEventHandlerClient();
        FMLCommonHandler.instance().bus().register((Object)clientEventHandler);
        MinecraftForge.EVENT_BUS.register((Object)clientEventHandler);
        FluidTexturesGC.init();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntitySmallAsteroid.class, (Render)new RenderSmallAsteroid());
        RenderingRegistry.registerEntityRenderingHandler(EntityGrapple.class, (Render)new RenderGrapple());
        IModelCustom podModel = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("galacticraftasteroids", "models/pod.obj"));
        RenderingRegistry.registerEntityRenderingHandler(EntityEntryPod.class, (Render)new RenderEntryPod(podModel));
        IModelCustom rocketModel = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("galacticraftasteroids", "models/tier3rocket.obj"));
        RenderingRegistry.registerEntityRenderingHandler(EntityTier3Rocket.class, (Render)new RenderTier3Rocket(rocketModel, "galacticraftasteroids", "tier3rocket"));
        IModelCustom grappleModel = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("galacticraftasteroids", "models/grapple.obj"));
        MinecraftForgeClient.registerItemRenderer((Item)AsteroidsItems.grapple, (IItemRenderer)new ItemRendererGrappleHook(grappleModel));
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)AsteroidBlocks.beamReceiver), (IItemRenderer)new ItemRendererBeamReceiver());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)AsteroidBlocks.beamReflector), (IItemRenderer)new ItemRendererBeamReflector());
        MinecraftForgeClient.registerItemRenderer((Item)AsteroidsItems.tier3Rocket, (IItemRenderer)new ItemRendererTier3Rocket(rocketModel));
        MinecraftForgeClient.registerItemRenderer((Item)AsteroidsItems.thermalPadding, (IItemRenderer)new ItemRendererThermalArmor());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)AsteroidBlocks.shortRangeTelepad), (IItemRenderer)new ItemRendererShortRangeTelepad());
        MinecraftForgeClient.registerItemRenderer((Item)AsteroidsItems.heavyNoseCone, (IItemRenderer)new ItemRendererHeavyNoseCone());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBeamReflector.class, (TileEntitySpecialRenderer)new TileEntityBeamReflectorRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBeamReceiver.class, (TileEntitySpecialRenderer)new TileEntityBeamReceiverRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityShortRangeTelepad.class, (TileEntitySpecialRenderer)new TileEntityShortRangeTelepadRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTreasureChestAsteroids.class, (TileEntitySpecialRenderer)new TileEntityTreasureChestRenderer());
    }

    @Override
    public void getGuiIDs(List<Integer> idList) {
        idList.add(3);
    }

    @Override
    public Object getGuiElement(Side side, int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        switch (ID) {
            case 3: {
                if (!(tile instanceof TileEntityShortRangeTelepad)) break;
                return new GuiShortRangeTelepad(player.field_71071_by, (TileEntityShortRangeTelepad)tile);
            }
        }
        return null;
    }

    @Override
    public int getBlockRenderID(Block block) {
        if (block == AsteroidBlocks.blockWalkway || block == AsteroidBlocks.blockWalkwayWire || block == AsteroidBlocks.blockWalkwayOxygenPipe) {
            return walkwayRenderID;
        }
        if (block == AsteroidBlocks.treasureChestTier3) {
            return treasureChestID;
        }
        return 0;
    }

    @Override
    public void spawnParticle(String particleID, Vector3 position, Vector3 motion, Object ... extraData) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc != null && mc.field_71451_h != null && mc.field_71452_i != null) {
            double dX = mc.field_71451_h.field_70165_t - position.x;
            double dY = mc.field_71451_h.field_70163_u - position.y;
            double dZ = mc.field_71451_h.field_70161_v - position.z;
            EntityFXTeleport particle = null;
            double viewDistance = 64.0;
            if (dX * dX + dY * dY + dZ * dZ < viewDistance * viewDistance && particleID.equals("portalBlue")) {
                particle = new EntityFXTeleport((World)mc.field_71441_e, position, motion, (TileEntityShortRangeTelepad)((Object)extraData[0]), (Boolean)extraData[1]);
            }
            if (particle != null) {
                particle.field_70169_q = particle.field_70165_t;
                particle.field_70167_r = particle.field_70163_u;
                particle.field_70166_s = particle.field_70161_v;
                mc.field_71452_i.func_78873_a(particle);
            }
        }
    }
}

