/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.blocks;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockTileGC;
import micdoodle8.mods.galacticraft.core.energy.tile.EnergyStorageTile;
import micdoodle8.mods.galacticraft.core.items.ItemBlockDesc;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityBeamReceiver;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBeamReceiver
extends BlockTileGC
implements ItemBlockDesc.IBlockShiftDesc {
    public BlockBeamReceiver(String assetName) {
        super(Material.field_151573_f);
        this.func_149663_c(assetName);
        this.func_149658_d("stone");
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int oldMeta = world.func_72805_g(x, y, z);
        int meta = this.getMetadataFromAngle(world, x, y, z, ForgeDirection.getOrientation((int)oldMeta).getOpposite().ordinal());
        if (meta == -1) {
            world.func_147480_a(x, y, z, true);
        }
        if (meta != oldMeta) {
            world.func_72921_c(x, y, z, meta, 3);
            TileEntityBeamReceiver thisTile = (TileEntityBeamReceiver)world.func_147438_o(x, y, z);
            if (thisTile != null) {
                thisTile.setFacing(ForgeDirection.getOrientation((int)meta));
                thisTile.invalidateReflector();
                thisTile.initiateReflector();
            }
        }
        super.func_149695_a(world, x, y, z, block);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        TileEntityBeamReceiver thisTile = (TileEntityBeamReceiver)world.func_147438_o(x, y, z);
        thisTile.setFacing(ForgeDirection.getOrientation((int)world.func_72805_g(x, y, z)));
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta != -1) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)meta);
            switch (dir) {
                case UP: {
                    this.func_149676_a(0.3f, 0.3f, 0.3f, 0.7f, 1.0f, 0.7f);
                    break;
                }
                case DOWN: {
                    this.func_149676_a(0.2f, 0.0f, 0.2f, 0.8f, 0.42f, 0.8f);
                    break;
                }
                case EAST: {
                    this.func_149676_a(0.58f, 0.2f, 0.2f, 1.0f, 0.8f, 0.8f);
                    break;
                }
                case WEST: {
                    this.func_149676_a(0.0f, 0.2f, 0.2f, 0.42f, 0.8f, 0.8f);
                    break;
                }
                case NORTH: {
                    this.func_149676_a(0.2f, 0.2f, 0.0f, 0.8f, 0.8f, 0.42f);
                    break;
                }
                case SOUTH: {
                    this.func_149676_a(0.2f, 0.2f, 0.58f, 0.8f, 0.8f, 1.0f);
                    break;
                }
            }
        }
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB axisalignedbb, List list, Entity entity) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        super.func_149743_a(world, x, y, z, axisalignedbb, list, entity);
    }

    private int getMetadataFromAngle(World world, int x, int y, int z, int side) {
        TileEntityBeamReceiver thisTile = (TileEntityBeamReceiver)world.func_147438_o(x, y, z);
        ForgeDirection direction = ForgeDirection.getOrientation((int)side).getOpposite();
        TileEntity tileAt = world.func_147438_o(x + direction.offsetX, y + direction.offsetY, z + direction.offsetZ);
        if (tileAt != null && tileAt instanceof EnergyStorageTile) {
            if (((EnergyStorageTile)tileAt).getModeFromDirection(direction.getOpposite()) != null) {
                return direction.ordinal();
            }
            return -1;
        }
        for (ForgeDirection adjacentDir : ForgeDirection.VALID_DIRECTIONS) {
            tileAt = world.func_147438_o(x + adjacentDir.offsetX, y + adjacentDir.offsetY, z + adjacentDir.offsetZ);
            if (tileAt == null || !(tileAt instanceof EnergyStorageTile) || ((EnergyStorageTile)tileAt).getModeFromDirection(adjacentDir.getOpposite()) == null) continue;
            return adjacentDir.ordinal();
        }
        return -1;
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        return this.getMetadataFromAngle(world, x, y, z, side);
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        if (this.getMetadataFromAngle(world, x, y, z, side) != -1) {
            return true;
        }
        if (world.field_72995_K && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.sendIncorrectSideMessage();
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void sendIncorrectSideMessage() {
        FMLClientHandler.instance().getClient().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(EnumColor.RED + GCCoreUtil.translate((String)"gui.receiver.cannotAttach")));
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public int func_149692_a(int metadata) {
        return 0;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileEntityBeamReceiver();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, 0));
    }

    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityBeamReceiver) {
            return ((TileEntityBeamReceiver)tile).onMachineActivated(world, x, y, z, entityPlayer, side, hitX, hitY, hitZ);
        }
        return false;
    }

    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate((String)(this.func_149739_a() + ".description"));
    }

    public boolean showDescription(int meta) {
        return true;
    }
}

