/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockTransmitter;
import micdoodle8.mods.galacticraft.core.energy.EnergyUtil;
import micdoodle8.mods.galacticraft.core.items.ItemBlockDesc;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAluminumWire;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenPipe;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockWalkway
extends BlockTransmitter
implements ITileEntityProvider,
ItemBlockDesc.IBlockShiftDesc {
    protected BlockWalkway(String assetName) {
        super(Material.field_151573_f);
        this.func_149711_c(1.0f);
        this.func_149658_d("galacticraftasteroids:walkway");
        this.func_149663_c(assetName);
        this.field_149758_A = true;
        this.minVector = new Vector3(0.0, 0.32, 0.0);
        this.maxVector = new Vector3(1.0, 1.0, 1.0);
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public int func_149645_b() {
        return GalacticraftPlanets.getBlockRenderID((Block)this);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        return this.getWalkwayOrientation(world, x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block blockChanged) {
        world.func_147465_d(x, y, z, (Block)this, this.getWalkwayOrientation(world, x, y, z), 3);
        if (this.getNetworkType() != null) {
            super.func_149695_a(world, x, y, z, blockChanged);
        }
    }

    public int getWalkwayOrientation(World world, int x, int y, int z) {
        int connectedNorth = this.isBlockNormalCube(world.func_147439_a(x, y, z - 1)) || world.func_147439_a(x, y, z - 1) instanceof BlockWalkway ? 1 : 0;
        int connectedEast = this.isBlockNormalCube(world.func_147439_a(x + 1, y, z)) || world.func_147439_a(x + 1, y, z) instanceof BlockWalkway ? 2 : 0;
        int connectedSouth = this.isBlockNormalCube(world.func_147439_a(x, y, z + 1)) || world.func_147439_a(x, y, z + 1) instanceof BlockWalkway ? 4 : 0;
        int connectedWest = this.isBlockNormalCube(world.func_147439_a(x - 1, y, z)) || world.func_147439_a(x - 1, y, z) instanceof BlockWalkway ? 8 : 0;
        return connectedNorth | connectedEast | connectedSouth | connectedWest;
    }

    public boolean isBlockNormalCube(Block block) {
        return block.func_149688_o().func_76230_c() && block.func_149686_d();
    }

    public TileEntity func_149915_a(World world, int metadata) {
        if (this == AsteroidBlocks.blockWalkwayOxygenPipe) {
            return new TileEntityOxygenPipe();
        }
        if (this == AsteroidBlocks.blockWalkwayWire) {
            return new TileEntityAluminumWire(2);
        }
        return null;
    }

    public NetworkType getNetworkType() {
        if (this == AsteroidBlocks.blockWalkwayOxygenPipe) {
            return NetworkType.OXYGEN;
        }
        if (this == AsteroidBlocks.blockWalkwayWire) {
            return NetworkType.POWER;
        }
        return null;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        TileEntity[] connectable = new TileEntity[6];
        if (tileEntity != null) {
            if (this.getNetworkType() != null) {
                switch (this.getNetworkType()) {
                    case OXYGEN: {
                        connectable = WorldUtil.getAdjacentOxygenConnections((TileEntity)tileEntity);
                        break;
                    }
                    case POWER: {
                        connectable = EnergyUtil.getAdjacentPowerConnections((TileEntity)tileEntity);
                        break;
                    }
                }
            }
            float minX = 0.0f;
            float minY = 0.32f;
            float minZ = 0.0f;
            float maxX = 1.0f;
            float maxY = 1.0f;
            float maxZ = 1.0f;
            if (connectable[0] != null) {
                minY = 0.0f;
            }
            this.func_149676_a(minX, minY, minZ, maxX, maxY, maxZ);
        }
    }

    private void addCollisionBox(World world, int x, int y, int z, AxisAlignedBB aabb, List list) {
        AxisAlignedBB axisalignedbb1 = this.func_149668_a(world, x, y, z);
        if (axisalignedbb1 != null && aabb.func_72326_a(axisalignedbb1)) {
            list.add(axisalignedbb1);
        }
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB axisalignedbb, List list, Entity entity) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        TileEntity[] connectable = new TileEntity[6];
        if (this.getNetworkType() != null) {
            switch (this.getNetworkType()) {
                case OXYGEN: {
                    connectable = WorldUtil.getAdjacentOxygenConnections((TileEntity)tileEntity);
                    break;
                }
                case POWER: {
                    connectable = EnergyUtil.getAdjacentPowerConnections((TileEntity)tileEntity);
                    break;
                }
            }
        }
        this.func_149676_a((float)this.minVector.x, (float)this.minVector.y, (float)this.minVector.z, (float)this.maxVector.x, (float)this.maxVector.y, (float)this.maxVector.z);
        this.addCollisionBox(world, x, y, z, axisalignedbb, list);
        this.func_149676_a(0.0f, 0.9f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.addCollisionBox(world, x, y, z, axisalignedbb, list);
        if (connectable[4] != null) {
            this.func_149676_a(0.0f, (float)this.minVector.y, (float)this.minVector.z, (float)this.maxVector.x, (float)this.maxVector.y, (float)this.maxVector.z);
            this.addCollisionBox(world, x, y, z, axisalignedbb, list);
        }
        if (connectable[5] != null) {
            this.func_149676_a((float)this.minVector.x, (float)this.minVector.y, (float)this.minVector.z, 1.0f, (float)this.maxVector.y, (float)this.maxVector.z);
            this.addCollisionBox(world, x, y, z, axisalignedbb, list);
        }
        if (connectable[0] != null) {
            this.func_149676_a((float)this.minVector.x, 0.0f, (float)this.minVector.z, (float)this.maxVector.x, (float)this.maxVector.y, (float)this.maxVector.z);
            this.addCollisionBox(world, x, y, z, axisalignedbb, list);
        }
        if (connectable[1] != null) {
            this.func_149676_a((float)this.minVector.x, (float)this.minVector.y, (float)this.minVector.z, (float)this.maxVector.x, 1.0f, (float)this.maxVector.z);
            this.addCollisionBox(world, x, y, z, axisalignedbb, list);
        }
        if (connectable[2] != null) {
            this.func_149676_a((float)this.minVector.x, (float)this.minVector.y, 0.0f, (float)this.maxVector.x, (float)this.maxVector.y, (float)this.maxVector.z);
            this.addCollisionBox(world, x, y, z, axisalignedbb, list);
        }
        if (connectable[3] != null) {
            this.func_149676_a((float)this.minVector.x, (float)this.minVector.y, (float)this.minVector.z, (float)this.maxVector.x, (float)this.maxVector.y, 1.0f);
            this.addCollisionBox(world, x, y, z, axisalignedbb, list);
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public String getShiftDescription(int meta) {
        if (this == AsteroidBlocks.blockWalkway) {
            return GCCoreUtil.translate((String)"tile.walkway.description");
        }
        if (this == AsteroidBlocks.blockWalkwayWire) {
            return GCCoreUtil.translate((String)"tile.walkwayAluminumWire.description");
        }
        if (this == AsteroidBlocks.blockWalkwayOxygenPipe) {
            return GCCoreUtil.translate((String)"tile.walkwayOxygenPipe.description");
        }
        return "";
    }

    public boolean showDescription(int meta) {
        return true;
    }
}

