/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.tile;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import micdoodle8.mods.galacticraft.api.power.EnergySource;
import micdoodle8.mods.galacticraft.api.power.IEnergyHandlerGC;
import micdoodle8.mods.galacticraft.api.power.ILaserNode;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.energy.tile.EnergyStorage;
import micdoodle8.mods.galacticraft.core.energy.tile.EnergyStorageTile;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectrical;
import micdoodle8.mods.galacticraft.core.tile.ReceiverMode;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityBeamOutput;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBeamReceiver
extends TileEntityBeamOutput
implements IEnergyHandlerGC,
ILaserNode {
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int facing = ForgeDirection.UNKNOWN.ordinal();
    private int preLoadFacing = -1;
    private EnergyStorage storage = new EnergyStorage(2.1474836E9f, 1.0f);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int modeReceive = ReceiverMode.UNDEFINED.ordinal();
    public Vector3 color = new Vector3(0.0, 1.0, 0.0);

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.preLoadFacing != -1) {
            this.setFacing(ForgeDirection.getOrientation((int)this.preLoadFacing));
            this.preLoadFacing = -1;
        }
        if (!this.field_145850_b.field_72995_K) {
            EnergySource.EnergySourceAdjacent source;
            TileBaseUniversalElectrical electricalTile;
            TileEntity tile;
            if (this.getTarget() != null && this.modeReceive == ReceiverMode.EXTRACT.ordinal() && this.facing != ForgeDirection.UNKNOWN.ordinal() && (tile = this.getAttachedTile()) instanceof TileBaseUniversalElectrical) {
                electricalTile = (TileBaseUniversalElectrical)tile;
                if (electricalTile.storage.getEnergyStoredGC() > 0.0f) {
                    source = new EnergySource.EnergySourceAdjacent(ForgeDirection.getOrientation((int)this.facing).getOpposite());
                    float toSend = Math.min(electricalTile.storage.getMaxExtract(), electricalTile.storage.getEnergyStoredGC());
                    electricalTile.extractEnergyGC((EnergySource)source, this.getTarget().receiveEnergyGC((EnergySource)new EnergySource.EnergySourceWireless((List)Lists.newArrayList((Object[])new ILaserNode[]{this})), toSend, false), false);
                }
            }
            if (this.modeReceive == ReceiverMode.RECEIVE.ordinal() && this.storage.getEnergyStoredGC() > 0.0f && (tile = this.getAttachedTile()) instanceof TileBaseUniversalElectrical) {
                electricalTile = (TileBaseUniversalElectrical)tile;
                source = new EnergySource.EnergySourceAdjacent(ForgeDirection.getOrientation((int)this.facing).getOpposite());
                this.storage.extractEnergyGC((float)((int)electricalTile.receiveEnergyGC((EnergySource)source, this.storage.getEnergyStoredGC(), false)), false);
            }
        }
    }

    public double getPacketRange() {
        return 24.0;
    }

    public int getPacketCooldown() {
        return 3;
    }

    public boolean isNetworkedTile() {
        return true;
    }

    public Vector3 getInputPoint() {
        Vector3 headVec = new Vector3((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
        ForgeDirection facingDir = ForgeDirection.getOrientation((int)this.facing);
        headVec.x += (double)((float)facingDir.offsetX * 0.1f);
        headVec.y += (double)((float)facingDir.offsetY * 0.1f);
        headVec.z += (double)((float)facingDir.offsetZ * 0.1f);
        return headVec;
    }

    public Vector3 getOutputPoint(boolean offset) {
        Vector3 headVec = new Vector3((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
        ForgeDirection facingDir = ForgeDirection.getOrientation((int)this.facing);
        headVec.x += (double)((float)facingDir.offsetX * 0.1f);
        headVec.y += (double)((float)facingDir.offsetY * 0.1f);
        headVec.z += (double)((float)facingDir.offsetZ * 0.1f);
        return headVec;
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    public TileEntity getAttachedTile() {
        if (this.facing == ForgeDirection.UNKNOWN.ordinal()) {
            return null;
        }
        TileEntity tile = new BlockVec3((TileEntity)this).getTileEntityOnSide(this.field_145850_b, this.facing);
        if (tile == null || tile.func_145837_r()) {
            this.setFacing(ForgeDirection.UNKNOWN);
        }
        if (tile instanceof EnergyStorageTile) {
            EnergyStorage attachedStorage = ((EnergyStorageTile)tile).storage;
            this.storage.setCapacity(attachedStorage.getCapacityGC() - attachedStorage.getEnergyStoredGC());
            this.storage.setMaxExtract(attachedStorage.getMaxExtract());
            this.storage.setMaxReceive(attachedStorage.getMaxReceive());
        }
        return tile;
    }

    public float receiveEnergyGC(EnergySource from, float amount, boolean simulate) {
        if (this.modeReceive != ReceiverMode.RECEIVE.ordinal()) {
            return 0.0f;
        }
        TileEntity tile = this.getAttachedTile();
        if (this.facing == ForgeDirection.UNKNOWN.ordinal()) {
            return 0.0f;
        }
        return this.storage.receiveEnergyGC(amount, simulate);
    }

    public float extractEnergyGC(EnergySource from, float amount, boolean simulate) {
        if (this.modeReceive != ReceiverMode.EXTRACT.ordinal()) {
            return 0.0f;
        }
        TileEntity tile = this.getAttachedTile();
        if (this.facing == ForgeDirection.UNKNOWN.ordinal()) {
            return 0.0f;
        }
        float extracted = this.storage.extractEnergyGC(amount, simulate);
        if (extracted < amount && tile instanceof EnergyStorageTile) {
            extracted += ((EnergyStorageTile)tile).storage.extractEnergyGC(amount - extracted, simulate);
        }
        return extracted;
    }

    public float getEnergyStoredGC(EnergySource from) {
        TileEntity tile = this.getAttachedTile();
        if (this.facing == ForgeDirection.UNKNOWN.ordinal()) {
            return 0.0f;
        }
        return this.storage.getEnergyStoredGC();
    }

    public float getMaxEnergyStoredGC(EnergySource from) {
        TileEntity tile = this.getAttachedTile();
        if (this.facing == ForgeDirection.UNKNOWN.ordinal()) {
            return 0.0f;
        }
        return this.storage.getCapacityGC();
    }

    public boolean nodeAvailable(EnergySource from) {
        TileEntity tile = this.getAttachedTile();
        return this.facing != ForgeDirection.UNKNOWN.ordinal();
    }

    public void setFacing(ForgeDirection newDirection) {
        if (newDirection.ordinal() != this.facing) {
            if (newDirection == ForgeDirection.UNKNOWN) {
                this.modeReceive = ReceiverMode.UNDEFINED.ordinal();
            } else {
                TileEntity tile = new Vector3((TileEntity)this).translate(new Vector3(newDirection)).getTileEntity((IBlockAccess)this.field_145850_b);
                if (tile == null) {
                    this.modeReceive = ReceiverMode.UNDEFINED.ordinal();
                } else if (tile instanceof EnergyStorageTile) {
                    ReceiverMode mode = ((EnergyStorageTile)tile).getModeFromDirection(newDirection.getOpposite());
                    this.modeReceive = mode != null ? mode.ordinal() : ReceiverMode.UNDEFINED.ordinal();
                }
            }
        }
        this.facing = newDirection.ordinal();
    }

    public boolean canConnectTo(ILaserNode laserNode) {
        if (this.modeReceive != ReceiverMode.UNDEFINED.ordinal() && this.color.equals((Object)laserNode.getColor())) {
            if (laserNode instanceof TileEntityBeamReceiver) {
                return ((TileEntityBeamReceiver)laserNode).modeReceive != this.modeReceive;
            }
            return true;
        }
        return false;
    }

    public Vector3 getColor() {
        return new Vector3(0.0, 1.0, 0.0);
    }

    @Override
    public ILaserNode getTarget() {
        if (this.modeReceive == ReceiverMode.EXTRACT.ordinal()) {
            return super.getTarget();
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.preLoadFacing = nbt.func_74762_e("FacingSide");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("FacingSide", this.facing);
    }
}

