/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.items.ItemBlockDesc;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCavernousVine
extends Block
implements IShearable,
ItemBlockDesc.IBlockShiftDesc {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] vineIcons;

    public BlockCavernousVine() {
        super(Material.field_151582_l);
        this.func_149715_a(1.0f);
        this.func_149675_a(true);
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 vec3d, Vec3 vec3d1) {
        return super.func_149731_a(world, x, y, z, vec3d, vec3d1);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (world.func_147468_f(x, y, z)) {
            int y2 = y - 1;
            while (world.func_147439_a(x, y2, z) == this) {
                world.func_147468_f(x, y2, z);
                --y2;
            }
            return true;
        }
        return false;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75100_b) {
                return;
            }
            entity.field_70181_x = 0.06f;
            entity.field_70177_z += 0.4f;
            if (!((EntityLivingBase)entity).func_70651_bq().contains(Potion.field_76436_u)) {
                ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 5, 20, false));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.vineIcons = new IIcon[3];
        for (int i = 0; i < 3; ++i) {
            this.vineIcons[i] = iconRegister.func_94245_a("galacticraftmars:vine_" + i);
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return this.getVineLight(world, x, y, z);
    }

    public IIcon func_149691_a(int side, int meta) {
        if (meta < 3) {
            return this.vineIcons[meta];
        }
        return super.func_149691_a(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    public int func_149645_b() {
        return GalacticraftPlanets.getBlockRenderID(this);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        return ForgeDirection.getOrientation((int)side) == ForgeDirection.DOWN && this.func_149747_d((IBlockAccess)world, x, y + 1, z, side);
    }

    public int getVineLength(IBlockAccess world, int x, int y, int z) {
        int vineCount = 0;
        int y2 = y;
        while (world.func_147439_a(x, y2, z) == MarsBlocks.vine) {
            ++vineCount;
            ++y2;
        }
        return vineCount;
    }

    public int getVineLight(IBlockAccess world, int x, int y, int z) {
        int vineCount = 0;
        int y2 = y;
        while (world.func_147439_a(x, y2, z) == MarsBlocks.vine) {
            vineCount += 4;
            --y2;
        }
        return Math.max(19 - vineCount, 0);
    }

    public int func_149738_a(World par1World) {
        return 50;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!world.field_72995_K) {
            for (int y2 = y - 1; y2 >= y - 2; --y2) {
                Block blockID = world.func_147439_a(x, y2, z);
                if (blockID.isAir((IBlockAccess)world, x, y, z)) continue;
                return;
            }
            world.func_147465_d(x, y - 1, z, (Block)this, this.getVineLength((IBlockAccess)world, x, y, z) % 3, 2);
            world.func_147451_t(x, y, z);
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            // empty if block
        }
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return Item.func_150898_a((Block)Blocks.field_150350_a);
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public void func_149636_a(World par1World, EntityPlayer par2EntityPlayer, int par3, int par4, int par5, int par6) {
        super.func_149636_a(par1World, par2EntityPlayer, par3, par4, par5, par6);
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public ArrayList<ItemStack> onSheared(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this, 1, 0));
        return ret;
    }

    public boolean isLadder(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return true;
    }

    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate((String)(this.func_149739_a() + ".description"));
    }

    public boolean showDescription(int meta) {
        return true;
    }
}

