/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.gui.screen;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import micdoodle8.mods.galacticraft.api.client.IGameScreen;
import micdoodle8.mods.galacticraft.api.client.IScreenManager;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.core.client.gui.screen.DrawGameScreen;
import micdoodle8.mods.galacticraft.core.client.render.entities.RenderPlayerGC;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTelemetry;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GameScreenText
implements IGameScreen {
    private float frameA;
    private float frameBx;
    private float frameBy;
    private int yPos;

    @Override
    public void setFrameSize(float frameSize) {
        this.frameA = frameSize;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(int type, float ticks, float sizeX, float sizeY, IScreenManager scr) {
        DrawGameScreen screen = (DrawGameScreen)scr;
        this.frameBx = sizeX - this.frameA;
        this.frameBy = sizeY - this.frameA;
        this.drawBlackBackground(0.0f);
        this.yPos = 0;
        TileEntityTelemetry telemeter = TileEntityTelemetry.getNearest(screen.driver);
        String strName = "";
        String str0 = "No link";
        String str1 = "";
        String str2 = "";
        String str3 = "";
        String str4 = "";
        Render renderEntity = null;
        Entity entity = null;
        float Xmargin = 0.0f;
        if (telemeter != null && telemeter.clientData.length >= 3) {
            if (telemeter.clientClass != null) {
                if (telemeter.clientClass == screen.telemetryLastClass && (telemeter.clientClass != EntityPlayerMP.class || telemeter.clientName.equals(screen.telemetryLastName))) {
                    entity = screen.telemetryLastEntity;
                    renderEntity = screen.telemetryLastRender;
                    strName = screen.telemetryLastName;
                } else {
                    entity = null;
                    if (telemeter.clientClass == EntityPlayerMP.class) {
                        strName = telemeter.clientName;
                        entity = new EntityOtherPlayerMP(screen.driver.func_145831_w(), telemeter.clientGameProfile);
                        renderEntity = (Render)RenderManager.field_78727_a.field_78729_o.get(EntityPlayer.class);
                    } else {
                        try {
                            entity = (Entity)telemeter.clientClass.getConstructor(World.class).newInstance(screen.driver.func_145831_w());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        if (entity != null) {
                            strName = entity.func_70005_c_();
                        }
                        renderEntity = (Render)RenderManager.field_78727_a.field_78729_o.get(telemeter.clientClass);
                    }
                }
            }
            if (entity instanceof EntityLivingBase) {
                str0 = telemeter.clientData[0] > 0 ? "ouch!!!!" : "";
                str1 = telemeter.clientData[1] >= 0 ? "Health: " + telemeter.clientData[1] + "%" : "";
                str2 = "" + telemeter.clientData[2] + " bpm";
                if (telemeter.clientData[3] > -1) {
                    str3 = "Food: " + telemeter.clientData[3] + "%";
                }
                if (telemeter.clientData[4] > -1) {
                    int oxygen = telemeter.clientData[4];
                    str4 = (oxygen = oxygen % 4096 + oxygen / 4096) == 180 || oxygen == 90 ? "Oxygen: OK" : "Oxygen: " + this.makeOxygenString(oxygen) + GCCoreUtil.translate("gui.seconds");
                }
            } else if (entity instanceof EntitySpaceshipBase) {
                int countdown = telemeter.clientData[0];
                str0 = "";
                str1 = countdown == 400 ? "On launchpad" : (countdown > 0 ? "Countdown: " + countdown / 20 : "Launched");
                str2 = "Height: " + telemeter.clientData[1];
                str3 = "Speed: " + this.makeSpeedString(telemeter.clientData[2]);
                str4 = "Fuel: " + telemeter.clientData[3] + "%";
            } else if (telemeter.clientData[2] >= 0) {
                str2 = "Speed: " + this.makeSpeedString(telemeter.clientData[2]);
            }
        } else {
            World w1 = screen.driver.func_145831_w();
            int time1 = w1 != null ? (int)((w1.func_72820_D() + 6000L) % 24000L) : 0;
            str2 = this.makeTimeString(time1 * 360);
        }
        int textWidthPixels = 155;
        int textHeightPixels = 60;
        if (str3.isEmpty()) {
            textHeightPixels -= 10;
        }
        if (str4.isEmpty()) {
            textHeightPixels -= 10;
        }
        float borders = this.frameA * 2.0f + 0.05f * Math.min(sizeX, sizeY);
        float scaleXTest = (sizeX - borders) / (float)textWidthPixels;
        float scaleYTest = (sizeY - borders) / (float)textHeightPixels;
        float scale = sizeX;
        if (scaleYTest < scaleXTest) {
            scale = sizeY;
        }
        borders = this.frameA * 2.0f + 0.05f * scale;
        scaleXTest = (sizeX - borders) / (float)textWidthPixels;
        scaleYTest = (sizeY - borders) / (float)textHeightPixels;
        scale = sizeX;
        float scaleText = scaleXTest;
        if (scaleYTest < scaleXTest) {
            scale = sizeY;
            scaleText = scaleYTest;
        }
        float border = this.frameA + 0.025f * scale;
        if (entity != null && renderEntity != null) {
            Xmargin = (sizeX - borders) / 2.0f;
        }
        float Xoffset = (sizeX - borders - (float)textWidthPixels * scaleText) / 2.0f + Xmargin;
        float Yoffset = (sizeY - borders - (float)textHeightPixels * scaleText) / 2.0f + scaleText;
        GL11.glTranslatef((float)(border + Xoffset), (float)(border + Yoffset), (float)0.0f);
        GL11.glScalef((float)scaleText, (float)scaleText, (float)1.0f);
        int whiteColour = GCCoreUtil.to32BitColor(255, 240, 216, 255);
        this.drawText(strName, whiteColour);
        this.drawText(str0, whiteColour);
        this.drawText(str1, whiteColour);
        this.drawText(str2, whiteColour);
        this.drawText(str3, whiteColour);
        this.drawText(str4, whiteColour);
        if (renderEntity != null && entity != null) {
            GL11.glTranslatef((float)(-Xmargin / 2.0f / scaleText), (float)((float)(textHeightPixels / 2) + (-Yoffset + (sizeY - borders) / 2.0f) / scaleText), (float)-5.0E-4f);
            float scalefactor = 38.0f / (float)Math.pow(Math.max(entity.field_70131_O, entity.field_70130_N), 0.65);
            GL11.glScalef((float)scalefactor, (float)scalefactor, (float)0.0015f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            if (entity instanceof EntitySpaceshipBase) {
                GL11.glRotatef((float)telemeter.clientData[4], (float)-1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)(entity.field_70131_O / 4.0f), (float)0.0f);
            }
            RenderPlayerGC.flagThermalOverride = true;
            renderEntity.func_76986_a(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f);
            RenderPlayerGC.flagThermalOverride = false;
        }
        screen.telemetryLastClass = telemeter == null ? null : telemeter.clientClass;
        screen.telemetryLastEntity = entity;
        screen.telemetryLastRender = renderEntity;
        screen.telemetryLastName = strName;
    }

    private String makeTimeString(int l) {
        int hrs = l / 360000;
        int mins = l / 6000 - hrs * 60;
        int secs = l / 100 - hrs * 3600 - mins * 60;
        String hrsStr = hrs > 9 ? "" + hrs : "0" + hrs;
        String minsStr = mins > 9 ? "" + mins : "0" + mins;
        String secsStr = secs > 9 ? "" + secs : "0" + secs;
        return hrsStr + ":" + minsStr + ":" + secsStr;
    }

    private String makeSpeedString(int speed100) {
        int sp1 = speed100 / 100;
        int sp2 = speed100 % 100;
        String spStr1 = "" + sp1;
        String spStr2 = (sp2 > 9 ? "" : "0") + sp2;
        return spStr1 + "." + spStr2 + " " + GCCoreUtil.translate("gui.lander.velocityu");
    }

    private String makeHealthString(int hearts2) {
        int sp1 = hearts2 / 2;
        int sp2 = hearts2 % 2 * 5;
        String spStr1 = "" + sp1;
        String spStr2 = "" + sp2;
        return spStr1 + "." + spStr2 + " hearts";
    }

    private String makeOxygenString(int oxygen) {
        int sp1 = oxygen * 9 / 20;
        int sp2 = oxygen * 9 % 20 / 2;
        String spStr1 = "" + sp1;
        String spStr2 = "" + sp2;
        return spStr1 + "." + spStr2;
    }

    private void drawText(String str, int colour) {
        Minecraft.func_71410_x().field_71466_p.func_85187_a(str, 0, this.yPos, colour, false);
        this.yPos += 10;
    }

    private void drawBlackBackground(float greyLevel) {
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        Tessellator tess = Tessellator.field_78398_a;
        GL11.glColor4f((float)greyLevel, (float)greyLevel, (float)greyLevel, (float)1.0f);
        tess.func_78382_b();
        tess.func_78377_a((double)this.frameA, (double)this.frameBy, (double)0.005f);
        tess.func_78377_a((double)this.frameBx, (double)this.frameBy, (double)0.005f);
        tess.func_78377_a((double)this.frameBx, (double)this.frameA, (double)0.005f);
        tess.func_78377_a((double)this.frameA, (double)this.frameA, (double)0.005f);
        tess.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
    }
}

