/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.dimension;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.wrappers.FlagData;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class SpaceRace {
    public static final String DEFAULT_NAME = GCCoreUtil.translate("gui.spaceRace.unnamed");
    private static int lastSpaceRaceID = 0;
    private int spaceRaceID;
    private List<String> playerNames = Lists.newArrayList();
    private String teamName;
    private FlagData flagData;
    private Vector3 teamColor;
    private int ticksSpent;
    private Map<CelestialBody, Integer> celestialBodyStatusList = new HashMap<CelestialBody, Integer>();

    public SpaceRace() {
    }

    public SpaceRace(List<String> playerNames, String teamName, FlagData flagData, Vector3 teamColor) {
        this.playerNames = playerNames;
        this.teamName = teamName;
        this.ticksSpent = 0;
        this.flagData = flagData;
        this.teamColor = teamColor;
        this.spaceRaceID = ++lastSpaceRaceID;
        for (int i = 0; i < flagData.getWidth(); ++i) {
            for (int j = 0; j < flagData.getHeight(); ++j) {
                Vector3 vec = flagData.getColorAt(i, j);
            }
        }
    }

    public void loadFromNBT(NBTTagCompound nbt) {
        NBTTagCompound tagAt;
        int i;
        this.teamName = nbt.func_74779_i("TeamName");
        this.spaceRaceID = nbt.func_74762_e("SpaceRaceID");
        this.ticksSpent = nbt.func_74762_e("TicksSpent");
        this.flagData = FlagData.readFlagData(nbt);
        this.teamColor = new Vector3(nbt.func_74769_h("teamColorR"), nbt.func_74769_h("teamColorG"), nbt.func_74769_h("teamColorB"));
        NBTTagList tagList = nbt.func_150295_c("PlayerList", 10);
        for (i = 0; i < tagList.func_74745_c(); ++i) {
            tagAt = tagList.func_150305_b(i);
            this.playerNames.add(tagAt.func_74779_i("PlayerName"));
        }
        tagList = nbt.func_150295_c("CelestialBodyList", 10);
        for (i = 0; i < tagList.func_74745_c(); ++i) {
            tagAt = tagList.func_150305_b(i);
            CelestialBody body = GalaxyRegistry.getCelestialBodyFromUnlocalizedName(tagAt.func_74779_i("CelestialBodyName"));
            if (body == null) continue;
            this.celestialBodyStatusList.put(body, tagAt.func_74762_e("TimeTaken"));
        }
    }

    public void saveToNBT(NBTTagCompound nbt) {
        NBTTagCompound tagComp;
        nbt.func_74778_a("TeamName", this.teamName);
        nbt.func_74768_a("SpaceRaceID", this.spaceRaceID);
        nbt.func_74772_a("TicksSpent", (long)this.ticksSpent);
        this.flagData.saveFlagData(nbt);
        nbt.func_74780_a("teamColorR", this.teamColor.x);
        nbt.func_74780_a("teamColorG", this.teamColor.y);
        nbt.func_74780_a("teamColorB", this.teamColor.z);
        NBTTagList tagList = new NBTTagList();
        for (String string : this.playerNames) {
            tagComp = new NBTTagCompound();
            tagComp.func_74778_a("PlayerName", string);
            tagList.func_74742_a((NBTBase)tagComp);
        }
        nbt.func_74782_a("PlayerList", (NBTBase)tagList);
        tagList = new NBTTagList();
        for (Map.Entry entry : this.celestialBodyStatusList.entrySet()) {
            tagComp = new NBTTagCompound();
            tagComp.func_74778_a("CelestialBodyName", ((CelestialBody)entry.getKey()).getUnlocalizedName());
            tagComp.func_74768_a("TimeTaken", ((Integer)entry.getValue()).intValue());
            tagList.func_74742_a((NBTBase)tagComp);
        }
        nbt.func_74782_a("CelestialBodyList", (NBTBase)tagList);
    }

    public void tick() {
        ++this.ticksSpent;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public List<String> getPlayerNames() {
        return this.playerNames;
    }

    public FlagData getFlagData() {
        return this.flagData;
    }

    public void setFlagData(FlagData flagData) {
        this.flagData = flagData;
    }

    public Vector3 getTeamColor() {
        return this.teamColor;
    }

    public void setTeamColor(Vector3 teamColor) {
        this.teamColor = teamColor;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public void setPlayerNames(List<String> playerNames) {
        this.playerNames = playerNames;
    }

    public void setSpaceRaceID(int raceID) {
        this.spaceRaceID = raceID;
    }

    public int getSpaceRaceID() {
        return this.spaceRaceID;
    }

    public Map<CelestialBody, Integer> getCelestialBodyStatusList() {
        return ImmutableMap.copyOf(this.celestialBodyStatusList);
    }

    public void setCelestialBodyReached(CelestialBody body) {
        this.celestialBodyStatusList.put(body, this.ticksSpent);
    }

    public int getTicksSpent() {
        return this.ticksSpent;
    }

    public int hashCode() {
        return this.spaceRaceID;
    }

    public boolean equals(Object other) {
        if (other instanceof SpaceRace) {
            return ((SpaceRace)other).getSpaceRaceID() == this.getSpaceRaceID();
        }
        return false;
    }
}

