/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.dimension;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRace;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.wrappers.FlagData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;

public class SpaceRaceManager {
    private static final Set<SpaceRace> spaceRaces = Sets.newHashSet();

    public static SpaceRace addSpaceRace(SpaceRace spaceRace) {
        spaceRaces.remove(spaceRace);
        spaceRaces.add(spaceRace);
        return spaceRace;
    }

    public static void removeSpaceRace(SpaceRace race) {
        spaceRaces.remove(race);
    }

    public static void tick() {
        for (SpaceRace race : spaceRaces) {
            boolean playerOnline = false;
            for (int j = 0; j < MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.size(); ++j) {
                Object o = MinecraftServer.func_71276_C().func_71203_ab().field_72404_b.get(j);
                if (!(o instanceof EntityPlayer)) continue;
                EntityPlayer player = (EntityPlayer)o;
                if (!race.getPlayerNames().contains(player.func_146103_bH().getName())) continue;
                CelestialBody body = GalaxyRegistry.getCelestialBodyFromDimensionID(player.field_70170_p.field_73011_w.field_76574_g);
                if (body != null && !race.getCelestialBodyStatusList().containsKey(body)) {
                    race.setCelestialBodyReached(body);
                }
                playerOnline = true;
            }
            if (!playerOnline) continue;
            race.tick();
        }
    }

    public static void loadSpaceRaces(NBTTagCompound nbt) {
        NBTTagList tagList = nbt.func_150295_c("SpaceRaceList", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbt2 = tagList.func_150305_b(i);
            SpaceRace race = new SpaceRace();
            race.loadFromNBT(nbt2);
            spaceRaces.add(race);
        }
    }

    public static void saveSpaceRaces(NBTTagCompound nbt) {
        NBTTagList tagList = new NBTTagList();
        for (SpaceRace race : spaceRaces) {
            NBTTagCompound nbt2 = new NBTTagCompound();
            race.saveToNBT(nbt2);
            tagList.func_74742_a((NBTBase)nbt2);
        }
        nbt.func_74782_a("SpaceRaceList", (NBTBase)tagList);
    }

    public static SpaceRace getSpaceRaceFromPlayer(String username) {
        for (SpaceRace race : spaceRaces) {
            if (!race.getPlayerNames().contains(username)) continue;
            return race;
        }
        return null;
    }

    public static SpaceRace getSpaceRaceFromID(int teamID) {
        for (SpaceRace race : spaceRaces) {
            if (race.getSpaceRaceID() != teamID) continue;
            return race;
        }
        return null;
    }

    public static void sendSpaceRaceData(EntityPlayerMP toPlayer, SpaceRace spaceRace) {
        if (spaceRace != null) {
            ArrayList<Object> objList = new ArrayList<Object>();
            objList.add(spaceRace.getSpaceRaceID());
            objList.add(spaceRace.getTeamName());
            objList.add(spaceRace.getFlagData());
            objList.add(spaceRace.getTeamColor());
            objList.add(spaceRace.getPlayerNames().toArray(new String[spaceRace.getPlayerNames().size()]));
            if (ConfigManagerCore.enableDebug) {
                for (Object e : objList) {
                    if (e instanceof String[]) {
                        for (String s : (String[])e) {
                            System.out.println(s);
                        }
                        continue;
                    }
                    System.out.println(e);
                }
            }
            if (toPlayer != null) {
                GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SPACE_RACE_DATA, objList), toPlayer);
            } else {
                GalacticraftCore.packetPipeline.sendToAll(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SPACE_RACE_DATA, objList));
            }
        }
    }

    public static ImmutableSet<SpaceRace> getSpaceRaces() {
        return ImmutableSet.copyOf(new HashSet<SpaceRace>(spaceRaces));
    }

    public static void onPlayerRemoval(String player, SpaceRace race) {
        for (String member : race.getPlayerNames()) {
            EntityPlayerMP memberObj = PlayerUtil.getPlayerForUsernameVanilla(MinecraftServer.func_71276_C(), member);
            if (memberObj == null) continue;
            memberObj.func_145747_a(new ChatComponentText((Object)((Object)EnumColor.DARK_AQUA) + GCCoreUtil.translateWithFormat("gui.spaceRace.chat.removeSuccess", (Object)((Object)EnumColor.RED) + player + (Object)((Object)EnumColor.DARK_AQUA))).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.DARK_AQUA)));
        }
        ArrayList<String> playerList = new ArrayList<String>();
        playerList.add(player);
        SpaceRace newRace = SpaceRaceManager.addSpaceRace(new SpaceRace(playerList, GCCoreUtil.translate("gui.spaceRace.unnamed"), new FlagData(48, 32), new Vector3(1.0, 1.0, 1.0)));
        EntityPlayerMP playerToRemove = PlayerUtil.getPlayerBaseServerFromPlayerUsername(player, true);
        if (playerToRemove != null) {
            SpaceRaceManager.sendSpaceRaceData(playerToRemove, newRace);
            SpaceRaceManager.sendSpaceRaceData(playerToRemove, race);
        }
    }
}

