/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.dimension;

import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.common.DimensionManager;

public class SpaceStationWorldData
extends WorldSavedData {
    private String spaceStationName = "NoName";
    private String owner = "NoOwner";
    private ArrayList<String> allowedPlayers = new ArrayList<String>(){

        @Override
        public boolean contains(Object o) {
            if (o instanceof String) {
                String paramStr = (String)o;
                for (String s : this) {
                    if (!paramStr.equalsIgnoreCase(s)) continue;
                    return true;
                }
            }
            return false;
        }
    };
    private NBTTagCompound dataCompound;

    public SpaceStationWorldData(String par1Str) {
        super(par1Str);
    }

    public ArrayList<String> getAllowedPlayers() {
        return this.allowedPlayers;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getSpaceStationName() {
        return this.spaceStationName;
    }

    public void setSpaceStationName(String string) {
        this.spaceStationName = string;
    }

    public void func_76184_a(NBTTagCompound nbttagcompound) {
        this.owner = nbttagcompound.func_74779_i("owner").replace(".", "");
        this.spaceStationName = nbttagcompound.func_74779_i("spaceStationName");
        this.dataCompound = nbttagcompound.func_74764_b("dataCompound") ? nbttagcompound.func_74775_l("dataCompound") : new NBTTagCompound();
        NBTTagList var2 = nbttagcompound.func_150295_c("allowedPlayers", 10);
        this.allowedPlayers.clear();
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            String var5 = var4.func_74779_i("allowedPlayer");
            if (this.allowedPlayers.contains(var5)) continue;
            this.allowedPlayers.add(var5);
        }
    }

    public void func_76187_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74778_a("owner", this.owner);
        nbttagcompound.func_74778_a("spaceStationName", this.spaceStationName);
        nbttagcompound.func_74782_a("dataCompound", (NBTBase)this.dataCompound);
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.allowedPlayers.size(); ++var3) {
            String player = this.allowedPlayers.get(var3);
            if (player == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74778_a("allowedPlayer", player);
            var2.func_74742_a((NBTBase)var4);
        }
        nbttagcompound.func_74782_a("allowedPlayers", (NBTBase)var2);
    }

    public static SpaceStationWorldData getStationData(World var0, int var1, EntityPlayer player) {
        int providerType = DimensionManager.getProviderType((int)var1);
        if (providerType != ConfigManagerCore.idDimensionOverworldOrbit && providerType != ConfigManagerCore.idDimensionOverworldOrbitStatic) {
            return null;
        }
        String var2 = SpaceStationWorldData.getSpaceStationID(var1);
        SpaceStationWorldData var3 = (SpaceStationWorldData)var0.func_72943_a(SpaceStationWorldData.class, var2);
        if (var3 == null) {
            var3 = new SpaceStationWorldData(var2);
            var0.func_72823_a(var2, (WorldSavedData)var3);
            var3.dataCompound = new NBTTagCompound();
            if (player != null) {
                var3.owner = player.func_146103_bH().getName().replace(".", "");
            }
            var3.spaceStationName = "Station: " + var3.owner;
            if (player != null) {
                var3.allowedPlayers.add(player.func_146103_bH().getName());
            }
            var3.func_76185_a();
        }
        if (var3.getSpaceStationName().replace(" ", "").isEmpty()) {
            var3.setSpaceStationName("Station: " + var3.owner);
            var3.func_76185_a();
        }
        return var3;
    }

    public static SpaceStationWorldData getMPSpaceStationData(World var0, int var1, EntityPlayer player) {
        String var2 = SpaceStationWorldData.getSpaceStationID(var1);
        SpaceStationWorldData var3 = (SpaceStationWorldData)var0.func_72943_a(SpaceStationWorldData.class, var2);
        if (var3 == null) {
            var3 = new SpaceStationWorldData(var2);
            var0.func_72823_a(var2, (WorldSavedData)var3);
            var3.dataCompound = new NBTTagCompound();
            if (player != null) {
                var3.owner = player.func_146103_bH().getName().replace(".", "");
            }
            var3.spaceStationName = "Station: " + var3.owner;
            if (player != null) {
                var3.allowedPlayers.add(player.func_146103_bH().getName());
            }
            var3.func_76185_a();
        }
        if (var3.getSpaceStationName().replace(" ", "").isEmpty()) {
            var3.setSpaceStationName("Station: " + var3.owner);
            var3.func_76185_a();
        }
        return var3;
    }

    public static String getSpaceStationID(int dimID) {
        return "spacestation_" + dimID;
    }
}

