/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.energy.item;

import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;

public class ElectricItemManagerIC2 {
    @Annotations.RuntimeInterface(clazz="ic2.api.item.IElectricItemManager", modID="IC2")
    public int charge(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        if (itemStack.func_77973_b() instanceof ItemElectricBase) {
            ItemElectricBase item = (ItemElectricBase)itemStack.func_77973_b();
            float energy = (float)amount * EnergyConfigHandler.IC2_RATIO;
            float rejectedElectricity = Math.max(item.getElectricityStored(itemStack) + energy - item.getMaxElectricityStored(itemStack), 0.0f);
            float energyToReceive = energy - rejectedElectricity;
            if (!ignoreTransferLimit && energyToReceive > item.transferMax) {
                rejectedElectricity += energyToReceive - item.transferMax;
                energyToReceive = item.transferMax;
            }
            if (!simulate) {
                item.setElectricity(itemStack, item.getElectricityStored(itemStack) + energyToReceive);
            }
            return (int)(energyToReceive * EnergyConfigHandler.TO_IC2_RATIO);
        }
        return 0;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.IElectricItemManager", modID="IC2")
    public int discharge(ItemStack itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        if (itemStack.func_77973_b() instanceof ItemElectricBase) {
            ItemElectricBase item = (ItemElectricBase)itemStack.func_77973_b();
            float energy = (float)amount * EnergyConfigHandler.IC2_RATIO;
            float energyToTransfer = Math.min(item.getElectricityStored(itemStack), energy);
            if (!ignoreTransferLimit) {
                energyToTransfer = Math.min(energyToTransfer, item.transferMax);
            }
            if (!simulate) {
                item.setElectricity(itemStack, item.getElectricityStored(itemStack) - energyToTransfer);
            }
            return (int)(energyToTransfer * EnergyConfigHandler.TO_IC2_RATIO);
        }
        return 0;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.IElectricItemManager", modID="IC2")
    public int getCharge(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemElectricBase) {
            ItemElectricBase item = (ItemElectricBase)itemStack.func_77973_b();
            return (int)(item.getElectricityStored(itemStack) * EnergyConfigHandler.TO_IC2_RATIO);
        }
        return 0;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.IElectricItemManager", modID="IC2")
    public boolean canUse(ItemStack itemStack, int amount) {
        if (itemStack.func_77973_b() instanceof ItemElectricBase) {
            return this.getCharge(itemStack) >= amount;
        }
        return false;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.IElectricItemManager", modID="IC2")
    public boolean use(ItemStack itemStack, int amount, EntityLivingBase entity) {
        if (itemStack.func_77973_b() instanceof ItemElectricBase) {
            return this.discharge(itemStack, amount, 1, true, false) >= amount - 1;
        }
        return false;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.IElectricItemManager", modID="IC2")
    public void chargeFromArmor(ItemStack itemStack, EntityLivingBase entity) {
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.item.IElectricItemManager", modID="IC2")
    public String getToolTip(ItemStack itemStack) {
        return null;
    }
}

