/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.energy.tile;

import buildcraft.api.mj.IBatteryObject;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.ISpecialElectricItem;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.EnumSet;
import mekanism.api.energy.EnergizedItemManager;
import mekanism.api.energy.IEnergizedItem;
import micdoodle8.mods.galacticraft.api.item.ElectricItemHelper;
import micdoodle8.mods.galacticraft.api.item.IItemElectric;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import micdoodle8.mods.galacticraft.api.transmission.tile.IElectrical;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.tile.EnergyStorageTile;
import micdoodle8.mods.galacticraft.core.tile.ReceiverMode;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileBaseUniversalElectrical
extends EnergyStorageTile {
    protected boolean isAddedToEnergyNet;
    protected Object powerHandlerBC;
    private float IC2surplusInGJ = 0.0f;

    @Override
    public double getPacketRange() {
        return 12.0;
    }

    @Override
    public int getPacketCooldown() {
        return 3;
    }

    @Override
    public boolean isNetworkedTile() {
        return true;
    }

    public EnumSet<ForgeDirection> getElectricalInputDirections() {
        return EnumSet.allOf(ForgeDirection.class);
    }

    public EnumSet<ForgeDirection> getElectricalOutputDirections() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    @Override
    public float getRequest(ForgeDirection direction) {
        if (this.getElectricalInputDirections().contains(direction) || direction == ForgeDirection.UNKNOWN) {
            return super.getRequest(direction);
        }
        return 0.0f;
    }

    @Override
    public float receiveElectricity(ForgeDirection from, float receive, int tier, boolean doReceive) {
        if (this.getElectricalInputDirections().contains(from) || from == ForgeDirection.UNKNOWN) {
            return super.receiveElectricity(from, receive, tier, doReceive);
        }
        return 0.0f;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
    }

    @Annotations.VersionSpecific(version="[1.7.2]")
    public void discharge(ItemStack itemStack) {
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            float energyToDischarge = this.getRequest(ForgeDirection.UNKNOWN);
            if (item instanceof IItemElectric) {
                this.storage.receiveEnergyGC(ElectricItemHelper.dischargeItem(itemStack, energyToDischarge));
            } else if (EnergyConfigHandler.isIndustrialCraft2Loaded()) {
                ISpecialElectricItem electricItem;
                if (item instanceof IElectricItem) {
                    IElectricItem electricItem2 = (IElectricItem)item;
                    if (electricItem2.canProvideEnergy(itemStack)) {
                        double result = 0.0;
                        int energyDischargeIC2 = (int)(energyToDischarge * EnergyConfigHandler.TO_IC2_RATIO);
                        try {
                            Class<?> clazz = Class.forName("ic2.api.item.IElectricItemManager");
                            Method dischargeMethod = clazz.getMethod("discharge", ItemStack.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
                            result = ((Integer)dischargeMethod.invoke((Object)ElectricItem.manager, itemStack, energyDischargeIC2, 4, false, false)).intValue();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        float energyDischarged = (float)result * EnergyConfigHandler.IC2_RATIO;
                        this.storage.receiveEnergyGC(energyDischarged);
                    }
                } else if (item instanceof ISpecialElectricItem && (electricItem = (ISpecialElectricItem)item).canProvideEnergy(itemStack)) {
                    double result = 0.0;
                    int energyDischargeIC2 = (int)(energyToDischarge * EnergyConfigHandler.TO_IC2_RATIO);
                    try {
                        Class<?> clazz = Class.forName("ic2.api.item.IElectricItemManager");
                        Method dischargeMethod = clazz.getMethod("discharge", ItemStack.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
                        result = ((Integer)dischargeMethod.invoke((Object)electricItem.getManager(itemStack), itemStack, energyDischargeIC2, 4, false, false)).intValue();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    float energyDischarged = (float)result * EnergyConfigHandler.IC2_RATIO;
                    this.storage.receiveEnergyGC(energyDischarged);
                }
            }
        }
    }

    @Annotations.AltForVersion(version="[1.7.10]")
    public void dischargeB(ItemStack itemStack) {
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            float energyToDischarge = this.getRequest(ForgeDirection.UNKNOWN);
            if (item instanceof IItemElectric) {
                this.storage.receiveEnergyGC(ElectricItemHelper.dischargeItem(itemStack, energyToDischarge));
            } else if (EnergyConfigHandler.isMekanismLoaded() && item instanceof IEnergizedItem && ((IEnergizedItem)item).canSend(itemStack)) {
                this.storage.receiveEnergyGC((float)EnergizedItemManager.discharge((ItemStack)itemStack, (double)(energyToDischarge * EnergyConfigHandler.TO_MEKANISM_RATIO)) * EnergyConfigHandler.MEKANISM_RATIO);
            } else if (EnergyConfigHandler.isIndustrialCraft2Loaded()) {
                ISpecialElectricItem electricItem;
                if (item instanceof IElectricItem) {
                    IElectricItem electricItem2 = (IElectricItem)item;
                    if (electricItem2.canProvideEnergy(itemStack)) {
                        double result = 0.0;
                        double energyDischargeIC2 = energyToDischarge * EnergyConfigHandler.TO_IC2_RATIO;
                        try {
                            Class<?> clazz = Class.forName("ic2.api.item.IElectricItemManager");
                            Method dischargeMethod = clazz.getMethod("discharge", ItemStack.class, Double.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
                            result = (Double)dischargeMethod.invoke((Object)ElectricItem.manager, itemStack, energyDischargeIC2, 4, false, false, false);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        float energyDischarged = (float)result * EnergyConfigHandler.IC2_RATIO;
                        this.storage.receiveEnergyGC(energyDischarged);
                    }
                } else if (item instanceof ISpecialElectricItem && (electricItem = (ISpecialElectricItem)item).canProvideEnergy(itemStack)) {
                    double result = 0.0;
                    double energyDischargeIC2 = energyToDischarge * EnergyConfigHandler.TO_IC2_RATIO;
                    try {
                        Class<?> clazz = Class.forName("ic2.api.item.IElectricItemManager");
                        Method dischargeMethod = clazz.getMethod("discharge", ItemStack.class, Double.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE);
                        result = (Double)dischargeMethod.invoke((Object)electricItem.getManager(itemStack), itemStack, energyDischargeIC2, 4, false, false, false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    float energyDischarged = (float)result * EnergyConfigHandler.IC2_RATIO;
                    this.storage.receiveEnergyGC(energyDischarged);
                }
            }
        }
    }

    @Override
    public void initiate() {
        super.initiate();
        if (EnergyConfigHandler.isBuildcraftLoaded()) {
            this.initBuildCraft();
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isAddedToEnergyNet) {
                this.initIC();
            }
            if (EnergyConfigHandler.isIndustrialCraft2Loaded() && this.IC2surplusInGJ >= 0.001f) {
                this.IC2surplusInGJ -= this.storage.receiveEnergyGC(this.IC2surplusInGJ);
                if (this.IC2surplusInGJ < 0.001f) {
                    this.IC2surplusInGJ = 0.0f;
                }
            }
            if (EnergyConfigHandler.isBuildcraftLoaded()) {
                PowerHandler handler;
                double energyBC;
                if (this.powerHandlerBC == null) {
                    this.initBuildCraft();
                }
                if ((energyBC = (handler = (PowerHandler)this.powerHandlerBC).getEnergyStored()) > 0.0) {
                    float usedBC;
                    if ((energyBC -= (double)(usedBC = this.storage.receiveEnergyGC((float)energyBC * EnergyConfigHandler.BC3_RATIO) * EnergyConfigHandler.TO_BC_RATIO)) < 0.0) {
                        energyBC = 0.0;
                    }
                    handler.setEnergy(energyBC);
                }
            }
        }
    }

    public void func_145843_s() {
        this.unloadTileIC2();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.unloadTileIC2();
        super.onChunkUnload();
    }

    protected void initIC() {
        if (EnergyConfigHandler.isIndustrialCraft2Loaded()) {
            try {
                Class<?> tileLoadEvent = Class.forName("ic2.api.energy.event.EnergyTileLoadEvent");
                Class<?> energyTile = Class.forName("ic2.api.energy.tile.IEnergyTile");
                Constructor<?> constr = tileLoadEvent.getConstructor(energyTile);
                Object o = constr.newInstance(this);
                if (o != null && o instanceof Event) {
                    MinecraftForge.EVENT_BUS.post((Event)o);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.isAddedToEnergyNet = true;
    }

    private void unloadTileIC2() {
        if (this.isAddedToEnergyNet && this.field_145850_b != null) {
            if (EnergyConfigHandler.isIndustrialCraft2Loaded() && !this.field_145850_b.field_72995_K) {
                try {
                    Class<?> tileLoadEvent = Class.forName("ic2.api.energy.event.EnergyTileUnloadEvent");
                    Class<?> energyTile = Class.forName("ic2.api.energy.tile.IEnergyTile");
                    Constructor<?> constr = tileLoadEvent.getConstructor(energyTile);
                    Object o = constr.newInstance(this);
                    if (o != null && o instanceof Event) {
                        MinecraftForge.EVENT_BUS.post((Event)o);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.isAddedToEnergyNet = false;
        }
    }

    @Annotations.VersionSpecific(version="[1.7.10]")
    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySink", modID="IC2")
    public double getDemandedEnergy() {
        try {
            if (this.IC2surplusInGJ < 0.001f) {
                this.IC2surplusInGJ = 0.0f;
                return Math.ceil(this.storage.receiveEnergyGC(2.1474836E9f, true) * EnergyConfigHandler.TO_IC2_RATIO);
            }
            float received = this.storage.receiveEnergyGC(this.IC2surplusInGJ, true);
            if (received == this.IC2surplusInGJ) {
                return Math.ceil((this.storage.receiveEnergyGC(2.1474836E9f, true) - this.IC2surplusInGJ) * EnergyConfigHandler.TO_IC2_RATIO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0.0;
    }

    @Annotations.VersionSpecific(version="[1.7.2]")
    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySink", modID="IC2")
    public double demandedEnergyUnits() {
        try {
            if (this.IC2surplusInGJ < 0.001f) {
                this.IC2surplusInGJ = 0.0f;
                return Math.ceil(this.storage.receiveEnergyGC(2.1474836E9f, true) * EnergyConfigHandler.TO_IC2_RATIO);
            }
            float received = this.storage.receiveEnergyGC(this.IC2surplusInGJ, true);
            if (received == this.IC2surplusInGJ) {
                return Math.ceil((this.storage.receiveEnergyGC(2.1474836E9f, true) - this.IC2surplusInGJ) * EnergyConfigHandler.TO_IC2_RATIO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0.0;
    }

    @Annotations.VersionSpecific(version="[1.7.10]")
    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySink", modID="IC2")
    public double injectEnergy(ForgeDirection direction, double amount, double voltage) {
        if (direction == ForgeDirection.UNKNOWN || this.getElectricalInputDirections().contains(direction)) {
            float convertedEnergy = (float)amount * EnergyConfigHandler.IC2_RATIO;
            int tierFromIC2 = (int)voltage > 120 ? 2 : 1;
            float receive = this.receiveElectricity(direction, convertedEnergy, tierFromIC2, true);
            this.IC2surplusInGJ = convertedEnergy > receive ? convertedEnergy - receive : 0.0f;
            return 0.0;
        }
        return amount;
    }

    @Annotations.VersionSpecific(version="[1.7.2]")
    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySink", modID="IC2")
    public double injectEnergyUnits(ForgeDirection direction, double amount) {
        if (direction == ForgeDirection.UNKNOWN || this.getElectricalInputDirections().contains(direction)) {
            float convertedEnergy = (float)amount * EnergyConfigHandler.IC2_RATIO;
            int tierFromIC2 = amount >= 128.0 ? 2 : 1;
            float receive = this.receiveElectricity(direction, convertedEnergy, tierFromIC2, true);
            this.IC2surplusInGJ = convertedEnergy > receive ? convertedEnergy - receive : 0.0f;
            return 0.0;
        }
        return amount;
    }

    @Annotations.VersionSpecific(version="[1.7.10]")
    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySink", modID="IC2")
    public int getSinkTier() {
        return 3;
    }

    @Annotations.VersionSpecific(version="[1.7.2]")
    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergySink", modID="IC2")
    public double getMaxSafeInput() {
        return 2.147483647E9;
    }

    @Annotations.RuntimeInterface(clazz="ic2.api.energy.tile.IEnergyAcceptor", modID="IC2")
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        if (emitter instanceof IElectrical || emitter instanceof IConductor) {
            return false;
        }
        try {
            Class<?> energyTile = Class.forName("ic2.api.energy.tile.IEnergyTile");
            if (!energyTile.isInstance(emitter)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getElectricalInputDirections().contains(direction);
    }

    public void initBuildCraft() {
        float receive;
        if (this.powerHandlerBC == null) {
            this.powerHandlerBC = new PowerHandler((IPowerReceptor)this, PowerHandler.Type.MACHINE);
        }
        if ((receive = this.storage.receiveEnergyGC(this.storage.getMaxReceive(), true) * EnergyConfigHandler.TO_BC_RATIO) < 0.1f) {
            receive = 0.0f;
        }
        ((PowerHandler)this.powerHandlerBC).configure(0.0, (double)receive, 0.0, (double)((int)(this.getMaxEnergyStoredGC() * EnergyConfigHandler.TO_BC_RATIO)));
        ((PowerHandler)this.powerHandlerBC).configurePowerPerdition(1, 10);
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.power.IPowerReceptor", modID="")
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        if (this.getElectricalInputDirections().contains(side)) {
            this.initBuildCraft();
            return ((PowerHandler)this.powerHandlerBC).getPowerReceiver();
        }
        return null;
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.power.IPowerReceptor", modID="")
    public void doWork(PowerHandler workProvider) {
        this.initBuildCraft();
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.power.IPowerReceptor", modID="")
    public World getWorld() {
        return this.func_145831_w();
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.mj.ISidedBatteryProvider", modID="")
    public IBatteryObject getMjBattery(String kind, ForgeDirection direction) {
        if (this.getElectricalInputDirections().contains(direction)) {
            return (IBatteryObject)this;
        }
        return null;
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.mj.IBatteryObject", modID="")
    public double getEnergyRequested() {
        float requested = this.getRequest(ForgeDirection.UNKNOWN) * EnergyConfigHandler.TO_BC_RATIO;
        if (requested < 0.1f) {
            requested = 0.0f;
        }
        return requested;
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.mj.IBatteryObject", modID="")
    public double addEnergy(double mj) {
        float convertedEnergy = (float)mj * EnergyConfigHandler.BC3_RATIO;
        float used = this.receiveElectricity(ForgeDirection.UNKNOWN, convertedEnergy, 1, true);
        return used * EnergyConfigHandler.TO_BC_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.mj.IBatteryObject", modID="")
    public double addEnergy(double mj, boolean ignoreCycleLimit) {
        float convertedEnergy = (float)mj * EnergyConfigHandler.BC3_RATIO;
        float used = this.receiveElectricity(ForgeDirection.UNKNOWN, convertedEnergy, 1, true);
        return used * EnergyConfigHandler.TO_BC_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.mj.IBatteryObject", modID="")
    public double getEnergyStored() {
        return this.getEnergyStoredGC() * EnergyConfigHandler.TO_BC_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.mj.IBatteryObject", modID="")
    public void setEnergyStored(double mj) {
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.mj.IBatteryObject", modID="")
    public double maxCapacity() {
        return this.getMaxEnergyStoredGC() * EnergyConfigHandler.TO_BC_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.mj.IBatteryObject", modID="")
    public double minimumConsumption() {
        return this.storage.getMaxReceive() * EnergyConfigHandler.TO_BC_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.mj.IBatteryObject", modID="")
    public double maxReceivedPerCycle() {
        return (this.getMaxEnergyStoredGC() - this.getEnergyStoredGC()) * EnergyConfigHandler.TO_BC_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.mj.IBatteryObject", modID="")
    public IBatteryObject reconfigure(double maxCapacity, double maxReceivedPerCycle, double minimumConsumption) {
        return (IBatteryObject)this;
    }

    @Annotations.RuntimeInterface(clazz="buildcraft.api.mj.IBatteryObject", modID="")
    public String kind() {
        return "buildcraft.kinesis";
    }

    @Annotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyHandler", modID="")
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (!this.getElectricalInputDirections().contains(from)) {
            return 0;
        }
        return MathHelper.func_76141_d((float)(super.receiveElectricity(from, (float)maxReceive * EnergyConfigHandler.RF_RATIO, 1, !simulate) * EnergyConfigHandler.TO_RF_RATIO));
    }

    @Annotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyHandler", modID="")
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Annotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyHandler", modID="")
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.getElectricalInputDirections().contains(from) || this.getElectricalOutputDirections().contains(from);
    }

    @Annotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyHandler", modID="")
    public int getEnergyStored(ForgeDirection from) {
        return MathHelper.func_76141_d((float)(this.getEnergyStoredGC() * EnergyConfigHandler.TO_RF_RATIO));
    }

    @Annotations.RuntimeInterface(clazz="cofh.api.energy.IEnergyHandler", modID="")
    public int getMaxEnergyStored(ForgeDirection from) {
        return MathHelper.func_76141_d((float)(this.getMaxEnergyStoredGC() * EnergyConfigHandler.TO_RF_RATIO));
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyAcceptor", modID="Mekanism")
    public double transferEnergyToAcceptor(ForgeDirection from, double amount) {
        if (!this.getElectricalInputDirections().contains(from)) {
            return 0.0;
        }
        return this.receiveElectricity(from, (float)amount * EnergyConfigHandler.MEKANISM_RATIO, 1, true) * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyAcceptor", modID="Mekanism")
    public boolean canReceiveEnergy(ForgeDirection side) {
        return this.getElectricalInputDirections().contains(side);
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyAcceptor", modID="Mekanism")
    public double getEnergy() {
        return this.getEnergyStoredGC() * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyAcceptor", modID="Mekanism")
    public void setEnergy(double energy) {
        this.storage.setEnergyStored((float)energy * EnergyConfigHandler.MEKANISM_RATIO);
    }

    @Annotations.RuntimeInterface(clazz="mekanism.api.energy.IStrictEnergyAcceptor", modID="Mekanism")
    public double getMaxEnergy() {
        return this.getMaxEnergyStoredGC() * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    @Override
    public ReceiverMode getModeFromDirection(ForgeDirection direction) {
        if (this.getElectricalInputDirections().contains(direction)) {
            return ReceiverMode.RECEIVE;
        }
        if (this.getElectricalOutputDirections().contains(direction)) {
            return ReceiverMode.EXTRACT;
        }
        return null;
    }

    public void updateFacing() {
        if (EnergyConfigHandler.isIndustrialCraft2Loaded() && !this.field_145850_b.field_72995_K) {
            this.unloadTileIC2();
        }
    }
}

