/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.network;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cpw.mods.fml.server.FMLServerHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageOutputStream;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityTieredRocket;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.fx.EntityFXSparks;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiBuggy;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiParaChest;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.command.CommandGCEnergyUnits;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRace;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRaceManager;
import micdoodle8.mods.galacticraft.core.dimension.SpaceStationWorldData;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderOrbit;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseConductor;
import micdoodle8.mods.galacticraft.core.entities.EntityBuggy;
import micdoodle8.mods.galacticraft.core.entities.IBubbleProvider;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerHandler;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import micdoodle8.mods.galacticraft.core.inventory.ContainerSchematic;
import micdoodle8.mods.galacticraft.core.inventory.IInventorySettable;
import micdoodle8.mods.galacticraft.core.items.ItemParaChute;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.NetworkUtil;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.tick.KeyHandlerClient;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerClient;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAirLockController;
import micdoodle8.mods.galacticraft.core.tile.TileEntityArclamp;
import micdoodle8.mods.galacticraft.core.tile.TileEntityScreen;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTelemetry;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.util.VersionUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.wrappers.FlagData;
import micdoodle8.mods.galacticraft.core.wrappers.Footprint;
import micdoodle8.mods.galacticraft.core.wrappers.PlayerGearData;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetHandler;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.io.FileUtils;

public class PacketSimple
extends Packet
implements IPacket {
    private EnumSimplePacket type;
    private List<Object> data;
    private static String spamCheckString;

    public PacketSimple() {
    }

    public PacketSimple(EnumSimplePacket packetType, Object[] data) {
        this(packetType, Arrays.asList(data));
    }

    public PacketSimple(EnumSimplePacket packetType, List<Object> data) {
        if (packetType.getDecodeClasses().length != data.size()) {
            GCLog.info("Simple Packet Core found data length different than packet type");
            new RuntimeException().printStackTrace();
        }
        this.type = packetType;
        this.data = data;
    }

    @Override
    public void encodeInto(ChannelHandlerContext context, ByteBuf buffer) {
        buffer.writeInt(this.type.ordinal());
        try {
            NetworkUtil.encodeData(buffer, this.data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext context, ByteBuf buffer) {
        this.type = EnumSimplePacket.values()[buffer.readInt()];
        try {
            if (this.type.getDecodeClasses().length > 0) {
                this.data = NetworkUtil.decodeData(this.type.getDecodeClasses(), buffer);
            }
            if (buffer.readableBytes() > 0) {
                GCLog.severe("Galacticraft packet length problem for packet type " + this.type.toString());
            }
        }
        catch (Exception e) {
            System.err.println("[Galacticraft] Error handling simple packet type: " + this.type.toString() + " " + buffer.toString());
            e.printStackTrace();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        EntityClientPlayerMP playerBaseClient = null;
        GCPlayerStatsClient stats = null;
        if (player instanceof EntityClientPlayerMP) {
            playerBaseClient = (EntityClientPlayerMP)player;
            stats = GCPlayerStatsClient.get((EntityPlayerSP)playerBaseClient);
        } else if (this.type != EnumSimplePacket.C_UPDATE_SPACESTATION_LIST && this.type != EnumSimplePacket.C_UPDATE_PLANETS_LIST && this.type != EnumSimplePacket.C_UPDATE_CONFIGS) {
            return;
        }
        switch (this.type) {
            case C_AIR_REMAINING: {
                if (!String.valueOf(this.data.get(2)).equals(String.valueOf(FMLClientHandler.instance().getClient().field_71439_g.func_146103_bH().getName()))) break;
                TickHandlerClient.airRemaining = (Integer)this.data.get(0);
                TickHandlerClient.airRemaining2 = (Integer)this.data.get(1);
                break;
            }
            case C_UPDATE_DIMENSION_LIST: {
                if (!String.valueOf(this.data.get(0)).equals(FMLClientHandler.instance().getClient().field_71439_g.func_146103_bH().getName())) break;
                String dimensionList = (String)this.data.get(1);
                if (ConfigManagerCore.enableDebug && !dimensionList.equals(spamCheckString)) {
                    GCLog.info("DEBUG info: " + dimensionList);
                    spamCheckString = new String(dimensionList);
                }
                String[] destinations = dimensionList.split("\\?");
                ArrayList possibleCelestialBodies = Lists.newArrayList();
                HashMap spaceStationNames = Maps.newHashMap();
                HashMap spaceStationIDs = Maps.newHashMap();
                for (String str : destinations) {
                    CelestialBody celestialBody = WorldUtil.getReachableCelestialBodiesForName(str);
                    if (celestialBody == null && str.contains("$")) {
                        celestialBody = GalacticraftCore.satelliteSpaceStation;
                        String[] values = str.split("\\$");
                        spaceStationNames.put(values[1], values[2]);
                        spaceStationIDs.put(values[1], Integer.parseInt(values[3]));
                    }
                    if (celestialBody == null) continue;
                    possibleCelestialBodies.add(celestialBody);
                }
                if (FMLClientHandler.instance().getClient().field_71441_e == null) break;
                if (!(FMLClientHandler.instance().getClient().field_71462_r instanceof GuiCelestialSelection)) {
                    GuiCelestialSelection gui = new GuiCelestialSelection(false, possibleCelestialBodies);
                    gui.spaceStationNames = spaceStationNames;
                    gui.spaceStationIDs = spaceStationIDs;
                    FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)gui);
                    break;
                }
                ((GuiCelestialSelection)FMLClientHandler.instance().getClient().field_71462_r).possibleBodies = possibleCelestialBodies;
                ((GuiCelestialSelection)FMLClientHandler.instance().getClient().field_71462_r).spaceStationNames = spaceStationNames;
                ((GuiCelestialSelection)FMLClientHandler.instance().getClient().field_71462_r).spaceStationIDs = spaceStationIDs;
                break;
            }
            case C_SPAWN_SPARK_PARTICLES: {
                int x = (Integer)this.data.get(0);
                int y = (Integer)this.data.get(1);
                int z = (Integer)this.data.get(2);
                Minecraft mc = Minecraft.func_71410_x();
                for (int i = 0; i < 4; ++i) {
                    EntityFXSparks fx;
                    if (mc == null || mc.field_71451_h == null || mc.field_71452_i == null || mc.field_71441_e == null || (fx = new EntityFXSparks((World)mc.field_71441_e, (double)x - 0.15 + 0.5, (double)y + 1.2, (double)z + 0.15 + 0.5, mc.field_71441_e.field_73012_v.nextDouble() / 20.0 - mc.field_71441_e.field_73012_v.nextDouble() / 20.0, mc.field_71441_e.field_73012_v.nextDouble() / 20.0 - mc.field_71441_e.field_73012_v.nextDouble() / 20.0)) == null) continue;
                    mc.field_71452_i.func_78873_a((EntityFX)fx);
                }
                break;
            }
            case C_UPDATE_GEAR_SLOT: {
                int subtype = (Integer)this.data.get(2);
                Object gearDataPlayer = null;
                MinecraftServer server = MinecraftServer.func_71276_C();
                gearDataPlayer = server != null ? PlayerUtil.getPlayerForUsernameVanilla(server, (String)this.data.get(0)) : player.field_70170_p.func_72924_a((String)this.data.get(0));
                if (gearDataPlayer == null) break;
                PlayerGearData gearData = ClientProxyCore.playerItemData.get(gearDataPlayer.func_146103_bH().getName());
                if (gearData == null) {
                    gearData = new PlayerGearData(player);
                }
                GCPlayerHandler.EnumModelPacket type = GCPlayerHandler.EnumModelPacket.values()[(Integer)this.data.get(1)];
                switch (type) {
                    case ADDMASK: {
                        gearData.setMask(0);
                        break;
                    }
                    case REMOVEMASK: {
                        gearData.setMask(-1);
                        break;
                    }
                    case ADDGEAR: {
                        gearData.setGear(0);
                        break;
                    }
                    case REMOVEGEAR: {
                        gearData.setGear(-1);
                        break;
                    }
                    case ADDLEFTGREENTANK: {
                        gearData.setLeftTank(0);
                        break;
                    }
                    case ADDLEFTORANGETANK: {
                        gearData.setLeftTank(1);
                        break;
                    }
                    case ADDLEFTREDTANK: {
                        gearData.setLeftTank(2);
                        break;
                    }
                    case ADDRIGHTGREENTANK: {
                        gearData.setRightTank(0);
                        break;
                    }
                    case ADDRIGHTORANGETANK: {
                        gearData.setRightTank(1);
                        break;
                    }
                    case ADDRIGHTREDTANK: {
                        gearData.setRightTank(2);
                        break;
                    }
                    case REMOVE_LEFT_TANK: {
                        gearData.setLeftTank(-1);
                        break;
                    }
                    case REMOVE_RIGHT_TANK: {
                        gearData.setRightTank(-1);
                        break;
                    }
                    case ADD_PARACHUTE: {
                        String name = "";
                        if (subtype == -1) break;
                        name = ItemParaChute.names[subtype];
                        gearData.setParachute(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/model/parachute/" + name + ".png"));
                        break;
                    }
                    case REMOVE_PARACHUTE: {
                        gearData.setParachute(null);
                        break;
                    }
                    case ADD_FREQUENCY_MODULE: {
                        gearData.setFrequencyModule(0);
                        break;
                    }
                    case REMOVE_FREQUENCY_MODULE: {
                        gearData.setFrequencyModule(-1);
                        break;
                    }
                    case ADD_THERMAL_HELMET: {
                        gearData.setThermalPadding(0, 0);
                        break;
                    }
                    case ADD_THERMAL_CHESTPLATE: {
                        gearData.setThermalPadding(1, 0);
                        break;
                    }
                    case ADD_THERMAL_LEGGINGS: {
                        gearData.setThermalPadding(2, 0);
                        break;
                    }
                    case ADD_THERMAL_BOOTS: {
                        gearData.setThermalPadding(3, 0);
                        break;
                    }
                    case REMOVE_THERMAL_HELMET: {
                        gearData.setThermalPadding(0, -1);
                        break;
                    }
                    case REMOVE_THERMAL_CHESTPLATE: {
                        gearData.setThermalPadding(1, -1);
                        break;
                    }
                    case REMOVE_THERMAL_LEGGINGS: {
                        gearData.setThermalPadding(2, -1);
                        break;
                    }
                    case REMOVE_THERMAL_BOOTS: {
                        gearData.setThermalPadding(3, -1);
                        break;
                    }
                }
                ClientProxyCore.playerItemData.put((String)this.data.get(0), gearData);
                ClientProxyCore.gearDataRequests.remove(this.data.get(0));
                break;
            }
            case C_CLOSE_GUI: {
                FMLClientHandler.instance().getClient().func_147108_a(null);
                break;
            }
            case C_RESET_THIRD_PERSON: {
                FMLClientHandler.instance().getClient().field_71474_y.field_74320_O = stats.thirdPersonView;
                break;
            }
            case C_UPDATE_SPACESTATION_LIST: {
                try {
                    if (WorldUtil.registeredSpaceStations != null) {
                        for (Integer registeredID : WorldUtil.registeredSpaceStations) {
                            DimensionManager.unregisterDimension((int)registeredID);
                        }
                    }
                    WorldUtil.registeredSpaceStations = new ArrayList<Integer>();
                    if (this.data.size() <= 0) break;
                    if (this.data.get(0) instanceof Integer) {
                        for (Object o : this.data) {
                            Integer dimID = (Integer)o;
                            if (WorldUtil.registeredSpaceStations.contains(dimID)) continue;
                            WorldUtil.registeredSpaceStations.add(dimID);
                            if (!DimensionManager.isDimensionRegistered((int)dimID)) {
                                DimensionManager.registerDimension((int)dimID, (int)ConfigManagerCore.idDimensionOverworldOrbit);
                                continue;
                            }
                            GCLog.severe("Dimension already registered on client: unable to register space station dimension " + dimID);
                        }
                    } else {
                        if (!(this.data.get(0) instanceof Integer[])) break;
                        for (Integer o : (Integer[])this.data.get(0)) {
                            Integer dimID = o;
                            if (WorldUtil.registeredSpaceStations.contains(dimID)) continue;
                            WorldUtil.registeredSpaceStations.add(dimID);
                            if (!DimensionManager.isDimensionRegistered((int)dimID)) {
                                DimensionManager.registerDimension((int)dimID, (int)ConfigManagerCore.idDimensionOverworldOrbit);
                                continue;
                            }
                            GCLog.severe("Dimension already registered on client: unable to register space station dimension " + dimID);
                        }
                    }
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            case C_UPDATE_SPACESTATION_DATA: {
                SpaceStationWorldData var4 = SpaceStationWorldData.getMPSpaceStationData(player.field_70170_p, (Integer)this.data.get(0), player);
                var4.func_76184_a((NBTTagCompound)this.data.get(1));
                break;
            }
            case C_UPDATE_SPACESTATION_CLIENT_ID: {
                ClientProxyCore.clientSpaceStationID = (Integer)this.data.get(0);
                break;
            }
            case C_UPDATE_PLANETS_LIST: {
                try {
                    if (ConfigManagerCore.enableDebug) {
                        System.out.println("GC connecting to server: received planets dimension ID list.");
                    }
                    if (WorldUtil.registeredPlanets != null) {
                        for (Integer registeredID : WorldUtil.registeredPlanets) {
                            DimensionManager.unregisterDimension((int)registeredID);
                        }
                    }
                    WorldUtil.registeredPlanets = new ArrayList<Integer>();
                    String ids = "";
                    if (this.data.size() > 0) {
                        int providerIndex = 2;
                        if (this.data.get(0) instanceof Integer) {
                            for (Object o : this.data) {
                                WorldUtil.registerPlanetClient((Integer)o, providerIndex);
                                ++providerIndex;
                                ids = ids + ((Integer)o).toString() + " ";
                            }
                        } else if (this.data.get(0) instanceof Integer[]) {
                            for (Integer o : (Integer[])this.data.get(0)) {
                                WorldUtil.registerPlanetClient(o, providerIndex);
                                ++providerIndex;
                                ids = ids + o.toString() + " ";
                            }
                        }
                    }
                    if (!ConfigManagerCore.enableDebug) break;
                    System.out.println("GC clientside planet dimensions registered: " + ids);
                    WorldProvider dimMoon = WorldUtil.getProviderForName("moon.moon");
                    if (dimMoon != null) {
                        System.out.println("Crosscheck: Moon is " + dimMoon.field_76574_g);
                    }
                    WorldProvider dimMars = WorldUtil.getProviderForName("planet.mars");
                    if (dimMoon != null) {
                        System.out.println("Crosscheck: Mars is " + dimMars.field_76574_g);
                    }
                    WorldProvider dimAst = WorldUtil.getProviderForName("planet.asteroids");
                    if (dimMoon == null) break;
                    System.out.println("Crosscheck: Asteroids is " + dimAst.field_76574_g);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case C_UPDATE_CONFIGS: {
                ConfigManagerCore.saveClientConfigOverrideable();
                ConfigManagerCore.setConfigOverride(this.data);
                break;
            }
            case C_ADD_NEW_SCHEMATIC: {
                ISchematicPage page = SchematicRegistry.getMatchingRecipeForID((Integer)this.data.get(0));
                if (stats.unlockedSchematics.contains(page)) break;
                stats.unlockedSchematics.add(page);
                break;
            }
            case C_UPDATE_SCHEMATIC_LIST: {
                for (Object o : this.data) {
                    Integer schematicID = (Integer)o;
                    if (schematicID == -2) continue;
                    Collections.sort(stats.unlockedSchematics);
                    if (stats.unlockedSchematics.contains(SchematicRegistry.getMatchingRecipeForID(schematicID))) continue;
                    stats.unlockedSchematics.add(SchematicRegistry.getMatchingRecipeForID(schematicID));
                }
                break;
            }
            case C_PLAY_SOUND_BOSS_DEATH: {
                player.func_85030_a(GalacticraftCore.TEXTURE_PREFIX + "entity.bossdeath", 10.0f, 0.8f);
                break;
            }
            case C_PLAY_SOUND_EXPLODE: {
                player.func_85030_a("random.explode", 10.0f, 0.7f);
                break;
            }
            case C_PLAY_SOUND_BOSS_LAUGH: {
                player.func_85030_a(GalacticraftCore.TEXTURE_PREFIX + "entity.bosslaugh", 10.0f, 0.2f);
                break;
            }
            case C_PLAY_SOUND_BOW: {
                player.func_85030_a("random.bow", 10.0f, 0.2f);
                break;
            }
            case C_UPDATE_OXYGEN_VALIDITY: {
                stats.oxygenSetupValid = (Boolean)this.data.get(0);
                break;
            }
            case C_OPEN_PARACHEST_GUI: {
                switch ((Integer)this.data.get(1)) {
                    case 0: {
                        if (!(player.field_70154_o instanceof EntityBuggy)) break;
                        FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiBuggy((IInventory)player.field_71071_by, (EntityBuggy)player.field_70154_o, ((EntityBuggy)player.field_70154_o).getType()));
                        player.field_71070_bA.field_75152_c = (Integer)this.data.get(0);
                        break;
                    }
                    case 1: {
                        int entityID = (Integer)this.data.get(2);
                        Entity entity = player.field_70170_p.func_73045_a(entityID);
                        if (entity != null && entity instanceof IInventorySettable) {
                            FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiParaChest((IInventory)player.field_71071_by, (IInventorySettable)entity));
                        }
                        player.field_71070_bA.field_75152_c = (Integer)this.data.get(0);
                    }
                }
                break;
            }
            case C_UPDATE_WIRE_BOUNDS: {
                TileEntity tile = player.field_70170_p.func_147438_o(((Integer)this.data.get(0)).intValue(), ((Integer)this.data.get(1)).intValue(), ((Integer)this.data.get(2)).intValue());
                if (!(tile instanceof TileBaseConductor)) break;
                ((TileBaseConductor)tile).adjacentConnections = null;
                player.field_70170_p.func_147439_a(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e).func_149719_a((IBlockAccess)player.field_70170_p, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
                break;
            }
            case C_OPEN_SPACE_RACE_GUI: {
                if (Minecraft.func_71410_x().field_71462_r == null) {
                    TickHandlerClient.spaceRaceGuiScheduled = false;
                    player.openGui((Object)GalacticraftCore.instance, 6, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                    break;
                }
                TickHandlerClient.spaceRaceGuiScheduled = true;
                break;
            }
            case C_UPDATE_SPACE_RACE_DATA: {
                Integer teamID = (Integer)this.data.get(0);
                String teamName = (String)this.data.get(1);
                FlagData flagData = (FlagData)this.data.get(2);
                Vector3 teamColor = (Vector3)this.data.get(3);
                ArrayList<String> playerList = new ArrayList<String>();
                for (int i = 4; i < this.data.size(); ++i) {
                    String playerName = (String)this.data.get(i);
                    ClientProxyCore.flagRequestsSent.remove(playerName);
                    playerList.add(playerName);
                }
                SpaceRace race = new SpaceRace(playerList, teamName, flagData, teamColor);
                race.setSpaceRaceID(teamID);
                SpaceRaceManager.addSpaceRace(race);
                break;
            }
            case C_OPEN_JOIN_RACE_GUI: {
                stats.spaceRaceInviteTeamID = (Integer)this.data.get(0);
                player.openGui((Object)GalacticraftCore.instance, 7, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                break;
            }
            case C_UPDATE_FOOTPRINT_LIST: {
                ArrayList<Footprint> printList = new ArrayList<Footprint>();
                long chunkKey = (Long)this.data.get(0);
                for (int i = 1; i < this.data.size(); ++i) {
                    Footprint print = (Footprint)this.data.get(i);
                    printList.add(print);
                }
                ClientProxyCore.footprintRenderer.setFootprints(chunkKey, printList);
                break;
            }
            case C_UPDATE_STATION_SPIN: {
                if (!(playerBaseClient.field_70170_p.field_73011_w instanceof WorldProviderOrbit)) break;
                ((WorldProviderOrbit)playerBaseClient.field_70170_p.field_73011_w).setSpinRate(((Float)this.data.get(0)).floatValue(), (Boolean)this.data.get(1));
                break;
            }
            case C_UPDATE_STATION_DATA: {
                if (!(playerBaseClient.field_70170_p.field_73011_w instanceof WorldProviderOrbit)) break;
                ((WorldProviderOrbit)playerBaseClient.field_70170_p.field_73011_w).setSpinCentre((Double)this.data.get(0), (Double)this.data.get(1));
                break;
            }
            case C_UPDATE_STATION_BOX: {
                if (!(playerBaseClient.field_70170_p.field_73011_w instanceof WorldProviderOrbit)) break;
                ((WorldProviderOrbit)playerBaseClient.field_70170_p.field_73011_w).setSpinBox((Integer)this.data.get(0), (Integer)this.data.get(1), (Integer)this.data.get(2), (Integer)this.data.get(3), (Integer)this.data.get(4), (Integer)this.data.get(5));
                break;
            }
            case C_UPDATE_THERMAL_LEVEL: {
                stats.thermalLevel = (Integer)this.data.get(0);
                break;
            }
            case C_DISPLAY_ROCKET_CONTROLS: {
                player.func_145747_a((IChatComponent)new ChatComponentText(GameSettings.func_74298_c((int)KeyHandlerClient.spaceKey.func_151463_i()) + "  - " + GCCoreUtil.translate("gui.rocket.launch.name")));
                player.func_145747_a((IChatComponent)new ChatComponentText(GameSettings.func_74298_c((int)KeyHandlerClient.leftKey.func_151463_i()) + " / " + GameSettings.func_74298_c((int)KeyHandlerClient.rightKey.func_151463_i()) + "  - " + GCCoreUtil.translate("gui.rocket.turn.name")));
                player.func_145747_a((IChatComponent)new ChatComponentText(GameSettings.func_74298_c((int)KeyHandlerClient.accelerateKey.func_151463_i()) + " / " + GameSettings.func_74298_c((int)KeyHandlerClient.decelerateKey.func_151463_i()) + "  - " + GCCoreUtil.translate("gui.rocket.updown.name")));
                player.func_145747_a((IChatComponent)new ChatComponentText(GameSettings.func_74298_c((int)KeyHandlerClient.openFuelGui.func_151463_i()) + "       - " + GCCoreUtil.translate("gui.rocket.inv.name")));
                break;
            }
            case C_GET_CELESTIAL_BODY_LIST: {
                String str = "";
                for (CelestialBody celestialBody : GalaxyRegistry.getRegisteredPlanets().values()) {
                    str = str.concat(celestialBody.getUnlocalizedName() + ";");
                }
                for (CelestialBody celestialBody : GalaxyRegistry.getRegisteredMoons().values()) {
                    str = str.concat(celestialBody.getUnlocalizedName() + ";");
                }
                for (CelestialBody celestialBody : GalaxyRegistry.getRegisteredSatellites().values()) {
                    str = str.concat(celestialBody.getUnlocalizedName() + ";");
                }
                for (SolarSystem solarSystem : GalaxyRegistry.getRegisteredSolarSystems().values()) {
                    str = str.concat(solarSystem.getUnlocalizedName() + ";");
                }
                GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(EnumSimplePacket.S_COMPLETE_CBODY_HANDSHAKE, new Object[]{str}));
                break;
            }
            case C_UPDATE_ENERGYUNITS: {
                CommandGCEnergyUnits.handleParamClientside((Integer)this.data.get(0));
                break;
            }
            case C_RESPAWN_PLAYER: {
                WorldProvider provider = WorldUtil.getProviderForName((String)this.data.get(0));
                int n = provider.field_76574_g;
                if (ConfigManagerCore.enableDebug) {
                    GCLog.info("DEBUG: Client receiving respawn packet for dim " + n);
                }
                int par2 = (Integer)this.data.get(1);
                String par3 = (String)this.data.get(2);
                int par4 = (Integer)this.data.get(3);
                WorldUtil.forceRespawnClient(n, par2, par3, par4);
                break;
            }
            case C_UPDATE_ARCLAMP_FACING: {
                TileEntity tile = player.field_70170_p.func_147438_o(((Integer)this.data.get(0)).intValue(), ((Integer)this.data.get(1)).intValue(), ((Integer)this.data.get(2)).intValue());
                int facingNew = (Integer)this.data.get(3);
                if (!(tile instanceof TileEntityArclamp)) break;
                ((TileEntityArclamp)tile).facing = facingNew;
                break;
            }
            case C_UPDATE_STATS: {
                stats.buildFlags = (Integer)this.data.get(0);
                break;
            }
            case C_UPDATE_VIEWSCREEN: {
                TileEntity tile = player.field_70170_p.func_147438_o(((Integer)this.data.get(0)).intValue(), ((Integer)this.data.get(1)).intValue(), ((Integer)this.data.get(2)).intValue());
                if (!(tile instanceof TileEntityScreen)) break;
                TileEntityScreen screenTile = (TileEntityScreen)tile;
                int screenType = (Integer)this.data.get(3);
                int flags = (Integer)this.data.get(4);
                screenTile.imageType = screenType;
                screenTile.connectedUp = (flags & 8) > 0;
                screenTile.connectedDown = (flags & 4) > 0;
                screenTile.connectedLeft = (flags & 2) > 0;
                screenTile.connectedRight = (flags & 1) > 0;
                screenTile.refreshNextTick(true);
                break;
            }
            case C_UPDATE_TELEMETRY: {
                TileEntity tile = player.field_70170_p.func_147438_o(((Integer)this.data.get(0)).intValue(), ((Integer)this.data.get(1)).intValue(), ((Integer)this.data.get(2)).intValue());
                if (!(tile instanceof TileEntityTelemetry)) break;
                String name = (String)this.data.get(3);
                if (name.startsWith("$")) {
                    String strName;
                    ((TileEntityTelemetry)tile).clientClass = EntityPlayerMP.class;
                    ((TileEntityTelemetry)tile).clientName = strName = name.substring(1);
                    GameProfile profile = FMLClientHandler.instance().getClientPlayerEntity().func_146103_bH();
                    if (!strName.equals(profile.getName())) {
                        profile = PlayerUtil.getOtherPlayerProfile(strName);
                        if (profile == null) {
                            String strUUID = (String)this.data.get(9);
                            profile = PlayerUtil.makeOtherPlayerProfile(strName, strUUID);
                        }
                        if (VersionUtil.mcVersionMatches("1.7.10") && !profile.getProperties().containsKey((Object)"textures")) {
                            GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(EnumSimplePacket.S_REQUEST_PLAYERSKIN, new Object[]{strName}));
                        }
                    }
                    ((TileEntityTelemetry)tile).clientGameProfile = profile;
                } else {
                    ((TileEntityTelemetry)tile).clientClass = (Class)EntityList.field_75625_b.get(name);
                }
                ((TileEntityTelemetry)tile).clientData = new int[5];
                for (int i = 4; i < 9; ++i) {
                    ((TileEntityTelemetry)tile).clientData[i - 4] = (Integer)this.data.get(i);
                }
                break;
            }
            case C_SEND_PLAYERSKIN: {
                String strName = (String)this.data.get(0);
                String s1 = (String)this.data.get(1);
                String s2 = (String)this.data.get(2);
                String strUUID = (String)this.data.get(3);
                GameProfile gp = PlayerUtil.getOtherPlayerProfile(strName);
                if (gp == null) {
                    gp = PlayerUtil.makeOtherPlayerProfile(strName, strUUID);
                }
                gp.getProperties().put((Object)"textures", (Object)new Property("textures", s1, s2));
                break;
            }
            case C_SEND_OVERWORLD_IMAGE: {
                try {
                    byte[] bytes = (byte[])this.data.get(0);
                    File folder = new File(FMLClientHandler.instance().getClient().field_71412_D, "assets/temp");
                    try {
                        if (folder.exists() || folder.mkdir()) {
                            File file0 = new File(folder, "overworld.png");
                            if (!file0.exists() || file0.canRead() && file0.canWrite()) {
                                FileUtils.writeByteArrayToFile((File)file0, (byte[])bytes);
                                BufferedImage img = ImageIO.read(file0);
                                if (img == null) break;
                                ClientProxyCore.overworldTextureClient = new DynamicTexture(img);
                                break;
                            }
                            System.err.println("Cannot read/write to file %minecraftDir%/assets/temp/overworld.png");
                            break;
                        }
                        System.err.println("Cannot create directory %minecraftDir%/assets/temp!");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {}
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handleServerSide(EntityPlayer player) {
        EntityPlayerMP playerBase = PlayerUtil.getPlayerBaseServerFromPlayer(player, false);
        GCPlayerStats stats = GCPlayerStats.get(playerBase);
        if (playerBase == null) {
            return;
        }
        block3 : switch (this.type) {
            case S_RESPAWN_PLAYER: {
                playerBase.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(player.field_71093_bK, player.field_70170_p.field_73013_u, player.field_70170_p.func_72912_H().func_76067_t(), playerBase.field_71134_c.func_73081_b()));
                break;
            }
            case S_TELEPORT_ENTITY: {
                try {
                    WorldProvider provider = WorldUtil.getProviderForName((String)this.data.get(0));
                    Integer dim = provider.field_76574_g;
                    GCLog.info("Found matching world (" + dim.toString() + ") for name: " + (String)this.data.get(0));
                    if (playerBase.field_70170_p instanceof WorldServer) {
                        WorldServer world = (WorldServer)playerBase.field_70170_p;
                        WorldUtil.transferEntityToDimension((Entity)playerBase, dim, world);
                    }
                    stats.teleportCooldown = 10;
                    GalacticraftCore.packetPipeline.sendTo(new PacketSimple(EnumSimplePacket.C_CLOSE_GUI, new Object[0]), playerBase);
                }
                catch (Exception e) {
                    GCLog.severe("Error occurred when attempting to transfer entity to dimension: " + (String)this.data.get(0));
                    e.printStackTrace();
                }
                break;
            }
            case S_IGNITE_ROCKET: {
                if (player.field_70170_p.field_72995_K || player.field_70128_L || player.field_70154_o == null || player.field_70154_o.field_70128_L || !(player.field_70154_o instanceof EntityTieredRocket)) break;
                EntityTieredRocket ship = (EntityTieredRocket)player.field_70154_o;
                if (ship.landing) break;
                if (ship.hasValidFuel()) {
                    ItemStack stack2 = stats.extendedInventory.func_70301_a(4);
                    if (stack2 != null && stack2.func_77973_b() instanceof ItemParaChute || stats.launchAttempts > 0) {
                        ship.igniteCheckingCooldown();
                        stats.launchAttempts = 0;
                        break;
                    }
                    if (stats.chatCooldown != 0 || stats.launchAttempts != 0) break;
                    player.func_145747_a((IChatComponent)new ChatComponentText(GCCoreUtil.translate("gui.rocket.warning.noparachute")));
                    stats.chatCooldown = 250;
                    stats.launchAttempts = 1;
                    break;
                }
                if (stats.chatCooldown != 0) break;
                player.func_145747_a((IChatComponent)new ChatComponentText(GCCoreUtil.translate("gui.rocket.warning.nofuel")));
                stats.chatCooldown = 250;
                break;
            }
            case S_OPEN_SCHEMATIC_PAGE: {
                if (player == null) break;
                ISchematicPage page = SchematicRegistry.getMatchingRecipeForID((Integer)this.data.get(0));
                player.openGui((Object)GalacticraftCore.instance, page.getGuiID(), player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                break;
            }
            case S_OPEN_FUEL_GUI: {
                if (player.field_70154_o instanceof EntityBuggy) {
                    GCCoreUtil.openBuggyInv(playerBase, (EntityBuggy)player.field_70154_o, ((EntityBuggy)player.field_70154_o).getType());
                    break;
                }
                if (!(player.field_70154_o instanceof EntitySpaceshipBase)) break;
                player.openGui((Object)GalacticraftCore.instance, 4, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                break;
            }
            case S_UPDATE_SHIP_YAW: {
                EntitySpaceshipBase ship;
                if (!(player.field_70154_o instanceof EntitySpaceshipBase) || (ship = (EntitySpaceshipBase)player.field_70154_o) == null) break;
                ship.field_70177_z = ((Float)this.data.get(0)).floatValue();
                break;
            }
            case S_UPDATE_SHIP_PITCH: {
                EntitySpaceshipBase ship;
                if (!(player.field_70154_o instanceof EntitySpaceshipBase) || (ship = (EntitySpaceshipBase)player.field_70154_o) == null) break;
                ship.field_70125_A = ((Float)this.data.get(0)).floatValue();
                break;
            }
            case S_SET_ENTITY_FIRE: {
                Entity entity = player.field_70170_p.func_73045_a(((Integer)this.data.get(0)).intValue());
                if (!(entity instanceof EntityLivingBase)) break;
                ((EntityLivingBase)entity).func_70015_d(3);
                break;
            }
            case S_BIND_SPACE_STATION_ID: {
                if (stats.spaceStationDimensionID != -1 && stats.spaceStationDimensionID != 0 || ConfigManagerCore.disableSpaceStationCreation) break;
                WorldUtil.bindSpaceStationToNewDimension(playerBase.field_70170_p, playerBase);
                WorldUtil.getSpaceStationRecipe((Integer)this.data.get(0)).matches((EntityPlayer)playerBase, true);
                break;
            }
            case S_UNLOCK_NEW_SCHEMATIC: {
                ISchematicPage page;
                Container container = player.field_71070_bA;
                if (!(container instanceof ContainerSchematic)) break;
                ContainerSchematic schematicContainer = (ContainerSchematic)container;
                ItemStack stack = schematicContainer.craftMatrix.func_70301_a(0);
                if (stack == null || (page = SchematicRegistry.getMatchingRecipeForItemStack(stack)) == null) break;
                SchematicRegistry.unlockNewPage(playerBase, stack);
                if (--stack.field_77994_a <= 0) {
                    stack = null;
                }
                schematicContainer.craftMatrix.func_70299_a(0, stack);
                schematicContainer.craftMatrix.func_70296_d();
                GalacticraftCore.packetPipeline.sendTo(new PacketSimple(EnumSimplePacket.C_ADD_NEW_SCHEMATIC, new Object[]{page.getPageID()}), playerBase);
                break;
            }
            case S_UPDATE_DISABLEABLE_BUTTON: {
                TileEntity tileAt = player.field_70170_p.func_147438_o(((Integer)this.data.get(0)).intValue(), ((Integer)this.data.get(1)).intValue(), ((Integer)this.data.get(2)).intValue());
                if (!(tileAt instanceof IDisableableMachine)) break;
                IDisableableMachine machine = (IDisableableMachine)tileAt;
                machine.setDisabled((Integer)this.data.get(3), !machine.getDisabled((Integer)this.data.get(3)));
                break;
            }
            case S_ON_FAILED_CHEST_UNLOCK: {
                if (stats.chatCooldown != 0) break;
                player.func_145747_a((IChatComponent)new ChatComponentText(GCCoreUtil.translateWithFormat("gui.chest.warning.wrongkey", this.data.get(0))));
                stats.chatCooldown = 100;
                break;
            }
            case S_RENAME_SPACE_STATION: {
                SpaceStationWorldData ssdata = SpaceStationWorldData.getStationData(playerBase.field_70170_p, (Integer)this.data.get(1), (EntityPlayer)playerBase);
                if (ssdata == null || !ssdata.getOwner().equalsIgnoreCase(player.func_146103_bH().getName())) break;
                ssdata.setSpaceStationName((String)this.data.get(0));
                ssdata.func_76186_a(true);
                break;
            }
            case S_OPEN_EXTENDED_INVENTORY: {
                player.openGui((Object)GalacticraftCore.instance, 5, player.field_70170_p, 0, 0, 0);
                break;
            }
            case S_ON_ADVANCED_GUI_CLICKED_INT: {
                TileEntity tile1 = player.field_70170_p.func_147438_o(((Integer)this.data.get(1)).intValue(), ((Integer)this.data.get(2)).intValue(), ((Integer)this.data.get(3)).intValue());
                switch ((Integer)this.data.get(0)) {
                    case 0: {
                        if (!(tile1 instanceof TileEntityAirLockController)) break block3;
                        TileEntityAirLockController airlockController = (TileEntityAirLockController)tile1;
                        airlockController.redstoneActivation = (Integer)this.data.get(4) == 1;
                        break block3;
                    }
                    case 1: {
                        if (!(tile1 instanceof TileEntityAirLockController)) break block3;
                        TileEntityAirLockController airlockController = (TileEntityAirLockController)tile1;
                        airlockController.playerDistanceActivation = (Integer)this.data.get(4) == 1;
                        break block3;
                    }
                    case 2: {
                        if (!(tile1 instanceof TileEntityAirLockController)) break block3;
                        TileEntityAirLockController airlockController = (TileEntityAirLockController)tile1;
                        airlockController.playerDistanceSelection = (Integer)this.data.get(4);
                        break block3;
                    }
                    case 3: {
                        if (!(tile1 instanceof TileEntityAirLockController)) break block3;
                        TileEntityAirLockController airlockController = (TileEntityAirLockController)tile1;
                        airlockController.playerNameMatches = (Integer)this.data.get(4) == 1;
                        break block3;
                    }
                    case 4: {
                        if (!(tile1 instanceof TileEntityAirLockController)) break block3;
                        TileEntityAirLockController airlockController = (TileEntityAirLockController)tile1;
                        airlockController.invertSelection = (Integer)this.data.get(4) == 1;
                        break block3;
                    }
                    case 5: {
                        if (!(tile1 instanceof TileEntityAirLockController)) break block3;
                        TileEntityAirLockController airlockController = (TileEntityAirLockController)tile1;
                        airlockController.lastHorizontalModeEnabled = airlockController.horizontalModeEnabled;
                        airlockController.horizontalModeEnabled = (Integer)this.data.get(4) == 1;
                        break block3;
                    }
                    case 6: {
                        if (!(tile1 instanceof IBubbleProvider)) break block3;
                        IBubbleProvider distributor = (IBubbleProvider)tile1;
                        distributor.setBubbleVisible((Integer)this.data.get(4) == 1);
                        break block3;
                    }
                }
                break;
            }
            case S_ON_ADVANCED_GUI_CLICKED_STRING: {
                TileEntity tile2 = player.field_70170_p.func_147438_o(((Integer)this.data.get(1)).intValue(), ((Integer)this.data.get(2)).intValue(), ((Integer)this.data.get(3)).intValue());
                switch ((Integer)this.data.get(0)) {
                    case 0: {
                        if (!(tile2 instanceof TileEntityAirLockController)) break block3;
                        TileEntityAirLockController airlockController = (TileEntityAirLockController)tile2;
                        airlockController.playerToOpenFor = (String)this.data.get(4);
                        break block3;
                    }
                }
                break;
            }
            case S_UPDATE_SHIP_MOTION_Y: {
                int entityID = (Integer)this.data.get(0);
                boolean up = (Boolean)this.data.get(1);
                Entity entity2 = player.field_70170_p.func_73045_a(entityID);
                if (!(entity2 instanceof EntityAutoRocket)) break;
                EntityAutoRocket autoRocket = (EntityAutoRocket)entity2;
                autoRocket.field_70181_x = autoRocket.field_70181_x + (up ? (double)0.02f : (double)-0.02f);
                break;
            }
            case S_START_NEW_SPACE_RACE: {
                Integer teamID = (Integer)this.data.get(0);
                String teamName = (String)this.data.get(1);
                FlagData flagData = (FlagData)this.data.get(2);
                Vector3 teamColor = (Vector3)this.data.get(3);
                ArrayList<String> playerList = new ArrayList<String>();
                for (int i = 4; i < this.data.size(); ++i) {
                    playerList.add((String)this.data.get(i));
                }
                boolean previousData = SpaceRaceManager.getSpaceRaceFromID(teamID) != null;
                SpaceRace newRace = new SpaceRace(playerList, teamName, flagData, teamColor);
                if (teamID > 0) {
                    newRace.setSpaceRaceID(teamID);
                }
                SpaceRaceManager.addSpaceRace(newRace);
                if (!previousData) break;
                SpaceRaceManager.sendSpaceRaceData(null, SpaceRaceManager.getSpaceRaceFromPlayer(playerBase.func_146103_bH().getName()));
                break;
            }
            case S_REQUEST_FLAG_DATA: {
                SpaceRaceManager.sendSpaceRaceData(playerBase, SpaceRaceManager.getSpaceRaceFromPlayer((String)this.data.get(0)));
                break;
            }
            case S_INVITE_RACE_PLAYER: {
                void var30_69;
                String[] teamNameSplit;
                Integer teamInvitedTo;
                SpaceRace race;
                EntityPlayerMP playerInvited = PlayerUtil.getPlayerBaseServerFromPlayerUsername((String)this.data.get(0), true);
                if (playerInvited == null || (race = SpaceRaceManager.getSpaceRaceFromID(teamInvitedTo = (Integer)this.data.get(1))) == null) break;
                GCPlayerStats.get((EntityPlayerMP)playerInvited).spaceRaceInviteTeamID = teamInvitedTo;
                String dA = EnumColor.DARK_AQUA.code;
                String bG = EnumColor.BRIGHT_GREEN.code;
                String dB = EnumColor.PURPLE.code;
                String teamNameTotal = "";
                String[] arr$ = teamNameSplit = race.getTeamName().split(" ");
                int len$ = arr$.length;
                boolean bl = false;
                while (var30_69 < len$) {
                    String teamNamePart = arr$[var30_69];
                    teamNameTotal = teamNameTotal.concat(dB + teamNamePart + " ");
                    ++var30_69;
                }
                playerInvited.func_145747_a(new ChatComponentText(dA + GCCoreUtil.translateWithFormat("gui.spaceRace.chat.inviteReceived", bG + player.func_146103_bH().getName() + dA) + "  " + GCCoreUtil.translateWithFormat("gui.spaceRace.chat.toJoin", teamNameTotal, (Object)((Object)EnumColor.AQUA) + "/joinrace" + dA)).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.DARK_AQUA)));
                break;
            }
            case S_REMOVE_RACE_PLAYER: {
                Integer teamInvitedTo = (Integer)this.data.get(1);
                SpaceRace race = SpaceRaceManager.getSpaceRaceFromID(teamInvitedTo);
                if (race == null) break;
                String playerToRemove = (String)this.data.get(0);
                if (!race.getPlayerNames().remove(playerToRemove)) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(GCCoreUtil.translateWithFormat("gui.spaceRace.chat.notFound", playerToRemove)));
                    break;
                }
                SpaceRaceManager.onPlayerRemoval(playerToRemove, race);
                break;
            }
            case S_ADD_RACE_PLAYER: {
                Integer teamToAddPlayer = (Integer)this.data.get(1);
                SpaceRace spaceRaceToAddPlayer = SpaceRaceManager.getSpaceRaceFromID(teamToAddPlayer);
                if (spaceRaceToAddPlayer == null) break;
                String playerToAdd = (String)this.data.get(0);
                if (!spaceRaceToAddPlayer.getPlayerNames().contains(playerToAdd)) {
                    SpaceRace oldRace = null;
                    while ((oldRace = SpaceRaceManager.getSpaceRaceFromPlayer(playerToAdd)) != null) {
                        SpaceRaceManager.removeSpaceRace(oldRace);
                    }
                    spaceRaceToAddPlayer.getPlayerNames().add(playerToAdd);
                    SpaceRaceManager.sendSpaceRaceData(null, spaceRaceToAddPlayer);
                    for (String member : spaceRaceToAddPlayer.getPlayerNames()) {
                        EntityPlayerMP memberObj = PlayerUtil.getPlayerForUsernameVanilla(MinecraftServer.func_71276_C(), member);
                        if (memberObj == null) continue;
                        memberObj.func_145747_a(new ChatComponentText((Object)((Object)EnumColor.DARK_AQUA) + GCCoreUtil.translateWithFormat("gui.spaceRace.chat.addSuccess", (Object)((Object)EnumColor.BRIGHT_GREEN) + playerToAdd + (Object)((Object)EnumColor.DARK_AQUA))).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.DARK_AQUA)));
                    }
                    break;
                }
                player.func_145747_a(new ChatComponentText(GCCoreUtil.translate("gui.spaceRace.chat.alreadyPart")).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.DARK_RED)));
                break;
            }
            case S_COMPLETE_CBODY_HANDSHAKE: {
                String completeList = (String)this.data.get(0);
                List<String> clientObjects = Arrays.asList(completeList.split(";"));
                ArrayList serverObjects = Lists.newArrayList();
                String missingObjects = "";
                for (CelestialBody celestialBody : GalaxyRegistry.getRegisteredPlanets().values()) {
                    serverObjects.add(celestialBody.getUnlocalizedName());
                }
                for (CelestialBody celestialBody : GalaxyRegistry.getRegisteredMoons().values()) {
                    serverObjects.add(celestialBody.getUnlocalizedName());
                }
                for (CelestialBody celestialBody : GalaxyRegistry.getRegisteredSatellites().values()) {
                    serverObjects.add(celestialBody.getUnlocalizedName());
                }
                for (SolarSystem solarSystem : GalaxyRegistry.getRegisteredSolarSystems().values()) {
                    serverObjects.add(solarSystem.getUnlocalizedName());
                }
                for (String string : serverObjects) {
                    if (clientObjects.contains(string)) continue;
                    missingObjects = missingObjects.concat(string + "\n");
                }
                if (missingObjects.length() <= 0) break;
                playerBase.field_71135_a.func_147360_c("Missing Galacticraft Celestial Objects:\n\n " + missingObjects);
                break;
            }
            case S_REQUEST_GEAR_DATA: {
                String name = (String)this.data.get(0);
                EntityPlayerMP entityPlayerMP = PlayerUtil.getPlayerBaseServerFromPlayerUsername(name, true);
                if (entityPlayerMP == null) break;
                GCPlayerHandler.checkGear(entityPlayerMP, GCPlayerStats.get(entityPlayerMP), true);
                break;
            }
            case S_REQUEST_ARCLAMP_FACING: {
                TileEntity tileAL = player.field_70170_p.func_147438_o(((Integer)this.data.get(0)).intValue(), ((Integer)this.data.get(1)).intValue(), ((Integer)this.data.get(2)).intValue());
                if (!(tileAL instanceof TileEntityArclamp)) break;
                ((TileEntityArclamp)tileAL).updateClientFlag = true;
                break;
            }
            case S_BUILDFLAGS_UPDATE: {
                stats.buildFlags = (Integer)this.data.get(0);
                break;
            }
            case S_UPDATE_VIEWSCREEN_REQUEST: {
                int screenDim = (Integer)this.data.get(0);
                TileEntity tile = player.field_70170_p.func_147438_o(((Integer)this.data.get(1)).intValue(), ((Integer)this.data.get(2)).intValue(), ((Integer)this.data.get(3)).intValue());
                if (!(tile instanceof TileEntityScreen)) break;
                ((TileEntityScreen)tile).updateClients();
                break;
            }
            case S_REQUEST_OVERWORLD_IMAGE: {
                ChunkCoordIntPair chunkCoordIntPair = new ChunkCoordIntPair((int)Math.floor(stats.coordsTeleportedFromX) >> 4, (int)Math.floor(stats.coordsTeleportedFromZ) >> 4);
                File baseFolder = new File(MinecraftServer.func_71276_C().func_71218_a(0).getChunkSaveLocation(), "galacticraft/overworldMap");
                if (!baseFolder.exists()) {
                    baseFolder.mkdirs();
                }
                File outputFile = new File(baseFolder, "" + chunkCoordIntPair.field_77276_a + "_" + chunkCoordIntPair.field_77275_b + ".jpg");
                boolean success = true;
                if (!outputFile.exists() || !outputFile.isFile()) {
                    success = false;
                    BufferedImage image = new BufferedImage(400, 400, 1);
                    for (int x0 = -12; x0 <= 12; ++x0) {
                        for (int z0 = -12; z0 <= 12; ++z0) {
                            Chunk chunk = MinecraftServer.func_71276_C().func_71218_a(0).func_72964_e(chunkCoordIntPair.field_77276_a + x0, chunkCoordIntPair.field_77275_b + z0);
                            if (chunk == null) continue;
                            for (int z = 0; z < 16; ++z) {
                                for (int x = 0; x < 16; ++x) {
                                    int l4 = chunk.func_76611_b(x, z) + 1;
                                    Block block = Blocks.field_150350_a;
                                    int i5 = 0;
                                    if (l4 > 1) {
                                        while ((block = chunk.func_150810_a(x, --l4, z)).func_149728_f(i5 = chunk.func_76628_c(x, l4, z)) == MapColor.field_151660_b && l4 > 0) {
                                        }
                                    }
                                    int col = block.func_149728_f((int)i5).field_76291_p;
                                    image.setRGB(x + (x0 + 12) * 16, z + (z0 + 12) * 16, col);
                                }
                            }
                        }
                    }
                    try {
                        if (!outputFile.exists() || outputFile.canWrite() && outputFile.canRead()) {
                            FileImageOutputStream outputStream = new FileImageOutputStream(outputFile);
                            GalacticraftCore.jpgWriter.setOutput(outputStream);
                            GalacticraftCore.jpgWriter.write(null, new IIOImage(image, null, null), GalacticraftCore.writeParam);
                            outputStream.close();
                            success = true;
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                if (success) {
                    try {
                        byte[] bytes = FileUtils.readFileToByteArray((File)outputFile);
                        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(EnumSimplePacket.C_SEND_OVERWORLD_IMAGE, new Object[]{bytes}), playerBase);
                    }
                    catch (Exception ex) {
                        System.err.println("Error sending overworld image to player.");
                        ex.printStackTrace();
                    }
                    break;
                }
                System.err.println("[Galacticraft] Error creating player's overworld texture, please report this as a bug!");
                break;
            }
            case S_REQUEST_PLAYERSKIN: {
                String strName = (String)this.data.get(0);
                EntityPlayerMP playerRequested = FMLServerHandler.instance().getServer().func_71203_ab().func_152612_a(strName);
                if (playerRequested == null) {
                    return;
                }
                GameProfile gp = playerRequested.func_146103_bH();
                if (gp == null) {
                    return;
                }
                Property property = (Property)Iterables.getFirst((Iterable)gp.getProperties().get((Object)"textures"), (Object)null);
                if (property == null) {
                    return;
                }
                GalacticraftCore.packetPipeline.sendTo(new PacketSimple(EnumSimplePacket.C_SEND_PLAYERSKIN, new Object[]{strName, property.getValue(), property.getSignature(), playerRequested.func_110124_au().toString()}), playerBase);
                break;
            }
        }
    }

    public void func_148837_a(PacketBuffer var1) {
        this.decodeInto(null, (ByteBuf)var1);
    }

    public void func_148840_b(PacketBuffer var1) {
        this.encodeInto(null, (ByteBuf)var1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_148833_a(INetHandler var1) {
        if (this.type != EnumSimplePacket.C_UPDATE_SPACESTATION_LIST && this.type != EnumSimplePacket.C_UPDATE_PLANETS_LIST && this.type != EnumSimplePacket.C_UPDATE_CONFIGS) {
            return;
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.handleClientSide((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
        }
    }

    public static enum EnumSimplePacket {
        S_RESPAWN_PLAYER(Side.SERVER, String.class),
        S_TELEPORT_ENTITY(Side.SERVER, String.class),
        S_IGNITE_ROCKET(Side.SERVER, new Class[0]),
        S_OPEN_SCHEMATIC_PAGE(Side.SERVER, Integer.class),
        S_OPEN_FUEL_GUI(Side.SERVER, String.class),
        S_UPDATE_SHIP_YAW(Side.SERVER, Float.class),
        S_UPDATE_SHIP_PITCH(Side.SERVER, Float.class),
        S_SET_ENTITY_FIRE(Side.SERVER, Integer.class),
        S_BIND_SPACE_STATION_ID(Side.SERVER, Integer.class),
        S_UNLOCK_NEW_SCHEMATIC(Side.SERVER, new Class[0]),
        S_UPDATE_DISABLEABLE_BUTTON(Side.SERVER, Integer.class, Integer.class, Integer.class, Integer.class),
        S_ON_FAILED_CHEST_UNLOCK(Side.SERVER, Integer.class),
        S_RENAME_SPACE_STATION(Side.SERVER, String.class, Integer.class),
        S_OPEN_EXTENDED_INVENTORY(Side.SERVER, new Class[0]),
        S_ON_ADVANCED_GUI_CLICKED_INT(Side.SERVER, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class),
        S_ON_ADVANCED_GUI_CLICKED_STRING(Side.SERVER, Integer.class, Integer.class, Integer.class, Integer.class, String.class),
        S_UPDATE_SHIP_MOTION_Y(Side.SERVER, Integer.class, Boolean.class),
        S_START_NEW_SPACE_RACE(Side.SERVER, Integer.class, String.class, FlagData.class, Vector3.class, String[].class),
        S_REQUEST_FLAG_DATA(Side.SERVER, String.class),
        S_INVITE_RACE_PLAYER(Side.SERVER, String.class, Integer.class),
        S_REMOVE_RACE_PLAYER(Side.SERVER, String.class, Integer.class),
        S_ADD_RACE_PLAYER(Side.SERVER, String.class, Integer.class),
        S_COMPLETE_CBODY_HANDSHAKE(Side.SERVER, String.class),
        S_REQUEST_GEAR_DATA(Side.SERVER, String.class),
        S_REQUEST_ARCLAMP_FACING(Side.CLIENT, Integer.class, Integer.class, Integer.class),
        S_REQUEST_OVERWORLD_IMAGE(Side.SERVER, new Class[0]),
        S_REQUEST_PLAYERSKIN(Side.SERVER, String.class),
        S_UPDATE_VIEWSCREEN_REQUEST(Side.CLIENT, Integer.class, Integer.class, Integer.class, Integer.class),
        S_BUILDFLAGS_UPDATE(Side.SERVER, Integer.class),
        C_AIR_REMAINING(Side.CLIENT, Integer.class, Integer.class, String.class),
        C_UPDATE_DIMENSION_LIST(Side.CLIENT, String.class, String.class),
        C_SPAWN_SPARK_PARTICLES(Side.CLIENT, Integer.class, Integer.class, Integer.class),
        C_UPDATE_GEAR_SLOT(Side.CLIENT, String.class, Integer.class, Integer.class),
        C_CLOSE_GUI(Side.CLIENT, new Class[0]),
        C_RESET_THIRD_PERSON(Side.CLIENT, new Class[0]),
        C_UPDATE_SPACESTATION_LIST(Side.CLIENT, Integer[].class),
        C_UPDATE_SPACESTATION_DATA(Side.CLIENT, Integer.class, NBTTagCompound.class),
        C_UPDATE_SPACESTATION_CLIENT_ID(Side.CLIENT, Integer.class),
        C_UPDATE_PLANETS_LIST(Side.CLIENT, Integer[].class),
        C_UPDATE_CONFIGS(Side.CLIENT, Boolean.class, Double.class, Integer.class, Integer.class, Integer.class, Float.class, Float.class, Float.class, Float.class, Integer.class, String[].class),
        C_UPDATE_STATS(Side.CLIENT, Integer.class),
        C_ADD_NEW_SCHEMATIC(Side.CLIENT, Integer.class),
        C_UPDATE_SCHEMATIC_LIST(Side.CLIENT, Integer[].class),
        C_PLAY_SOUND_BOSS_DEATH(Side.CLIENT, new Class[0]),
        C_PLAY_SOUND_EXPLODE(Side.CLIENT, new Class[0]),
        C_PLAY_SOUND_BOSS_LAUGH(Side.CLIENT, new Class[0]),
        C_PLAY_SOUND_BOW(Side.CLIENT, new Class[0]),
        C_UPDATE_OXYGEN_VALIDITY(Side.CLIENT, Boolean.class),
        C_OPEN_PARACHEST_GUI(Side.CLIENT, Integer.class, Integer.class, Integer.class),
        C_UPDATE_WIRE_BOUNDS(Side.CLIENT, Integer.class, Integer.class, Integer.class),
        C_OPEN_SPACE_RACE_GUI(Side.CLIENT, new Class[0]),
        C_UPDATE_SPACE_RACE_DATA(Side.CLIENT, Integer.class, String.class, FlagData.class, Vector3.class, String[].class),
        C_OPEN_JOIN_RACE_GUI(Side.CLIENT, Integer.class),
        C_UPDATE_FOOTPRINT_LIST(Side.CLIENT, Long.class, Footprint[].class),
        C_UPDATE_STATION_SPIN(Side.CLIENT, Float.class, Boolean.class),
        C_UPDATE_STATION_DATA(Side.CLIENT, Double.class, Double.class),
        C_UPDATE_STATION_BOX(Side.CLIENT, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class),
        C_UPDATE_THERMAL_LEVEL(Side.CLIENT, Integer.class),
        C_DISPLAY_ROCKET_CONTROLS(Side.CLIENT, new Class[0]),
        C_GET_CELESTIAL_BODY_LIST(Side.CLIENT, new Class[0]),
        C_UPDATE_ENERGYUNITS(Side.CLIENT, Integer.class),
        C_RESPAWN_PLAYER(Side.CLIENT, String.class, Integer.class, String.class, Integer.class),
        C_UPDATE_ARCLAMP_FACING(Side.CLIENT, Integer.class, Integer.class, Integer.class, Integer.class),
        C_UPDATE_VIEWSCREEN(Side.CLIENT, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class),
        C_UPDATE_TELEMETRY(Side.CLIENT, Integer.class, Integer.class, Integer.class, String.class, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class, String.class),
        C_SEND_PLAYERSKIN(Side.CLIENT, String.class, String.class, String.class, String.class),
        C_SEND_OVERWORLD_IMAGE(Side.CLIENT, byte[].class);

        private Side targetSide;
        private Class<?>[] decodeAs;

        private EnumSimplePacket(Side targetSide, Class<?> ... decodeAs) {
            this.targetSide = targetSide;
            this.decodeAs = decodeAs;
        }

        public Side getTargetSide() {
            return this.targetSide;
        }

        public Class<?>[] getDecodeClasses() {
            return this.decodeAs;
        }
    }
}

