/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.ICargoEntity;
import micdoodle8.mods.galacticraft.api.entity.IDockable;
import micdoodle8.mods.galacticraft.api.entity.IFuelable;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.blocks.BlockMulti;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityLandingPad
extends TileEntityMulti
implements IMultiBlock,
IFuelable,
IFuelDock,
ICargoEntity {
    protected long ticks = 0L;
    private IDockable dockedEntity;

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            List list = this.field_145850_b.func_72872_a(IFuelable.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 0.5), (double)this.field_145848_d, (double)((double)this.field_145849_e - 0.5), (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 2.0), (double)((double)this.field_145849_e + 0.5)));
            boolean docked = false;
            for (Object o : list) {
                if (!(o instanceof IDockable)) continue;
                docked = true;
                IDockable fuelable = (IDockable)o;
                if (fuelable == this.dockedEntity || !fuelable.isDockValid(this)) break;
                fuelable.setPad(this);
                break;
            }
            if (!docked) {
                this.dockedEntity = null;
            }
        }
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public boolean onActivated(EntityPlayer entityPlayer) {
        return false;
    }

    @Override
    public void onCreate(BlockVec3 placedPosition) {
        this.mainBlockPosition = placedPosition;
        this.func_70296_d();
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                BlockVec3 vecToAdd = new BlockVec3(placedPosition.x + x, placedPosition.y, placedPosition.z + z);
                if (vecToAdd.equals(placedPosition)) continue;
                ((BlockMulti)GCBlocks.fakeBlock).makeFakeBlock(this.field_145850_b, vecToAdd, placedPosition, 2);
            }
        }
    }

    @Override
    public void onDestroy(TileEntity callingBlock) {
        BlockVec3 thisBlock = new BlockVec3(this);
        this.field_145850_b.func_147480_a(thisBlock.x, thisBlock.y, thisBlock.z, true);
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextDouble() < 0.1) {
                    FMLClientHandler.instance().getClient().field_71452_i.func_147215_a(thisBlock.x + x, thisBlock.y, thisBlock.z + z, GCBlocks.landingPad, Block.func_149682_b((Block)GCBlocks.landingPad) >> 12 & 0xFF);
                }
                this.field_145850_b.func_147468_f(thisBlock.x + x, thisBlock.y, thisBlock.z + z);
            }
        }
        if (this.dockedEntity != null) {
            this.dockedEntity.onPadDestroyed();
            this.dockedEntity = null;
        }
    }

    @Override
    public int addFuel(FluidStack liquid, boolean doFill) {
        if (this.dockedEntity != null) {
            return this.dockedEntity.addFuel(liquid, doFill);
        }
        return 0;
    }

    @Override
    public FluidStack removeFuel(int amount) {
        if (this.dockedEntity != null) {
            return this.dockedEntity.removeFuel(amount);
        }
        return null;
    }

    @Override
    public HashSet<ILandingPadAttachable> getConnectedTiles() {
        HashSet<ILandingPadAttachable> connectedTiles = new HashSet<ILandingPadAttachable>();
        for (int x = -2; x < 3; ++x) {
            for (int z = -2; z < 3; ++z) {
                TileEntity tile;
                if (x != -2 && x != 2 && z != -2 && z != 2 || Math.abs(x) == Math.abs(z) || (tile = this.field_145850_b.func_147438_o(this.field_145851_c + x, this.field_145848_d, this.field_145849_e + z)) == null || !(tile instanceof ILandingPadAttachable) || !((ILandingPadAttachable)tile).canAttachToLandingPad((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) continue;
                connectedTiles.add((ILandingPadAttachable)tile);
            }
        }
        return connectedTiles;
    }

    @Override
    public ICargoEntity.EnumCargoLoadingState addCargo(ItemStack stack, boolean doAdd) {
        if (this.dockedEntity != null) {
            return this.dockedEntity.addCargo(stack, doAdd);
        }
        return ICargoEntity.EnumCargoLoadingState.NOTARGET;
    }

    @Override
    public ICargoEntity.RemovalResult removeCargo(boolean doRemove) {
        if (this.dockedEntity != null) {
            return this.dockedEntity.removeCargo(doRemove);
        }
        return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.NOTARGET, null);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)((double)this.field_145848_d + 0.4), (double)(this.field_145849_e + 2));
    }

    @Override
    public boolean isBlockAttachable(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof ILandingPadAttachable) {
            return ((ILandingPadAttachable)tile).canAttachToLandingPad(world, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return false;
    }

    @Override
    public IDockable getDockedEntity() {
        return this.dockedEntity;
    }

    @Override
    public void dockEntity(IDockable entity) {
        this.dockedEntity = entity;
    }
}

