/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import com.google.common.collect.Lists;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.entity.IWorldTransferCallback;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.recipe.SpaceStationRecipe;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.api.world.SpaceStationType;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.dimension.SpaceStationWorldData;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderMoon;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderOrbit;
import micdoodle8.mods.galacticraft.core.entities.EntityCelestialFake;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerHandler;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.items.ItemParaChute;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTelemetry;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.VersionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.network.play.server.S1FPacketSetExperience;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldUtil {
    public static List<Integer> registeredSpaceStations;
    public static List<Integer> registeredPlanets;
    private static IWorldGenerator generatorGCGreg;
    private static IWorldGenerator generatorCoFH;
    private static IWorldGenerator generatorDenseOres;
    private static IWorldGenerator generatorTCAuraNodes;
    private static Method generateTCAuraNodes;
    private static boolean generatorsInitialised;

    public static double getGravityForEntity(Entity entity) {
        if (entity.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            IGalacticraftWorldProvider customProvider = (IGalacticraftWorldProvider)entity.field_70170_p.field_73011_w;
            return 0.08 - (double)customProvider.getGravity();
        }
        return 0.08;
    }

    public static double getItemGravity(EntityItem e) {
        if (e.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) {
            IGalacticraftWorldProvider customProvider = (IGalacticraftWorldProvider)e.field_70170_p.field_73011_w;
            return Math.max(0.002, (double)0.04f - (customProvider instanceof IOrbitDimension ? 0.05999999910593033 : (double)customProvider.getGravity()) / 1.75);
        }
        return 0.04f;
    }

    public static boolean shouldRenderFire(Entity entity) {
        if (!(entity instanceof EntityLivingBase)) {
            return entity.func_70027_ad();
        }
        return !(entity.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) && entity.func_70027_ad();
    }

    public static Vector3 getWorldColor(World world) {
        return new Vector3(1.0, 1.0, 1.0);
    }

    @SideOnly(value=Side.CLIENT)
    public static float getWorldBrightness(WorldClient world) {
        if (world.field_73011_w instanceof WorldProviderMoon) {
            float f1 = world.func_72826_c(1.0f);
            float f2 = 1.0f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            f2 = 1.0f - f2;
            return f2 * 0.8f;
        }
        return world.func_72971_b(1.0f);
    }

    public static float getColorRed(World world) {
        return (float)WorldUtil.getWorldColor((World)world).x;
    }

    public static float getColorGreen(World world) {
        return (float)WorldUtil.getWorldColor((World)world).y;
    }

    public static float getColorBlue(World world) {
        return (float)WorldUtil.getWorldColor((World)world).z;
    }

    public static Vec3 getFogColorHook(World world) {
        if (world.field_73011_w instanceof WorldProviderSurface && FMLClientHandler.instance().getClient().field_71439_g.field_70163_u >= 200.0) {
            float var20 = (float)(FMLClientHandler.instance().getClient().field_71439_g.field_70163_u - 200.0) / 1000.0f;
            float var21 = Math.max(1.0f - var20 * 4.0f, 0.0f);
            Vec3 vec = world.func_72948_g(1.0f);
            return Vec3.func_72443_a((double)(vec.field_72450_a * (double)var21), (double)(vec.field_72448_b * (double)var21), (double)(vec.field_72449_c * (double)var21));
        }
        return world.func_72948_g(1.0f);
    }

    public static Vec3 getSkyColorHook(World world) {
        if (world.field_73011_w instanceof WorldProviderSurface && FMLClientHandler.instance().getClient().field_71439_g.field_70163_u >= 200.0) {
            float var20 = (float)(FMLClientHandler.instance().getClient().field_71439_g.field_70163_u - 200.0) / 1000.0f;
            float var21 = Math.max(1.0f - var20 * 2.0f, 0.0f);
            Vec3 vec = world.func_72833_a((Entity)FMLClientHandler.instance().getClient().field_71451_h, 1.0f);
            return Vec3.func_72443_a((double)(vec.field_72450_a * (double)var21), (double)(vec.field_72448_b * (double)var21), (double)(vec.field_72449_c * (double)var21));
        }
        return world.func_72833_a((Entity)FMLClientHandler.instance().getClient().field_71451_h, 1.0f);
    }

    public static WorldProvider getProviderForName(String par1String) {
        String nameToFind = par1String;
        if (par1String.contains("$")) {
            String[] twoDimensions = par1String.split("\\$");
            nameToFind = twoDimensions[0];
        }
        if (nameToFind == null) {
            return null;
        }
        for (Integer element : WorldUtil.getArrayOfPossibleDimensions()) {
            WorldProvider elementProvider = WorldUtil.getProviderForDimension(element);
            if (elementProvider == null || !nameToFind.equals(elementProvider.func_80007_l())) continue;
            return elementProvider;
        }
        GCLog.info("Failed to find matching world for '" + par1String + "'");
        return null;
    }

    public static List<Integer> getPossibleDimensionsForSpaceshipTier(int tier) {
        WorldProvider provider;
        ArrayList<Integer> temp = new ArrayList<Integer>();
        if (!ConfigManagerCore.disableRocketsToOverworld) {
            temp.add(0);
        }
        for (Integer element : registeredPlanets) {
            provider = WorldUtil.getProviderForDimension(element);
            if (provider == null) continue;
            if (provider instanceof IGalacticraftWorldProvider) {
                if (!((IGalacticraftWorldProvider)provider).canSpaceshipTierPass(tier)) continue;
                temp.add(element);
                continue;
            }
            temp.add(element);
        }
        for (Integer element : registeredSpaceStations) {
            provider = WorldUtil.getProviderForDimension(element);
            if (provider == null) continue;
            if (provider instanceof IGalacticraftWorldProvider) {
                if (!((IGalacticraftWorldProvider)provider).canSpaceshipTierPass(tier)) continue;
                temp.add(element);
                continue;
            }
            temp.add(element);
        }
        return temp;
    }

    public static CelestialBody getReachableCelestialBodiesForDimensionID(int id) {
        ArrayList celestialBodyList = Lists.newArrayList();
        celestialBodyList.addAll(GalaxyRegistry.getRegisteredMoons().values());
        celestialBodyList.addAll(GalaxyRegistry.getRegisteredPlanets().values());
        celestialBodyList.addAll(GalaxyRegistry.getRegisteredSatellites().values());
        for (CelestialBody cBody : celestialBodyList) {
            if (!cBody.getReachable() || cBody.getDimensionID() != id) continue;
            return cBody;
        }
        return null;
    }

    public static CelestialBody getReachableCelestialBodiesForName(String name) {
        ArrayList celestialBodyList = Lists.newArrayList();
        celestialBodyList.addAll(GalaxyRegistry.getRegisteredMoons().values());
        celestialBodyList.addAll(GalaxyRegistry.getRegisteredPlanets().values());
        celestialBodyList.addAll(GalaxyRegistry.getRegisteredSatellites().values());
        for (CelestialBody cBody : celestialBodyList) {
            if (!cBody.getReachable() || !cBody.getName().equals(name)) continue;
            return cBody;
        }
        return null;
    }

    public static WorldProvider getProviderForDimension(int id) {
        WorldServer ws;
        WorldProvider provider = null;
        MinecraftServer theServer = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (theServer != null && (ws = theServer.func_71218_a(id)) != null) {
            provider = ws.field_73011_w;
        }
        if (provider == null) {
            provider = WorldProvider.func_76570_a((int)id);
        }
        return provider;
    }

    public static HashMap<String, Integer> getArrayOfPossibleDimensions(List<Integer> ids, EntityPlayerMP playerBase) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Integer id : ids) {
            CelestialBody celestialBody = WorldUtil.getReachableCelestialBodiesForDimensionID(id);
            if (id > 0 && celestialBody == null) {
                celestialBody = GalacticraftCore.satelliteSpaceStation;
            }
            WorldProvider provider = WorldUtil.getProviderForDimension(id);
            if (celestialBody == null || provider == null) continue;
            if (provider instanceof IGalacticraftWorldProvider && !(provider instanceof IOrbitDimension) || provider.field_76574_g == 0) {
                map.put(celestialBody.getName(), provider.field_76574_g);
                continue;
            }
            if (playerBase == null || !(provider instanceof IOrbitDimension)) continue;
            SpaceStationWorldData data = SpaceStationWorldData.getStationData(playerBase.field_70170_p, id, (EntityPlayer)playerBase);
            if (ConfigManagerCore.spaceStationsRequirePermission && !data.getAllowedPlayers().contains(playerBase.func_146103_bH().getName()) && !VersionUtil.isPlayerOpped(playerBase)) continue;
            map.put(celestialBody.getName() + "$" + data.getOwner() + "$" + data.getSpaceStationName() + "$" + provider.field_76574_g, provider.field_76574_g);
        }
        ArrayList<CelestialBody> cBodyList = new ArrayList<CelestialBody>();
        cBodyList.addAll(GalaxyRegistry.getRegisteredPlanets().values());
        cBodyList.addAll(GalaxyRegistry.getRegisteredMoons().values());
        for (CelestialBody body : cBodyList) {
            if (body.getReachable()) continue;
            map.put(body.getLocalizedName() + "*", body.getDimensionID());
        }
        return map;
    }

    private static List<Integer> getExistingSpaceStationList(File var0) {
        ArrayList<Integer> var1 = new ArrayList<Integer>();
        File[] var2 = var0.listFiles();
        if (var2 != null) {
            for (File var5 : var2) {
                if (!var5.getName().contains("spacestation_")) continue;
                String var6 = var5.getName();
                var6 = var6.substring(13, var6.length() - 4);
                var1.add(Integer.parseInt(var6));
            }
        }
        return var1;
    }

    public static void unregisterSpaceStations() {
        if (registeredSpaceStations != null) {
            for (Integer registeredID : registeredSpaceStations) {
                DimensionManager.unregisterDimension((int)registeredID);
            }
            registeredSpaceStations = null;
        }
    }

    public static void registerSpaceStations(File spaceStationList) {
        registeredSpaceStations = WorldUtil.getExistingSpaceStationList(spaceStationList);
        MinecraftServer theServer = FMLCommonHandler.instance().getMinecraftServerInstance();
        for (Integer registeredID : registeredSpaceStations) {
            int id = Arrays.binarySearch(ConfigManagerCore.staticLoadDimensions, registeredID);
            if (!DimensionManager.isDimensionRegistered((int)registeredID)) {
                if (id >= 0) {
                    DimensionManager.registerDimension((int)registeredID, (int)ConfigManagerCore.idDimensionOverworldOrbitStatic);
                    theServer.func_71218_a(registeredID.intValue());
                    continue;
                }
                DimensionManager.registerDimension((int)registeredID, (int)ConfigManagerCore.idDimensionOverworldOrbit);
                continue;
            }
            GCLog.severe("Dimension already registered to another mod: unable to register space station dimension " + registeredID);
        }
    }

    public static void registerPlanet(int planetID, boolean isStatic) {
        if (registeredPlanets == null) {
            registeredPlanets = new ArrayList<Integer>();
        }
        registeredPlanets.add(planetID);
        if (isStatic) {
            if (!DimensionManager.isDimensionRegistered((int)planetID)) {
                DimensionManager.registerDimension((int)planetID, (int)planetID);
                GCLog.info("Registered Dimension: " + planetID);
            } else {
                GCLog.severe("Dimension already registered to another mod: unable to register planet dimension " + planetID);
            }
        }
    }

    public static void unregisterPlanets() {
        if (registeredPlanets != null) {
            for (Integer var1 : registeredPlanets) {
                DimensionManager.unregisterDimension((int)var1);
                GCLog.info("Unregistered Dimension: " + var1);
            }
            registeredPlanets = null;
        }
    }

    public static void registerPlanetClient(Integer dimID, int providerIndex) {
        int providerID = GalacticraftRegistry.getProviderID(providerIndex);
        if (providerID == 0) {
            GCLog.severe("Server dimension " + dimID + " has no match on client due to earlier registration problem.");
        } else if (!registeredPlanets.contains(dimID)) {
            registeredPlanets.add(dimID);
            DimensionManager.registerDimension((int)dimID, (int)providerID);
        } else {
            GCLog.severe("Dimension already registered to another mod: unable to register planet dimension " + dimID);
        }
    }

    public static Integer[] getArrayOfPossibleDimensions() {
        ArrayList<Integer> temp = new ArrayList<Integer>();
        temp.add(0);
        for (Integer i : registeredPlanets) {
            temp.add(i);
        }
        if (registeredSpaceStations != null) {
            for (Integer i : registeredSpaceStations) {
                temp.add(i);
            }
        }
        Integer[] finalArray = new Integer[temp.size()];
        int count = 0;
        for (Integer integ : temp) {
            finalArray[count++] = integ;
        }
        return finalArray;
    }

    public static SpaceStationWorldData bindSpaceStationToNewDimension(World world, EntityPlayerMP player) {
        int newID = DimensionManager.getNextFreeDimId();
        SpaceStationWorldData data = WorldUtil.createSpaceStation(world, newID, player);
        GCPlayerStats stats = GCPlayerStats.get(player);
        stats.spaceStationDimensionID = newID;
        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SPACESTATION_CLIENT_ID, new Object[]{newID}), player);
        return data;
    }

    public static SpaceStationWorldData createSpaceStation(World world, int dimID, EntityPlayerMP player) {
        registeredSpaceStations.add(dimID);
        int id = Arrays.binarySearch(ConfigManagerCore.staticLoadDimensions, dimID);
        if (!DimensionManager.isDimensionRegistered((int)dimID)) {
            if (id >= 0) {
                DimensionManager.registerDimension((int)dimID, (int)ConfigManagerCore.idDimensionOverworldOrbitStatic);
            } else {
                DimensionManager.registerDimension((int)dimID, (int)ConfigManagerCore.idDimensionOverworldOrbit);
            }
        } else {
            GCLog.severe("Dimension already registered to another mod: unable to register space station dimension " + dimID);
        }
        GalacticraftCore.packetPipeline.sendToAll(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SPACESTATION_LIST, WorldUtil.getSpaceStationList()));
        return SpaceStationWorldData.getStationData(world, dimID, (EntityPlayer)player);
    }

    public static Entity transferEntityToDimension(Entity entity, int dimensionID, WorldServer world) {
        return WorldUtil.transferEntityToDimension(entity, dimensionID, world, true, null);
    }

    public static Entity transferEntityToDimension(Entity entity, int dimensionID, WorldServer world, boolean transferInv, EntityAutoRocket ridingRocket) {
        MinecraftServer mcServer;
        if (!world.field_72995_K && (mcServer = FMLCommonHandler.instance().getMinecraftServerInstance()) != null) {
            WorldServer var6 = mcServer.func_71218_a(dimensionID);
            if (var6 == null) {
                System.err.println("Cannot Transfer Entity to Dimension: Could not get World for Dimension " + dimensionID);
                return null;
            }
            ITeleportType type = GalacticraftRegistry.getTeleportTypeForDimension(var6.field_73011_w.getClass());
            if (type != null) {
                return WorldUtil.teleportEntity((World)var6, entity, dimensionID, type, transferInv, ridingRocket);
            }
        }
        return null;
    }

    private static Entity teleportEntity(World worldNew, Entity entity, int dimID, ITeleportType type, boolean transferInv, EntityAutoRocket ridingRocket) {
        NBTTagCompound nbt;
        ArrayList<TileEntityTelemetry> tList;
        if (entity.field_70154_o != null) {
            if (entity.field_70154_o instanceof EntitySpaceshipBase) {
                entity.func_70078_a(entity.field_70154_o);
            } else if (entity.field_70154_o instanceof EntityCelestialFake) {
                entity.field_70154_o.func_70106_y();
                entity.func_70078_a(null);
            }
        }
        boolean dimChange = entity.field_70170_p != worldNew;
        entity.field_70170_p.func_72866_a(entity, false);
        EntityPlayerMP player = null;
        Vector3 spawnPos = null;
        int oldDimID = entity.field_70170_p.field_73011_w.field_76574_g;
        if (ridingRocket != null) {
            tList = ridingRocket.getTelemetry();
            nbt = new NBTTagCompound();
            ridingRocket.field_70128_L = false;
            ridingRocket.field_70153_n = null;
            ridingRocket.func_70039_c(nbt);
            ((WorldServer)ridingRocket.field_70170_p).func_73039_n().func_72790_b((Entity)ridingRocket);
            ridingRocket.field_70170_p.field_72996_f.remove(ridingRocket);
            ridingRocket.field_70170_p.func_72847_b((Entity)ridingRocket);
            ridingRocket = (EntityAutoRocket)EntityList.func_75615_a((NBTTagCompound)nbt, (World)worldNew);
            if (ridingRocket != null) {
                ridingRocket.setWaitForPlayer(true);
                if (ridingRocket instanceof IWorldTransferCallback) {
                    ((IWorldTransferCallback)((Object)ridingRocket)).onWorldTransferred(worldNew);
                }
            }
        }
        if (dimChange) {
            if (entity instanceof EntityPlayerMP) {
                player = (EntityPlayerMP)entity;
                World worldOld = player.field_70170_p;
                if (ConfigManagerCore.enableDebug) {
                    try {
                        GCLog.info("DEBUG: Attempting to remove player from old dimension " + oldDimID);
                        ((WorldServer)worldOld).func_73040_p().func_72695_c(player);
                        GCLog.info("DEBUG: Successfully removed player from old dimension " + oldDimID);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        ((WorldServer)worldOld).func_73040_p().func_72695_c(player);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                player.func_71053_j();
                GCPlayerStats stats = GCPlayerStats.get(player);
                stats.usingPlanetSelectionGui = false;
                player.field_71093_bK = dimID;
                if (ConfigManagerCore.enableDebug) {
                    GCLog.info("DEBUG: Sending respawn packet to player for dim " + dimID);
                }
                player.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(dimID, player.field_70170_p.field_73013_u, player.field_70170_p.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
                if (worldNew.field_73011_w instanceof WorldProviderOrbit && registeredSpaceStations.contains(dimID)) {
                    NBTTagCompound var2 = new NBTTagCompound();
                    SpaceStationWorldData.getStationData(worldNew, dimID, (EntityPlayer)player).func_76187_b(var2);
                    GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SPACESTATION_DATA, new Object[]{dimID, var2}), player);
                }
                worldOld.field_73010_i.remove(player);
                worldOld.func_72854_c();
                if (player.field_70175_ag && worldOld.func_72863_F().func_73149_a(player.field_70176_ah, player.field_70164_aj)) {
                    Chunk chunkOld = worldOld.func_72964_e(player.field_70176_ah, player.field_70164_aj);
                    chunkOld.func_76622_b((Entity)player);
                    chunkOld.field_76643_l = true;
                }
                worldOld.field_72996_f.remove(player);
                worldOld.func_72847_b((Entity)player);
                worldNew.func_72838_d(entity);
                entity.func_70029_a(worldNew);
                spawnPos = type.getPlayerSpawnLocation((WorldServer)entity.field_70170_p, player);
                ChunkCoordIntPair pair = worldNew.func_72964_e(spawnPos.intX(), spawnPos.intZ()).func_76632_l();
                if (ConfigManagerCore.enableDebug) {
                    GCLog.info("DEBUG: Loading first chunk in new dimension.");
                }
                ((WorldServer)worldNew).field_73059_b.func_73158_c(pair.field_77276_a, pair.field_77275_b);
                worldNew.func_72866_a(entity, false);
                entity.func_70012_b(spawnPos.x, spawnPos.y, spawnPos.z, entity.field_70177_z, entity.field_70125_A);
                player.field_71133_b.func_71203_ab().func_72375_a(player, (WorldServer)worldNew);
                player.field_71135_a.func_147364_a(spawnPos.x, spawnPos.y, spawnPos.z, entity.field_70177_z, entity.field_70125_A);
                GCLog.info("Server attempting to transfer player " + player.func_146103_bH().getName() + " to dimension " + worldNew.field_73011_w.field_76574_g);
                player.field_71134_c.func_73080_a((WorldServer)worldNew);
                player.field_71133_b.func_71203_ab().func_72354_b(player, (WorldServer)worldNew);
                player.field_71133_b.func_71203_ab().func_72385_f(player);
                for (Object o : player.func_70651_bq()) {
                    PotionEffect var10 = (PotionEffect)o;
                    player.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(player.func_145782_y(), var10));
                }
                player.field_71135_a.func_147359_a((Packet)new S1FPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
            } else {
                tList = null;
                if (entity instanceof EntitySpaceshipBase) {
                    tList = ((EntitySpaceshipBase)entity).getTelemetry();
                }
                WorldUtil.removeEntityFromWorld(entity.field_70170_p, entity, true);
                nbt = new NBTTagCompound();
                entity.field_70128_L = false;
                entity.func_70039_c(nbt);
                entity.field_70128_L = true;
                entity = EntityList.func_75615_a((NBTTagCompound)nbt, (World)worldNew);
                if (entity == null) {
                    return null;
                }
                if (entity instanceof IWorldTransferCallback) {
                    ((IWorldTransferCallback)entity).onWorldTransferred(worldNew);
                }
                worldNew.func_72838_d(entity);
                entity.func_70029_a(worldNew);
                worldNew.func_72866_a(entity, false);
                if (tList != null && tList.size() > 0) {
                    for (TileEntityTelemetry t : tList) {
                        t.addTrackedEntity(entity);
                    }
                }
            }
        } else if (entity instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)entity;
            player.func_71053_j();
            GCPlayerStats stats = GCPlayerStats.get(player);
            stats.usingPlanetSelectionGui = false;
            worldNew.func_72866_a(entity, false);
            spawnPos = type.getPlayerSpawnLocation((WorldServer)entity.field_70170_p, (EntityPlayerMP)entity);
            player.field_71135_a.func_147364_a(spawnPos.x, spawnPos.y, spawnPos.z, entity.field_70177_z, entity.field_70125_A);
            entity.func_70012_b(spawnPos.x, spawnPos.y, spawnPos.z, entity.field_70177_z, entity.field_70125_A);
            worldNew.func_72866_a(entity, false);
            GCLog.info("Server attempting to transfer player " + player.func_146103_bH().getName() + " within same dimension " + worldNew.field_73011_w.field_76574_g);
        }
        if (player != null) {
            GCPlayerStats playerStats = GCPlayerStats.get(player);
            if (ridingRocket == null && type.useParachute() && playerStats.extendedInventory.func_70301_a(4) != null && playerStats.extendedInventory.func_70301_a(4).func_77973_b() instanceof ItemParaChute) {
                GCPlayerHandler.setUsingParachute(player, playerStats, true);
            } else {
                GCPlayerHandler.setUsingParachute(player, playerStats, false);
            }
            if (playerStats.rocketStacks != null && playerStats.rocketStacks.length > 0) {
                for (int stack = 0; stack < playerStats.rocketStacks.length; ++stack) {
                    if (transferInv) {
                        if (playerStats.rocketStacks[stack] != null) continue;
                        if (stack == playerStats.rocketStacks.length - 1) {
                            if (playerStats.rocketItem == null) continue;
                            playerStats.rocketStacks[stack] = new ItemStack(playerStats.rocketItem, 1, playerStats.rocketType);
                            continue;
                        }
                        if (stack != playerStats.rocketStacks.length - 2) continue;
                        playerStats.rocketStacks[stack] = playerStats.launchpadStack;
                        playerStats.launchpadStack = null;
                        continue;
                    }
                    playerStats.rocketStacks[stack] = null;
                }
            }
            if (transferInv && playerStats.chestSpawnCooldown == 0) {
                playerStats.chestSpawnVector = type.getParaChestSpawnLocation((WorldServer)entity.field_70170_p, player, new Random());
                playerStats.chestSpawnCooldown = 200;
            }
        }
        if (ridingRocket != null) {
            entity.func_70080_a(ridingRocket.field_70165_t, ridingRocket.field_70163_u, ridingRocket.field_70161_v, 0.0f, 0.0f);
            worldNew.func_72866_a(entity, true);
            worldNew.func_72838_d((Entity)ridingRocket);
            ridingRocket.func_70029_a(worldNew);
            worldNew.func_72866_a((Entity)ridingRocket, true);
            entity.func_70078_a((Entity)ridingRocket);
        } else if (spawnPos != null) {
            entity.func_70012_b(spawnPos.x, spawnPos.y, spawnPos.z, entity.field_70177_z, entity.field_70125_A);
        }
        if (entity instanceof EntityPlayerMP) {
            FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)((EntityPlayerMP)entity), oldDimID, dimID);
            type.onSpaceDimensionChanged(worldNew, (EntityPlayerMP)entity, ridingRocket != null);
        }
        return entity;
    }

    @SideOnly(value=Side.CLIENT)
    public static EntityPlayer forceRespawnClient(int dimID, int par2, String par3, int par4) {
        S07PacketRespawn fakePacket = new S07PacketRespawn(dimID, EnumDifficulty.func_151523_a((int)par2), WorldType.func_77130_a((String)par3), WorldSettings.GameType.func_77146_a((int)par4));
        Minecraft.func_71410_x().func_147114_u().func_147280_a(fakePacket);
        return FMLClientHandler.instance().getClientPlayerEntity();
    }

    private static void removeEntityFromWorld(World var0, Entity var1, boolean directlyRemove) {
        if (var1 instanceof EntityPlayer) {
            EntityPlayer var2 = (EntityPlayer)var1;
            var2.func_71053_j();
            var0.field_73010_i.remove(var2);
            var0.func_72854_c();
            int var3 = var1.field_70176_ah;
            int var4 = var1.field_70164_aj;
            if (var1.field_70175_ag && var0.func_72863_F().func_73149_a(var3, var4)) {
                var0.func_72964_e(var3, var4).func_76622_b(var1);
                var0.func_72964_e((int)var3, (int)var4).field_76643_l = true;
            }
            if (directlyRemove) {
                var0.field_72996_f.remove(var1);
                var0.func_72847_b(var1);
            }
        }
        var1.field_70128_L = false;
    }

    public static SpaceStationRecipe getSpaceStationRecipe(int planetID) {
        for (SpaceStationType type : GalacticraftRegistry.getSpaceStationData()) {
            if (type.getWorldToOrbitID() != planetID) continue;
            return type.getRecipeForSpaceStation();
        }
        return null;
    }

    public static List<Object> getPlanetList() {
        Integer[] iArray = new Integer[registeredPlanets.size()];
        for (int i = 0; i < iArray.length; ++i) {
            iArray[i] = registeredPlanets.get(i);
        }
        ArrayList<Object> objList = new ArrayList<Object>();
        objList.add(iArray);
        return objList;
    }

    public static List<Object> getSpaceStationList() {
        Integer[] iArray = new Integer[registeredSpaceStations.size()];
        for (int i = 0; i < iArray.length; ++i) {
            iArray[i] = registeredSpaceStations.get(i);
        }
        ArrayList<Object> objList = new ArrayList<Object>();
        objList.add(iArray);
        return objList;
    }

    public static boolean otherModPreventGenerate(int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (!(world.field_73011_w instanceof IGalacticraftWorldProvider)) {
            return false;
        }
        if (world.field_73011_w instanceof WorldProviderOrbit) {
            return true;
        }
        if (ConfigManagerCore.enableOtherModsFeatures) {
            return false;
        }
        if (!generatorsInitialised) {
            Set registeredGenerators;
            Field regField;
            block31: {
                block30: {
                    block29: {
                        generatorsInitialised = true;
                        try {
                            Class<?> GCGreg = Class.forName("bloodasp.galacticgreg.GT_Worldgenerator_Space");
                            if (GCGreg == null) break block29;
                            regField = Class.forName("cpw.mods.fml.common.registry.GameRegistry").getDeclaredField("worldGenerators");
                            regField.setAccessible(true);
                            registeredGenerators = (Set)regField.get(null);
                            for (IWorldGenerator gen : registeredGenerators) {
                                if (!GCGreg.isInstance(gen)) continue;
                                generatorGCGreg = gen;
                                break;
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    try {
                        Class<?> cofh = Class.forName("cofh.core.world.WorldHandler");
                        if (cofh == null) break block30;
                        regField = Class.forName("cpw.mods.fml.common.registry.GameRegistry").getDeclaredField("worldGenerators");
                        regField.setAccessible(true);
                        registeredGenerators = (Set)regField.get(null);
                        for (IWorldGenerator gen : registeredGenerators) {
                            if (!cofh.isInstance(gen)) continue;
                            generatorCoFH = gen;
                            break;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                try {
                    Class<?> denseOres = Class.forName("com.rwtema.denseores.WorldGenOres");
                    if (denseOres == null) break block31;
                    regField = Class.forName("cpw.mods.fml.common.registry.GameRegistry").getDeclaredField("worldGenerators");
                    regField.setAccessible(true);
                    registeredGenerators = (Set)regField.get(null);
                    for (IWorldGenerator gen : registeredGenerators) {
                        if (!denseOres.isInstance(gen)) continue;
                        generatorDenseOres = gen;
                        break;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                Class<?> genThaumCraft = Class.forName("thaumcraft.common.lib.world.ThaumcraftWorldGenerator");
                if (genThaumCraft != null) {
                    regField = Class.forName("cpw.mods.fml.common.registry.GameRegistry").getDeclaredField("worldGenerators");
                    regField.setAccessible(true);
                    registeredGenerators = (Set)regField.get(null);
                    for (IWorldGenerator gen : registeredGenerators) {
                        if (!genThaumCraft.isInstance(gen)) continue;
                        generatorTCAuraNodes = gen;
                        break;
                    }
                    if (generatorTCAuraNodes != null && ConfigManagerCore.enableThaumCraftNodes) {
                        generateTCAuraNodes = genThaumCraft.getDeclaredMethod("generateWildNodes", World.class, Random.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
                        generateTCAuraNodes.setAccessible(true);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (generatorGCGreg != null) {
                System.out.println("Whitelisting GalacticGreg oregen on planets.");
            }
            if (generatorCoFH != null) {
                System.out.println("Whitelisting CoFHCore custom oregen on planets.");
            }
            if (generatorDenseOres != null) {
                System.out.println("Whitelisting Dense Ores oregen on planets.");
            }
            if (generatorTCAuraNodes != null && generateTCAuraNodes != null) {
                System.out.println("Whitelisting ThaumCraft aura node generation on planets.");
            }
        }
        if (generatorGCGreg != null || generatorCoFH != null || generatorDenseOres != null || generatorTCAuraNodes != null) {
            try {
                long worldSeed = world.func_72905_C();
                Random fmlRandom = new Random(worldSeed);
                long xSeed = fmlRandom.nextLong() >> 3;
                long zSeed = fmlRandom.nextLong() >> 3;
                long chunkSeed = xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed;
                fmlRandom.setSeed(chunkSeed);
                if (generatorCoFH != null) {
                    generatorCoFH.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
                }
                if (generatorDenseOres != null) {
                    generatorDenseOres.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
                }
                if (generatorGCGreg != null) {
                    generatorGCGreg.generate(fmlRandom, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
                }
                if (generateTCAuraNodes != null) {
                    generateTCAuraNodes.invoke((Object)generatorTCAuraNodes, world, fmlRandom, chunkX, chunkZ, false, true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public static void toCelestialSelection(EntityPlayerMP player, GCPlayerStats stats, int tier) {
        player.func_70078_a(null);
        stats.spaceshipTier = tier;
        HashMap<String, Integer> map = WorldUtil.getArrayOfPossibleDimensions(WorldUtil.getPossibleDimensionsForSpaceshipTier(tier), player);
        String dimensionList = "";
        int count = 0;
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            dimensionList = dimensionList.concat(entry.getKey() + (count < map.entrySet().size() - 1 ? "?" : ""));
            ++count;
        }
        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_DIMENSION_LIST, new Object[]{player.func_146103_bH().getName(), dimensionList}), player);
        stats.usingPlanetSelectionGui = true;
        stats.savedPlanetList = new String(dimensionList);
        EntityCelestialFake fakeEntity = new EntityCelestialFake(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0f);
        player.field_70170_p.func_72838_d((Entity)fakeEntity);
        player.func_70078_a((Entity)fakeEntity);
    }

    public static Vector3 getFootprintPosition(World world, float rotation, Vector3 startPosition, BlockVec3 playerCenter) {
        int mainPosZ;
        int mainPosY;
        Vector3 position = startPosition.clone();
        float footprintScale = 0.375f;
        int mainPosX = position.intX();
        if (world.func_147439_a(mainPosX, mainPosY = position.intY(), mainPosZ = position.intZ()).isAir((IBlockAccess)world, mainPosX, mainPosY, mainPosZ)) {
            position.x += (double)(playerCenter.x - mainPosX);
            position.z += (double)(playerCenter.z - mainPosZ);
            if (world.func_147439_a(position.intX(), position.intY(), position.intZ()).isAir((IBlockAccess)world, position.intX(), position.intY(), position.intZ())) {
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    if (direction == ForgeDirection.DOWN || direction == ForgeDirection.UP || world.func_147439_a(mainPosX + direction.offsetX, mainPosY, mainPosZ + direction.offsetZ).isAir((IBlockAccess)world, mainPosX + direction.offsetX, mainPosY, mainPosZ + direction.offsetZ)) continue;
                    position.x += (double)direction.offsetX;
                    position.z += (double)direction.offsetZ;
                    break;
                }
            }
        }
        mainPosX = position.intX();
        mainPosZ = position.intZ();
        double x0 = Math.sin((double)(45.0f - rotation) * Math.PI / 180.0) * (double)footprintScale + position.x;
        double x1 = Math.sin((double)(135.0f - rotation) * Math.PI / 180.0) * (double)footprintScale + position.x;
        double x2 = Math.sin((double)(225.0f - rotation) * Math.PI / 180.0) * (double)footprintScale + position.x;
        double x3 = Math.sin((double)(315.0f - rotation) * Math.PI / 180.0) * (double)footprintScale + position.x;
        double z0 = Math.cos((double)(45.0f - rotation) * Math.PI / 180.0) * (double)footprintScale + position.z;
        double z1 = Math.cos((double)(135.0f - rotation) * Math.PI / 180.0) * (double)footprintScale + position.z;
        double z2 = Math.cos((double)(225.0f - rotation) * Math.PI / 180.0) * (double)footprintScale + position.z;
        double z3 = Math.cos((double)(315.0f - rotation) * Math.PI / 180.0) * (double)footprintScale + position.z;
        double xMin = Math.min(Math.min(x0, x1), Math.min(x2, x3));
        double xMax = Math.max(Math.max(x0, x1), Math.max(x2, x3));
        double zMin = Math.min(Math.min(z0, z1), Math.min(z2, z3));
        double zMax = Math.max(Math.max(z0, z1), Math.max(z2, z3));
        if (xMin < (double)mainPosX) {
            position.x += (double)mainPosX - xMin;
        }
        if (xMax > (double)(mainPosX + 1)) {
            position.x -= xMax - (double)(mainPosX + 1);
        }
        if (zMin < (double)mainPosZ) {
            position.z += (double)mainPosZ - zMin;
        }
        if (zMax > (double)(mainPosZ + 1)) {
            position.z -= zMax - (double)(mainPosZ + 1);
        }
        return position;
    }

    static {
        generatorGCGreg = null;
        generatorCoFH = null;
        generatorDenseOres = null;
        generatorTCAuraNodes = null;
        generateTCAuraNodes = null;
        generatorsInitialised = false;
    }
}

