/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.client.gui.container;

import java.util.ArrayList;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiContainerGC;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementInfoRegion;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.inventory.ContainerOxygenSealer;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.oxygen.OxygenPressureProtocol;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenSealer;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiOxygenSealer
extends GuiContainerGC {
    private static final ResourceLocation sealerTexture = new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/oxygen_large.png");
    private final TileEntityOxygenSealer sealer;
    private GuiButton buttonDisable;
    private GuiElementInfoRegion oxygenInfoRegion;
    private GuiElementInfoRegion electricInfoRegion;

    public GuiOxygenSealer(InventoryPlayer par1InventoryPlayer, TileEntityOxygenSealer par2TileEntityAirDistributor) {
        super(new ContainerOxygenSealer(par1InventoryPlayer, par2TileEntityAirDistributor));
        this.oxygenInfoRegion = new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 112, (this.field_146295_m - this.field_147000_g) / 2 + 24, 56, 9, new ArrayList<String>(), this.field_146294_l, this.field_146295_m, this);
        this.electricInfoRegion = new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 112, (this.field_146295_m - this.field_147000_g) / 2 + 37, 56, 9, new ArrayList<String>(), this.field_146294_l, this.field_146295_m, this);
        this.sealer = par2TileEntityAirDistributor;
        this.field_147000_g = 200;
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        switch (par1GuiButton.field_146127_k) {
            case 0: {
                GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_UPDATE_DISABLEABLE_BUTTON, new Object[]{this.sealer.field_145851_c, this.sealer.field_145848_d, this.sealer.field_145849_e, 0}));
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        ArrayList<String> batterySlotDesc = new ArrayList<String>();
        batterySlotDesc.add(GCCoreUtil.translate("gui.batterySlot.desc.0"));
        batterySlotDesc.add(GCCoreUtil.translate("gui.batterySlot.desc.1"));
        this.infoRegions.add(new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 46, (this.field_146295_m - this.field_147000_g) / 2 + 26, 18, 18, batterySlotDesc, this.field_146294_l, this.field_146295_m, this));
        ArrayList<String> oxygenSlotDesc = new ArrayList<String>();
        oxygenSlotDesc.add(GCCoreUtil.translate("gui.oxygenSlot.desc.0"));
        oxygenSlotDesc.add(GCCoreUtil.translate("gui.oxygenSlot.desc.1"));
        this.infoRegions.add(new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 16, (this.field_146295_m - this.field_147000_g) / 2 + 26, 18, 18, oxygenSlotDesc, this.field_146294_l, this.field_146295_m, this));
        ArrayList<String> oxygenDesc = new ArrayList<String>();
        oxygenDesc.add(GCCoreUtil.translate("gui.oxygenStorage.desc.0"));
        oxygenDesc.add((Object)((Object)EnumColor.YELLOW) + GCCoreUtil.translate("gui.oxygenStorage.desc.1") + ": " + (int)Math.floor(this.sealer.storedOxygen) + " / " + (int)Math.floor(this.sealer.maxOxygen));
        this.oxygenInfoRegion.tooltipStrings = oxygenDesc;
        this.oxygenInfoRegion.xPosition = (this.field_146294_l - this.field_146999_f) / 2 + 112;
        this.oxygenInfoRegion.yPosition = (this.field_146295_m - this.field_147000_g) / 2 + 23;
        this.oxygenInfoRegion.parentWidth = this.field_146294_l;
        this.oxygenInfoRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.oxygenInfoRegion);
        ArrayList<String> electricityDesc = new ArrayList<String>();
        electricityDesc.add(GCCoreUtil.translate("gui.energyStorage.desc.0"));
        electricityDesc.add((Object)((Object)EnumColor.YELLOW) + GCCoreUtil.translate("gui.energyStorage.desc.1") + ": " + (int)Math.floor(this.sealer.getEnergyStoredGC()) + " / " + (int)Math.floor(this.sealer.getMaxEnergyStoredGC()));
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        this.electricInfoRegion.xPosition = (this.field_146294_l - this.field_146999_f) / 2 + 112;
        this.electricInfoRegion.yPosition = (this.field_146295_m - this.field_147000_g) / 2 + 36;
        this.electricInfoRegion.parentWidth = this.field_146294_l;
        this.electricInfoRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.electricInfoRegion);
        this.buttonDisable = new GuiButton(0, this.field_146294_l / 2 - 38, this.field_146295_m / 2 - 30 + 21, 76, 20, GCCoreUtil.translate("gui.button.enableseal.name"));
        this.field_146292_n.add(this.buttonDisable);
    }

    protected void func_146979_b(int par1, int par2) {
        this.field_146289_q.func_78276_b(this.sealer.func_145825_b(), 8, 10, 0x404040);
        GCCoreUtil.drawStringRightAligned(GCCoreUtil.translate("gui.message.in.name") + ":", 99, 26, 0x404040, this.field_146289_q);
        GCCoreUtil.drawStringRightAligned(GCCoreUtil.translate("gui.message.in.name") + ":", 99, 38, 0x404040, this.field_146289_q);
        String status = GCCoreUtil.translate("gui.message.status.name") + ": " + this.getStatus();
        this.buttonDisable.field_146124_l = this.sealer.disableCooldown == 0;
        this.buttonDisable.field_146126_j = this.sealer.disabled ? GCCoreUtil.translate("gui.button.enableseal.name") : GCCoreUtil.translate("gui.button.disableseal.name");
        this.field_146289_q.func_78276_b(status, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(status) / 2, 50, 0x404040);
        status = GCCoreUtil.translate("gui.oxygenUse.desc") + ": " + this.sealer.oxygenPerTick * 20.0f + GCCoreUtil.translate("gui.perSecond");
        this.field_146289_q.func_78276_b(status, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(status) / 2, 60, 0x404040);
        this.field_146289_q.func_78276_b(GCCoreUtil.translate("container.inventory"), 8, this.field_147000_g - 90 + 3, 0x404040);
    }

    private String getStatus() {
        Block blockAbove = this.sealer.func_145831_w().func_147439_a(this.sealer.field_145851_c, this.sealer.field_145848_d + 1, this.sealer.field_145849_e);
        if (!(blockAbove instanceof BlockAir) && !OxygenPressureProtocol.canBlockPassAir(this.sealer.func_145831_w(), blockAbove, new BlockVec3(this.sealer.field_145851_c, this.sealer.field_145848_d + 1, this.sealer.field_145849_e), 1)) {
            return (Object)((Object)EnumColor.DARK_RED) + GCCoreUtil.translate("gui.status.sealerblocked.name");
        }
        if (this.sealer.disabled) {
            return (Object)((Object)EnumColor.DARK_RED) + GCCoreUtil.translate("gui.status.disabled.name");
        }
        if (this.sealer.getEnergyStoredGC() == 0.0f) {
            return (Object)((Object)EnumColor.DARK_RED) + GCCoreUtil.translate("gui.status.missingpower.name");
        }
        if (this.sealer.storedOxygen < 1.0f) {
            return (Object)((Object)EnumColor.DARK_RED) + GCCoreUtil.translate("gui.status.missingoxygen.name");
        }
        if (this.sealer.calculatingSealed) {
            return (Object)((Object)EnumColor.ORANGE) + GCCoreUtil.translate("gui.status.checkingSeal.name") + "...";
        }
        int threadCooldown = this.sealer.getScaledThreadCooldown(25);
        if (threadCooldown < 15) {
            if (threadCooldown < 4) {
                String elipsis = "";
                for (int i = 0; i < (23 - threadCooldown) % 4; ++i) {
                    elipsis = elipsis + ".";
                }
                return (Object)((Object)EnumColor.ORANGE) + GCCoreUtil.translate("gui.status.checkStarting.name") + elipsis;
            }
            return (Object)((Object)EnumColor.ORANGE) + GCCoreUtil.translate("gui.status.checkPending.name");
        }
        if (!this.sealer.sealed) {
            return (Object)((Object)EnumColor.DARK_RED) + GCCoreUtil.translate("gui.status.unsealed.name");
        }
        return (Object)((Object)EnumColor.DARK_GREEN) + GCCoreUtil.translate("gui.status.sealed.name");
    }

    protected void func_146976_a(float var1, int var2, int var3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(sealerTexture);
        int var5 = (this.field_146294_l - this.field_146999_f) / 2;
        int var6 = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(var5, var6 + 5, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.sealer != null) {
            ArrayList<String> oxygenDesc = new ArrayList<String>();
            oxygenDesc.add(GCCoreUtil.translate("gui.oxygenStorage.desc.0"));
            oxygenDesc.add((Object)((Object)EnumColor.YELLOW) + GCCoreUtil.translate("gui.oxygenStorage.desc.1") + ": " + (int)Math.floor(this.sealer.storedOxygen) + " / " + (int)Math.floor(this.sealer.maxOxygen));
            this.oxygenInfoRegion.tooltipStrings = oxygenDesc;
            ArrayList<String> electricityDesc = new ArrayList<String>();
            electricityDesc.add(GCCoreUtil.translate("gui.energyStorage.desc.0"));
            EnergyDisplayHelper.getEnergyDisplayTooltip(this.sealer.getEnergyStoredGC(), this.sealer.getMaxEnergyStoredGC(), electricityDesc);
            this.electricInfoRegion.tooltipStrings = electricityDesc;
            int scale = this.sealer.getCappedScaledOxygenLevel(54);
            this.func_73729_b(var5 + 113, var6 + 24, 197, 7, Math.min(scale, 54), 7);
            scale = this.sealer.getScaledElecticalLevel(54);
            this.func_73729_b(var5 + 113, var6 + 37, 197, 0, Math.min(scale, 54), 7);
            scale = 25 - this.sealer.getScaledThreadCooldown(25);
            this.func_73729_b(var5 + 148, var6 + 60, 176, 14, 10, 27);
            if (scale != 0) {
                this.func_73729_b(var5 + 149, var6 + 61 + scale, 186, 14, 8, 25 - scale);
            }
            if (this.sealer.getEnergyStoredGC() > 0.0f) {
                this.func_73729_b(var5 + 99, var6 + 36, 176, 0, 11, 10);
            }
            if (this.sealer.storedOxygen > 0.0f) {
                this.func_73729_b(var5 + 100, var6 + 23, 187, 0, 10, 10);
            }
        }
    }
}

