/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.proxy;

import api.player.client.ClientPlayerAPI;
import api.player.model.ModelPlayerAPI;
import api.player.render.RenderPlayerAPI;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.event.client.CelestialBodyRenderEvent;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityTieredRocket;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.client.FootprintRenderer;
import micdoodle8.mods.galacticraft.core.client.fx.EffectHandler;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.client.gui.screen.InventoryTabGalacticraft;
import micdoodle8.mods.galacticraft.core.client.model.ModelPlayerBaseGC;
import micdoodle8.mods.galacticraft.core.client.model.ModelRocketTier1;
import micdoodle8.mods.galacticraft.core.client.render.ThreadDownloadImageDataGC;
import micdoodle8.mods.galacticraft.core.client.render.block.BlockRendererBreathableAir;
import micdoodle8.mods.galacticraft.core.client.render.block.BlockRendererLandingPad;
import micdoodle8.mods.galacticraft.core.client.render.block.BlockRendererMachine;
import micdoodle8.mods.galacticraft.core.client.render.block.BlockRendererMeteor;
import micdoodle8.mods.galacticraft.core.client.render.block.BlockRendererNasaWorkbench;
import micdoodle8.mods.galacticraft.core.client.render.block.BlockRendererOxygenPipe;
import micdoodle8.mods.galacticraft.core.client.render.block.BlockRendererParachest;
import micdoodle8.mods.galacticraft.core.client.render.block.BlockRendererTreasureChest;
import micdoodle8.mods.galacticraft.core.client.render.block.BlockRendererUnlitTorch;
import micdoodle8.mods.galacticraft.core.client.render.entities.RenderAlienVillager;
import micdoodle8.mods.galacticraft.core.client.render.entities.RenderBubble;
import micdoodle8.mods.galacticraft.core.client.render.entities.RenderBuggy;
import micdoodle8.mods.galacticraft.core.client.render.entities.RenderEntityFake;
import micdoodle8.mods.galacticraft.core.client.render.entities.RenderEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.client.render.entities.RenderEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.client.render.entities.RenderEvolvedSkeletonBoss;
import micdoodle8.mods.galacticraft.core.client.render.entities.RenderEvolvedSpider;
import micdoodle8.mods.galacticraft.core.client.render.entities.RenderEvolvedZombie;
import micdoodle8.mods.galacticraft.core.client.render.entities.RenderFlag;
import micdoodle8.mods.galacticraft.core.client.render.entities.RenderLander;
import micdoodle8.mods.galacticraft.core.client.render.entities.RenderMeteor;
import micdoodle8.mods.galacticraft.core.client.render.entities.RenderMeteorChunk;
import micdoodle8.mods.galacticraft.core.client.render.entities.RenderParaChest;
import micdoodle8.mods.galacticraft.core.client.render.entities.RenderPlayerBaseGC;
import micdoodle8.mods.galacticraft.core.client.render.entities.RenderPlayerGC;
import micdoodle8.mods.galacticraft.core.client.render.entities.RenderTier1Rocket;
import micdoodle8.mods.galacticraft.core.client.render.item.ItemRendererArclamp;
import micdoodle8.mods.galacticraft.core.client.render.item.ItemRendererBuggy;
import micdoodle8.mods.galacticraft.core.client.render.item.ItemRendererFlag;
import micdoodle8.mods.galacticraft.core.client.render.item.ItemRendererKey;
import micdoodle8.mods.galacticraft.core.client.render.item.ItemRendererMeteorChunk;
import micdoodle8.mods.galacticraft.core.client.render.item.ItemRendererScreen;
import micdoodle8.mods.galacticraft.core.client.render.item.ItemRendererThruster;
import micdoodle8.mods.galacticraft.core.client.render.item.ItemRendererTier1Rocket;
import micdoodle8.mods.galacticraft.core.client.render.item.ItemRendererUnlitTorch;
import micdoodle8.mods.galacticraft.core.client.render.tile.TileEntityAluminumWireRenderer;
import micdoodle8.mods.galacticraft.core.client.render.tile.TileEntityArclampRenderer;
import micdoodle8.mods.galacticraft.core.client.render.tile.TileEntityDishRenderer;
import micdoodle8.mods.galacticraft.core.client.render.tile.TileEntityNasaWorkbenchRenderer;
import micdoodle8.mods.galacticraft.core.client.render.tile.TileEntityParachestRenderer;
import micdoodle8.mods.galacticraft.core.client.render.tile.TileEntityScreenRenderer;
import micdoodle8.mods.galacticraft.core.client.render.tile.TileEntitySolarPanelRenderer;
import micdoodle8.mods.galacticraft.core.client.render.tile.TileEntityThrusterRenderer;
import micdoodle8.mods.galacticraft.core.client.render.tile.TileEntityTreasureChestRenderer;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderMoon;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderOrbit;
import micdoodle8.mods.galacticraft.core.entities.EntityAlienVillager;
import micdoodle8.mods.galacticraft.core.entities.EntityBubble;
import micdoodle8.mods.galacticraft.core.entities.EntityBuggy;
import micdoodle8.mods.galacticraft.core.entities.EntityCelestialFake;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.core.entities.EntityFlag;
import micdoodle8.mods.galacticraft.core.entities.EntityLander;
import micdoodle8.mods.galacticraft.core.entities.EntityLanderBase;
import micdoodle8.mods.galacticraft.core.entities.EntityMeteor;
import micdoodle8.mods.galacticraft.core.entities.EntityMeteorChunk;
import micdoodle8.mods.galacticraft.core.entities.EntityParachest;
import micdoodle8.mods.galacticraft.core.entities.EntitySkeletonBoss;
import micdoodle8.mods.galacticraft.core.entities.EntityTier1Rocket;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerBaseSP;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import micdoodle8.mods.galacticraft.core.entities.player.IPlayerClient;
import micdoodle8.mods.galacticraft.core.entities.player.PlayerClient;
import micdoodle8.mods.galacticraft.core.inventory.InventoryExtended;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.proxy.CommonProxyCore;
import micdoodle8.mods.galacticraft.core.recipe.craftguide.CraftGuideIntegration;
import micdoodle8.mods.galacticraft.core.tick.KeyHandlerClient;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerClient;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAluminumWire;
import micdoodle8.mods.galacticraft.core.tile.TileEntityArclamp;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDish;
import micdoodle8.mods.galacticraft.core.tile.TileEntityNasaWorkbench;
import micdoodle8.mods.galacticraft.core.tile.TileEntityParaChest;
import micdoodle8.mods.galacticraft.core.tile.TileEntityScreen;
import micdoodle8.mods.galacticraft.core.tile.TileEntitySolar;
import micdoodle8.mods.galacticraft.core.tile.TileEntityThruster;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTreasureChest;
import micdoodle8.mods.galacticraft.core.wrappers.BlockMetaList;
import micdoodle8.mods.galacticraft.core.wrappers.PlayerGearData;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidBlock;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import tconstruct.client.tabs.InventoryTabVanilla;
import tconstruct.client.tabs.TabRegistry;

public class ClientProxyCore
extends CommonProxyCore {
    private static int renderIdTreasureChest;
    private static int renderIdParachest;
    private static int renderIdTorchUnlit;
    private static int renderIdBreathableAir;
    private static int renderIdOxygenPipe;
    private static int renderIdMeteor;
    private static int renderIdCraftingTable;
    private static int renderIdLandingPad;
    private static int renderIdMachine;
    public static FootprintRenderer footprintRenderer;
    public static List<String> flagRequestsSent;
    private static int renderIndexHeavyArmor;
    private static int renderIndexSensorGlasses;
    public static Set<Vector3> valueableBlocks;
    public static HashSet<BlockMetaList> detectableBlocks;
    public static Map<String, PlayerGearData> playerItemData;
    public static double playerPosX;
    public static double playerPosY;
    public static double playerPosZ;
    public static float playerRotationYaw;
    public static float playerRotationPitch;
    public static boolean lastSpacebarDown;
    public static int clientSpaceStationID;
    public static MusicTicker.MusicType MUSIC_TYPE_MARS;
    public static EnumRarity galacticraftItem;
    public static Map<String, String> capeMap;
    public static InventoryExtended dummyInventory;
    private static final ResourceLocation underOilTexture;
    private static float[] numbers;
    private static FloatBuffer scaleup;
    public static float globalRadius;
    public static double offsetY;
    public static float terrainHeight;
    private static boolean smallMoonActive;
    private static Map<String, ResourceLocation> capesMap;
    public static IPlayerClient playerClientHandler;
    private static Minecraft mc;
    public static List<String> gearDataRequests;
    public static DynamicTexture overworldTextureClient;
    public static DynamicTexture overworldTextureLocal;
    public static boolean overworldTextureRequestSent;
    private static float PLAYER_Y_OFFSET;
    private static final ResourceLocation saturnRingTexture;
    private static final ResourceLocation uranusRingTexture;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        scaleup.put(numbers, 0, 16);
        renderIndexSensorGlasses = RenderingRegistry.addNewArmourRendererPrefix((String)"sensor");
        renderIndexHeavyArmor = RenderingRegistry.addNewArmourRendererPrefix((String)"titanium");
        if (Loader.isModLoaded((String)"PlayerAPI")) {
            ClientPlayerAPI.register((String)"GalacticraftCore", GCPlayerBaseSP.class);
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        Class[][] commonTypes = new Class[][]{{MusicTicker.MusicType.class, ResourceLocation.class, Integer.TYPE, Integer.TYPE}};
        MUSIC_TYPE_MARS = (MusicTicker.MusicType)EnumHelper.addEnum((Class[][])commonTypes, MusicTicker.MusicType.class, (String)"MARS_JC", (Object[])new Object[]{new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "galacticraft.musicSpace"), 12000, 24000});
        ClientProxyCore.registerHandlers();
        ClientProxyCore.registerTileEntityRenderers();
        ClientProxyCore.registerBlockHandlers();
        ClientProxyCore.setupCapes();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        ClientProxyCore.registerInventoryTabs();
        ClientProxyCore.registerEntityRenderers();
        ClientProxyCore.registerItemRenderers();
        MinecraftForge.EVENT_BUS.register((Object)new TabRegistry());
        if (Loader.isModLoaded((String)"craftguide")) {
            CraftGuideIntegration.register();
        }
    }

    public static void registerEntityRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityTier1Rocket.class, (Render)new RenderTier1Rocket(new ModelRocketTier1(), GalacticraftCore.ASSET_PREFIX, "rocketT1"));
        RenderingRegistry.registerEntityRenderingHandler(EntityEvolvedSpider.class, (Render)new RenderEvolvedSpider());
        RenderingRegistry.registerEntityRenderingHandler(EntityEvolvedZombie.class, (Render)new RenderEvolvedZombie());
        RenderingRegistry.registerEntityRenderingHandler(EntityEvolvedCreeper.class, (Render)new RenderEvolvedCreeper());
        RenderingRegistry.registerEntityRenderingHandler(EntityEvolvedSkeleton.class, (Render)new RenderEvolvedSkeleton());
        RenderingRegistry.registerEntityRenderingHandler(EntitySkeletonBoss.class, (Render)new RenderEvolvedSkeletonBoss());
        RenderingRegistry.registerEntityRenderingHandler(EntityMeteor.class, (Render)new RenderMeteor());
        RenderingRegistry.registerEntityRenderingHandler(EntityBuggy.class, (Render)new RenderBuggy());
        RenderingRegistry.registerEntityRenderingHandler(EntityMeteorChunk.class, (Render)new RenderMeteorChunk());
        RenderingRegistry.registerEntityRenderingHandler(EntityFlag.class, (Render)new RenderFlag());
        RenderingRegistry.registerEntityRenderingHandler(EntityParachest.class, (Render)new RenderParaChest());
        RenderingRegistry.registerEntityRenderingHandler(EntityAlienVillager.class, (Render)new RenderAlienVillager());
        RenderingRegistry.registerEntityRenderingHandler(EntityBubble.class, (Render)new RenderBubble(0.25f, 0.25f, 1.0f));
        RenderingRegistry.registerEntityRenderingHandler(EntityLander.class, (Render)new RenderLander());
        RenderingRegistry.registerEntityRenderingHandler(EntityCelestialFake.class, (Render)new RenderEntityFake());
        if (Loader.isModLoaded((String)"RenderPlayerAPI")) {
            ModelPlayerAPI.register((String)"GalacticraftCore", ModelPlayerBaseGC.class);
            RenderPlayerAPI.register((String)"GalacticraftCore", RenderPlayerBaseGC.class);
        } else {
            RenderingRegistry.registerEntityRenderingHandler(EntityPlayer.class, (Render)new RenderPlayerGC());
        }
    }

    public static void registerItemRenderers() {
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)GCBlocks.unlitTorch), (IItemRenderer)new ItemRendererUnlitTorch());
        MinecraftForgeClient.registerItemRenderer((Item)GCItems.rocketTier1, (IItemRenderer)new ItemRendererTier1Rocket(new EntityTier1Rocket((World)ClientProxyCore.mc.field_71441_e), new ModelRocketTier1(), new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/model/rocketT1.png")));
        MinecraftForgeClient.registerItemRenderer((Item)GCItems.buggy, (IItemRenderer)new ItemRendererBuggy());
        MinecraftForgeClient.registerItemRenderer((Item)GCItems.flag, (IItemRenderer)new ItemRendererFlag());
        MinecraftForgeClient.registerItemRenderer((Item)GCItems.key, (IItemRenderer)new ItemRendererKey(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/model/treasure.png")));
        MinecraftForgeClient.registerItemRenderer((Item)GCItems.meteorChunk, (IItemRenderer)new ItemRendererMeteorChunk());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)GCBlocks.spinThruster), (IItemRenderer)new ItemRendererThruster());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)GCBlocks.brightLamp), (IItemRenderer)new ItemRendererArclamp());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)GCBlocks.screen), (IItemRenderer)new ItemRendererScreen());
    }

    public static void registerHandlers() {
        TickHandlerClient tickHandlerClient = new TickHandlerClient();
        FMLCommonHandler.instance().bus().register((Object)tickHandlerClient);
        MinecraftForge.EVENT_BUS.register((Object)tickHandlerClient);
        FMLCommonHandler.instance().bus().register((Object)new KeyHandlerClient());
        ClientRegistry.registerKeyBinding((KeyBinding)KeyHandlerClient.galaxyMap);
        ClientRegistry.registerKeyBinding((KeyBinding)KeyHandlerClient.openFuelGui);
        ClientRegistry.registerKeyBinding((KeyBinding)KeyHandlerClient.toggleAdvGoggles);
        MinecraftForge.EVENT_BUS.register((Object)GalacticraftCore.proxy);
    }

    public static void registerTileEntityRenderers() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityAluminumWire.class, (TileEntitySpecialRenderer)new TileEntityAluminumWireRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTreasureChest.class, (TileEntitySpecialRenderer)new TileEntityTreasureChestRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityParaChest.class, (TileEntitySpecialRenderer)new TileEntityParachestRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityNasaWorkbench.class, (TileEntitySpecialRenderer)new TileEntityNasaWorkbenchRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySolar.class, (TileEntitySpecialRenderer)new TileEntitySolarPanelRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDish.class, (TileEntitySpecialRenderer)new TileEntityDishRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityThruster.class, (TileEntitySpecialRenderer)new TileEntityThrusterRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityArclamp.class, (TileEntitySpecialRenderer)new TileEntityArclampRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityScreen.class, (TileEntitySpecialRenderer)new TileEntityScreenRenderer());
    }

    public static void registerBlockHandlers() {
        renderIdTreasureChest = RenderingRegistry.getNextAvailableRenderId();
        renderIdTorchUnlit = RenderingRegistry.getNextAvailableRenderId();
        renderIdBreathableAir = RenderingRegistry.getNextAvailableRenderId();
        renderIdOxygenPipe = RenderingRegistry.getNextAvailableRenderId();
        renderIdMeteor = RenderingRegistry.getNextAvailableRenderId();
        renderIdCraftingTable = RenderingRegistry.getNextAvailableRenderId();
        renderIdLandingPad = RenderingRegistry.getNextAvailableRenderId();
        renderIdMachine = RenderingRegistry.getNextAvailableRenderId();
        renderIdParachest = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererTreasureChest(renderIdTreasureChest));
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererParachest(renderIdParachest));
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererUnlitTorch(renderIdTorchUnlit));
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererBreathableAir(renderIdBreathableAir));
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererOxygenPipe(renderIdOxygenPipe));
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMeteor(renderIdMeteor));
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererNasaWorkbench(renderIdCraftingTable));
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererLandingPad(renderIdLandingPad));
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(renderIdMachine));
    }

    public static void setupCapes() {
        try {
            ClientProxyCore.updateCapeList();
        }
        catch (Exception e) {
            FMLLog.severe((String)"Error while setting up Galacticraft donor capes", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    private static void updateCapeList() {
        int timeout = 10000;
        URL capeListUrl = null;
        try {
            capeListUrl = new URL("https://raw.github.com/micdoodle8/Galacticraft/master/capes.txt");
        }
        catch (MalformedURLException e) {
            FMLLog.severe((String)"Error getting capes list URL", (Object[])new Object[0]);
            e.printStackTrace();
            return;
        }
        URLConnection connection = null;
        try {
            connection = capeListUrl.openConnection();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        connection.setConnectTimeout(timeout);
        connection.setReadTimeout(timeout);
        InputStream stream = null;
        try {
            stream = connection.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        InputStreamReader streamReader = new InputStreamReader(stream);
        BufferedReader reader = new BufferedReader(streamReader);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains(":")) continue;
                int splitLocation = line.indexOf(":");
                String username = line.substring(0, splitLocation);
                String capeUrl = "https://raw.github.com/micdoodle8/Galacticraft/master/capes/" + line.substring(splitLocation + 1) + ".png";
                capeMap.put(username, capeUrl);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            streamReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void registerInventoryTabs() {
        if (!Loader.isModLoaded((String)"TConstruct") && TabRegistry.getTabList().size() < 1) {
            TabRegistry.registerTab(new InventoryTabVanilla());
        }
        TabRegistry.registerTab(new InventoryTabGalacticraft());
    }

    public static void renderPlanets(float par3) {
    }

    @Override
    public int getBlockRender(Block blockID) {
        if (blockID == GCBlocks.breatheableAir || blockID == GCBlocks.brightBreatheableAir) {
            return renderIdBreathableAir;
        }
        if (blockID == GCBlocks.oxygenPipe) {
            return renderIdOxygenPipe;
        }
        if (blockID == GCBlocks.fallenMeteor) {
            return renderIdMeteor;
        }
        if (blockID == GCBlocks.nasaWorkbench) {
            return renderIdCraftingTable;
        }
        if (blockID == GCBlocks.landingPadFull) {
            return renderIdLandingPad;
        }
        if (blockID == GCBlocks.unlitTorch || blockID == GCBlocks.unlitTorchLit || blockID == GCBlocks.glowstoneTorch) {
            return renderIdTorchUnlit;
        }
        if (blockID == GCBlocks.fuelLoader || blockID == GCBlocks.cargoLoader || blockID == GCBlocks.machineBase || blockID == GCBlocks.machineBase2 || blockID == GCBlocks.machineTiered || blockID == GCBlocks.oxygenCollector || blockID == GCBlocks.oxygenCompressor || blockID == GCBlocks.oxygenDetector || blockID == GCBlocks.oxygenDistributor || blockID == GCBlocks.oxygenSealer || blockID == GCBlocks.refinery || blockID == GCBlocks.telemetry) {
            return renderIdMachine;
        }
        if (blockID == GCBlocks.treasureChestTier1) {
            return renderIdTreasureChest;
        }
        if (blockID == GCBlocks.parachest) {
            return renderIdParachest;
        }
        return -1;
    }

    @Override
    public World getClientWorld() {
        return ClientProxyCore.mc.field_71441_e;
    }

    @Override
    public int getTitaniumArmorRenderIndex() {
        return renderIndexHeavyArmor;
    }

    @Override
    public int getSensorArmorRenderIndex() {
        return renderIndexSensorGlasses;
    }

    @Override
    public void spawnParticle(String particleID, Vector3 position, Vector3 motion, Object[] otherInfo) {
        EffectHandler.spawnParticle(particleID, position, motion, otherInfo);
    }

    public static void renderLiquidOverlays(float partialTicks) {
        if (!ClientProxyCore.isInsideOfFluid((Entity)ClientProxyCore.mc.field_71439_g, GalacticraftCore.gcFluidOil)) {
            return;
        }
        mc.func_110434_K().func_110577_a(underOilTexture);
        Tessellator tessellator = Tessellator.field_78398_a;
        float f1 = ClientProxyCore.mc.field_71439_g.func_70013_c(partialTicks) / 3.0f;
        GL11.glColor4f((float)f1, (float)f1, (float)f1, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPushMatrix();
        float f2 = 4.0f;
        float f3 = -1.0f;
        float f4 = 1.0f;
        float f5 = -1.0f;
        float f6 = 1.0f;
        float f7 = -0.5f;
        float f8 = -ClientProxyCore.mc.field_71439_g.field_70177_z / 64.0f;
        float f9 = ClientProxyCore.mc.field_71439_g.field_70125_A / 64.0f;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)f3, (double)f5, (double)f7, (double)(f2 + f8), (double)(f2 + f9));
        tessellator.func_78374_a((double)f4, (double)f5, (double)f7, (double)(0.0f + f8), (double)(f2 + f9));
        tessellator.func_78374_a((double)f4, (double)f6, (double)f7, (double)(0.0f + f8), (double)(0.0f + f9));
        tessellator.func_78374_a((double)f3, (double)f6, (double)f7, (double)(f2 + f8), (double)(0.0f + f9));
        tessellator.func_78381_a();
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    public static boolean isInsideOfFluid(Entity entity, Fluid fluid) {
        int k;
        int j;
        double d0 = entity.field_70163_u + (double)entity.func_70047_e();
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        Block block = entity.field_70170_p.func_147439_a(i, j = MathHelper.func_76141_d((float)MathHelper.func_76128_c((double)d0)), k = MathHelper.func_76128_c((double)entity.field_70161_v));
        if (block != null && block instanceof IFluidBlock && ((IFluidBlock)block).getFluid() != null && ((IFluidBlock)block).getFluid().getName().equals(fluid.getName())) {
            double filled = ((IFluidBlock)block).getFilledPercentage(entity.field_70170_p, i, j, k);
            if (filled < 0.0) {
                return d0 > (double)j + (1.0 - (filled *= -1.0));
            }
            return d0 < (double)j + filled;
        }
        return false;
    }

    public static void renderFootprints(float partialTicks) {
        footprintRenderer.renderFootprints((EntityPlayer)ClientProxyCore.mc.field_71439_g, partialTicks);
        MinecraftForge.EVENT_BUS.post((Event)new EventSpecialRender(partialTicks));
    }

    @Override
    public World getWorldForID(int dimensionID) {
        WorldClient world = ClientProxyCore.mc.field_71441_e;
        if (world != null && world.field_73011_w.field_76574_g == dimensionID) {
            return world;
        }
        return null;
    }

    @SubscribeEvent
    public void onRenderPlayerPre(RenderPlayerEvent.Pre event) {
        GL11.glPushMatrix();
        EntityPlayer player = event.entityPlayer;
        if (player.field_70154_o instanceof EntityTieredRocket && player == Minecraft.func_71410_x().field_71439_g && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
            EntityTieredRocket entity = (EntityTieredRocket)player.field_70154_o;
            GL11.glTranslatef((float)0.0f, (float)(-entity.getRotateOffset() - PLAYER_Y_OFFSET), (float)0.0f);
            float anglePitch = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * event.partialRenderTick;
            float angleYaw = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * event.partialRenderTick;
            GL11.glRotatef((float)(-angleYaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)anglePitch, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)(entity.getRotateOffset() + PLAYER_Y_OFFSET), (float)0.0f);
        }
    }

    @SubscribeEvent
    public void onRenderPlayerPost(RenderPlayerEvent.Post event) {
        GL11.glPopMatrix();
    }

    @SubscribeEvent
    public void onRenderPlayerEquipped(RenderPlayerEvent.Specials.Pre event) {
        Entity ridden = event.entityPlayer.field_70154_o;
        if (ridden instanceof EntityAutoRocket || ridden instanceof EntityLanderBase) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPostRender(RenderPlayerEvent.Specials.Post event) {
        AbstractClientPlayer player = (AbstractClientPlayer)event.entityPlayer;
        boolean flag = capeMap.containsKey(event.entityPlayer.func_70005_c_());
        if (flag && !player.func_82150_aj() && !player.func_82238_cc()) {
            String url = capeMap.get(player.func_70005_c_());
            ResourceLocation capeLoc = capesMap.get(url);
            if (!capesMap.containsKey(url)) {
                try {
                    String dirName = Minecraft.func_71410_x().field_71412_D.getAbsolutePath();
                    File directory = new File(dirName, "assets");
                    boolean success = true;
                    if (!directory.exists()) {
                        success = directory.mkdir();
                    }
                    if (success) {
                        if (!(directory = new File(directory, "gcCapes")).exists()) {
                            success = directory.mkdir();
                        }
                        if (success) {
                            String hash = String.valueOf(player.func_70005_c_().hashCode());
                            File file1 = new File(directory, hash.substring(0, 2));
                            File file2 = new File(file1, hash);
                            ResourceLocation resourcelocation = new ResourceLocation("gcCapes/" + hash);
                            ThreadDownloadImageDataGC threaddownloadimagedata = new ThreadDownloadImageDataGC(file2, url, null, new IImageBuffer(){

                                public BufferedImage func_78432_a(BufferedImage p_78432_1_) {
                                    if (p_78432_1_ == null) {
                                        return null;
                                    }
                                    BufferedImage bufferedimage1 = new BufferedImage(512, 256, 2);
                                    Graphics graphics = bufferedimage1.getGraphics();
                                    graphics.drawImage(p_78432_1_, 0, 0, null);
                                    graphics.dispose();
                                    p_78432_1_ = bufferedimage1;
                                    return p_78432_1_;
                                }

                                public void func_152634_a() {
                                }
                            });
                            if (mc.func_110434_K().func_110579_a(resourcelocation, (ITextureObject)threaddownloadimagedata)) {
                                capeLoc = resourcelocation;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                capesMap.put(url, capeLoc);
            }
            if (capeLoc != null) {
                mc.func_110434_K().func_110577_a(capeLoc);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.125f);
                double d3 = player.field_71091_bM + (player.field_71094_bP - player.field_71091_bM) * (double)event.partialRenderTick - (player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)event.partialRenderTick);
                double d4 = player.field_71096_bN + (player.field_71095_bQ - player.field_71096_bN) * (double)event.partialRenderTick - (player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)event.partialRenderTick);
                double d0 = player.field_71097_bO + (player.field_71085_bR - player.field_71097_bO) * (double)event.partialRenderTick - (player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)event.partialRenderTick);
                float f4 = (player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * event.partialRenderTick) / 57.29578f;
                double d1 = MathHelper.func_76126_a((float)f4);
                double d2 = -MathHelper.func_76134_b((float)f4);
                float f5 = (float)d4 * 10.0f;
                if (f5 < -6.0f) {
                    f5 = -6.0f;
                }
                if (f5 > 32.0f) {
                    f5 = 32.0f;
                }
                float f6 = (float)(d3 * d1 + d0 * d2) * 100.0f;
                float f7 = (float)(d3 * d2 - d0 * d1) * 100.0f;
                if (f6 < 0.0f) {
                    f6 = 0.0f;
                }
                float f8 = player.field_71107_bF + (player.field_71109_bG - player.field_71107_bF) * event.partialRenderTick;
                f5 += MathHelper.func_76126_a((float)((player.field_70141_P + (player.field_70140_Q - player.field_70141_P) * event.partialRenderTick) * 6.0f)) * 32.0f * f8;
                if (player.func_70093_af()) {
                    f5 += 25.0f;
                }
                GL11.glRotatef((float)(6.0f + f6 / 2.0f + f5), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)(f7 / 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)(-f7 / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                event.renderer.field_77109_a.func_78111_c(0.0625f);
                GL11.glPopMatrix();
            }
        }
    }

    public static void adjustRenderPos(Entity entity, double offsetX, double offsetY, double offsetZ) {
        GL11.glPushMatrix();
        if (smallMoonActive && (offsetX != 0.0 || offsetY != 0.0 || offsetZ != 0.0)) {
            EntityClientPlayerMP player = ClientProxyCore.mc.field_71439_g;
            if (player.field_70163_u > (double)(terrainHeight + 8.0f) && player.field_70154_o != entity && player != entity) {
                double globalArc = (double)globalRadius / 57.2957795;
                int pX = MathHelper.func_76128_c((double)(player.field_70165_t / 16.0)) << 4;
                int pZ = MathHelper.func_76128_c((double)(player.field_70161_v / 16.0)) << 4;
                int eX = MathHelper.func_76128_c((double)(entity.field_70165_t / 16.0)) << 4;
                int eY = MathHelper.func_76128_c((double)(entity.field_70163_u / 16.0)) << 4;
                int eZ = MathHelper.func_76128_c((double)(entity.field_70161_v / 16.0)) << 4;
                float dX = eX - pX;
                float dZ = eZ - pZ;
                float floatPX = (float)player.field_70165_t;
                float floatPZ = (float)player.field_70161_v;
                if (dX > 0.0f) {
                    if ((dX -= 16.0f) > 0.0f) {
                        dX -= floatPX - (float)pX;
                    }
                } else if (dX < 0.0f && (dX += 16.0f) < 0.0f) {
                    dX += 16.0f - floatPX + (float)pX;
                }
                if (dZ > 0.0f) {
                    if ((dZ -= 16.0f) > 0.0f) {
                        dZ -= floatPZ - (float)pZ;
                    }
                } else if (dZ < 0.0f && (dZ += 16.0f) < 0.0f) {
                    dZ += 16.0f - floatPZ + (float)pZ;
                }
                float theta = (float)MathHelper.func_76138_g((double)((double)dX / globalArc));
                float phi = (float)MathHelper.func_76138_g((double)((double)dZ / globalArc));
                if (theta < 0.0f) {
                    theta += 360.0f;
                }
                if (phi < 0.0f) {
                    phi += 360.0f;
                }
                float ytranslate = globalRadius + (float)(player.field_70163_u - entity.field_70163_u) + (float)eY - terrainHeight;
                GL11.glTranslatef((float)(-dX + (float)eX - floatPX + 8.0f), (float)(-ytranslate), (float)(-dZ + (float)eZ - floatPZ + 8.0f));
                if (theta > 0.0f) {
                    GL11.glRotatef((float)theta, (float)0.0f, (float)0.0f, (float)-1.0f);
                }
                if (phi > 0.0f) {
                    GL11.glRotatef((float)phi, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                GL11.glTranslatef((float)(floatPX - (float)eX - 8.0f), (float)ytranslate, (float)(floatPZ - (float)eZ - 8.0f));
            }
        }
    }

    public static void adjustTileRenderPos(TileEntity tile, double offsetX, double offsetY, double offsetZ) {
        GL11.glPushMatrix();
        if (smallMoonActive && (offsetX != 0.0 || offsetY != 0.0 || offsetZ != 0.0)) {
            EntityClientPlayerMP player = ClientProxyCore.mc.field_71439_g;
            WorldProvider provider = ClientProxyCore.mc.field_71441_e.field_73011_w;
            if (provider instanceof WorldProviderMoon && player.field_70163_u > (double)(terrainHeight + 8.0f)) {
                double globalArc = (double)globalRadius / 57.2957795;
                int pX = MathHelper.func_76128_c((double)(player.field_70165_t / 16.0)) << 4;
                int pZ = MathHelper.func_76128_c((double)(player.field_70161_v / 16.0)) << 4;
                int eX = tile.field_145851_c / 16 << 4;
                int eY = tile.field_145848_d / 16 << 4;
                int eZ = tile.field_145849_e / 16 << 4;
                float dX = eX - pX;
                float dZ = eZ - pZ;
                float floatPX = (float)player.field_70165_t;
                float floatPZ = (float)player.field_70161_v;
                if (dX > 0.0f) {
                    if ((dX -= 16.0f) > 0.0f) {
                        dX -= floatPX - (float)pX;
                    }
                } else if (dX < 0.0f && (dX += 16.0f) < 0.0f) {
                    dX += 16.0f - floatPX + (float)pX;
                }
                if (dZ > 0.0f) {
                    if ((dZ -= 16.0f) > 0.0f) {
                        dZ -= floatPZ - (float)pZ;
                    }
                } else if (dZ < 0.0f && (dZ += 16.0f) < 0.0f) {
                    dZ += 16.0f - floatPZ + (float)pZ;
                }
                float theta = (float)MathHelper.func_76138_g((double)((double)dX / globalArc));
                float phi = (float)MathHelper.func_76138_g((double)((double)dZ / globalArc));
                if (theta < 0.0f) {
                    theta += 360.0f;
                }
                if (phi < 0.0f) {
                    phi += 360.0f;
                }
                float ytranslate = globalRadius + (float)player.field_70163_u - (float)tile.field_145848_d + (float)eY - terrainHeight;
                GL11.glTranslatef((float)(-dX - floatPX + (float)eX + 8.0f), (float)(-ytranslate), (float)(-dZ - floatPZ + (float)eZ + 8.0f));
                if (theta > 0.0f) {
                    GL11.glRotatef((float)theta, (float)0.0f, (float)0.0f, (float)-1.0f);
                }
                if (phi > 0.0f) {
                    GL11.glRotatef((float)phi, (float)1.0f, (float)0.0f, (float)0.0f);
                }
                GL11.glTranslatef((float)(floatPX - (float)eX - 8.0f), (float)ytranslate, (float)(floatPZ - (float)eZ - 8.0f));
            }
        }
    }

    public static void orientCamera(float partialTicks) {
        EntityClientPlayerMP player = ClientProxyCore.mc.field_71439_g;
        GCPlayerStatsClient stats = GCPlayerStatsClient.get((EntityPlayerSP)player);
        EntityLivingBase entityLivingBase = ClientProxyCore.mc.field_71451_h;
        if (player.field_70154_o instanceof EntityTieredRocket && ClientProxyCore.mc.field_71474_y.field_74320_O == 0) {
            EntityTieredRocket entity = (EntityTieredRocket)player.field_70154_o;
            float offset = entity.getRotateOffset() + PLAYER_Y_OFFSET;
            GL11.glTranslatef((float)0.0f, (float)(-offset), (float)0.0f);
            float anglePitch = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * partialTicks;
            float angleYaw = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks;
            GL11.glRotatef((float)(-anglePitch), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)angleYaw, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)offset, (float)0.0f);
        }
        if (entityLivingBase.field_70170_p.field_73011_w instanceof WorldProviderOrbit && !entityLivingBase.func_70608_bn()) {
            float f1 = entityLivingBase.field_70129_M - 1.62f;
            float pitch = entityLivingBase.field_70127_C + (entityLivingBase.field_70125_A - entityLivingBase.field_70127_C) * partialTicks;
            float yaw = entityLivingBase.field_70126_B + (entityLivingBase.field_70177_z - entityLivingBase.field_70126_B) * partialTicks + 180.0f;
            float eyeHeightChange = entityLivingBase.field_70129_M - entityLivingBase.field_70130_N / 2.0f;
            GL11.glTranslatef((float)0.0f, (float)(-f1), (float)0.0f);
            GL11.glRotatef((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-pitch), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.1f);
            GL11.glRotatef((float)(180.0f * stats.gdir.getThetaX()), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(180.0f * stats.gdir.getThetaZ()), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(pitch * stats.gdir.getPitchGravityX()), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(pitch * stats.gdir.getPitchGravityY()), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(yaw * stats.gdir.getYawGravityX()), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(yaw * stats.gdir.getYawGravityY()), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(yaw * stats.gdir.getYawGravityZ()), (float)0.0f, (float)0.0f, (float)1.0f);
            if (stats.landingTicks > 0) {
                float sneakY = stats.landingTicks >= 4 ? (stats.landingTicks >= 5 ? 0.15f : 0.3f) : (float)stats.landingTicks * 0.075f;
                GL11.glTranslatef((float)(sneakY * stats.gdir.getSneakVecX()), (float)(sneakY * stats.gdir.getSneakVecY()), (float)(sneakY * stats.gdir.getSneakVecZ()));
            }
            GL11.glTranslatef((float)(eyeHeightChange * stats.gdir.getEyeVecX()), (float)(eyeHeightChange * stats.gdir.getEyeVecY()), (float)(eyeHeightChange * stats.gdir.getEyeVecZ()));
            if (stats.gravityTurnRate < 1.0f) {
                GL11.glRotatef((float)(90.0f * (stats.gravityTurnRatePrev + (stats.gravityTurnRate - stats.gravityTurnRatePrev) * partialTicks)), (float)stats.gravityTurnVecX, (float)stats.gravityTurnVecY, (float)stats.gravityTurnVecZ);
            }
        }
    }

    public static void adjustRenderCamera() {
        GL11.glPushMatrix();
    }

    public static void setPositionList(WorldRenderer rend, int glRenderList) {
        GL11.glNewList((int)(glRenderList + 3), (int)4864);
        EntityLivingBase entitylivingbase = ClientProxyCore.mc.field_71451_h;
        if (entitylivingbase != null) {
            if (rend.field_78924_a.field_73011_w instanceof WorldProviderMoon) {
                globalRadius = 300.0f;
                terrainHeight = 64.0f;
                if (entitylivingbase.field_70163_u > (double)(terrainHeight + 8.0f)) {
                    smallMoonActive = true;
                    double globalArc = (double)globalRadius / 57.2957795;
                    float globeRadius = globalRadius - terrainHeight;
                    int pX = MathHelper.func_76128_c((double)(entitylivingbase.field_70165_t / 16.0)) << 4;
                    int pZ = MathHelper.func_76128_c((double)(entitylivingbase.field_70161_v / 16.0)) << 4;
                    float dX = rend.field_78923_c - pX;
                    float dZ = rend.field_78921_e - pZ;
                    float scalerX = 0.0f;
                    float scalerZ = 0.0f;
                    if (dX > 0.0f) {
                        if ((dX -= 16.0f) > 0.0f) {
                            scalerX = (dX = (float)((double)dX - (entitylivingbase.field_70165_t - (double)pX))) < 16.0f ? 16.0f - ((float)entitylivingbase.field_70165_t - (float)pX) : 16.0f;
                        }
                    } else if (dX < 0.0f && (dX += 16.0f) < 0.0f) {
                        scalerX = (dX = (float)((double)dX + (16.0 - (entitylivingbase.field_70165_t - (double)pX)))) > -16.0f ? (float)entitylivingbase.field_70165_t - (float)pX : 16.0f;
                    }
                    if (dZ > 0.0f) {
                        if ((dZ -= 16.0f) > 0.0f) {
                            scalerZ = (dZ = (float)((double)dZ - (entitylivingbase.field_70161_v - (double)pZ))) < 16.0f ? 16.0f - ((float)entitylivingbase.field_70161_v - (float)pZ) : 16.0f;
                        }
                    } else if (dZ < 0.0f && (dZ += 16.0f) < 0.0f) {
                        scalerZ = (dZ = (float)((double)dZ + (16.0 - (entitylivingbase.field_70161_v - (double)pZ)))) > -16.0f ? (float)entitylivingbase.field_70161_v - (float)pZ : 16.0f;
                    }
                    float origClipX = rend.field_78932_i;
                    float origClipY = rend.field_78929_j;
                    float origClipZ = rend.field_78930_k;
                    float theta = (float)MathHelper.func_76138_g((double)((double)dX / globalArc));
                    float phi = (float)MathHelper.func_76138_g((double)((double)dZ / globalArc));
                    if (theta < 0.0f) {
                        theta += 360.0f;
                    }
                    if (phi < 0.0f) {
                        phi += 360.0f;
                    }
                    GL11.glTranslatef((float)(origClipX - dX + 8.0f), (float)(-globeRadius + 8.0f), (float)(origClipZ - dZ + 8.0f));
                    if (theta > 0.0f) {
                        GL11.glRotatef((float)theta, (float)0.0f, (float)0.0f, (float)-1.0f);
                    }
                    if (phi > 0.0f) {
                        GL11.glRotatef((float)phi, (float)1.0f, (float)0.0f, (float)0.0f);
                    }
                    GL11.glTranslatef((float)-8.0f, (float)(origClipY + globeRadius - 8.0f), (float)-8.0f);
                    if (dX != 0.0f || dZ != 0.0f) {
                        float scalex = (globalRadius * 2.0f + scalerX) / globalRadius / 2.0f;
                        float scalez = (globalRadius * 2.0f + scalerZ) / globalRadius / 2.0f;
                        scaleup.rewind();
                        scaleup.put(scalex);
                        scaleup.position(10);
                        scaleup.put(scalez);
                        scaleup.rewind();
                        GL11.glMultMatrix((FloatBuffer)scaleup);
                        GL11.glTranslatef((float)(-8.0f * (scalex - 1.0f)), (float)0.0f, (float)(-8.0f * (scalez - 1.0f)));
                    }
                    GL11.glTranslatef((float)(-origClipX), (float)(-origClipY), (float)(-origClipZ));
                    offsetY = (float)rend.field_78920_d - terrainHeight;
                } else {
                    smallMoonActive = false;
                    offsetY = 0.0;
                }
            } else {
                terrainHeight = Float.MAX_VALUE;
                globalRadius = Float.MAX_VALUE;
                smallMoonActive = false;
                offsetY = 0.0;
            }
        }
        GL11.glEndList();
    }

    @Override
    public EntityPlayer getPlayerFromNetHandler(INetHandler handler) {
        if (handler instanceof NetHandlerPlayServer) {
            return ((NetHandlerPlayServer)handler).field_147369_b;
        }
        return FMLClientHandler.instance().getClientPlayerEntity();
    }

    public void addVertex(double x, double y, double z) {
        double var7 = 1.0 + (y + offsetY) / (double)globalRadius;
        x += (x % 16.0 - 8.0) * var7 + 8.0;
        z += (z % 16.0 - 8.0) * var7 + 8.0;
    }

    @SubscribeEvent
    public void onRenderPlanetPre(CelestialBodyRenderEvent.Pre event) {
        if (event.celestialBody == GalacticraftCore.planetOverworld) {
            if (!overworldTextureRequestSent) {
                GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_REQUEST_OVERWORLD_IMAGE, new Object[0]));
                overworldTextureRequestSent = true;
            }
            if (overworldTextureClient != null) {
                event.celestialBodyTexture = null;
                GL11.glBindTexture((int)3553, (int)overworldTextureClient.func_110552_b());
            }
        }
    }

    @SubscribeEvent
    public void onRenderPlanetPost(CelestialBodyRenderEvent.Post event) {
        if (ClientProxyCore.mc.field_71462_r instanceof GuiCelestialSelection) {
            if (event.celestialBody == GalacticraftCore.planetSaturn) {
                ClientProxyCore.mc.field_71446_o.func_110577_a(saturnRingTexture);
                float size = (float)GuiCelestialSelection.getWidthForCelestialBodyStatic(event.celestialBody) / 6.0f;
                ((GuiCelestialSelection)ClientProxyCore.mc.field_71462_r).drawTexturedModalRect(-7.5f * size, -1.75f * size, 15.0f * size, 3.5f * size, 0.0f, 0.0f, 30.0f, 7.0f, false, false, 30.0f, 7.0f);
            } else if (event.celestialBody == GalacticraftCore.planetUranus) {
                ClientProxyCore.mc.field_71446_o.func_110577_a(uranusRingTexture);
                float size = (float)GuiCelestialSelection.getWidthForCelestialBodyStatic(event.celestialBody) / 6.0f;
                ((GuiCelestialSelection)ClientProxyCore.mc.field_71462_r).drawTexturedModalRect(-1.75f * size, -7.0f * size, 3.5f * size, 14.0f * size, 0.0f, 0.0f, 28.0f, 7.0f, false, false, 28.0f, 7.0f);
            }
        }
    }

    static {
        footprintRenderer = new FootprintRenderer();
        flagRequestsSent = new ArrayList<String>();
        valueableBlocks = Sets.newHashSet();
        detectableBlocks = Sets.newHashSet();
        playerItemData = Maps.newHashMap();
        clientSpaceStationID = 0;
        galacticraftItem = EnumHelper.addRarity((String)"GCRarity", (EnumChatFormatting)EnumChatFormatting.BLUE, (String)"Space");
        capeMap = new HashMap<String, String>();
        dummyInventory = new InventoryExtended();
        underOilTexture = new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/misc/underoil.png");
        numbers = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        scaleup = BufferUtils.createFloatBuffer((int)512);
        globalRadius = Float.MAX_VALUE;
        offsetY = 0.0;
        terrainHeight = Float.MAX_VALUE;
        smallMoonActive = false;
        capesMap = Maps.newHashMap();
        playerClientHandler = new PlayerClient();
        mc = FMLClientHandler.instance().getClient();
        gearDataRequests = Lists.newArrayList();
        overworldTextureRequestSent = false;
        PLAYER_Y_OFFSET = 1.62f;
        saturnRingTexture = new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/saturnRings.png");
        uranusRingTexture = new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/uranusRings.png");
    }

    public static class EventSpecialRender
    extends Event {
        public final float partialTicks;

        public EventSpecialRender(float partialTicks) {
            this.partialTicks = partialTicks;
        }
    }
}

