/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import cpw.mods.fml.relauncher.Side;
import micdoodle8.mods.galacticraft.api.entity.ICargoEntity;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCargoUnloader
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
ILandingPadAttachable {
    private ItemStack[] containingItems = new ItemStack[15];
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean targetEmpty;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean targetNoInventory;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean noTarget;
    public ICargoEntity attachedFuelable;

    public TileEntityCargoUnloader() {
        this.storage.setMaxExtract(45.0f);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.ticks % 100L == 0L) {
                this.checkForCargoEntity();
            }
            if (this.attachedFuelable != null) {
                this.noTarget = false;
                ICargoEntity.RemovalResult result = this.attachedFuelable.removeCargo(false);
                if (result.resultStack != null) {
                    this.targetEmpty = false;
                    ICargoEntity.EnumCargoLoadingState state = this.addCargo(result.resultStack, false);
                    boolean bl = this.targetEmpty = state == ICargoEntity.EnumCargoLoadingState.EMPTY;
                    if (this.ticks % 15L == 0L && state == ICargoEntity.EnumCargoLoadingState.SUCCESS && !this.disabled && this.hasEnoughEnergyToRun) {
                        this.addCargo(this.attachedFuelable.removeCargo((boolean)true).resultStack, true);
                    }
                } else {
                    this.targetNoInventory = result.resultState == ICargoEntity.EnumCargoLoadingState.NOINVENTORY;
                    this.noTarget = result.resultState == ICargoEntity.EnumCargoLoadingState.NOTARGET;
                    this.targetEmpty = true;
                }
            } else {
                this.noTarget = true;
            }
        }
    }

    public void checkForCargoEntity() {
        boolean foundFuelable = false;
        for (ForgeDirection dir : ForgeDirection.values()) {
            if (dir == ForgeDirection.UNKNOWN) continue;
            TileEntity pad = new BlockVec3(this).getTileEntityOnSide(this.field_145850_b, dir);
            if (pad != null && pad instanceof TileEntityMulti) {
                TileEntity mainTile = ((TileEntityMulti)pad).getMainBlockTile();
                if (!(mainTile instanceof ICargoEntity)) continue;
                this.attachedFuelable = (ICargoEntity)mainTile;
                foundFuelable = true;
                break;
            }
            if (pad == null || !(pad instanceof ICargoEntity)) continue;
            this.attachedFuelable = (ICargoEntity)pad;
            foundFuelable = true;
            break;
        }
        if (!foundFuelable) {
            this.attachedFuelable = null;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.containingItems = this.readStandardItemsFromNBT(par1NBTTagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        this.writeStandardItemsToNBT(par1NBTTagCompound);
    }

    @Override
    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate("container.cargounloader.name");
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side != this.func_145832_p() - 2) {
            int[] nArray2 = new int[14];
            nArray2[0] = 1;
            nArray2[1] = 2;
            nArray2[2] = 3;
            nArray2[3] = 4;
            nArray2[4] = 5;
            nArray2[5] = 6;
            nArray2[6] = 7;
            nArray2[7] = 8;
            nArray2[8] = 9;
            nArray2[9] = 10;
            nArray2[10] = 11;
            nArray2[11] = 12;
            nArray2[12] = 13;
            nArray = nArray2;
            nArray2[13] = 14;
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        return false;
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (side != this.func_145832_p() - 2) {
            if (slotID == 0) {
                return ItemElectricBase.isElectricItem(itemstack.func_77973_b());
            }
            return true;
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return ItemElectricBase.isElectricItem(itemstack.func_77973_b());
        }
        return true;
    }

    @Override
    public boolean shouldUseEnergy() {
        return !this.getDisabled(0);
    }

    public ICargoEntity.EnumCargoLoadingState addCargo(ItemStack stack, boolean doAdd) {
        ItemStack stackAt;
        int count = 1;
        for (count = 1; count < this.containingItems.length; ++count) {
            stackAt = this.containingItems[count];
            if (stackAt == null || stackAt.func_77973_b() != stack.func_77973_b() || stackAt.func_77960_j() != stack.func_77960_j() || stackAt.field_77994_a >= stackAt.func_77976_d()) continue;
            if (stackAt.field_77994_a + stack.field_77994_a <= stackAt.func_77976_d()) {
                if (doAdd) {
                    this.containingItems[count].field_77994_a += stack.field_77994_a;
                    this.func_70296_d();
                }
                return ICargoEntity.EnumCargoLoadingState.SUCCESS;
            }
            int origSize = stackAt.field_77994_a;
            int surplus = origSize + stack.field_77994_a - stackAt.func_77976_d();
            if (doAdd) {
                this.containingItems[count].field_77994_a = stackAt.func_77976_d();
                this.func_70296_d();
            }
            stack.field_77994_a = surplus;
            if (this.addCargo(stack, doAdd) == ICargoEntity.EnumCargoLoadingState.SUCCESS) {
                return ICargoEntity.EnumCargoLoadingState.SUCCESS;
            }
            this.containingItems[count].field_77994_a = origSize;
            return ICargoEntity.EnumCargoLoadingState.FULL;
        }
        for (count = 1; count < this.containingItems.length; ++count) {
            stackAt = this.containingItems[count];
            if (stackAt != null) continue;
            if (doAdd) {
                this.containingItems[count] = stack;
                this.func_70296_d();
            }
            return ICargoEntity.EnumCargoLoadingState.SUCCESS;
        }
        return ICargoEntity.EnumCargoLoadingState.FULL;
    }

    public ICargoEntity.RemovalResult removeCargo(boolean doRemove) {
        for (int i = 1; i < this.containingItems.length; ++i) {
            ItemStack stackAt = this.containingItems[i];
            if (stackAt == null) continue;
            ItemStack resultStack = stackAt.func_77946_l();
            resultStack.field_77994_a = 1;
            if (doRemove && --stackAt.field_77994_a <= 0) {
                this.containingItems[i] = null;
            }
            if (doRemove) {
                this.func_70296_d();
            }
            return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.SUCCESS, resultStack);
        }
        return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.EMPTY, null);
    }

    @Override
    public boolean canAttachToLandingPad(IBlockAccess world, int x, int y, int z) {
        return true;
    }
}

