/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.prefab.entity;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.ICargoEntity;
import micdoodle8.mods.galacticraft.api.entity.IDockable;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockLandingPadFull;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.entities.player.GCEntityPlayerMP;
import micdoodle8.mods.galacticraft.core.event.EventLandingPadRemoval;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFuelLoader;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public abstract class EntityAutoRocket
extends EntitySpaceshipBase
implements IDockable,
IInventory,
IPacketReceiver {
    public FluidTank fuelTank = new FluidTank(this.getFuelTankCapacity());
    public int destinationFrequency = -1;
    public BlockVec3 targetVec;
    public int targetDimension;
    protected ItemStack[] cargoItems;
    private IFuelDock landingPad;
    public boolean landing;
    public EnumAutoLaunch autoLaunchSetting;
    private static boolean marsLoaded = Loader.isModLoaded((String)"GalacticraftMars");
    public int autoLaunchCountdown;
    public String statusMessage;
    public int statusMessageCooldown;
    public int lastStatusMessageCooldown;
    public boolean statusValid;
    protected double lastMotionY;
    protected double lastLastMotionY;
    private boolean waitForPlayer;

    public EntityAutoRocket(World world) {
        super(world);
        this.field_70129_M = 0.0f;
    }

    public EntityAutoRocket(World world, double posX, double posY, double posZ) {
        this(world);
        this.func_70105_a(0.98f, 2.0f);
        this.field_70129_M = this.field_70131_O / 2.0f;
        this.func_70107_b(posX, posY, posZ);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = posX;
        this.field_70167_r = posY;
        this.field_70166_s = posZ;
    }

    public abstract int getFuelTankCapacity();

    public boolean checkLaunchValidity() {
        this.statusMessageCooldown = 40;
        if (this.hasValidFuel()) {
            if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.UNIGNITED.ordinal() && !this.field_70170_p.field_72995_K) {
                if (!this.setFrequency()) {
                    this.destinationFrequency = -1;
                    this.statusMessage = "\u00a7c" + StatCollector.func_74838_a((String)"gui.message.frequency.name") + "#\u00a7c" + StatCollector.func_74838_a((String)"gui.message.notSet.name");
                    return false;
                }
                this.statusMessage = "\u00a7a" + StatCollector.func_74838_a((String)"gui.message.success.name");
                return true;
            }
        } else {
            this.destinationFrequency = -1;
            this.statusMessage = "\u00a7c" + StatCollector.func_74838_a((String)"gui.message.notEnough.name") + "#\u00a7c" + StatCollector.func_74838_a((String)"gui.message.fuel.name");
            return false;
        }
        this.destinationFrequency = -1;
        return false;
    }

    public boolean setFrequency() {
        if (!marsLoaded) {
            return false;
        }
        for (int x = MathHelper.func_76128_c((double)this.field_70165_t) - 1; x <= MathHelper.func_76128_c((double)this.field_70165_t) + 1; ++x) {
            for (int y = MathHelper.func_76128_c((double)this.field_70163_u) - 3; y <= MathHelper.func_76128_c((double)this.field_70163_u) + 1; ++y) {
                for (int z = MathHelper.func_76128_c((double)this.field_70161_v) - 1; z <= MathHelper.func_76128_c((double)this.field_70161_v) + 1; ++z) {
                    TileEntity tile = this.field_70170_p.func_147438_o(x, y, z);
                    if (!(tile instanceof IFuelDock)) continue;
                    IFuelDock dock = (IFuelDock)tile;
                    try {
                        int controllerFrequency;
                        boolean foundPad;
                        Boolean b;
                        TileEntity launchController = null;
                        Class<?> controllerClass = Class.forName("micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityLaunchController");
                        for (ILandingPadAttachable connectedTile : dock.getConnectedTiles()) {
                            try {
                                controllerClass.cast(connectedTile);
                            }
                            catch (ClassCastException e) {
                                continue;
                            }
                            launchController = (TileEntity)connectedTile;
                            if (launchController != null) {
                                TileEntity tile2 = launchController.func_145831_w().func_147438_o(launchController.field_145851_c, launchController.field_145848_d, launchController.field_145849_e);
                                try {
                                    controllerClass.cast(tile2);
                                }
                                catch (ClassCastException e) {
                                    launchController = null;
                                    continue;
                                }
                                launchController = tile2;
                            }
                            if (launchController == null) continue;
                            break;
                        }
                        if (launchController == null || (b = (Boolean)controllerClass.getMethod("validFrequency", new Class[0]).invoke(launchController, new Object[0])) == null || !b.booleanValue() || !(foundPad = this.setTarget(false, controllerFrequency = controllerClass.getField("destFrequency").getInt(launchController)))) continue;
                        this.destinationFrequency = controllerFrequency;
                        return true;
                    }
                    catch (ClassCastException e) {
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.destinationFrequency = -1;
        return false;
    }

    protected boolean setTarget(boolean doSet, int destFreq) {
        if (!marsLoaded || FMLCommonHandler.instance().getMinecraftServerInstance() == null || FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c == null) {
            return false;
        }
        for (int i = 0; i < FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c.length; ++i) {
            WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[i];
            for (int j = 0; j < world.field_147482_g.size(); ++j) {
                TileEntity tile = (TileEntity)world.field_147482_g.get(j);
                if (tile == null) continue;
                tile = world.func_147438_o(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
                try {
                    Class<?> controllerClass = Class.forName("micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityLaunchController");
                    try {
                        controllerClass.cast(tile);
                    }
                    catch (ClassCastException e) {
                        continue;
                    }
                    int controllerFrequency = controllerClass.getField("frequency").getInt(tile);
                    if (destFreq != controllerFrequency) continue;
                    boolean targetSet = false;
                    block6: for (int x = -2; x <= 2; ++x) {
                        for (int z = -2; z <= 2; ++z) {
                            Block block = world.func_147439_a(tile.field_145851_c + x, tile.field_145848_d, tile.field_145849_e + z);
                            if (!(block instanceof BlockLandingPadFull)) continue;
                            if (doSet) {
                                this.targetVec = new BlockVec3(tile.field_145851_c + x, tile.field_145848_d, tile.field_145849_e + z);
                            }
                            targetSet = true;
                            break block6;
                        }
                    }
                    if (doSet) {
                        this.targetDimension = tile.func_145831_w().field_73011_w.field_76574_g;
                    }
                    if (!targetSet) {
                        if (doSet) {
                            this.targetVec = null;
                        }
                        return false;
                    }
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    @Override
    public int getScaledFuelLevel(int scale) {
        if (this.getFuelTankCapacity() <= 0) {
            return 0;
        }
        return this.fuelTank.getFluidAmount() * scale / this.getFuelTankCapacity();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.statusMessageCooldown > 0) {
                --this.statusMessageCooldown;
            }
            if (this.statusMessageCooldown == 0 && this.lastStatusMessageCooldown > 0 && this.statusValid) {
                this.autoLaunch();
            }
            if (this.autoLaunchCountdown > 0) {
                --this.autoLaunchCountdown;
                if (this.autoLaunchCountdown <= 0) {
                    this.autoLaunch();
                }
            }
            if (this.autoLaunchSetting == EnumAutoLaunch.ROCKET_IS_FUELED && this.fuelTank.getFluidAmount() == this.fuelTank.getCapacity()) {
                this.autoLaunch();
            }
            if (this.autoLaunchSetting == EnumAutoLaunch.INSTANT && this.autoLaunchCountdown == 0) {
                this.autoLaunch();
            }
            if (this.autoLaunchSetting == EnumAutoLaunch.REDSTONE_SIGNAL && this.ticks % 25L == 0L && this.getLandingPad() != null && this.getLandingPad().getConnectedTiles() != null) {
                for (ILandingPadAttachable tile : this.getLandingPad().getConnectedTiles()) {
                    if (this.field_70170_p.func_147438_o(((TileEntity)tile).field_145851_c, ((TileEntity)tile).field_145848_d, ((TileEntity)tile).field_145849_e) == null) continue;
                    try {
                        Class<?> controllerClass = Class.forName("micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityLaunchController");
                        try {
                            controllerClass.cast(this.field_70170_p.func_147438_o(((TileEntity)tile).field_145851_c, ((TileEntity)tile).field_145848_d, ((TileEntity)tile).field_145849_e));
                        }
                        catch (ClassCastException e) {
                            continue;
                        }
                        if (!this.field_70170_p.func_72864_z(((TileEntity)tile).field_145851_c, ((TileEntity)tile).field_145848_d, ((TileEntity)tile).field_145849_e)) continue;
                        this.autoLaunch();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal() && this.hasValidFuel() && this.landing && this.targetVec != null && this.field_70170_p.func_147438_o(this.targetVec.intX(), this.targetVec.intY(), this.targetVec.intZ()) instanceof IFuelDock && this.field_70163_u - (double)this.targetVec.y < 5.0) {
                this.field_70181_x *= 0.99;
                for (int x = MathHelper.func_76128_c((double)this.field_70165_t) - 1; x <= MathHelper.func_76128_c((double)this.field_70165_t) + 1; ++x) {
                    for (int y = MathHelper.func_76128_c((double)(this.field_70163_u - (double)(this.field_70131_O / 2.0f) + 0.3)); y <= MathHelper.func_76128_c((double)this.field_70163_u) + 1; ++y) {
                        for (int z = MathHelper.func_76128_c((double)this.field_70161_v) - 1; z <= MathHelper.func_76128_c((double)this.field_70161_v) + 1; ++z) {
                            TileEntity tile = this.field_70170_p.func_147438_o(x, y, z);
                            if (!(tile instanceof IFuelDock)) continue;
                            this.failRocket();
                        }
                    }
                }
            }
            if (this.getLandingPad() != null && this.getLandingPad().getConnectedTiles() != null) {
                for (ILandingPadAttachable tile : this.getLandingPad().getConnectedTiles()) {
                    if (this.field_70170_p.func_147438_o(((TileEntity)tile).field_145851_c, ((TileEntity)tile).field_145848_d, ((TileEntity)tile).field_145849_e) == null || !(this.field_70170_p.func_147438_o(((TileEntity)tile).field_145851_c, ((TileEntity)tile).field_145848_d, ((TileEntity)tile).field_145849_e) instanceof TileEntityFuelLoader) || !(tile instanceof TileEntityFuelLoader) || !(((TileEntityFuelLoader)tile).getEnergyStoredGC() > 0.0f) || this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) continue;
                    this.setPad(null);
                }
            }
            this.lastStatusMessageCooldown = this.statusMessageCooldown;
        }
    }

    @Override
    protected boolean shouldMoveClientSide() {
        return false;
    }

    private void autoLaunch() {
        this.ignite();
        this.autoLaunchSetting = null;
    }

    public boolean igniteWithResult() {
        if (this.setFrequency()) {
            super.ignite();
            return true;
        }
        if (this.isPlayerRocket()) {
            super.ignite();
            return true;
        }
        return false;
    }

    @Override
    public void ignite() {
        this.igniteWithResult();
    }

    public abstract boolean isPlayerRocket();

    protected void landRocket(int x, int y, int z) {
        IFuelDock dock;
        TileEntity tile = this.field_70170_p.func_147438_o(x, y, z);
        if (tile instanceof IFuelDock && this.isDockValid(dock = (IFuelDock)tile)) {
            if (!this.field_70170_p.field_72995_K) {
                this.setLaunchPhase(EntitySpaceshipBase.EnumLaunchPhase.UNIGNITED);
                this.landing = false;
                this.targetVec = null;
                this.setPad(dock);
                if (marsLoaded) {
                    this.updateControllerSettings(dock);
                }
            }
            this.onRocketLand(x, y, z);
        }
    }

    public void updateControllerSettings(IFuelDock dock) {
        HashSet<ILandingPadAttachable> connectedTiles = dock.getConnectedTiles();
        try {
            Class<?> controllerClass = Class.forName("micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityLaunchController");
            for (ILandingPadAttachable connectedTile : connectedTiles) {
                if (connectedTile == null) continue;
                TileEntity updatedTile = this.field_70170_p.func_147438_o(((TileEntity)connectedTile).field_145851_c, ((TileEntity)connectedTile).field_145848_d, ((TileEntity)connectedTile).field_145849_e);
                try {
                    controllerClass.cast(updatedTile);
                }
                catch (ClassCastException e) {
                    continue;
                }
                controllerClass.getField("attachedDock").set(updatedTile, dock);
                Boolean autoLaunchEnabled = controllerClass.getField("launchSchedulingEnabled").getBoolean(updatedTile);
                if (autoLaunchEnabled.booleanValue()) {
                    this.autoLaunchSetting = EnumAutoLaunch.values()[controllerClass.getField("launchDropdownSelection").getInt(updatedTile)];
                    switch (this.autoLaunchSetting) {
                        case INSTANT: {
                            this.autoLaunchCountdown = 12;
                            break;
                        }
                        case TIME_10_SECONDS: {
                            this.autoLaunchCountdown = 200;
                            break;
                        }
                        case TIME_30_SECONDS: {
                            this.autoLaunchCountdown = 600;
                            break;
                        }
                        case TIME_1_MINUTE: {
                            this.autoLaunchCountdown = 1200;
                            break;
                        }
                    }
                } else {
                    this.autoLaunchSetting = null;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onRocketLand(int x, int y, int z) {
        this.func_70080_a((double)x + 0.5, (double)y + 0.4, (double)z + 0.5, this.field_70177_z, 0.0f);
    }

    @Override
    public void decodePacketdata(ByteBuf buffer) {
        super.decodePacketdata(buffer);
        this.fuelTank.setFluid(new FluidStack(GalacticraftCore.fluidFuel, buffer.readInt()));
        this.landing = buffer.readBoolean();
        this.destinationFrequency = buffer.readInt();
        if (buffer.readBoolean()) {
            this.targetVec = new BlockVec3(buffer.readInt(), buffer.readInt(), buffer.readInt());
        }
        this.field_70159_w = buffer.readDouble() / 8000.0;
        this.field_70181_x = buffer.readDouble() / 8000.0;
        this.field_70179_y = buffer.readDouble() / 8000.0;
        this.lastMotionY = buffer.readDouble() / 8000.0;
        this.lastLastMotionY = buffer.readDouble() / 8000.0;
        if (this.cargoItems == null) {
            this.cargoItems = new ItemStack[this.func_70302_i_()];
        }
        this.setWaitForPlayer(buffer.readBoolean());
        this.statusMessage = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.statusMessage = this.statusMessage.equals("") ? null : this.statusMessage;
        this.statusMessageCooldown = buffer.readInt();
        this.lastStatusMessageCooldown = buffer.readInt();
        this.statusValid = buffer.readBoolean();
    }

    @Override
    public void handlePacketData(Side side, EntityPlayer player) {
    }

    @Override
    public void getNetworkedData(ArrayList<Object> list) {
        super.getNetworkedData(list);
        list.add(this.fuelTank.getFluidAmount());
        list.add(this.landing);
        list.add(this.destinationFrequency);
        list.add(this.targetVec != null);
        if (this.targetVec != null) {
            list.add(this.targetVec.x);
            list.add(this.targetVec.y);
            list.add(this.targetVec.z);
        }
        list.add(this.field_70159_w * 8000.0);
        list.add(this.field_70181_x * 8000.0);
        list.add(this.field_70179_y * 8000.0);
        list.add(this.lastMotionY * 8000.0);
        list.add(this.lastLastMotionY * 8000.0);
        list.add(this.getWaitForPlayer());
        list.add(this.statusMessage != null ? this.statusMessage : "");
        list.add(this.statusMessageCooldown);
        list.add(this.lastStatusMessageCooldown);
        list.add(this.statusValid);
    }

    @Override
    protected void failRocket() {
        if (this.shouldCancelExplosion()) {
            for (int i = -3; i <= 3; ++i) {
                if (!this.landing || this.targetVec == null || !(this.field_70170_p.func_147438_o((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u + (double)i), (int)Math.floor(this.field_70161_v)) instanceof IFuelDock) || !(this.field_70163_u - (double)this.targetVec.y < 5.0)) continue;
                for (int x = MathHelper.func_76128_c((double)this.field_70165_t) - 1; x <= MathHelper.func_76128_c((double)this.field_70165_t) + 1; ++x) {
                    for (int y = MathHelper.func_76128_c((double)(this.field_70163_u - 3.0)); y <= MathHelper.func_76128_c((double)this.field_70163_u) + 1; ++y) {
                        for (int z = MathHelper.func_76128_c((double)this.field_70161_v) - 1; z <= MathHelper.func_76128_c((double)this.field_70161_v) + 1; ++z) {
                            TileEntity tile = this.field_70170_p.func_147438_o(x, y, z);
                            if (!(tile instanceof IFuelDock)) continue;
                            this.landRocket(x, y, z);
                            return;
                        }
                    }
                }
            }
        }
        if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
            super.failRocket();
        }
    }

    protected boolean shouldCancelExplosion() {
        return this.hasValidFuel();
    }

    public boolean hasValidFuel() {
        return this.fuelTank.getFluidAmount() > 0;
    }

    @Override
    public void onLaunch() {
        if (!(this.field_70170_p.field_73011_w instanceof WorldProviderSurface) && !(this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider)) {
            for (int i = ConfigManagerCore.disableRocketLaunchDimensions.length - 1; i >= 0; --i) {
                if (ConfigManagerCore.disableRocketLaunchDimensions[i] != this.field_70170_p.field_73011_w.field_76574_g) continue;
                this.setLaunchPhase(EntitySpaceshipBase.EnumLaunchPhase.UNIGNITED);
                this.timeUntilLaunch = 0;
                if (!this.field_70170_p.field_72995_K && this.field_70153_n instanceof GCEntityPlayerMP) {
                    ((GCEntityPlayerMP)this.field_70153_n).func_145747_a((IChatComponent)new ChatComponentText(GCCoreUtil.translate("gui.rocket.warning.nogyroscope")));
                }
                return;
            }
        }
        super.onLaunch();
        if (!this.field_70170_p.field_72995_K) {
            if (!(this.field_70170_p.field_73011_w instanceof IOrbitDimension) && this.field_70153_n != null && this.field_70153_n instanceof GCEntityPlayerMP) {
                ((GCEntityPlayerMP)this.field_70153_n).getPlayerStats().coordsTeleportedFromX = this.field_70153_n.field_70165_t;
                ((GCEntityPlayerMP)this.field_70153_n).getPlayerStats().coordsTeleportedFromZ = this.field_70153_n.field_70161_v;
            }
            int amountRemoved = 0;
            block1: for (int x = MathHelper.func_76128_c((double)this.field_70165_t) - 1; x <= MathHelper.func_76128_c((double)this.field_70165_t) + 1; ++x) {
                for (int y = MathHelper.func_76128_c((double)this.field_70163_u) - 3; y <= MathHelper.func_76128_c((double)this.field_70163_u) + 1; ++y) {
                    for (int z = MathHelper.func_76128_c((double)this.field_70161_v) - 1; z <= MathHelper.func_76128_c((double)this.field_70161_v) + 1; ++z) {
                        Block block = this.field_70170_p.func_147439_a(x, y, z);
                        if (block == null || !(block instanceof BlockLandingPadFull) || amountRemoved >= 9) continue;
                        EventLandingPadRemoval event = new EventLandingPadRemoval(this.field_70170_p, x, y, z);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        if (!event.allow) break block1;
                        this.field_70170_p.func_147468_f(x, y, z);
                        amountRemoved = 9;
                        break block1;
                    }
                }
            }
            if (this.field_70153_n != null && this.field_70153_n instanceof GCEntityPlayerMP) {
                ((GCEntityPlayerMP)this.field_70153_n).getPlayerStats().launchpadStack = amountRemoved == 9 ? new ItemStack(GCBlocks.landingPad, 9, 0) : null;
            }
            this.func_85030_a("random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.fuelTank.getFluid() != null) {
            nbt.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        }
        if (this.func_70302_i_() > 0) {
            NBTTagList var2 = new NBTTagList();
            for (int var3 = 0; var3 < this.cargoItems.length; ++var3) {
                if (this.cargoItems[var3] == null) continue;
                NBTTagCompound var4 = new NBTTagCompound();
                var4.func_74774_a("Slot", (byte)var3);
                this.cargoItems[var3].func_77955_b(var4);
                var2.func_74742_a((NBTBase)var4);
            }
            nbt.func_74782_a("Items", (NBTBase)var2);
        }
        nbt.func_74757_a("TargetValid", this.targetVec != null);
        if (this.targetVec != null) {
            nbt.func_74780_a("targetTileX", (double)this.targetVec.x);
            nbt.func_74780_a("targetTileY", (double)this.targetVec.y);
            nbt.func_74780_a("targetTileZ", (double)this.targetVec.z);
        }
        nbt.func_74757_a("WaitingForPlayer", this.getWaitForPlayer());
        nbt.func_74757_a("Landing", this.landing);
        nbt.func_74768_a("AutoLaunchSetting", this.autoLaunchSetting != null ? this.autoLaunchSetting.getIndex() : -1);
        nbt.func_74768_a("TimeUntilAutoLaunch", this.autoLaunchCountdown);
        nbt.func_74768_a("DestinationFrequency", this.destinationFrequency);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("fuelTank")) {
            this.fuelTank.readFromNBT(nbt.func_74775_l("fuelTank"));
        }
        if (this.func_70302_i_() > 0) {
            NBTTagList var2 = nbt.func_150295_c("Items", 10);
            this.cargoItems = new ItemStack[this.func_70302_i_()];
            for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
                NBTTagCompound var4 = var2.func_150305_b(var3);
                int var5 = var4.func_74771_c("Slot") & 0xFF;
                if (var5 < 0 || var5 >= this.cargoItems.length) continue;
                this.cargoItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
            }
        }
        if (nbt.func_74767_n("TargetValid") && nbt.func_74764_b("targetTileX")) {
            this.targetVec = new BlockVec3(MathHelper.func_76128_c((double)nbt.func_74769_h("targetTileX")), MathHelper.func_76128_c((double)nbt.func_74769_h("targetTileY")), MathHelper.func_76128_c((double)nbt.func_74769_h("targetTileZ")));
        }
        this.setWaitForPlayer(nbt.func_74767_n("WaitingForPlayer"));
        this.landing = nbt.func_74767_n("Landing");
        int autoLaunchValue = nbt.func_74762_e("AutoLaunchSetting");
        this.autoLaunchSetting = autoLaunchValue == -1 ? null : EnumAutoLaunch.values()[autoLaunchValue];
        this.autoLaunchCountdown = nbt.func_74762_e("TimeUntilAutoLaunch");
        this.destinationFrequency = nbt.func_74762_e("DestinationFrequency");
    }

    @Override
    public int addFuel(FluidStack liquid, boolean doFill) {
        if (liquid != null && FluidRegistry.getFluidName((FluidStack)liquid).equalsIgnoreCase("fuel")) {
            return this.fuelTank.fill(liquid, doFill);
        }
        return 0;
    }

    @Override
    public FluidStack removeFuel(int amount) {
        return this.fuelTank.drain(amount, true);
    }

    @Override
    public void setPad(IFuelDock pad) {
        this.landingPad = pad;
    }

    @Override
    public IFuelDock getLandingPad() {
        return this.landingPad;
    }

    @Override
    public int getMaxFuel() {
        return this.fuelTank.getCapacity();
    }

    @Override
    public boolean isDockValid(IFuelDock dock) {
        if (dock instanceof TileEntityLandingPad) {
            if (!this.field_70170_p.field_72995_K) {
                this.setLaunchPhase(EntitySpaceshipBase.EnumLaunchPhase.UNIGNITED);
                this.landing = false;
                this.targetVec = null;
                this.setPad(dock);
                if (marsLoaded) {
                    this.updateControllerSettings(dock);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public ICargoEntity.EnumCargoLoadingState addCargo(ItemStack stack, boolean doAdd) {
        ItemStack stackAt;
        if (this.func_70302_i_() <= 3) {
            if (this.autoLaunchSetting == EnumAutoLaunch.CARGO_IS_FULL) {
                this.autoLaunch();
            }
            return ICargoEntity.EnumCargoLoadingState.NOINVENTORY;
        }
        int count = 0;
        for (count = 0; count < this.cargoItems.length - 2; ++count) {
            stackAt = this.cargoItems[count];
            if (stackAt == null || stackAt.func_77973_b() != stack.func_77973_b() || stackAt.func_77960_j() != stack.func_77960_j() || stackAt.field_77994_a >= stackAt.func_77976_d()) continue;
            if (stackAt.field_77994_a + stack.field_77994_a <= stackAt.func_77976_d()) {
                if (doAdd) {
                    this.cargoItems[count].field_77994_a += stack.field_77994_a;
                    this.func_70296_d();
                }
                return ICargoEntity.EnumCargoLoadingState.SUCCESS;
            }
            int origSize = stackAt.field_77994_a;
            int surplus = origSize + stack.field_77994_a - stackAt.func_77976_d();
            if (doAdd) {
                this.cargoItems[count].field_77994_a = stackAt.func_77976_d();
                this.func_70296_d();
            }
            stack.field_77994_a = surplus;
            if (this.addCargo(stack, doAdd) == ICargoEntity.EnumCargoLoadingState.SUCCESS) {
                return ICargoEntity.EnumCargoLoadingState.SUCCESS;
            }
            this.cargoItems[count].field_77994_a = origSize;
            if (this.autoLaunchSetting == EnumAutoLaunch.CARGO_IS_FULL) {
                this.autoLaunch();
            }
            return ICargoEntity.EnumCargoLoadingState.FULL;
        }
        for (count = 0; count < this.cargoItems.length - 2; ++count) {
            stackAt = this.cargoItems[count];
            if (stackAt != null) continue;
            if (doAdd) {
                this.cargoItems[count] = stack;
                this.func_70296_d();
            }
            return ICargoEntity.EnumCargoLoadingState.SUCCESS;
        }
        if (this.autoLaunchSetting == EnumAutoLaunch.CARGO_IS_FULL) {
            this.autoLaunch();
        }
        return ICargoEntity.EnumCargoLoadingState.FULL;
    }

    @Override
    public ICargoEntity.RemovalResult removeCargo(boolean doRemove) {
        for (int i = 0; i < this.cargoItems.length - 2; ++i) {
            ItemStack stackAt = this.cargoItems[i];
            if (stackAt == null) continue;
            if (doRemove && --this.cargoItems[i].field_77994_a <= 0) {
                this.cargoItems[i] = null;
            }
            if (doRemove) {
                this.func_70296_d();
            }
            return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.SUCCESS, new ItemStack(stackAt.func_77973_b(), 1, stackAt.func_77960_j()));
        }
        if (this.autoLaunchSetting == EnumAutoLaunch.CARGO_IS_UNLOADED) {
            this.autoLaunch();
        }
        return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.EMPTY, null);
    }

    public ItemStack func_70301_a(int par1) {
        return this.cargoItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.cargoItems[par1] != null) {
            if (this.cargoItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.cargoItems[par1];
                this.cargoItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.cargoItems[par1].func_77979_a(par2);
            if (this.cargoItems[par1].field_77994_a == 0) {
                this.cargoItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.cargoItems[par1] != null) {
            ItemStack var2 = this.cargoItems[par1];
            this.cargoItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.cargoItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return GCCoreUtil.translate("container.spaceship.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return !this.field_70128_L && entityplayer.func_70068_e((Entity)this) <= 64.0;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public void func_70296_d() {
    }

    @Override
    public void onPadDestroyed() {
        if (!this.field_70128_L && this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
            this.dropShipAsItem();
            this.func_70106_y();
        }
    }

    @Override
    public List<ItemStack> getItemsDropped(List<ItemStack> droppedItemList) {
        if (this.cargoItems != null) {
            for (ItemStack item : this.cargoItems) {
                if (item == null) continue;
                droppedItemList.add(item);
            }
        }
        return droppedItemList;
    }

    public boolean getWaitForPlayer() {
        return this.waitForPlayer;
    }

    public void setWaitForPlayer(boolean waitForPlayer) {
        this.waitForPlayer = waitForPlayer;
    }

    public static enum EnumAutoLaunch {
        CARGO_IS_UNLOADED(0, "cargoUnloaded"),
        CARGO_IS_FULL(1, "cargoFull"),
        ROCKET_IS_FUELED(2, "fullyFueled"),
        INSTANT(3, "instant"),
        TIME_10_SECONDS(4, "tenSec"),
        TIME_30_SECONDS(5, "thirtySec"),
        TIME_1_MINUTE(6, "oneMin"),
        REDSTONE_SIGNAL(7, "redstoneSig");

        private final int index;
        private String title;

        private EnumAutoLaunch(int index, String title) {
            this.index = index;
            this.title = title;
        }

        public int getIndex() {
            return this.index;
        }

        public String getTitle() {
            return GCCoreUtil.translate("gui.message." + this.title + ".name");
        }
    }
}

