/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.prefab.entity;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.entity.ICameraZoomEntity;
import micdoodle8.mods.galacticraft.api.entity.IDockable;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.entity.IWorldTransferCallback;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.player.GCEntityPlayerMP;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFuelLoader;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;

public abstract class EntityTieredRocket
extends EntityAutoRocket
implements IRocketType,
IDockable,
IInventory,
IWorldTransferCallback,
ICameraZoomEntity {
    public IRocketType.EnumRocketType rocketType;
    public float rumble;
    public int launchCooldown;
    private ArrayList<BlockVec3> preGenList = new ArrayList();
    private Iterator<BlockVec3> preGenIterator = null;
    private MinecraftServer mcserver = FMLCommonHandler.instance().getMinecraftServerInstance();

    public EntityTieredRocket(World par1World) {
        super(par1World);
        this.func_70105_a(0.98f, 4.0f);
        this.field_70129_M = this.field_70131_O / 2.0f;
    }

    public EntityTieredRocket(World world, double posX, double posY, double posZ) {
        super(world, posX, posY, posZ);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        if (Loader.isModLoaded((String)"ICBM|Explosion")) {
            try {
                Class.forName("icbm.api.RadarRegistry").getMethod("register", Entity.class).invoke(null, this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (Loader.isModLoaded((String)"ICBM|Explosion")) {
            try {
                Class.forName("icbm.api.RadarRegistry").getMethod("unregister", Entity.class).invoke(null, this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void igniteCheckingCooldown() {
        if (!this.field_70170_p.field_72995_K && this.launchCooldown <= 0) {
            this.initiatePlanetsPreGen(this.field_70176_ah, this.field_70164_aj);
            this.ignite();
        }
    }

    private void initiatePlanetsPreGen(int cx, int cz) {
        this.preGenList.clear();
        if (this.destinationFrequency == -1) {
            ArrayList<Integer> toPreGen = new ArrayList<Integer>();
            for (Planet planet : GalaxyRegistry.getRegisteredPlanets().values()) {
                if (planet.getDimensionID() == this.field_71093_bK || !planet.getReachable() || planet.getTierRequirement() > this.getRocketTier()) continue;
                toPreGen.add(planet.getDimensionID());
            }
            if (toPreGen.size() > 0) {
                for (Integer dimID : toPreGen) {
                    this.preGenList.add(new BlockVec3(cx, dimID, cz));
                    if (!ConfigManagerCore.enableDebug) continue;
                    GCLog.info("Starting terrain pregen for dimension " + dimID + " at " + (cx * 16 + 8) + ", " + (cz * 16 + 8));
                }
                for (int r = 1; r < 12; ++r) {
                    int xmin = cx - r;
                    int xmax = cx + r;
                    int zmin = cz - r;
                    int zmax = cz + r;
                    for (int i = -r; i < r; ++i) {
                        for (Integer dimID : toPreGen) {
                            this.preGenList.add(new BlockVec3(xmin, dimID, cz + i));
                            this.preGenList.add(new BlockVec3(xmax, dimID, cz - i));
                            this.preGenList.add(new BlockVec3(cx - i, dimID, zmin));
                            this.preGenList.add(new BlockVec3(cx + i, dimID, zmax));
                        }
                    }
                }
                this.preGenIterator = this.preGenList.iterator();
            }
        } else {
            this.preGenIterator = null;
        }
    }

    @Override
    public void func_70071_h_() {
        if (this.getWaitForPlayer()) {
            if (this.field_70153_n != null) {
                if (this.ticks >= 40L) {
                    if (!this.field_70170_p.field_72995_K) {
                        Entity e = this.field_70153_n;
                        this.field_70153_n.field_70154_o = null;
                        this.field_70153_n = null;
                        e.func_70078_a((Entity)this);
                    }
                    this.setWaitForPlayer(false);
                    this.field_70181_x = -0.5;
                } else {
                    this.field_70179_y = 0.0;
                    this.field_70181_x = 0.0;
                    this.field_70159_w = 0.0;
                    this.field_70153_n.field_70179_y = 0.0;
                    this.field_70153_n.field_70181_x = 0.0;
                    this.field_70153_n.field_70159_w = 0.0;
                }
            } else {
                this.field_70179_y = 0.0;
                this.field_70181_x = 0.0;
                this.field_70159_w = 0.0;
            }
        }
        super.func_70071_h_();
        if (this.landing) {
            this.field_70177_z = 0.0f;
            this.field_70125_A = 0.0f;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.launchCooldown > 0) {
                --this.launchCooldown;
            }
            if (this.preGenIterator != null) {
                if (this.preGenIterator.hasNext()) {
                    BlockVec3 coords = this.preGenIterator.next();
                    WorldServer w = this.mcserver.func_71218_a(coords.y);
                    w.func_72964_e(coords.x, coords.z);
                    if (this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal() && this.preGenIterator.hasNext()) {
                        coords = this.preGenIterator.next();
                        w = this.mcserver.func_71218_a(coords.y);
                        w.func_72964_e(coords.x, coords.z);
                    }
                } else {
                    this.preGenIterator = null;
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && this.getLandingPad() != null && this.getLandingPad().getConnectedTiles() != null) {
            for (ILandingPadAttachable tile : this.getLandingPad().getConnectedTiles()) {
                if (this.field_70170_p.func_147438_o(((TileEntity)tile).field_145851_c, ((TileEntity)tile).field_145848_d, ((TileEntity)tile).field_145849_e) == null || !(this.field_70170_p.func_147438_o(((TileEntity)tile).field_145851_c, ((TileEntity)tile).field_145848_d, ((TileEntity)tile).field_145849_e) instanceof TileEntityFuelLoader) || !(tile instanceof TileEntityFuelLoader) || !(((TileEntityFuelLoader)tile).getEnergyStoredGC() > 0.0f) || this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) continue;
                this.setPad(null);
            }
        }
        if (this.rumble > 0.0f) {
            this.rumble -= 1.0f;
        } else if (this.rumble < 0.0f) {
            this.rumble += 1.0f;
        }
        if (this.field_70153_n != null) {
            this.field_70153_n.field_70165_t += (double)(this.rumble / (37.0f - 5.0f * (float)this.getRocketTier()));
            this.field_70153_n.field_70161_v += (double)(this.rumble / (37.0f - 5.0f * (float)this.getRocketTier()));
        }
        if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal() || this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
            this.func_70057_ab();
            this.rumble = (float)this.field_70146_Z.nextInt(3) - 3.0f;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.lastLastMotionY = this.lastMotionY;
            this.lastMotionY = this.field_70181_x;
        }
    }

    @Override
    public void decodePacketdata(ByteBuf buffer) {
        this.rocketType = IRocketType.EnumRocketType.values()[buffer.readInt()];
        super.decodePacketdata(buffer);
        if (buffer.readBoolean()) {
            this.field_70165_t = buffer.readDouble() / 8000.0;
            this.field_70163_u = buffer.readDouble() / 8000.0;
            this.field_70161_v = buffer.readDouble() / 8000.0;
        }
    }

    @Override
    public void getNetworkedData(ArrayList<Object> list) {
        list.add(this.rocketType != null ? this.rocketType.getIndex() : 0);
        super.getNetworkedData(list);
        boolean sendPosUpdates = this.ticks < 25L || this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal();
        list.add(sendPosUpdates);
        if (sendPosUpdates) {
            list.add(this.field_70165_t * 8000.0);
            list.add(this.field_70163_u * 8000.0);
            list.add(this.field_70161_v * 8000.0);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onReachAtmosphere() {
        if (this.destinationFrequency != -1) {
            if (this.field_70170_p.field_72995_K) {
                return;
            }
            this.setTarget(true, this.destinationFrequency);
            if (this.targetVec == null) {
                this.func_70106_y();
                return;
            }
            if (this.targetDimension != this.field_70170_p.field_73011_w.field_76574_g) {
                WorldServer worldServer;
                WorldProvider targetDim = WorldProvider.func_76570_a((int)this.targetDimension);
                if (targetDim != null && (this.targetDimension == 0 || targetDim instanceof IGalacticraftWorldProvider && ((IGalacticraftWorldProvider)targetDim).canSpaceshipTierPass(this.getRocketTier())) && (worldServer = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.targetDimension)) != null) {
                    if (this.field_70153_n != null) {
                        WorldUtil.transferEntityToDimension(this.field_70153_n, this.targetDimension, worldServer, false, this);
                    }
                    return;
                }
            } else {
                this.func_70107_b((float)this.targetVec.x + 0.5f, this.targetVec.y + 800, (float)this.targetVec.z + 0.5f);
                if (this.field_70153_n != null) {
                    this.setWaitForPlayer(true);
                }
                this.landing = true;
                return;
            }
        }
        if (this.field_70153_n != null && !this.field_70170_p.field_72995_K && this.field_70153_n instanceof GCEntityPlayerMP) {
            GCEntityPlayerMP player = (GCEntityPlayerMP)this.field_70153_n;
            HashMap<String, Integer> map = WorldUtil.getArrayOfPossibleDimensions(WorldUtil.getPossibleDimensionsForSpaceshipTier(this.getRocketTier()), player);
            String temp = "";
            int count = 0;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                temp = temp.concat(entry.getKey() + (count < map.entrySet().size() - 1 ? "?" : ""));
                ++count;
            }
            GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_DIMENSION_LIST, new Object[]{player.func_146103_bH().getName(), temp}), player);
            player.getPlayerStats().spaceshipTier = this.getRocketTier();
            player.getPlayerStats().usingPlanetSelectionGui = true;
            this.onTeleport(player);
            player.func_70078_a(this);
            if (!this.field_70128_L) {
                this.func_70106_y();
            }
        }
    }

    @Override
    protected boolean shouldCancelExplosion() {
        return this.hasValidFuel() && Math.abs(this.lastLastMotionY) < 4.0;
    }

    public void onTeleport(EntityPlayerMP player) {
    }

    @Override
    protected void onRocketLand(int x, int y, int z) {
        super.onRocketLand(x, y, z);
        this.launchCooldown = 40;
        this.func_70080_a((double)x + 0.5, (double)y + 1.8, (double)z + 0.5, this.field_70177_z, 0.0f);
    }

    @Override
    public void onLaunch() {
        super.onLaunch();
    }

    @Override
    protected boolean shouldMoveClientSide() {
        return true;
    }

    public boolean func_130002_c(EntityPlayer par1EntityPlayer) {
        if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
            return false;
        }
        if (this.field_70153_n != null && this.field_70153_n instanceof GCEntityPlayerMP) {
            if (!this.field_70170_p.field_72995_K) {
                GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_RESET_THIRD_PERSON, new Object[0]), (EntityPlayerMP)par1EntityPlayer);
                ((GCEntityPlayerMP)par1EntityPlayer).getPlayerStats().chatCooldown = 0;
                par1EntityPlayer.func_70078_a(null);
            }
            return true;
        }
        if (par1EntityPlayer instanceof GCEntityPlayerMP) {
            if (!this.field_70170_p.field_72995_K) {
                GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_DISPLAY_ROCKET_CONTROLS, new Object[0]), (GCEntityPlayerMP)par1EntityPlayer);
                ((GCEntityPlayerMP)par1EntityPlayer).getPlayerStats().chatCooldown = 0;
                par1EntityPlayer.func_70078_a((Entity)this);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("Type", this.rocketType.getIndex());
        super.func_70014_b(nbt);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        this.rocketType = IRocketType.EnumRocketType.values()[nbt.func_74762_e("Type")];
        super.func_70037_a(nbt);
    }

    @Override
    public IRocketType.EnumRocketType getType() {
        return this.rocketType;
    }

    public int func_70302_i_() {
        return this.rocketType.getInventorySpace();
    }

    @Override
    public void onWorldTransferred(World world) {
        if (this.targetVec != null) {
            this.func_70107_b((float)this.targetVec.x + 0.5f, this.targetVec.y + 800, (float)this.targetVec.z + 0.5f);
            this.landing = true;
            this.setWaitForPlayer(true);
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
        } else {
            this.func_70106_y();
        }
    }

    public void func_70043_V() {
        if (this.field_70153_n != null) {
            this.field_70153_n.func_70107_b(this.field_70165_t, this.field_70163_u + this.func_70042_X() + this.field_70153_n.func_70033_W(), this.field_70161_v);
        }
    }

    @Override
    public boolean isPlayerRocket() {
        return true;
    }
}

