/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import micdoodle8.mods.galacticraft.api.block.IPartialSealableBlock;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkConnection;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.items.ItemBlockDesc;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAluminumWire;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenPipe;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockEnclosed
extends BlockContainer
implements IPartialSealableBlock,
ITileEntityProvider,
ItemBlockDesc.IBlockShiftDesc {
    private IIcon[] enclosedIcons;

    public static EnumEnclosedBlock getTypeFromMeta(int metadata) {
        for (EnumEnclosedBlock type : EnumEnclosedBlock.values()) {
            if (type.getMetadata() != metadata) continue;
            return type;
        }
        return null;
    }

    public BlockEnclosed(String assetName) {
        super(Material.field_151571_B);
        this.func_149752_b(0.2f);
        this.func_149711_c(0.4f);
        this.func_149672_a(Block.field_149769_e);
        this.func_149658_d(GalacticraftCore.TEXTURE_PREFIX + assetName);
        this.func_149663_c(assetName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.ALUMINUM_WIRE.getMetadata()));
        par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.ALUMINUM_WIRE_HEAVY.getMetadata()));
        par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.OXYGEN_PIPE.getMetadata()));
        if (CompatibilityManager.isTELoaded()) {
            // empty if block
        }
        if (CompatibilityManager.isIc2Loaded()) {
            par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.IC2_COPPER_CABLE.getMetadata()));
            par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.IC2_GOLD_CABLE.getMetadata()));
            par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.IC2_HV_CABLE.getMetadata()));
            par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.IC2_GLASS_FIBRE_CABLE.getMetadata()));
            par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.IC2_LV_CABLE.getMetadata()));
        }
        if (CompatibilityManager.isBCraftLoaded()) {
            par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.BC_ITEM_COBBLESTONEPIPE.getMetadata()));
            par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.BC_ITEM_STONEPIPE.getMetadata()));
            par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.BC_FLUIDS_COBBLESTONEPIPE.getMetadata()));
            par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.BC_FLUIDS_STONEPIPE.getMetadata()));
            par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.BC_POWER_STONEPIPE.getMetadata()));
            par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.BC_POWER_GOLDPIPE.getMetadata()));
        }
        if (CompatibilityManager.isAppEngLoaded()) {
            par3List.add(new ItemStack(par1, 1, EnumEnclosedBlock.ME_CABLE.getMetadata()));
        }
    }

    public CreativeTabs func_149708_J() {
        return GalacticraftCore.galacticraftBlocksTab;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        return par2 >= this.enclosedIcons.length ? this.field_149761_L : this.enclosedIcons[par2];
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.enclosedIcons = new IIcon[16];
        for (int i = 0; i < EnumEnclosedBlock.values().length; ++i) {
            this.enclosedIcons[EnumEnclosedBlock.values()[i].getMetadata()] = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + EnumEnclosedBlock.values()[i].getTexture());
        }
        this.field_149761_L = par1IconRegister.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "" + EnumEnclosedBlock.OXYGEN_PIPE.getTexture());
    }

    public void func_149726_b(World world, int x, int y, int z) {
        block16: {
            super.func_149726_b(world, x, y, z);
            int metadata = world.func_72805_g(x, y, z);
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (metadata != EnumEnclosedBlock.TE_CONDUIT.getMetadata()) {
                if (metadata > 0 && metadata <= EnumEnclosedBlock.OXYGEN_PIPE.getMetadata()) {
                    if (tileEntity instanceof INetworkConnection) {
                        ((INetworkConnection)tileEntity).refresh();
                    }
                } else if (metadata <= EnumEnclosedBlock.IC2_LV_CABLE.getMetadata()) {
                    if (CompatibilityManager.isIc2Loaded()) {
                        try {
                            Class<?> clazz = Class.forName("ic2.core.block.wiring.TileEntityCable");
                            if (clazz == null || !clazz.isInstance(tileEntity)) break block16;
                            try {
                                Method method = clazz.getMethod("onNeighborBlockChange", new Class[0]);
                                method.invoke((Object)tileEntity, new Object[0]);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else if (metadata > EnumEnclosedBlock.BC_POWER_GOLDPIPE.getMetadata() && metadata > EnumEnclosedBlock.ME_CABLE.getMetadata()) {
                    if (metadata <= EnumEnclosedBlock.ALUMINUM_WIRE.getMetadata()) {
                        if (tileEntity instanceof IConductor) {
                            ((IConductor)tileEntity).refresh();
                        }
                    } else if (metadata <= EnumEnclosedBlock.ALUMINUM_WIRE_HEAVY.getMetadata() && tileEntity instanceof IConductor) {
                        ((IConductor)tileEntity).refresh();
                    }
                }
            }
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        block24: {
            super.func_149695_a(world, x, y, z, block);
            int metadata = world.func_72805_g(x, y, z);
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (metadata != EnumEnclosedBlock.TE_CONDUIT.getMetadata()) {
                if (metadata > 0 && metadata <= EnumEnclosedBlock.OXYGEN_PIPE.getMetadata()) {
                    if (tileEntity instanceof INetworkConnection) {
                        ((INetworkConnection)tileEntity).refresh();
                    }
                } else if (metadata <= EnumEnclosedBlock.IC2_LV_CABLE.getMetadata()) {
                    if (CompatibilityManager.isIc2Loaded()) {
                        try {
                            Class<?> clazz = Class.forName("ic2.core.block.wiring.TileEntityCable");
                            if (clazz == null || !clazz.isInstance(tileEntity)) break block24;
                            try {
                                Method method = clazz.getMethod("onNeighborBlockChange", new Class[0]);
                                method.invoke((Object)tileEntity, new Object[0]);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else if (metadata <= EnumEnclosedBlock.BC_POWER_GOLDPIPE.getMetadata()) {
                    if (CompatibilityManager.isBCraftLoaded()) {
                        try {
                            Class<?> clazzPipe = Class.forName("buildcraft.transport.Pipe");
                            Class<?> clazzPipeTile = Class.forName("buildcraft.transport.TileGenericPipe");
                            Class<?> clazzPipeBlock = Class.forName("buildcraft.transport.BlockGenericPipe");
                            Object pipe = CompatibilityManager.methodBCBlockPipe_getPipe.invoke(null, world, x, y, z);
                            Method isValid = clazzPipeBlock.getMethod("isValid", clazzPipe);
                            Boolean valid = (Boolean)isValid.invoke(null, pipe);
                            if (valid.booleanValue()) {
                                Method schedule = clazzPipeTile.getMethod("scheduleNeighborChange", new Class[0]);
                                Object container = clazzPipe.getField("container").get(pipe);
                                schedule.invoke(container, new Object[0]);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else if (metadata <= EnumEnclosedBlock.ME_CABLE.getMetadata()) {
                    if (CompatibilityManager.isAppEngLoaded()) {
                        world.func_147471_g(x, y, z);
                    }
                } else if (metadata <= EnumEnclosedBlock.ALUMINUM_WIRE.getMetadata()) {
                    if (tileEntity instanceof IConductor) {
                        ((IConductor)tileEntity).refresh();
                    }
                } else if (metadata <= EnumEnclosedBlock.ALUMINUM_WIRE_HEAVY.getMetadata() && tileEntity instanceof IConductor) {
                    ((IConductor)tileEntity).refresh();
                }
            }
        }
    }

    public TileEntity func_149915_a(World world, int metadata) {
        if (metadata != EnumEnclosedBlock.TE_CONDUIT.getMetadata()) {
            if (metadata > 0 && metadata <= EnumEnclosedBlock.OXYGEN_PIPE.getMetadata()) {
                return new TileEntityOxygenPipe();
            }
            if (metadata <= EnumEnclosedBlock.IC2_LV_CABLE.getMetadata()) {
                if (CompatibilityManager.isIc2Loaded()) {
                    try {
                        Constructor<?> constructor2;
                        Class<?> clazz = Class.forName("ic2.core.block.wiring.TileEntityCable");
                        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
                        Constructor<?> constructor = null;
                        Constructor<?>[] arr$ = constructors;
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$ && (constructor = (constructor2 = arr$[i$])).getGenericParameterTypes().length != 1; ++i$) {
                        }
                        constructor.setAccessible(true);
                        return (TileEntity)constructor.newInstance((short)BlockEnclosed.getTypeFromMeta(metadata).getSubMetaValue());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if (metadata <= EnumEnclosedBlock.BC_POWER_GOLDPIPE.getMetadata()) {
                if (CompatibilityManager.isBCraftLoaded()) {
                    try {
                        Constructor<?> constructor2;
                        Class<?> clazzTilePipe = Class.forName("buildcraft.transport.TileGenericPipe");
                        Constructor<?>[] constructors = clazzTilePipe.getDeclaredConstructors();
                        Constructor<?> constructor = null;
                        Constructor<?>[] arr$ = constructors;
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$ && (constructor = (constructor2 = arr$[i$])).getGenericParameterTypes().length != 0; ++i$) {
                        }
                        constructor.setAccessible(true);
                        TileEntity tilePipe = (TileEntity)constructor.newInstance(new Object[0]);
                        return tilePipe;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if (metadata <= EnumEnclosedBlock.ME_CABLE.getMetadata()) {
                if (CompatibilityManager.isAppEngLoaded()) {
                    try {
                        Class<?> clazz = Class.forName("appeng.me.tile.TileCable");
                        return (TileEntity)clazz.newInstance();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                if (metadata <= EnumEnclosedBlock.ALUMINUM_WIRE.getMetadata()) {
                    return new TileEntityAluminumWire(1);
                }
                if (metadata <= EnumEnclosedBlock.ALUMINUM_WIRE_HEAVY.getMetadata()) {
                    return new TileEntityAluminumWire(2);
                }
            }
        }
        return null;
    }

    @Override
    public boolean isSealed(World world, int x, int y, int z, ForgeDirection direction) {
        return true;
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate(this.func_149739_a() + ".description");
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    public static enum EnumEnclosedBlock {
        TE_CONDUIT(0, 2, null, "enclosed_te_conduit"),
        OXYGEN_PIPE(1, -1, null, "enclosed_oxygen_pipe"),
        IC2_COPPER_CABLE(2, 0, null, "enclosed_copper_cable"),
        IC2_GOLD_CABLE(3, 3, null, "enclosed_gold_cable"),
        IC2_HV_CABLE(4, 6, null, "enclosed_hv_cable"),
        IC2_GLASS_FIBRE_CABLE(5, 9, null, "enclosed_glassfibre_cable"),
        IC2_LV_CABLE(6, 10, null, "enclosed_lv_cable"),
        BC_ITEM_STONEPIPE(7, -1, "PipeItemsStone", "enclosed_itempipe_stone"),
        BC_ITEM_COBBLESTONEPIPE(8, -1, "PipeItemsCobblestone", "enclosed_itempipe_cobblestone"),
        BC_FLUIDS_STONEPIPE(9, -1, "PipeFluidsStone", "enclosed_liquidpipe_stone"),
        BC_FLUIDS_COBBLESTONEPIPE(10, -1, "PipeFluidsCobblestone", "enclosed_liquidpipe_cobblestone"),
        BC_POWER_STONEPIPE(11, -1, "PipePowerStone", "enclosed_powerpipe_stone"),
        BC_POWER_GOLDPIPE(12, -1, "PipePowerGold", "enclosed_powerpipe_gold"),
        ME_CABLE(13, -1, null, "enclosed_me_cable"),
        ALUMINUM_WIRE(14, -1, null, "enclosed_aluminum_wire"),
        ALUMINUM_WIRE_HEAVY(15, -1, null, "enclosed_heavy_aluminum_wire");

        int metadata;
        int subMeta;
        String pipeClass;
        String texture;

        private EnumEnclosedBlock(int metadata, int subMeta, String pipeClass, String texture) {
            this.metadata = metadata;
            this.subMeta = subMeta;
            this.pipeClass = pipeClass;
            this.texture = texture;
        }

        public int getMetadata() {
            return this.metadata;
        }

        public int getSubMetaValue() {
            return this.subMeta;
        }

        public String getPipeClass() {
            return this.pipeClass;
        }

        public String getTexture() {
            return this.texture;
        }
    }
}

