/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.energy;

import buildcraft.api.mj.MjAPI;
import buildcraft.api.power.IPowerReceptor;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergyTile;
import mekanism.api.energy.ICableOutputter;
import mekanism.api.energy.IStrictEnergyAcceptor;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyUtil {
    public static TileEntity[] getAdjacentPowerConnections(TileEntity tile) {
        TileEntity[] adjacentConnections = new TileEntity[6];
        boolean isMekLoaded = EnergyConfigHandler.isMekanismLoaded();
        boolean isIC2Loaded = EnergyConfigHandler.isIndustrialCraft2Loaded();
        boolean isBCLoaded = EnergyConfigHandler.isBuildcraftLoaded();
        boolean isBCReallyLoaded = EnergyConfigHandler.isBuildcraftReallyLoaded();
        BlockVec3 thisVec = new BlockVec3(tile);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tileEntity = thisVec.getTileEntityOnSide(tile.func_145831_w(), direction);
            if (tileEntity instanceof IConnector) {
                if (!((IConnector)tileEntity).canConnect(direction.getOpposite(), NetworkType.POWER)) continue;
                adjacentConnections[direction.ordinal()] = tileEntity;
                continue;
            }
            if (isMekLoaded && (tileEntity instanceof IStrictEnergyAcceptor || tileEntity instanceof ICableOutputter)) {
                try {
                    if (Class.forName("codechicken.multipart.TileMultipart").isInstance(tileEntity)) {
                        continue;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (tileEntity instanceof IStrictEnergyAcceptor && ((IStrictEnergyAcceptor)tileEntity).canReceiveEnergy(direction.getOpposite())) {
                    adjacentConnections[direction.ordinal()] = tileEntity;
                    continue;
                }
                if (!(tileEntity instanceof ICableOutputter) || !((ICableOutputter)tileEntity).canOutputTo(direction.getOpposite())) continue;
                adjacentConnections[direction.ordinal()] = tileEntity;
                continue;
            }
            if (isIC2Loaded && tileEntity instanceof IEnergyTile) {
                if (tileEntity instanceof IEnergyConductor) continue;
                if (tileEntity instanceof IEnergyAcceptor && ((IEnergyAcceptor)tileEntity).acceptsEnergyFrom(tile, direction.getOpposite())) {
                    adjacentConnections[direction.ordinal()] = tileEntity;
                    continue;
                }
                if (!(tileEntity instanceof IEnergyEmitter) || !((IEnergyEmitter)tileEntity).emitsEnergyTo(tile, direction.getOpposite())) continue;
                adjacentConnections[direction.ordinal()] = tileEntity;
                continue;
            }
            if (!isBCLoaded) continue;
            if (isBCReallyLoaded) {
                try {
                    Object pipe;
                    Class<?> clazzPipeWood;
                    Class<?> clazzPipeTile = Class.forName("buildcraft.transport.TileGenericPipe");
                    if (clazzPipeTile.isInstance(tileEntity) && (clazzPipeWood = Class.forName("buildcraft.transport.pipes.PipePowerWood")).isInstance(pipe = clazzPipeTile.getField("pipe").get(tileEntity))) {
                        continue;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (EnergyConfigHandler.getBuildcraftVersion() == 6 && MjAPI.getMjBattery((Object)tileEntity, (String)"buildcraft.kinesis", (ForgeDirection)direction.getOpposite()) != null) {
                adjacentConnections[direction.ordinal()] = tileEntity;
            }
            if (!(tileEntity instanceof IPowerReceptor) || ((IPowerReceptor)tileEntity).getPowerReceiver(direction.getOpposite()) == null) continue;
            adjacentConnections[direction.ordinal()] = tileEntity;
        }
        return adjacentConnections;
    }
}

