/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.energy.grid;

import buildcraft.api.mj.MjAPI;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import cpw.mods.fml.common.FMLLog;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySink;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.energy.IStrictEnergyAcceptor;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.grid.IElectricityNetwork;
import micdoodle8.mods.galacticraft.api.transmission.grid.PathfinderChecker;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import micdoodle8.mods.galacticraft.api.transmission.tile.IElectrical;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkConnection;
import micdoodle8.mods.galacticraft.api.transmission.tile.INetworkProvider;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalConductor;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EnergyNetwork
implements IElectricityNetwork {
    public static int tickCount = 0;
    private int tickDone = -1;
    private float totalRequested = 0.0f;
    private float totalStorageExcess = 0.0f;
    private float totalEnergy = 0.0f;
    private float totalSent = 0.0f;
    private boolean doneScheduled = false;
    private boolean spamstop = false;
    private boolean loopPrevention = false;
    public int networkTierGC = 1;
    private int producersTierGC = 1;
    private List<TileEntity> connectedAcceptors = new LinkedList<TileEntity>();
    private List<ForgeDirection> connectedDirections = new LinkedList<ForgeDirection>();
    private Set<TileEntity> availableAcceptors = new HashSet<TileEntity>();
    private Map<TileEntity, ForgeDirection> availableconnectedDirections = new HashMap<TileEntity, ForgeDirection>();
    private Map<TileEntity, Float> energyRequests = new HashMap<TileEntity, Float>();
    private List<TileEntity> ignoreAcceptors = new LinkedList<TileEntity>();
    private final Set<IConductor> conductors = new HashSet<IConductor>();
    private static final float ENERGY_STORAGE_LEVEL = 200.0f;
    private Method demandedEnergyIC2 = null;
    private Method injectEnergyIC2 = null;
    private boolean initialisedIC2Methods = false;
    private boolean voltageParameterIC2 = false;

    @Override
    public Set<IConductor> getTransmitters() {
        return this.conductors;
    }

    @Override
    public float getRequest(TileEntity ... ignoreTiles) {
        if (tickCount != this.tickDone) {
            this.tickDone = tickCount;
            this.ignoreAcceptors.clear();
            this.ignoreAcceptors.addAll(Arrays.asList(ignoreTiles));
            this.doTickStartCalc();
            if (EnergyConfigHandler.isBuildcraftLoaded()) {
                for (IConductor wire : this.getTransmitters()) {
                    if (!(wire instanceof TileBaseUniversalConductor)) continue;
                    ((TileBaseUniversalConductor)wire).reconfigureBC();
                }
            }
        }
        return this.totalRequested - this.totalEnergy - this.totalSent;
    }

    @Override
    public float produce(float energy, boolean doReceive, int producerTier, TileEntity ... ignoreTiles) {
        if (this.loopPrevention) {
            return energy;
        }
        if (energy > 0.0f) {
            if (tickCount != this.tickDone) {
                this.tickDone = tickCount;
                this.ignoreAcceptors.clear();
                this.ignoreAcceptors.addAll(Arrays.asList(ignoreTiles));
                this.producersTierGC = 1;
                this.doTickStartCalc();
            } else {
                this.ignoreAcceptors.addAll(Arrays.asList(ignoreTiles));
            }
            if (!this.doneScheduled && this.totalRequested > 0.0f) {
                try {
                    Class<?> clazz = Class.forName("micdoodle8.mods.galacticraft.core.tick.TickHandlerServer");
                    clazz.getMethod("scheduleNetworkTick", this.getClass()).invoke(null, this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.doneScheduled = true;
            }
            float totalEnergyLast = this.totalEnergy;
            if (doReceive) {
                this.totalEnergy += Math.min(energy, this.totalRequested - totalEnergyLast);
                if (producerTier > 1) {
                    this.producersTierGC = 2;
                }
            }
            if (this.totalRequested >= totalEnergyLast + energy) {
                return 0.0f;
            }
            if (totalEnergyLast >= this.totalRequested) {
                return energy;
            }
            return totalEnergyLast + energy - this.totalRequested;
        }
        return energy;
    }

    public void tickEnd() {
        this.doneScheduled = false;
        this.loopPrevention = true;
        if (this.totalEnergy > 0.0f) {
            this.doTickStartCalc();
            if (this.totalRequested > 0.0f) {
                this.totalSent = this.doProduce();
                this.totalEnergy = this.totalSent < this.totalEnergy ? (this.totalEnergy -= this.totalSent) : 0.0f;
            }
        } else {
            this.totalEnergy = 0.0f;
        }
        this.loopPrevention = false;
    }

    private void doTickStartCalc() {
        this.totalSent = 0.0f;
        this.refreshAcceptors();
        if (!this.initialisedIC2Methods) {
            this.initialiseIC2Methods();
        }
        if (this.getTransmitters().size() == 0) {
            return;
        }
        this.loopPrevention = true;
        this.availableAcceptors.clear();
        this.availableconnectedDirections.clear();
        this.energyRequests.clear();
        this.totalRequested = 0.0f;
        this.totalStorageExcess = 0.0f;
        boolean isIC2Loaded = EnergyConfigHandler.isIndustrialCraft2Loaded();
        boolean isBCLoaded = EnergyConfigHandler.isBuildcraftLoaded();
        boolean isMekLoaded = EnergyConfigHandler.isMekanismLoaded();
        if (!this.connectedAcceptors.isEmpty()) {
            Iterator<ForgeDirection> acceptorDirection = this.connectedDirections.iterator();
            for (TileEntity acceptor : this.connectedAcceptors) {
                PowerHandler.PowerReceiver BCreceiver;
                ForgeDirection sideFrom = acceptorDirection.next();
                if (this.ignoreAcceptors.contains(acceptor) || this.availableAcceptors.contains(acceptor)) continue;
                float e = 0.0f;
                if (acceptor instanceof IElectrical) {
                    e = ((IElectrical)acceptor).getRequest(sideFrom);
                } else if (isMekLoaded && acceptor instanceof IStrictEnergyAcceptor) {
                    e = (float)((((IStrictEnergyAcceptor)acceptor).getMaxEnergy() - ((IStrictEnergyAcceptor)acceptor).getEnergy()) * (double)EnergyConfigHandler.MEKANISM_RATIO);
                } else if (isIC2Loaded && acceptor instanceof IEnergySink) {
                    double result;
                    block15: {
                        result = 0.0;
                        try {
                            result = (Double)this.demandedEnergyIC2.invoke((Object)acceptor, new Object[0]);
                        }
                        catch (Exception ex) {
                            if (!ConfigManagerCore.enableDebug) break block15;
                            ex.printStackTrace();
                        }
                    }
                    result = Math.max(result, this.networkTierGC == 2 ? 256.0 : 128.0);
                    e = (float)result * EnergyConfigHandler.IC2_RATIO;
                } else if (isBCLoaded && EnergyConfigHandler.getBuildcraftVersion() == 6 && MjAPI.getMjBattery((Object)acceptor, (String)"buildcraft.kinesis", (ForgeDirection)sideFrom) != null) {
                    e = (float)MjAPI.getMjBattery((Object)acceptor, (String)"buildcraft.kinesis", (ForgeDirection)sideFrom).getEnergyRequested() * EnergyConfigHandler.BC3_RATIO;
                } else if (isBCLoaded && acceptor instanceof IPowerReceptor && (BCreceiver = ((IPowerReceptor)acceptor).getPowerReceiver(sideFrom)) != null) {
                    e = (float)BCreceiver.powerRequest() * EnergyConfigHandler.BC3_RATIO;
                }
                if (!(e > 0.0f)) continue;
                this.availableAcceptors.add(acceptor);
                this.availableconnectedDirections.put(acceptor, sideFrom);
                this.energyRequests.put(acceptor, Float.valueOf(e));
                this.totalRequested += e;
                if (!(e > 200.0f)) continue;
                this.totalStorageExcess += e - 200.0f;
            }
        }
        this.loopPrevention = false;
    }

    private float doProduce() {
        float returnvalue;
        float sent = 0.0f;
        if (!this.availableAcceptors.isEmpty()) {
            boolean isIC2Loaded = EnergyConfigHandler.isIndustrialCraft2Loaded();
            boolean isBCLoaded = EnergyConfigHandler.isBuildcraftLoaded();
            boolean isMekLoaded = EnergyConfigHandler.isMekanismLoaded();
            float energyNeeded = this.totalRequested;
            float energyAvailable = this.totalEnergy;
            float reducor = 1.0f;
            float energyStorageReducor = 1.0f;
            if (energyNeeded > energyAvailable) {
                if ((energyNeeded -= this.totalStorageExcess) > energyAvailable) {
                    energyStorageReducor = 0.0f;
                    reducor = energyAvailable / energyNeeded;
                } else {
                    energyStorageReducor = (energyAvailable - energyNeeded) / this.totalStorageExcess;
                }
            }
            int tierProduced = Math.min(this.producersTierGC, this.networkTierGC);
            for (TileEntity tileEntity : this.availableAcceptors) {
                float sentToAcceptor;
                if (sent >= energyAvailable) break;
                float currentSending = this.energyRequests.get(tileEntity).floatValue();
                if (currentSending > 200.0f) {
                    currentSending = 200.0f + (currentSending - 200.0f) * energyStorageReducor;
                }
                if ((currentSending *= reducor) > energyAvailable - sent) {
                    currentSending = energyAvailable - sent;
                }
                ForgeDirection sideFrom = this.availableconnectedDirections.get(tileEntity);
                if (tileEntity instanceof IElectrical) {
                    sentToAcceptor = ((IElectrical)tileEntity).receiveElectricity(sideFrom, currentSending, tierProduced, true);
                } else if (isMekLoaded && tileEntity instanceof IStrictEnergyAcceptor) {
                    sentToAcceptor = (float)((IStrictEnergyAcceptor)tileEntity).transferEnergyToAcceptor(sideFrom, (double)(currentSending * EnergyConfigHandler.TO_MEKANISM_RATIO)) * EnergyConfigHandler.MEKANISM_RATIO;
                } else if (isIC2Loaded && tileEntity instanceof IEnergySink) {
                    double energySendingIC2 = currentSending * EnergyConfigHandler.TO_IC2_RATIO;
                    if (energySendingIC2 >= 1.0) {
                        double result;
                        block29: {
                            result = 0.0;
                            try {
                                result = this.voltageParameterIC2 ? ((Double)this.injectEnergyIC2.invoke((Object)tileEntity, sideFrom, energySendingIC2, 120.0)).doubleValue() : ((Double)this.injectEnergyIC2.invoke((Object)tileEntity, sideFrom, energySendingIC2)).doubleValue();
                            }
                            catch (Exception ex) {
                                if (!ConfigManagerCore.enableDebug) break block29;
                                ex.printStackTrace();
                            }
                        }
                        sentToAcceptor = currentSending - (float)result * EnergyConfigHandler.IC2_RATIO;
                        if (sentToAcceptor < 0.0f) {
                            sentToAcceptor = 0.0f;
                        }
                    } else {
                        sentToAcceptor = 0.0f;
                    }
                } else if (isBCLoaded && EnergyConfigHandler.getBuildcraftVersion() == 6 && MjAPI.getMjBattery((Object)tileEntity, (String)"buildcraft.kinesis", (ForgeDirection)sideFrom) != null) {
                    sentToAcceptor = (float)MjAPI.getMjBattery((Object)tileEntity, (String)"buildcraft.kinesis", (ForgeDirection)sideFrom).addEnergy((double)(currentSending * EnergyConfigHandler.TO_BC_RATIO)) * EnergyConfigHandler.BC3_RATIO;
                } else if (isBCLoaded && tileEntity instanceof IPowerReceptor) {
                    PowerHandler.PowerReceiver receiver = ((IPowerReceptor)tileEntity).getPowerReceiver(sideFrom);
                    if (receiver != null) {
                        double toSendBC = Math.min((double)(currentSending * EnergyConfigHandler.TO_BC_RATIO), receiver.powerRequest());
                        sentToAcceptor = (float)receiver.receiveEnergy(PowerHandler.Type.PIPE, toSendBC, sideFrom) * EnergyConfigHandler.BC3_RATIO;
                    } else {
                        sentToAcceptor = 0.0f;
                    }
                } else {
                    sentToAcceptor = 0.0f;
                }
                if (sentToAcceptor / currentSending > 1.002f && sentToAcceptor > 0.01f) {
                    if (!this.spamstop) {
                        FMLLog.info((String)("Energy network: acceptor took too much energy, offered " + currentSending + ", took " + sentToAcceptor + ". " + tileEntity.toString()), (Object[])new Object[0]);
                        this.spamstop = true;
                    }
                    sentToAcceptor = currentSending;
                }
                sent += sentToAcceptor;
            }
        }
        if (tickCount % 200 == 0) {
            this.spamstop = false;
        }
        if ((returnvalue = sent) > this.totalEnergy) {
            returnvalue = this.totalEnergy;
        }
        if (returnvalue < 0.0f) {
            returnvalue = 0.0f;
        }
        return returnvalue;
    }

    @Override
    public void refresh() {
        int tierfound = 2;
        Iterator<IConductor> it = this.getTransmitters().iterator();
        while (it.hasNext()) {
            IConductor conductor = it.next();
            if (conductor == null) {
                it.remove();
                continue;
            }
            TileEntity tile = (TileEntity)conductor;
            World world = tile.func_145831_w();
            if (tile.func_145837_r() || world == null || !world.func_72899_e(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e)) {
                it.remove();
                continue;
            }
            if (conductor != world.func_147438_o(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e)) {
                it.remove();
                continue;
            }
            if (conductor.getTierGC() < 2) {
                tierfound = 1;
            }
            if (conductor.getNetwork() == this) continue;
            conductor.setNetwork(this);
            conductor.onNetworkChanged();
        }
        this.networkTierGC = tierfound;
    }

    private void refreshAcceptors() {
        this.connectedAcceptors.clear();
        this.connectedDirections.clear();
        this.refresh();
        try {
            boolean isIC2Loaded = EnergyConfigHandler.isIndustrialCraft2Loaded();
            boolean isBCLoaded = EnergyConfigHandler.isBuildcraftLoaded();
            boolean isMekLoaded = EnergyConfigHandler.isMekanismLoaded();
            LinkedList<IConductor> conductors = new LinkedList<IConductor>();
            conductors.addAll(this.getTransmitters());
            for (IConductor conductor : conductors) {
                TileEntity[] adjacentConnections = conductor.getAdjacentConnections();
                for (int i = 0; i < adjacentConnections.length; ++i) {
                    TileEntity acceptor = adjacentConnections[i];
                    if (acceptor == null || acceptor instanceof IConductor || acceptor.func_145837_r()) continue;
                    ForgeDirection sideFrom = ForgeDirection.getOrientation((int)i).getOpposite();
                    if (acceptor instanceof IElectrical) {
                        if (!((IElectrical)acceptor).canConnect(sideFrom, NetworkType.POWER)) continue;
                        this.connectedAcceptors.add(acceptor);
                        this.connectedDirections.add(sideFrom);
                        continue;
                    }
                    if (isMekLoaded && acceptor instanceof IStrictEnergyAcceptor) {
                        if (!((IStrictEnergyAcceptor)acceptor).canReceiveEnergy(sideFrom)) continue;
                        this.connectedAcceptors.add(acceptor);
                        this.connectedDirections.add(sideFrom);
                        continue;
                    }
                    if (isIC2Loaded && acceptor instanceof IEnergyAcceptor) {
                        if (!((IEnergyAcceptor)acceptor).acceptsEnergyFrom((TileEntity)conductor, sideFrom)) continue;
                        this.connectedAcceptors.add(acceptor);
                        this.connectedDirections.add(sideFrom);
                        continue;
                    }
                    if (isBCLoaded && EnergyConfigHandler.getBuildcraftVersion() == 6 && MjAPI.getMjBattery((Object)acceptor, (String)"buildcraft.kinesis", (ForgeDirection)sideFrom) != null) {
                        this.connectedAcceptors.add(acceptor);
                        this.connectedDirections.add(sideFrom);
                        continue;
                    }
                    if (!isBCLoaded || !(acceptor instanceof IPowerReceptor) || ((IPowerReceptor)acceptor).getPowerReceiver(sideFrom) == null) continue;
                    this.connectedAcceptors.add(acceptor);
                    this.connectedDirections.add(sideFrom);
                }
            }
        }
        catch (Exception e) {
            FMLLog.severe((String)"Energy Network: Error when trying to refresh list of power acceptors.", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    @Override
    public IElectricityNetwork merge(IElectricityNetwork network) {
        if (network != null && network != this) {
            Set<IConductor> thisNetwork = this.getTransmitters();
            Set thatNetwork = network.getTransmitters();
            if (thisNetwork.size() >= thatNetwork.size()) {
                thisNetwork.addAll(thatNetwork);
                this.refresh();
                if (network instanceof EnergyNetwork) {
                    ((EnergyNetwork)network).destroy();
                }
                return this;
            }
            thatNetwork.addAll(thisNetwork);
            network.refresh();
            this.destroy();
            return network;
        }
        return this;
    }

    private void destroy() {
        this.getTransmitters().clear();
        this.connectedAcceptors.clear();
        this.availableAcceptors.clear();
        this.totalEnergy = 0.0f;
        this.totalRequested = 0.0f;
        try {
            Class<?> clazz = Class.forName("micdoodle8.mods.galacticraft.core.tick.TickHandlerServer");
            clazz.getMethod("removeNetworkTick", this.getClass()).invoke(null, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void split(IConductor splitPoint) {
        if (splitPoint instanceof TileEntity) {
            TileEntity[] connectedBlocks;
            this.getTransmitters().remove(splitPoint);
            for (TileEntity connectedBlockA : connectedBlocks = splitPoint.getAdjacentConnections()) {
                if (!(connectedBlockA instanceof INetworkConnection)) continue;
                for (TileEntity connectedBlockB : connectedBlocks) {
                    if (connectedBlockA == connectedBlockB || !(connectedBlockB instanceof INetworkConnection)) continue;
                    PathfinderChecker finder = new PathfinderChecker(((TileEntity)splitPoint).func_145831_w(), (INetworkConnection)connectedBlockB, NetworkType.POWER, splitPoint);
                    finder.init(new BlockVec3(connectedBlockA));
                    if (finder.results.size() > 0) {
                        for (BlockVec3 node : finder.closedSet) {
                            TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).func_145831_w());
                            if (!(nodeTile instanceof INetworkProvider) || nodeTile == splitPoint) continue;
                            ((INetworkProvider)nodeTile).setNetwork(this);
                        }
                        continue;
                    }
                    EnergyNetwork newNetwork = new EnergyNetwork();
                    for (BlockVec3 node : finder.closedSet) {
                        TileEntity nodeTile = node.getTileEntity((IBlockAccess)((TileEntity)splitPoint).func_145831_w());
                        if (!(nodeTile instanceof INetworkProvider) || nodeTile == splitPoint) continue;
                        newNetwork.getTransmitters().add((IConductor)nodeTile);
                    }
                    newNetwork.refresh();
                }
            }
        }
    }

    public String toString() {
        return "EnergyNetwork[" + this.hashCode() + "|Wires:" + this.getTransmitters().size() + "|Acceptors:" + this.connectedAcceptors.size() + "]";
    }

    private void initialiseIC2Methods() {
        if (EnergyConfigHandler.isIndustrialCraft2Loaded()) {
            if (ConfigManagerCore.enableDebug) {
                GCLog.info("Debug UN: Initialising IC2 methods");
            }
            try {
                Class<?> clazz = Class.forName("ic2.api.energy.tile.IEnergySink");
                if (ConfigManagerCore.enableDebug) {
                    GCLog.info("Debug UN: Found IC2 IEnergySink class");
                }
                try {
                    this.demandedEnergyIC2 = clazz.getMethod("demandedEnergyUnits", new Class[0]);
                }
                catch (Exception e) {
                    try {
                        this.demandedEnergyIC2 = clazz.getMethod("getDemandedEnergy", new Class[0]);
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
                if (ConfigManagerCore.enableDebug) {
                    GCLog.info("Debug UN: Set IC2 demandedEnergy method");
                }
                try {
                    this.injectEnergyIC2 = clazz.getMethod("injectEnergyUnits", ForgeDirection.class, Double.TYPE);
                    if (ConfigManagerCore.enableDebug) {
                        GCLog.info("Debug UN: IC2 inject 1.7.2 succeeded");
                    }
                }
                catch (Exception e) {
                    try {
                        this.injectEnergyIC2 = clazz.getMethod("injectEnergy", ForgeDirection.class, Double.TYPE, Double.TYPE);
                        this.voltageParameterIC2 = true;
                        if (ConfigManagerCore.enableDebug) {
                            GCLog.info("Debug UN: IC2 inject 1.7.10 succeeded");
                        }
                    }
                    catch (Exception ee) {
                        ee.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.initialisedIC2Methods = true;
    }
}

