/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities.player;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.Event;
import micdoodle8.mods.galacticraft.api.entity.IIgnoreShift;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderMoon;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.event.EventWakePlayer;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerServer;
import micdoodle8.mods.galacticraft.core.util.DamageSourceGC;
import micdoodle8.mods.galacticraft.core.wrappers.Footprint;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.WorldProviderAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.items.ItemArmorAsteroids;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ItemInWorldManager;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;

public class GCEntityPlayerMP
extends EntityPlayerMP {
    private boolean updatingRidden = false;
    public boolean openedSpaceRaceManager = false;

    public GCEntityPlayerMP(MinecraftServer server, WorldServer world, GameProfile profile, ItemInWorldManager itemInWorldManager) {
        super(server, world, profile, itemInWorldManager);
    }

    public void func_71049_a(EntityPlayer oldPlayer, boolean keepInv) {
        super.func_71049_a(oldPlayer, keepInv);
        if (oldPlayer instanceof GCEntityPlayerMP) {
            this.openedSpaceRaceManager = ((GCEntityPlayerMP)oldPlayer).openedSpaceRaceManager;
            this.getPlayerStats().copyFrom(((GCEntityPlayerMP)oldPlayer).getPlayerStats(), keepInv || this.field_70170_p.func_82736_K().func_82766_b("keepInventory"));
        }
    }

    public void func_70098_U() {
        this.updatingRidden = true;
        super.func_70098_U();
        this.updatingRidden = false;
    }

    public void func_70078_a(Entity par1Entity) {
        if (this.updatingRidden && this.field_70154_o instanceof IIgnoreShift && ((IIgnoreShift)this.field_70154_o).shouldIgnoreShiftExit()) {
            return;
        }
        super.func_70078_a(par1Entity);
    }

    public void func_70091_d(double par1, double par3, double par5) {
        super.func_70091_d(par1, par3, par5);
        if (this.field_70170_p.field_73011_w instanceof WorldProviderMoon && !this.field_70170_p.field_72995_K && this.field_70154_o == null) {
            this.updateFeet(par1, par5);
        }
    }

    private void updateFeet(double motionX, double motionZ) {
        int iPosZ;
        int iPosY;
        int iPosX;
        double motionSqrd = motionX * motionX + motionZ * motionZ;
        if (motionSqrd > 0.001 && this.field_70170_p.func_147439_a(iPosX = MathHelper.func_76128_c((double)this.field_70165_t), iPosY = MathHelper.func_76128_c((double)this.field_70163_u) - 1, iPosZ = MathHelper.func_76128_c((double)this.field_70161_v)) == GCBlocks.blockMoon && this.field_70170_p.func_72805_g(iPosX, iPosY, iPosZ) == 5) {
            GCPlayerStats playerStats = this.getPlayerStats();
            if (playerStats.distanceSinceLastStep > 0.35) {
                Vector3 pos = new Vector3((Entity)this);
                pos.y = (float)MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)) + this.field_70146_Z.nextFloat() / 100.0f;
                switch (playerStats.lastStep) {
                    case 0: {
                        float a = (-this.field_70177_z + 90.0f) / 57.29578f;
                        pos.translate(new Vector3(MathHelper.func_76126_a((float)a) * 0.25f, 0.0, MathHelper.func_76134_b((float)a) * 0.25f));
                        break;
                    }
                    case 1: {
                        float a = (-this.field_70177_z - 90.0f) / 57.29578f;
                        pos.translate(new Vector3((double)MathHelper.func_76126_a((float)a) * 0.25, 0.0, (double)MathHelper.func_76134_b((float)a) * 0.25));
                    }
                }
                TickHandlerServer.addFootprint(new Footprint(this.field_70170_p.field_73011_w.field_76574_g, pos, this.field_70177_z), this.field_70170_p.field_73011_w.field_76574_g);
                ++playerStats.lastStep;
                playerStats.lastStep %= 2;
                playerStats.distanceSinceLastStep = 0.0;
            } else {
                playerStats.distanceSinceLastStep += motionSqrd;
            }
        }
    }

    public void func_70999_a(boolean par1, boolean par2, boolean par3) {
        this.wakeUpPlayer(par1, par2, par3, false);
    }

    public void wakeUpPlayer(boolean par1, boolean par2, boolean par3, boolean bypass) {
        ChunkCoordinates c = this.field_71081_bT;
        if (c != null) {
            EventWakePlayer event = new EventWakePlayer((EntityPlayer)this, c.field_71574_a, c.field_71572_b, c.field_71573_c, par1, par2, par3, bypass);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (bypass || event.result == null || event.result == EntityPlayer.EnumStatus.OK) {
                super.func_70999_a(par1, par2, par3);
            }
        }
    }

    public final GCPlayerStats getPlayerStats() {
        return GCPlayerStats.get(this);
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (Loader.isModLoaded((String)"GalacticraftMars")) {
            if (par1DamageSource == DamageSource.field_76380_i) {
                if (this.field_70170_p.field_73011_w instanceof WorldProviderAsteroids) {
                    if (this.field_70163_u > -120.0) {
                        return false;
                    }
                    if (this.field_70163_u > -180.0) {
                        par2 /= 2.0f;
                    }
                }
            } else if (par1DamageSource == DamageSource.field_76379_h || par1DamageSource == DamageSourceGC.spaceshipCrash) {
                int titaniumCount = 0;
                if (this.field_71071_by != null) {
                    for (int i = 0; i < 4; ++i) {
                        ItemStack armorPiece = this.func_82169_q(i);
                        if (armorPiece == null || !(armorPiece.func_77973_b() instanceof ItemArmorAsteroids)) continue;
                        ++titaniumCount;
                    }
                }
                if (titaniumCount == 4) {
                    titaniumCount = 5;
                }
                par2 = (float)((double)par2 * (1.0 - 0.15 * (double)titaniumCount));
            }
        }
        return super.func_70097_a(par1DamageSource, par2);
    }
}

