/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.perlin;

import java.util.Random;

public class FishyNoise {
    int[] perm = new int[512];
    public float[][] grad2d = new float[][]{{1.0f, 0.0f}, {0.9239f, 0.3827f}, {0.707107f, 0.707107f}, {0.3827f, 0.9239f}, {0.0f, 1.0f}, {-0.3827f, 0.9239f}, {-0.707107f, 0.707107f}, {-0.9239f, 0.3827f}, {-1.0f, 0.0f}, {-0.9239f, -0.3827f}, {-0.707107f, -0.707107f}, {-0.3827f, -0.9239f}, {0.0f, -1.0f}, {0.3827f, -0.9239f}, {0.707107f, -0.707107f}, {0.9239f, -0.3827f}};
    public int[][] grad3d = new int[][]{{1, 1, 0}, {-1, 1, 0}, {1, -1, 0}, {-1, -1, 0}, {1, 0, 1}, {-1, 0, 1}, {1, 0, -1}, {-1, 0, -1}, {0, 1, 1}, {0, -1, 1}, {0, 1, -1}, {0, -1, -1}, {1, 1, 0}, {-1, 1, 0}, {0, -1, 1}, {0, -1, -1}};

    public FishyNoise(long seed) {
        int i;
        Random rand = new Random(seed);
        for (i = 0; i < 256; ++i) {
            this.perm[i] = i;
        }
        for (i = 0; i < 256; ++i) {
            int j = rand.nextInt(256);
            this.perm[i] = this.perm[i] ^ this.perm[j];
            this.perm[j] = this.perm[i] ^ this.perm[j];
            this.perm[i] = this.perm[i] ^ this.perm[j];
        }
        System.arraycopy(this.perm, 0, this.perm, 256, 256);
    }

    private static float lerp(float x, float y, float n) {
        return x + n * (y - x);
    }

    private static int fastFloor(float x) {
        return x > 0.0f ? (int)x : (int)x - 1;
    }

    private static float fade(float n) {
        return n * n * n * (n * (n * 6.0f - 15.0f) + 10.0f);
    }

    private static float dot2(float[] grad2, float x, float y) {
        return grad2[0] * x + grad2[1] * y;
    }

    private static float dot3(int[] grad3, float x, float y, float z) {
        return (float)grad3[0] * x + (float)grad3[1] * y + (float)grad3[2] * z;
    }

    public float noise2d(float x, float y) {
        int largeX = FishyNoise.fastFloor(x);
        int largeY = FishyNoise.fastFloor(y);
        x -= (float)largeX;
        y -= (float)largeY;
        float u = FishyNoise.fade(x);
        float v = FishyNoise.fade(y);
        float grad00 = FishyNoise.dot2(this.grad2d[this.perm[(largeX &= 0xFF) + this.perm[largeY &= 0xFF]] & 0xF], x, y);
        float grad01 = FishyNoise.dot2(this.grad2d[this.perm[largeX + this.perm[largeY + 1]] & 0xF], x, y - 1.0f);
        float grad11 = FishyNoise.dot2(this.grad2d[this.perm[largeX + 1 + this.perm[largeY + 1]] & 0xF], x - 1.0f, y - 1.0f);
        float grad10 = FishyNoise.dot2(this.grad2d[this.perm[largeX + 1 + this.perm[largeY]] & 0xF], x - 1.0f, y);
        float lerpX0 = FishyNoise.lerp(grad00, grad10, u);
        float lerpX1 = FishyNoise.lerp(grad01, grad11, u);
        return FishyNoise.lerp(lerpX0, lerpX1, v);
    }

    public float noise3d(float x, float y, float z) {
        int unitX = FishyNoise.fastFloor(x);
        int unitY = FishyNoise.fastFloor(y);
        int unitZ = FishyNoise.fastFloor(z);
        x -= (float)unitX;
        y -= (float)unitY;
        z -= (float)unitZ;
        float u = FishyNoise.fade(x);
        float v = FishyNoise.fade(y);
        float w = FishyNoise.fade(z);
        float grad000 = FishyNoise.dot3(this.grad3d[this.perm[(unitX &= 0xFF) + this.perm[(unitY &= 0xFF) + this.perm[unitZ &= 0xFF]]] & 0xF], x, y, z);
        float grad100 = FishyNoise.dot3(this.grad3d[this.perm[unitX + 1 + this.perm[unitY + this.perm[unitZ]]] & 0xF], x - 1.0f, y, z);
        float grad010 = FishyNoise.dot3(this.grad3d[this.perm[unitX + this.perm[unitY + 1 + this.perm[unitZ]]] & 0xF], x, y - 1.0f, z);
        float grad110 = FishyNoise.dot3(this.grad3d[this.perm[unitX + 1 + this.perm[unitY + 1 + this.perm[unitZ]]] & 0xF], x - 1.0f, y - 1.0f, z);
        float grad001 = FishyNoise.dot3(this.grad3d[this.perm[unitX + this.perm[unitY + this.perm[unitZ + 1]]] & 0xF], x, y, z - 1.0f);
        float grad101 = FishyNoise.dot3(this.grad3d[this.perm[unitX + 1 + this.perm[unitY + this.perm[unitZ + 1]]] & 0xF], x - 1.0f, y, z - 1.0f);
        float grad011 = FishyNoise.dot3(this.grad3d[this.perm[unitX + this.perm[unitY + 1 + this.perm[unitZ + 1]]] & 0xF], x, y - 1.0f, z - 1.0f);
        float grad111 = FishyNoise.dot3(this.grad3d[this.perm[unitX + 1 + this.perm[unitY + 1 + this.perm[unitZ + 1]]] & 0xF], x - 1.0f, y - 1.0f, z - 1.0f);
        return FishyNoise.lerp(FishyNoise.lerp(FishyNoise.lerp(grad000, grad100, u), FishyNoise.lerp(grad010, grad110, u), v), FishyNoise.lerp(FishyNoise.lerp(grad001, grad101, u), FishyNoise.lerp(grad011, grad111, u), v), w);
    }
}

