/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tick;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRace;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRaceManager;
import micdoodle8.mods.galacticraft.core.dimension.WorldDataSpaceRaces;
import micdoodle8.mods.galacticraft.core.energy.grid.EnergyNetwork;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.oxygen.ThreadFindSeal;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygenSealer;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.wrappers.Footprint;
import micdoodle8.mods.galacticraft.core.wrappers.ScheduledBlockChange;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;

public class TickHandlerServer {
    private static Map<Integer, CopyOnWriteArrayList<ScheduledBlockChange>> scheduledBlockChanges = new ConcurrentHashMap<Integer, CopyOnWriteArrayList<ScheduledBlockChange>>();
    private static Map<Integer, CopyOnWriteArrayList<BlockVec3>> scheduledTorchUpdates = new ConcurrentHashMap<Integer, CopyOnWriteArrayList<BlockVec3>>();
    private static Map<Integer, List<BlockVec3>> edgeChecks = new HashMap<Integer, List<BlockVec3>>();
    private static LinkedList<EnergyNetwork> networkTicks = new LinkedList();
    private static Map<Integer, List<Footprint>> footprintList = new HashMap<Integer, List<Footprint>>();
    public static WorldDataSpaceRaces spaceRaceData = null;
    private static long tickCount;

    public static void restart() {
        scheduledBlockChanges.clear();
        scheduledTorchUpdates.clear();
        edgeChecks.clear();
        networkTicks.clear();
        footprintList.clear();
        for (SpaceRace race : SpaceRaceManager.getSpaceRaces()) {
            SpaceRaceManager.removeSpaceRace(race);
        }
        spaceRaceData = null;
        tickCount = 0L;
    }

    public static void addFootprint(Footprint print, int dimID) {
        List<Footprint> footprints = footprintList.get(dimID);
        if (footprints == null) {
            footprints = new ArrayList<Footprint>();
        }
        footprints.add(print);
        footprintList.put(dimID, footprints);
    }

    public static void scheduleNewBlockChange(int dimID, ScheduledBlockChange change) {
        CopyOnWriteArrayList<ScheduledBlockChange> changeList = scheduledBlockChanges.get(dimID);
        if (changeList == null) {
            changeList = new CopyOnWriteArrayList();
        }
        changeList.add(change);
        scheduledBlockChanges.put(dimID, changeList);
    }

    public static void scheduleNewBlockChange(int dimID, List<ScheduledBlockChange> changeAdd) {
        CopyOnWriteArrayList<ScheduledBlockChange> changeList = scheduledBlockChanges.get(dimID);
        if (changeList == null) {
            changeList = new CopyOnWriteArrayList();
        }
        changeList.addAll(changeAdd);
        scheduledBlockChanges.put(dimID, changeList);
    }

    public static void scheduleNewTorchUpdate(int dimID, List<BlockVec3> torches) {
        CopyOnWriteArrayList<BlockVec3> updateList = scheduledTorchUpdates.get(dimID);
        if (updateList == null) {
            updateList = new CopyOnWriteArrayList();
        }
        updateList.addAll(torches);
        scheduledTorchUpdates.put(dimID, updateList);
    }

    public static void scheduleNewEdgeCheck(int dimID, BlockVec3 edgeBlock) {
        List<BlockVec3> updateList = edgeChecks.get(dimID);
        if (updateList == null) {
            updateList = new ArrayList<BlockVec3>();
        }
        updateList.add(edgeBlock);
        edgeChecks.put(dimID, updateList);
    }

    public static boolean scheduledForChange(int dimID, BlockVec3 test) {
        CopyOnWriteArrayList<ScheduledBlockChange> changeList = scheduledBlockChanges.get(dimID);
        if (changeList != null) {
            for (ScheduledBlockChange change : changeList) {
                if (!test.equals(change.getChangePosition())) continue;
                return true;
            }
        }
        return false;
    }

    public static void scheduleNetworkTick(EnergyNetwork grid) {
        networkTicks.add(grid);
    }

    public static void removeNetworkTick(EnergyNetwork grid) {
        networkTicks.remove(grid);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (spaceRaceData == null) {
                WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
                spaceRaceData = (WorldDataSpaceRaces)world.field_72988_C.func_75742_a(WorldDataSpaceRaces.class, "GCSpaceRaceData");
                if (spaceRaceData == null) {
                    spaceRaceData = new WorldDataSpaceRaces("GCSpaceRaceData");
                    world.field_72988_C.func_75745_a("GCSpaceRaceData", (WorldSavedData)spaceRaceData);
                }
            }
            SpaceRaceManager.tick();
            if (tickCount % 100L == 0L) {
                WorldServer[] worlds = FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c;
                for (int i = 0; i < worlds.length; ++i) {
                    List<Footprint> footprints = footprintList.get(worlds[i].field_73011_w.field_76574_g);
                    if (footprints == null) continue;
                    ArrayList<Footprint> toRemove = new ArrayList<Footprint>();
                    for (int j = 0; j < footprints.size(); ++j) {
                        footprints.get((int)j).age = (short)(footprints.get((int)j).age + 100);
                        if (footprints.get((int)j).age < 3200) continue;
                        toRemove.add(footprints.get(j));
                    }
                    footprints.removeAll(toRemove);
                    footprintList.put(worlds[i].field_73011_w.field_76574_g, footprints);
                    GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_FOOTPRINT_LIST, new Object[]{footprints.toArray(new Footprint[footprints.size()])}), worlds[i].field_73011_w.field_76574_g);
                }
            }
            if (++tickCount >= Long.MAX_VALUE) {
                tickCount = 0L;
            }
            ++EnergyNetwork.tickCount;
        } else if (event.phase == TickEvent.Phase.END) {
            int maxPasses = 10;
            while (!networkTicks.isEmpty()) {
                LinkedList<EnergyNetwork> pass = new LinkedList<EnergyNetwork>();
                pass.addAll(networkTicks);
                networkTicks.clear();
                for (EnergyNetwork grid : pass) {
                    grid.tickEnd();
                }
                if (--maxPasses > 0) continue;
                break;
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            CopyOnWriteArrayList<BlockVec3> torchList;
            WorldServer world = (WorldServer)event.world;
            CopyOnWriteArrayList<ScheduledBlockChange> changeList = scheduledBlockChanges.get(world.field_73011_w.field_76574_g);
            if (changeList != null && !changeList.isEmpty()) {
                for (ScheduledBlockChange change : changeList) {
                    BlockVec3 changePosition;
                    if (change == null || (changePosition = change.getChangePosition()) == null) continue;
                    world.func_147465_d(changePosition.x, changePosition.y, changePosition.z, change.getChangeID(), change.getChangeMeta(), 2);
                }
                changeList.clear();
                scheduledBlockChanges.remove(world.field_73011_w.field_76574_g);
            }
            if ((torchList = scheduledTorchUpdates.get(world.field_73011_w.field_76574_g)) != null && !torchList.isEmpty()) {
                for (BlockVec3 torch : torchList) {
                    if (torch == null) continue;
                    if (world.func_147439_a(torch.x, torch.y, torch.z) == GCBlocks.unlitTorch) {
                        world.func_147454_a(torch.x, torch.y, torch.z, GCBlocks.unlitTorch, 2 + world.field_73012_v.nextInt(30), 0);
                        continue;
                    }
                    if (world.func_147439_a(torch.x, torch.y, torch.z) != GCBlocks.unlitTorchLit) continue;
                    world.func_147454_a(torch.x, torch.y, torch.z, GCBlocks.unlitTorchLit, 2 + world.field_73012_v.nextInt(30), 0);
                }
                torchList.clear();
                scheduledTorchUpdates.remove(world.field_73011_w.field_76574_g);
            }
            if (world.field_73011_w instanceof IOrbitDimension) {
                Object[] entityList;
                for (Object o : entityList = world.field_72996_f.toArray()) {
                    IOrbitDimension dimension;
                    if (!(o instanceof Entity)) continue;
                    Entity e = (Entity)o;
                    if (!(e.field_70170_p.field_73011_w instanceof IOrbitDimension) || !(e.field_70163_u <= (double)(dimension = (IOrbitDimension)e.field_70170_p.field_73011_w).getYCoordToTeleportToPlanet())) continue;
                    Integer dim = WorldUtil.getProviderForName((String)dimension.getPlanetToOrbit()).field_76574_g;
                    WorldUtil.transferEntityToDimension(e, dim, world, false, null);
                }
            }
        } else if (event.phase == TickEvent.Phase.END) {
            WorldServer world = (WorldServer)event.world;
            List<BlockVec3> edgesList = edgeChecks.get(world.field_73011_w.field_76574_g);
            HashSet<BlockVec3> checkedThisTick = new HashSet<BlockVec3>();
            if (edgesList != null && !edgesList.isEmpty()) {
                ArrayList<BlockVec3> edgesListCopy = new ArrayList<BlockVec3>();
                edgesListCopy.addAll(edgesList);
                for (BlockVec3 edgeBlock : edgesListCopy) {
                    if (edgeBlock == null || checkedThisTick.contains(edgeBlock) || TickHandlerServer.scheduledForChange(world.field_73011_w.field_76574_g, edgeBlock)) continue;
                    ThreadFindSeal done = new ThreadFindSeal((World)world, edgeBlock, 2000, new ArrayList<TileEntityOxygenSealer>());
                    checkedThisTick.addAll(done.checked);
                }
                edgeChecks.remove(world.field_73011_w.field_76574_g);
            }
        }
    }
}

