/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm;

import com.builtbroken.icbm.CommonProxy;
import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.content.missile.EntityMissile;
import com.builtbroken.icbm.content.missile.RenderMissile;
import com.builtbroken.icbm.content.rocketlauncher.RenderRocketLauncher;
import com.builtbroken.mc.lib.render.fx.FXElectricBolt;
import com.builtbroken.mc.lib.render.fx.FXElectricBoltSpawner;
import com.builtbroken.mc.lib.render.fx.FXEnderPortalPartical;
import com.builtbroken.mc.lib.render.fx.FXShockWave;
import com.builtbroken.mc.lib.render.fx.FXSmoke;
import com.builtbroken.mc.lib.transform.vector.Pos;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private boolean disableReflectionFX = false;

    @Override
    public void init() {
        super.init();
        MinecraftForgeClient.registerItemRenderer((Item)ICBM.itemRocketLauncher, (IItemRenderer)new RenderRocketLauncher());
        RenderMissile render = new RenderMissile(0.5f);
        MinecraftForgeClient.registerItemRenderer((Item)ICBM.itemMissile, (IItemRenderer)render);
        RenderingRegistry.registerEntityRenderingHandler(EntityMissile.class, (Render)render);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Override
    public int getParticleSetting() {
        return Minecraft.func_71410_x().field_71474_y.field_74362_aa;
    }

    @Override
    public void spawnParticle(String name, World world, Pos position, double motionX, double motionY, double motionZ, float red, float green, float blue, float scale, double distance) {
        FXSmoke fx = null;
        if (name.equals("smoke")) {
            fx = new FXSmoke(world, position, red, green, blue, scale, distance);
        } else if (name.equals("missile_smoke")) {
            fx = new FXSmoke(world, position, red, green, blue, scale, distance).setAge(100);
        } else if (name.equals("portal")) {
            fx = new FXEnderPortalPartical(world, position, red, green, blue, scale, distance);
        } else if (!name.equals("antimatter")) {
            if (name.equals("digging")) {
                fx = new EntityDiggingFX(world, position.x(), position.y(), position.z(), motionX, motionY, motionZ, Block.func_149729_e((int)((int)red)), 0, (int)green);
                fx.func_70541_f(blue);
            } else if (name.equals("shockwave")) {
                fx = new FXShockWave(world, position, red, green, blue, scale, distance);
            }
        }
        if (fx != null) {
            fx.field_70159_w = motionX;
            fx.field_70181_x = motionY;
            fx.field_70179_y = motionZ;
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @Override
    public void spawnShock(World world, Pos startVec, Pos targetVec) {
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new FXElectricBolt(world, startVec, targetVec, 0L));
    }

    @Override
    public void spawnShock(World world, Pos startVec, Pos targetVec, int duration) {
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new FXElectricBoltSpawner(world, startVec, targetVec, 0L, duration));
    }

    @Override
    public List<Entity> getEntityFXs() {
        if (!this.disableReflectionFX) {
            try {
                EffectRenderer renderer = Minecraft.func_71410_x().field_71452_i;
                List[] fxLayers = (List[])ReflectionHelper.getPrivateValue(EffectRenderer.class, (Object)renderer, (int)2);
                return fxLayers[0];
            }
            catch (Exception e) {
                ICBM.LOGGER.log(Level.ERROR, "Failed to use reflection on entity effects.");
                e.printStackTrace();
                this.disableReflectionFX = true;
            }
        }
        return null;
    }
}

