/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.blast.explosive;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.content.blast.explosive.BlastProfiler;
import com.builtbroken.icbm.content.blast.explosive.BlastRunProfile;
import com.builtbroken.icbm.content.warhead.TileWarhead;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.lib.helper.DamageUtility;
import com.builtbroken.mc.lib.helper.MathUtility;
import com.builtbroken.mc.lib.transform.sorting.Vector3DistanceComparator;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.lib.world.edit.BlockEdit;
import com.builtbroken.mc.lib.world.explosive.Blast;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTNT;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.Explosion;

public class BlastBasic
extends Blast {
    static DamageSource source = new DamageSource("blast").func_94540_d();
    static BlastProfiler profiler = new BlastProfiler();
    protected float energy = 0.0f;
    protected double radius = 0.0;
    protected Entity explosionBlameEntity;
    protected Explosion wrapperExplosion;
    protected List<BlockEdit> postCallDestroyMethod = new ArrayList<BlockEdit>();
    protected BlastRunProfile profile = profiler.run(this);

    public void getEffectedBlocks(List<BlockEdit> list) {
        HashMap<BlockEdit, Float> map = new HashMap<BlockEdit, Float>();
        this.profile.startSection("getEffectedBlocks");
        this.profile.startSection("Pathfinder");
        this.triggerPathFinder(map, new BlockEdit(this.world, (double)this.x, (double)this.y, (double)this.z), this.energy);
        this.profile.endSection("Pathfinder");
        list.addAll(map.keySet());
        this.profile.startSection("Sorter");
        Collections.sort(list, new Vector3DistanceComparator(new Pos(this.x(), this.y(), this.z())));
        this.profile.endSection("Sorter");
        this.profile.endSection("getEffectedBlocks");
        if (Engine.runningAsDev) {
            ICBM.LOGGER.info((Object)this.profile.getOutputSimple());
        }
    }

    protected void triggerPathFinder(HashMap<BlockEdit, Float> map, BlockEdit vec, float energy) {
        this.expand(map, vec, energy, null, 0);
    }

    protected void expand(HashMap<BlockEdit, Float> map, BlockEdit vec, float energy, EnumFacing side, int iteration) {
        long timeStart = System.nanoTime();
        if (iteration < this.size * 2) {
            float e = this.getEnergyCostOfTile(vec, energy);
            ++this.profile.tilesPathed;
            if (e >= 0.0f) {
                vec.energy_$eq(energy);
                this.onBlockMapped(vec, e, energy - e);
                map.put(vec, Float.valueOf(energy - e));
                if (e > 1.0f) {
                    ArrayList<BlockEdit> sides = new ArrayList<BlockEdit>();
                    for (EnumFacing dir : EnumFacing.values()) {
                        if (dir == side) continue;
                        BlockEdit v = new BlockEdit(this.world, vec.x(), vec.y(), vec.z());
                        v.addEquals(dir);
                        v.face_$eq(dir);
                        v.logPrevBlock();
                        sides.add(v);
                    }
                    Collections.sort(sides, new Vector3DistanceComparator(new Pos(this.x(), this.y(), this.z())));
                    this.profile.blockIterationTimes.add(System.nanoTime() - timeStart);
                    for (BlockEdit f : sides) {
                        EnumFacing face;
                        float eToSpend = e / (float)sides.size() + e % (float)sides.size();
                        e -= eToSpend;
                        EnumFacing enumFacing = face = side == null ? this.getOpposite(f.face()) : side;
                        if (map.containsKey(f) && !(map.get(f).floatValue() < eToSpend)) continue;
                        f.face_$eq(face);
                        this.expand(map, f, eToSpend, face, iteration + 1);
                    }
                }
            }
        }
    }

    private EnumFacing getOpposite(EnumFacing face) {
        switch (face) {
            case UP: {
                return EnumFacing.DOWN;
            }
            case DOWN: {
                return EnumFacing.UP;
            }
            case NORTH: {
                return EnumFacing.SOUTH;
            }
            case SOUTH: {
                return EnumFacing.NORTH;
            }
            case EAST: {
                return EnumFacing.WEST;
            }
            case WEST: {
                return EnumFacing.EAST;
            }
        }
        return null;
    }

    protected float getEnergyCostOfTile(BlockEdit vec, float energy) {
        if (vec.isAirBlock(this.world)) {
            ++this.profile.airBlocksPathed;
        } else {
            ++this.profile.blocksRemoved;
        }
        return vec.getHardness() >= 0.0f ? energy - (float)Math.max((double)vec.getResistance(this.explosionBlameEntity, (double)this.x, (double)this.y, (double)this.z), 0.5) : -1.0f;
    }

    public void handleBlockPlacement(BlockEdit vec) {
        Block block = vec.getBlock();
        TileEntity tile = vec.getTileEntity();
        if (vec.block() == Blocks.field_150350_a || vec.block() == Blocks.field_150480_ab) {
            if (!(block instanceof BlockTNT) && !(vec.getTileEntity() instanceof TileWarhead)) {
                block.func_149723_a(this.world, vec.xi(), vec.yi(), vec.zi(), this.wrapperExplosion);
            } else {
                this.postCallDestroyMethod.add(vec);
            }
            vec.place();
        }
    }

    protected BlockEdit onBlockMapped(BlockEdit change, float energyExpended, float energyLeft) {
        if (energyExpended > energyLeft) {
            change.doItemDrop_$eq(true);
        }
        return change;
    }

    public void doEffectOther(boolean beforeBlocksPlaced) {
        AxisAlignedBB bounds;
        List list;
        if (!beforeBlocksPlaced && (list = this.world.func_72872_a(Entity.class, bounds = AxisAlignedBB.func_72330_a((double)(this.x - this.size - 1), (double)(this.y - this.size - 1), (double)(this.z - this.size - 1), (double)(this.x + this.size + 1), (double)(this.y + this.size + 1), (double)(this.z + this.size + 1)))) != null && !list.isEmpty()) {
            for (Object obj : list) {
                if (!(obj instanceof Entity)) continue;
                this.effectEntity((Entity)obj);
            }
        }
    }

    protected void effectEntity(Entity entity) {
        Pos eVec;
        MovingObjectPosition hit;
        if (DamageUtility.canDamage((Entity)entity) && ((hit = (eVec = new Pos(entity)).rayTrace(this.world, new Pos(this.x(), this.y(), this.z()))) == null || hit.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK)) {
            float e = ((float)this.radius + 5.0f) / (float)eVec.distance((IPos3D)new Pos(this.x(), this.y(), this.z()));
            entity.func_70097_a(source, e);
            this.applyMotion(entity, eVec, e);
        }
    }

    protected void applyMotion(Entity entity, Pos eVec, float energyAppliedNearEntity) {
        if (!entity.func_70115_ae()) {
            Pos motion = eVec.toEulerAngle(new Pos(this.x(), this.y(), this.z())).toVector().multiply((double)energyAppliedNearEntity);
            entity.field_70159_w += (double)(motion.xi() & 1);
            entity.field_70181_x += (double)(motion.xi() & 1);
            entity.field_70179_y += (double)(motion.xi() & 1);
        }
    }

    public Blast setCause(TriggerCause cause) {
        super.setCause(cause);
        if (cause instanceof TriggerCause.TriggerCauseEntity) {
            this.explosionBlameEntity = ((TriggerCause.TriggerCauseEntity)cause).source;
        }
        if (this.explosionBlameEntity == null) {
            this.explosionBlameEntity = new EntityTNTPrimed(this.world);
            this.explosionBlameEntity.func_70107_b((double)this.x, (double)this.y, (double)this.z);
        }
        this.wrapperExplosion = new WrapperExplosion(this);
        return this;
    }

    public BlastBasic setYield(int size) {
        super.setYield(size);
        this.radius = size;
        this.calcStartingEnergy();
        return this;
    }

    protected void calcStartingEnergy() {
        this.energy = (float)(MathUtility.getSphereVolume((double)this.radius) * (double)this.eUnitPerBlock);
    }

    public static class WrapperExplosion
    extends Explosion {
        public final BlastBasic blast;

        public WrapperExplosion(BlastBasic blast) {
            super(blast.world(), blast.explosionBlameEntity, blast.x(), blast.y(), blast.z(), (float)blast.size);
            this.blast = blast;
        }
    }
}

