/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.blast.explosive;

import com.builtbroken.icbm.content.blast.explosive.BlastBasic;
import com.builtbroken.jlib.lang.StringHelpers;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.testing.debug.profiler.RunProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BlastRunProfile
extends RunProfile {
    public final int size;
    public final float energy;
    public final Pos center;
    public int tilesPathed = 0;
    public int airBlocksPathed = 0;
    public int blocksRemoved = 0;
    public List<Long> blockIterationTimes = new ArrayList<Long>();

    public BlastRunProfile(BlastBasic blast) {
        super("icbm.blast." + ((Object)((Object)blast)).getClass().getSimpleName() + "#" + System.nanoTime());
        this.size = blast.size;
        this.energy = blast.energy;
        this.center = new Pos((double)blast.x, (double)blast.y, (double)blast.z);
    }

    public void addRunData(StringBuilder stringBuilder) {
        stringBuilder.append("\nCenter: " + this.center);
        stringBuilder.append("\nEnergy: " + this.energy);
        stringBuilder.append("\nSize:   " + this.size);
        stringBuilder.append("\n");
        stringBuilder.append("\nIterations: " + StringHelpers.fitIntoSpaces((long)this.tilesPathed, (int)5));
        stringBuilder.append("\nAir:        " + StringHelpers.fitIntoSpaces((long)this.airBlocksPathed, (int)5));
        stringBuilder.append("\nBlocks:     " + StringHelpers.fitIntoSpaces((long)this.blocksRemoved, (int)5));
        stringBuilder.append("\n");
        long averageBlockIterationTime = 0L;
        for (Long n : this.blockIterationTimes) {
            averageBlockIterationTime += n.longValue();
        }
        Collections.sort(this.blockIterationTimes);
        stringBuilder.append("\nAvg B Time: " + StringHelpers.formatNanoTime((long)(averageBlockIterationTime /= (long)this.blockIterationTimes.size())));
        stringBuilder.append("\nMin B Time: " + StringHelpers.formatNanoTime((long)this.blockIterationTimes.get(0)));
        stringBuilder.append("\nMax B Time: " + StringHelpers.formatNanoTime((long)this.blockIterationTimes.get(this.blockIterationTimes.size() - 1)));
        stringBuilder.append("\n");
    }
}

