/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.crafting;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.content.crafting.AbstractModule;
import com.builtbroken.mc.core.Engine;
import com.google.common.collect.HashBiMap;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;

public class ModuleBuilder {
    public static final String SAVE_ID = "moduleID";
    HashBiMap<String, Class<? extends AbstractModule>> idToCLassMap = HashBiMap.create();
    HashMap<String, List<String>> modToModules = new HashMap();

    protected boolean register(String mod_id, String name, Class<? extends AbstractModule> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("ModuleBuidler.register(" + mod_id + ", " + name + ", clazz) clazz can not be null");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("ModuleBuidler.register(" + mod_id + ", name, " + clazz + ") name can not be empty");
        }
        if (mod_id == null || mod_id.isEmpty()) {
            throw new IllegalArgumentException("ModuleBuidler.register(mod_id, " + name + ", " + clazz + ") mod_id is invalid");
        }
        String id = mod_id + "." + name;
        if (!this.idToCLassMap.containsKey((Object)id)) {
            this.idToCLassMap.put((Object)id, clazz);
            List<String> list = null;
            if (this.modToModules.containsKey(mod_id)) {
                list = this.modToModules.get(mod_id);
            }
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(id);
            this.modToModules.put(mod_id, list);
            return true;
        }
        return false;
    }

    public boolean isRegistered(String id) {
        return this.idToCLassMap.containsKey((Object)id);
    }

    public Set<String> getIDs() {
        return this.idToCLassMap.keySet();
    }

    public String getID(AbstractModule module) {
        Class<?> clazz = module.getClass();
        if (this.idToCLassMap.inverse().containsKey(clazz)) {
            return (String)this.idToCLassMap.inverse().get(clazz);
        }
        return module.getClass().getSimpleName();
    }

    public AbstractModule build(ItemStack stack) {
        block11: {
            String id;
            if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b(SAVE_ID) && this.idToCLassMap.containsKey((Object)(id = stack.func_77978_p().func_74779_i(SAVE_ID)))) {
                if (this.idToCLassMap.get((Object)id) != null) {
                    try {
                        return ((AbstractModule)((Class)this.idToCLassMap.get((Object)id)).getConstructor(ItemStack.class).newInstance(stack)).load();
                    }
                    catch (InstantiationException e) {
                        ICBM.LOGGER.error("ModuleBuilder failed to create module from class " + this.idToCLassMap.get((Object)id));
                        if (Engine.runningAsDev) {
                            e.printStackTrace();
                        }
                        break block11;
                    }
                    catch (IllegalAccessException e) {
                        ICBM.LOGGER.error("ModuleBuilder was prevented access to class " + this.idToCLassMap.get((Object)id));
                        if (Engine.runningAsDev) {
                            e.printStackTrace();
                        }
                        break block11;
                    }
                    catch (NoSuchMethodException e) {
                        ICBM.LOGGER.error("ModuleBuilder failed to find  constructor(ItemStack.class) for class " + this.idToCLassMap.get((Object)id));
                        if (Engine.runningAsDev) {
                            e.printStackTrace();
                        }
                        break block11;
                    }
                    catch (InvocationTargetException e) {
                        ICBM.LOGGER.error("ModuleBuilder failed to find to invoke constructor(ItemStack.class) for class " + this.idToCLassMap.get((Object)id));
                        if (Engine.runningAsDev) {
                            e.printStackTrace();
                        }
                        break block11;
                    }
                }
                ICBM.LOGGER.error("ModuleBuilder, module " + id + " has no class registered.");
            }
        }
        return null;
    }
}

