/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.crafting.missile.casing;

import com.builtbroken.icbm.api.IModuleContainer;
import com.builtbroken.icbm.content.crafting.AbstractModule;
import com.builtbroken.icbm.content.crafting.missile.MissileModuleBuilder;
import com.builtbroken.icbm.content.crafting.missile.MissileSizes;
import com.builtbroken.icbm.content.crafting.missile.engine.Engine;
import com.builtbroken.icbm.content.crafting.missile.guidance.Guidance;
import com.builtbroken.icbm.content.crafting.missile.warhead.Warhead;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public abstract class Missile
extends AbstractModule
implements IModuleContainer {
    private Warhead warhead;
    private Guidance guidance;
    private Engine engine;
    public final MissileSizes size;
    public int body_length = 2;

    public Missile(ItemStack stack, MissileSizes size) {
        super(stack, "missile");
        this.size = size;
        this.load(stack);
    }

    @Override
    public void load(NBTTagCompound nbt) {
        if (nbt.func_74764_b("warhead")) {
            this.setWarhead(MissileModuleBuilder.INSTANCE.buildWarhead(ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("warhead"))));
        }
        if (nbt.func_74764_b("engine")) {
            this.setEngine(MissileModuleBuilder.INSTANCE.buildEngine(ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("engine"))));
        }
        if (nbt.func_74764_b("guidance")) {
            this.setGuidance(MissileModuleBuilder.INSTANCE.buildGuidance(ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("guidance"))));
        }
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbt) {
        if (this.getWarhead() != null) {
            nbt.func_74782_a("warhead", (NBTBase)this.getWarhead().toStack().func_77955_b(new NBTTagCompound()));
        }
        if (this.getEngine() != null) {
            nbt.func_74782_a("engine", (NBTBase)this.getEngine().toStack().func_77955_b(new NBTTagCompound()));
        }
        if (this.getGuidance() != null) {
            nbt.func_74782_a("guidance", (NBTBase)this.getGuidance().toStack().func_77955_b(new NBTTagCompound()));
        }
        return nbt;
    }

    @Override
    public boolean canInstallModule(ItemStack stack, AbstractModule module) {
        return module instanceof Engine || module instanceof Warhead || module instanceof Guidance;
    }

    @Override
    public boolean installModule(ItemStack stack, AbstractModule module) {
        if (module instanceof Engine && this.engine == null) {
            this.setEngine((Engine)module);
            return this.getEngine() == module;
        }
        if (module instanceof Warhead && this.warhead == null) {
            this.setWarhead((Warhead)module);
            return this.getWarhead() == module;
        }
        if (module instanceof Guidance && this.guidance == null) {
            this.setGuidance((Guidance)module);
            return this.getGuidance() == module;
        }
        return false;
    }

    public void setWarhead(Warhead warhead) {
        this.warhead = warhead;
    }

    public void setGuidance(Guidance guidance) {
        this.guidance = guidance;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public Warhead getWarhead() {
        return this.warhead;
    }

    public Guidance getGuidance() {
        return this.guidance;
    }

    public Engine getEngine() {
        return this.engine;
    }
}

