/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.display;

import com.builtbroken.icbm.content.crafting.missile.MissileModuleBuilder;
import com.builtbroken.icbm.content.crafting.missile.casing.Missile;
import com.builtbroken.icbm.content.missile.ItemMissile;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.IPacketReceiver;
import com.builtbroken.mc.core.network.packet.AbstractPacket;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.lib.render.RenderItemOverlayUtility;
import com.builtbroken.mc.lib.transform.region.Cuboid;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.prefab.tile.Tile;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileMissileDisplay
extends Tile
implements IPacketReceiver {
    private Missile missile = null;

    public TileMissileDisplay() {
        super("missileDisplay", Material.field_151594_q);
        this.renderTileEntity = true;
        this.isOpaque = true;
        this.bounds = new Cuboid(0.0, 0.0, 0.0, 1.0, 0.4, 1.0);
    }

    public Tile newTile() {
        return new TileMissileDisplay();
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("missileItem")) {
            this.setMissile(MissileModuleBuilder.INSTANCE.buildMissile(ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("missileItem"))));
        } else {
            this.setMissile(null);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.getMissile() != null) {
            nbt.func_74782_a("missileItem", (NBTBase)this.getMissile().toStack().func_77955_b(new NBTTagCompound()));
        }
    }

    public PacketTile getDescPacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new PacketTile((TileEntity)this, 0, new Object[]{tag});
    }

    public void updateClient() {
        Engine.instance.packetHandler.sendToAllAround((AbstractPacket)this.getDescPacket(), (TileEntity)this);
    }

    public boolean read(EntityPlayer player, AbstractPacket packet) {
        System.out.println("Packet Received");
        this.func_145839_a(ByteBufUtils.readTag((ByteBuf)packet.data));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Pos pos, float frame, int pass) {
        if (this.func_145831_w() != null && this.getMissile() != null) {
            RenderItemOverlayUtility.renderItem((World)this.func_145831_w(), (ForgeDirection)ForgeDirection.UNKNOWN, (ItemStack)this.missile.toStack(), (Pos)pos.add(0.5), (float)0.0f, (int)0);
        }
    }

    public void setMissile(Missile missile) {
        this.missile = missile;
    }

    public boolean onPlayerRightClick(EntityPlayer player, int side, Pos hit) {
        if (this.isServer()) {
            ItemStack stack = player.func_70694_bm();
            if (this.getMissile() != null) {
                if (stack == null) {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Removed Missile"));
                    player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = this.getMissile().toStack();
                    this.setMissile(null);
                    player.field_71069_bz.func_75142_b();
                    this.updateClient();
                    return true;
                }
            } else if (stack.func_77973_b() instanceof ItemMissile) {
                player.func_146105_b((IChatComponent)new ChatComponentText("Added Missile"));
                this.setMissile(MissileModuleBuilder.INSTANCE.buildMissile(stack));
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                    if (stack.field_77994_a <= 0) {
                        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                    }
                    player.field_71069_bz.func_75142_b();
                    this.updateClient();
                }
                return true;
            }
        }
        return false;
    }

    public Missile getMissile() {
        return this.missile;
    }
}

