/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.missile;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.api.IMissile;
import com.builtbroken.icbm.content.crafting.missile.MissileSizes;
import com.builtbroken.icbm.content.crafting.missile.casing.Missile;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.api.explosive.IExplosive;
import com.builtbroken.mc.api.explosive.IExplosiveContainer;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.lib.world.explosive.ExplosiveRegistry;
import com.builtbroken.mc.prefab.entity.EntityProjectile;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntityMissile
extends EntityProjectile
implements IExplosiveContainer,
IMissile,
IEntityAdditionalSpawnData {
    private Missile missile;

    public EntityMissile(World w) {
        super(w);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityMissile(EntityLivingBase entity) {
        super(entity);
        this.func_70105_a(0.5f, 0.5f);
    }

    public static void fireMissileByEntity(EntityLivingBase entity, ItemStack missile, MissileSizes size) {
        EntityMissile entityMissile = new EntityMissile(entity);
        entityMissile.setMissile(MissileSizes.loadMissile(missile));
        entityMissile.setTicksInAir(1);
        entityMissile.setMotion(1);
        entityMissile.field_70170_p.func_72838_d((Entity)entityMissile);
        entityMissile.field_70170_p.func_72956_a((Entity)entityMissile, "icbm:missilelaunch", 4.0f, (1.0f + (entityMissile.field_70170_p.field_73012_v.nextFloat() - entityMissile.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
    }

    public String func_70005_c_() {
        return this.getMissile() == null ? "Unknown-Missile" : (this.getMissile().getWarhead() == null ? "Missile-Module" : "Missile with " + this.getMissile().getWarhead().ex.toString() + " warhead");
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70132_H && !this.field_70122_E && this.getTicksInAir() > 0) {
            this.spawnMissileSmoke();
        }
    }

    private void spawnMissileSmoke() {
        if (this.field_70170_p.field_72995_K) {
            Pos position = new Pos((Entity)this);
            double distance = -1.2f;
            Pos delta = new Pos();
            delta.y_$eq(Math.sin(Math.toRadians(this.field_70125_A)) * distance);
            double dH = Math.cos(Math.toRadians(this.field_70125_A)) * distance;
            delta.x_$eq(Math.sin(Math.toRadians(this.field_70177_z)) * dH);
            delta.z_$eq(Math.cos(Math.toRadians(this.field_70177_z)) * dH);
            position.add((IPos3D)delta);
            this.field_70170_p.func_72869_a("flame", position.x(), position.y(), position.z(), 0.0, 0.0, 0.0);
            ICBM.proxy.spawnParticle("missile_smoke", this.field_70170_p, position, 4.0f, 2.0);
            position.multiply(1.0 - 0.001 * Math.random());
            ICBM.proxy.spawnParticle("missile_smoke", this.field_70170_p, position, 4.0f, 2.0);
            position.multiply(1.0 - 0.001 * Math.random());
            ICBM.proxy.spawnParticle("missile_smoke", this.field_70170_p, position, 4.0f, 2.0);
            position.multiply(1.0 - 0.001 * Math.random());
            ICBM.proxy.spawnParticle("missile_smoke", this.field_70170_p, position, 4.0f, 2.0);
        }
    }

    public IExplosive getExplosive() {
        return this.getMissile() != null && this.getMissile().getWarhead() != null ? this.getMissile().getWarhead().ex : null;
    }

    protected void onStoppedMoving() {
        this.onImpact();
    }

    protected void onImpact() {
        super.onImpact();
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70014_b(tag);
        ExplosiveRegistry.triggerExplosive((World)this.field_70170_p, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (IExplosive)this.getExplosive(), (TriggerCause)new TriggerCause.TriggerCauseEntity((Entity)this), (int)5, (NBTTagCompound)tag);
    }

    public Missile getMissile() {
        return this.missile;
    }

    public void setMissile(Missile missile) {
        this.missile = missile;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("missileStack")) {
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("missileStack"));
            this.setMissile(MissileSizes.loadMissile(stack));
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.getMissile() != null) {
            ItemStack stack = this.getMissile().toStack();
            nbt.func_74782_a("missileStack", (NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70014_b(tag);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)tag);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.func_70037_a(ByteBufUtils.readTag((ByteBuf)additionalData));
    }
}

