/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.missile;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.api.IAmmo;
import com.builtbroken.icbm.api.IAmmoType;
import com.builtbroken.icbm.api.IWeapon;
import com.builtbroken.icbm.content.crafting.missile.MissileModuleBuilder;
import com.builtbroken.icbm.content.crafting.missile.MissileSizes;
import com.builtbroken.icbm.content.crafting.missile.casing.Missile;
import com.builtbroken.icbm.content.missile.AmmoTypeMissile;
import com.builtbroken.icbm.content.missile.EntityMissile;
import com.builtbroken.mc.api.explosive.IExplosive;
import com.builtbroken.mc.api.items.IExplosiveItem;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.lib.world.explosive.ExplosiveRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemMissile
extends Item
implements IExplosiveItem,
IAmmo {
    public ItemMissile() {
        this.func_77655_b("missile");
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public String func_77658_a() {
        return "item.icbm:missile";
    }

    public String func_77667_c(ItemStack item) {
        if (item.func_77960_j() < MissileSizes.values().length) {
            MissileSizes size = MissileSizes.values()[item.func_77960_j()];
            if (this.getExplosive(item) == null) {
                return this.func_77658_a() + "." + size.toString().toLowerCase() + ".empty";
            }
            return this.func_77658_a() + "." + size.toString().toLowerCase();
        }
        return this.func_77658_a();
    }

    public IExplosive getExplosive(ItemStack itemStack) {
        Missile missile = MissileSizes.loadMissile(itemStack);
        return missile.getWarhead() != null ? missile.getWarhead().ex : null;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (MissileSizes size : MissileSizes.values()) {
            list.add(new ItemStack(item, 1, size.ordinal()));
            for (IExplosive ex : ExplosiveRegistry.getExplosives()) {
                list.add(MissileModuleBuilder.INSTANCE.buildMissile(size, ex).toStack());
            }
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        super.func_77624_a(stack, player, list, bool);
        Missile missile = MissileSizes.loadMissile(stack);
        IExplosive ex = missile.getWarhead() != null ? missile.getWarhead().ex : null;
        String ex_translation = LanguageUtility.getLocal((String)"info.icbm:warhead.name") + ": ";
        if (ex != null) {
            ex_translation = ex_translation + LanguageUtility.getLocal((String)(ex.getTranslationKey() + ".name"));
            list.add(ex_translation);
            ArrayList l = new ArrayList();
            ex.addInfoToItem(stack, l);
            for (String s : l) {
                list.add(s);
            }
        } else {
            ex_translation = ex_translation + "----";
            list.add(ex_translation);
        }
        String engine_translation = LanguageUtility.getLocal((String)"info.icbm:engine.name") + ": ";
        engine_translation = missile.getEngine() != null ? engine_translation + LanguageUtility.getLocal((String)(missile.getEngine().getUnlocaizedName() + ".name")) : engine_translation + "----";
        list.add(engine_translation);
    }

    @Override
    public boolean isAmmo(ItemStack stack) {
        Missile missile = MissileSizes.loadMissile(stack);
        return missile != null && missile.getEngine() != null;
    }

    @Override
    public boolean isClip(ItemStack stack) {
        return false;
    }

    @Override
    public IAmmoType getAmmoType(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 1: {
                return AmmoTypeMissile.SMALL;
            }
            case 2: {
                return AmmoTypeMissile.STANDARD;
            }
            case 3: {
                return AmmoTypeMissile.MEDIUM;
            }
            case 4: {
                return AmmoTypeMissile.LARGE;
            }
        }
        return AmmoTypeMissile.MICRO;
    }

    @Override
    public int getAmmoCount(ItemStack ammoStack) {
        return ammoStack.field_77994_a;
    }

    @Override
    public void fireAmmo(IWeapon weapon, ItemStack weaponStack, ItemStack ammoStack, Entity firingEntity) {
        if (firingEntity instanceof EntityLivingBase) {
            EntityMissile.fireMissileByEntity((EntityLivingBase)firingEntity, ammoStack, ((AmmoTypeMissile)this.getAmmoType((ItemStack)ammoStack)).size);
        } else {
            ICBM.LOGGER.error("Item Missile can't be fired using \n fireAmmo(" + weapon + ", " + ammoStack + ", " + firingEntity + ") \n when the entity is not an instanceof EntityLivingBase");
        }
    }

    @Override
    public void consumeAmmo(IWeapon weapon, ItemStack weaponStack, ItemStack ammoStack, int shotsFired) {
        ammoStack.field_77994_a -= shotsFired;
    }
}

