/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.missile;

import com.builtbroken.icbm.api.ICustomMissileRender;
import com.builtbroken.icbm.content.crafting.missile.MissileModuleBuilder;
import com.builtbroken.icbm.content.crafting.missile.casing.Missile;
import com.builtbroken.icbm.content.missile.EntityMissile;
import com.builtbroken.icbm.content.missile.ItemMissile;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderMissile
extends Render
implements IItemRenderer {
    public static final IModelCustom SMALL = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("icbm", "models/missile_conventional.tcn"));
    public static final ResourceLocation SMALL_TEXTURE = new ResourceLocation("icbm", "textures/models/missile_condensed.png");

    public RenderMissile(float f) {
        this.field_76989_e = f;
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float f, float f1) {
        EntityMissile entityMissile = (EntityMissile)entity;
        Missile missile = entityMissile.getMissile();
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glTranslated((double)x, (double)(y - 1.0), (double)z);
        float yaw = RenderMissile.interpolateRotation(-entity.field_70126_B + 90.0f, -entity.field_70177_z + 90.0f, f1);
        GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(RenderMissile.interpolateRotation(entity.field_70127_C, entity.field_70125_A, f1) + 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        if (!(missile instanceof ICustomMissileRender) || !((ICustomMissileRender)((Object)missile)).renderMissileInWorld()) {
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(SMALL_TEXTURE);
            if (missile == null || missile.getWarhead() != null) {
                SMALL.renderOnly(new String[]{"WARHEAD 1", "WARHEAD 2", "WARHEAD 3", "WARHEAD 4"});
            }
            SMALL.renderAllExcept(new String[]{"WARHEAD 1", "WARHEAD 2", "WARHEAD 3", "WARHEAD 4"});
        }
        GL11.glPopMatrix();
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return null;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return this.shouldUseRenderHelper(type, item, null);
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return item.func_77973_b() instanceof ItemMissile;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (this.shouldUseRenderHelper(type, item, null)) {
            Missile missile = MissileModuleBuilder.INSTANCE.buildMissile(item);
            float scale = 0.5f;
            float yaw = 0.0f;
            float pitch = -90.0f;
            switch (type) {
                case INVENTORY: {
                    GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)0.0f);
                    break;
                }
                case EQUIPPED: {
                    GL11.glTranslatef((float)1.0f, (float)0.3f, (float)0.5f);
                    break;
                }
                case EQUIPPED_FIRST_PERSON: {
                    GL11.glTranslatef((float)1.15f, (float)-1.0f, (float)0.5f);
                    break;
                }
                case ENTITY: {
                    GL11.glTranslatef((float)-0.6f, (float)0.0f, (float)0.0f);
                    break;
                }
            }
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)pitch, (float)0.0f, (float)0.0f, (float)1.0f);
            if (!(missile instanceof ICustomMissileRender) || !((ICustomMissileRender)((Object)missile)).renderMissileItem(type, item, data)) {
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(SMALL_TEXTURE);
                if (missile == null || missile.getWarhead() != null) {
                    SMALL.renderOnly(new String[]{"WARHEAD 1", "WARHEAD 2", "WARHEAD 3", "WARHEAD 4"});
                }
                SMALL.renderAllExcept(new String[]{"WARHEAD 1", "WARHEAD 2", "WARHEAD 3", "WARHEAD 4"});
            }
        }
    }

    public static float interpolateRotation(float prev, float rotation, float f) {
        float f3;
        for (f3 = rotation - prev; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return prev + f * f3;
    }
}

