/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.warhead;

import com.builtbroken.icbm.content.crafting.missile.MissileSizes;
import com.builtbroken.icbm.content.crafting.missile.warhead.Warhead;
import com.builtbroken.icbm.content.missile.RenderMissile;
import com.builtbroken.icbm.content.warhead.ItemBlockWarhead;
import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.api.explosive.IExplosive;
import com.builtbroken.mc.api.explosive.IExplosiveContainer;
import com.builtbroken.mc.api.items.ISimpleItemRenderer;
import com.builtbroken.mc.api.tile.IRemovable;
import com.builtbroken.mc.core.network.IPacketReceiver;
import com.builtbroken.mc.core.network.packet.AbstractPacket;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.lib.helper.WrenchUtility;
import com.builtbroken.mc.lib.transform.region.Cuboid;
import com.builtbroken.mc.lib.transform.vector.Location;
import com.builtbroken.mc.lib.transform.vector.Pos;
import com.builtbroken.mc.lib.world.edit.WorldChangeHelper;
import com.builtbroken.mc.lib.world.explosive.ExplosiveItemUtility;
import com.builtbroken.mc.prefab.tile.Tile;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.Explosion;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class TileWarhead
extends Tile
implements IExplosiveContainer,
IPacketReceiver,
IRemovable.ISneakPickup,
ISimpleItemRenderer {
    public boolean exploding = false;
    protected Warhead warhead;

    public TileWarhead() {
        super("warhead", Material.field_151573_f);
        this.hardness = 100.0f;
        this.renderNormalBlock = false;
        this.renderTileEntity = true;
        this.isOpaque = false;
        this.itemBlock = ItemBlockWarhead.class;
        this.bounds = new Cuboid(0.2, 0.0, 0.2, 0.8, 0.5, 0.8);
    }

    public void onCollide(Entity entity) {
        if (entity != null && entity.func_70027_ad()) {
            this.explode((TriggerCause)new TriggerCause.TriggerCauseEntity(entity));
        }
    }

    public Tile newTile() {
        return new TileWarhead();
    }

    public boolean onPlayerActivated(EntityPlayer entityPlayer, int side, Pos hit) {
        if (entityPlayer.func_71045_bC() != null) {
            if (entityPlayer.func_71045_bC().func_77973_b() == Items.field_151033_d) {
                this.explode((TriggerCause)new TriggerCause.TriggerCauseFire(ForgeDirection.getOrientation((int)side)));
                return true;
            }
            if (WrenchUtility.isUsableWrench((EntityPlayer)entityPlayer, (ItemStack)entityPlayer.func_71045_bC(), (int)this.xi(), (int)this.yi(), (int)this.zi())) {
                int change = 3;
                switch (this.func_145832_p()) {
                    case 0: {
                        change = 2;
                        break;
                    }
                    case 2: {
                        change = 5;
                        break;
                    }
                    case 5: {
                        change = 3;
                        break;
                    }
                    case 3: {
                        change = 4;
                        break;
                    }
                    case 4: {
                        change = 1;
                        break;
                    }
                    case 1: {
                        change = 0;
                    }
                }
                this.setMeta(ForgeDirection.getOrientation((int)change).ordinal());
                this.world().func_147444_c(this.xi(), this.yi(), this.zi(), this.func_145838_q());
                return true;
            }
        }
        return false;
    }

    public void onPlaced(EntityLivingBase entityLiving, ItemStack itemStack) {
        super.onPlaced(entityLiving, itemStack);
        if (!this.world().field_72995_K && ExplosiveItemUtility.getExplosive((ItemStack)itemStack) != null) {
            this.warhead = MissileSizes.loadWarhead(itemStack);
            this.setMeta(this.determineOrientation(entityLiving));
            int power_side = -1;
            int powerMax = 0;
            for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                Location position = this.toVectorWorld();
                position.add(ForgeDirection.getOrientation((int)i));
                Block b = position.getBlock();
                if (this.world().func_72878_l(this.xi(), this.yi(), this.zi(), i) > powerMax) {
                    powerMax = this.world().func_72878_l(this.xi(), this.yi(), this.zi(), i);
                    power_side = i;
                }
                if (b != Blocks.field_150480_ab && b != Blocks.field_150353_l && b != Blocks.field_150356_k) continue;
                this.explode((TriggerCause)new TriggerCause.TriggerCauseFire(ForgeDirection.getOrientation((int)i)));
                return;
            }
            if (power_side != -1) {
                this.explode((TriggerCause)new TriggerCause.TriggerCauseRedstone(ForgeDirection.UNKNOWN, powerMax));
            }
        }
    }

    public void onWorldJoin() {
        super.onWorldJoin();
        this.world().func_147471_g(this.xi(), this.yi(), this.zi());
    }

    public void onNeighborChanged(Block block) {
        super.onNeighborChanged(block);
        int power_side = -1;
        int powerMax = 0;
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            Location position = this.toVectorWorld();
            position.add(ForgeDirection.getOrientation((int)i));
            Block b = position.getBlock();
            if (this.world().func_72878_l(this.xi(), this.yi(), this.zi(), i) > powerMax) {
                powerMax = this.world().func_72878_l(this.xi(), this.yi(), this.zi(), i);
                power_side = i;
            }
            if (b != Blocks.field_150480_ab && b != Blocks.field_150353_l && b != Blocks.field_150356_k) continue;
            this.explode((TriggerCause)new TriggerCause.TriggerCauseFire(ForgeDirection.getOrientation((int)i)));
            return;
        }
        if (power_side != -1) {
            this.explode((TriggerCause)new TriggerCause.TriggerCauseRedstone(ForgeDirection.UNKNOWN, powerMax));
        }
    }

    public void explode(TriggerCause triggerCause) {
        if (!this.exploding) {
            this.exploding = true;
            if (this.warhead.trigger(triggerCause, this.world(), this.x(), this.y(), this.z()) == WorldChangeHelper.ChangeResult.COMPLETED) {
                this.world().func_147468_f(this.xi(), this.yi(), this.zi());
            } else {
                this.exploding = false;
            }
        }
    }

    public void onDestroyedByExplosion(Explosion explosion) {
        this.explode((TriggerCause)new TriggerCause.TriggerCauseExplosion(explosion));
    }

    public boolean canUpdate() {
        return false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.warhead.load(nbt);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.warhead.save(nbt);
    }

    public boolean read(EntityPlayer player, AbstractPacket type) {
        byte ID = type.data.readByte();
        if (ID == 1) {
            NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)type.data);
            if (this.warhead == null) {
                this.warhead = MissileSizes.loadWarhead(this.getItemStack());
                this.warhead.load(tag);
            } else {
                this.warhead.load(tag);
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        return true;
    }

    public PacketTile getDescPacket() {
        return new PacketTile((TileEntity)this, 1, new Object[]{this.warhead});
    }

    public IExplosive getExplosive() {
        return this.warhead.ex;
    }

    public void getSubBlocks(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        ExplosiveItemUtility.getSubItems((Item)par1, (List)par3List);
    }

    public ItemStack getPickBlock(MovingObjectPosition target) {
        return this.getItemStack();
    }

    public ItemStack getItemStack() {
        ItemStack stack = new ItemStack(this.func_145838_q());
        if (this.warhead != null) {
            this.warhead.save(stack);
        } else {
            stack.func_77964_b(1);
        }
        return stack;
    }

    public List<ItemStack> getRemovedItems(EntityPlayer entity) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(this.getItemStack());
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Pos position, float frame, int pass) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(position.xf() + 0.5f), (float)(position.yf() - 2.5f), (float)(position.zf() + 0.5f));
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(RenderMissile.SMALL_TEXTURE);
        RenderMissile.SMALL.renderOnly(new String[]{"WARHEAD 1", "WARHEAD 2", "WARHEAD 3", "WARHEAD 4"});
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryItem(IItemRenderer.ItemRenderType type, ItemStack itemStack, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            GL11.glTranslatef((float)1.0f, (float)0.3f, (float)0.5f);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glTranslatef((float)1.15f, (float)1.0f, (float)0.5f);
        }
        if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        }
        this.renderDynamic(new Pos(), 0.0f, 0);
    }
}

