/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.client.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiOptions;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import us.ichun.mods.ichunutil.client.gui.GuiModUpdateNotification;
import us.ichun.mods.ichunutil.client.gui.config.GuiConfigs;
import us.ichun.mods.ichunutil.client.keybind.KeyBind;
import us.ichun.mods.ichunutil.client.render.RendererHelper;
import us.ichun.mods.ichunutil.common.core.config.ConfigHandler;
import us.ichun.mods.ichunutil.common.core.event.ServerPacketableEvent;
import us.ichun.mods.ichunutil.common.grab.GrabHandler;
import us.ichun.mods.ichunutil.common.tracker.EntityInfo;
import us.ichun.mods.ichunutil.common.tracker.IAdditionalTrackerInfo;
import us.ichun.mods.ichunutil.common.tracker.TrackerRegistry;

public class TickHandlerClient {
    public GuiModUpdateNotification modUpdateNotification;
    public int ticks;
    public float renderTick;
    public boolean optionsKeyDown;
    public boolean mouseLeftDown;
    public GuiButton buttonDummy;
    public int screenWidth;
    public int screenHeight;
    public ArrayList<KeyBind> keyBindList;
    public HashMap<KeyBinding, KeyBind> mcKeyBindList;
    public boolean firstConnectToServer;
    public int infectionTimeout;
    public boolean isFirstInfection;
    public ArrayList<TrackerRegistry> trackedEntities;
    public ArrayList<Class<? extends Item>> bowAnimationLockedItems;
    public ArrayList<SwingProofHandler> swingProofItems;
    private int prevCurItem;
    private boolean currentItemIsSwingProof;
    private boolean hasShownItemName;

    public TickHandlerClient() {
        this.screenWidth = Minecraft.func_71410_x().field_71443_c;
        this.screenHeight = Minecraft.func_71410_x().field_71440_d;
        this.keyBindList = new ArrayList();
        this.mcKeyBindList = new HashMap();
        this.firstConnectToServer = false;
        this.infectionTimeout = 0;
        this.isFirstInfection = false;
        this.trackedEntities = new ArrayList();
        this.bowAnimationLockedItems = new ArrayList();
        this.swingProofItems = new ArrayList();
        this.buttonDummy = new GuiButton(0, 0, 0, "");
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START) {
            this.renderTick = event.renderTickTime;
            if (this.screenWidth != mc.field_71443_c || this.screenHeight != mc.field_71440_d) {
                this.screenWidth = mc.field_71443_c;
                this.screenHeight = mc.field_71440_d;
                for (Framebuffer buffer : RendererHelper.frameBuffers) {
                    buffer.func_147613_a(this.screenWidth, this.screenHeight);
                }
            }
            if (mc.field_71439_g != null) {
                ItemStack currentInv = mc.field_71439_g.func_71045_bC();
                if (currentInv != null && this.isItemSwingProof(currentInv.func_77973_b())) {
                    mc.field_71442_b.func_78767_c();
                    if (this.prevCurItem == mc.field_71439_g.field_71071_by.field_70461_c) {
                        mc.field_71460_t.field_78516_c.field_78454_c = 1.0f;
                        mc.field_71460_t.field_78516_c.field_78451_d = 1.0f;
                        mc.field_71460_t.field_78516_c.field_78453_b = mc.field_71439_g.field_71071_by.func_70448_g();
                        mc.field_71460_t.field_78516_c.field_78450_g = mc.field_71439_g.field_71071_by.field_70461_c;
                        if (!this.currentItemIsSwingProof) {
                            this.handleSwingProofItemEquip(mc.field_71439_g, currentInv);
                        }
                        if (mc.field_71456_v.field_92017_k == 0) {
                            this.hasShownItemName = true;
                        }
                        if (this.hasShownItemName) {
                            mc.field_71456_v.field_92017_k = 0;
                        }
                    }
                    mc.field_71439_g.field_82175_bq = false;
                    mc.field_71439_g.field_110158_av = 0;
                    mc.field_71439_g.field_70733_aJ = 0.0f;
                }
                boolean bl = this.currentItemIsSwingProof = currentInv != null && this.isItemSwingProof(currentInv.func_77973_b());
                if (this.prevCurItem != mc.field_71439_g.field_71071_by.field_70461_c) {
                    if (mc.field_71439_g.field_71071_by.field_70461_c >= 0 && mc.field_71439_g.field_71071_by.field_70461_c <= 9 && mc.field_71460_t.field_78516_c.field_78454_c >= 1.0f) {
                        this.prevCurItem = mc.field_71439_g.field_71071_by.field_70461_c;
                    }
                    this.currentItemIsSwingProof = false;
                    this.hasShownItemName = false;
                }
            }
        } else {
            ScaledResolution reso = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
            if (!ConfigHandler.configs.isEmpty() && mc.field_71462_r != null && mc.field_71462_r.getClass().equals(GuiOptions.class)) {
                GuiOptions gui = (GuiOptions)mc.field_71462_r;
                String s = StatCollector.func_74837_a((String)"ichun.gui.moreOptions", (Object[])new Object[]{GameSettings.func_74298_c((int)24)});
                int width = mc.field_71466_p.func_78256_a(s);
                int i = Mouse.getX() * reso.func_78326_a() / mc.field_71443_c;
                int j = reso.func_78328_b() - Mouse.getY() * reso.func_78328_b() / mc.field_71440_d - 1;
                this.buttonDummy.field_146128_h = reso.func_78326_a() - (width + 5);
                this.buttonDummy.field_146129_i = reso.func_78328_b() - (mc.field_71466_p.field_78288_b + 4);
                this.buttonDummy.field_146120_f = width + 40;
                this.buttonDummy.field_146121_g = 20;
                this.buttonDummy.func_146112_a(mc, 0, 0);
                gui.func_73731_b(mc.field_71466_p, s, gui.field_146294_l - mc.field_71466_p.func_78256_a(s) - 2, gui.field_146295_m - 10, 0xFFFFFF);
                if (!this.mouseLeftDown && Mouse.isButtonDown((int)0) && i >= this.buttonDummy.field_146128_h && i <= reso.func_78326_a() && j >= this.buttonDummy.field_146129_i && j <= reso.func_78328_b() || !this.optionsKeyDown && Keyboard.isKeyDown((int)24)) {
                    this.buttonDummy.func_146113_a(mc.func_147118_V());
                    int oriScale = mc.field_71474_y.field_74335_Z;
                    mc.field_71474_y.field_74335_Z = 2;
                    FMLClientHandler.instance().showGuiScreen((Object)new GuiConfigs(oriScale, mc.field_71462_r));
                }
                this.mouseLeftDown = Mouse.isButtonDown((int)0);
                this.optionsKeyDown = Keyboard.isKeyDown((int)24);
            }
            if (mc.field_71441_e != null) {
                if (this.infectionTimeout > 0 && (mc.field_71462_r == null || mc.field_71462_r instanceof GuiChat)) {
                    int max = this.isFirstInfection ? 100 : 60;
                    int alpha = MathHelper.func_76125_a((int)((int)((max - this.infectionTimeout <= 5 ? ((float)(max - this.infectionTimeout) + event.renderTickTime) / 5.0f : ((float)(this.infectionTimeout - 5) - event.renderTickTime) / (float)(max - 5)) * 220.0f)), (int)0, (int)255);
                    GlStateManager.func_179092_a((int)516, (float)0.00625f);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179112_b((int)770, (int)772);
                    RendererHelper.drawColourOnScreen(this.isFirstInfection ? 0xFF0000 : 65280, alpha, 0.0, 0.0, reso.func_78326_a(), reso.func_78328_b(), 0.0);
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179092_a((int)516, (float)0.1f);
                }
                if (this.modUpdateNotification != null) {
                    this.modUpdateNotification.update();
                }
            }
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.side.isClient() && event.phase.equals((Object)TickEvent.Phase.END)) {
            for (TrackerRegistry reg : this.trackedEntities) {
                if (!reg.type.equals((Object)TrackerRegistry.EnumTrackerType.PERSISTENT_PLAYER) || !reg.entityToTrack.func_70005_c_().equals(event.player.func_70005_c_())) continue;
                reg.entityToTrack = event.player;
            }
            ItemStack is = event.player.func_71045_bC();
            if (is != null && (event.player != Minecraft.func_71410_x().func_175606_aa() || Minecraft.func_71410_x().field_71474_y.field_74320_O != 0) && this.isItemBowAnimationLocked(is.func_77973_b()) && event.player.func_71052_bv() <= 0) {
                event.player.func_71041_bz();
                event.player.func_71008_a(is, Integer.MAX_VALUE);
            }
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (Minecraft.func_71410_x().field_71441_e != null) {
                this.worldTick(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71441_e);
            }
            ++this.ticks;
        }
    }

    public void worldTick(Minecraft mc, WorldClient world) {
        for (KeyBind keyBind : this.keyBindList) {
            keyBind.tick();
        }
        for (Map.Entry entry : this.mcKeyBindList.entrySet()) {
            if (((KeyBind)entry.getValue()).keyIndex != ((KeyBinding)entry.getKey()).func_151463_i()) {
                entry.setValue(new KeyBind(((KeyBinding)entry.getKey()).func_151463_i(), false, false, false, false));
            }
            ((KeyBind)entry.getValue()).tick();
        }
        if (this.firstConnectToServer) {
            this.firstConnectToServer = false;
            MinecraftForge.EVENT_BUS.post((Event)new ServerPacketableEvent());
        }
        if (this.infectionTimeout > 0) {
            --this.infectionTimeout;
        }
        if (!mc.func_147113_T()) {
            for (int i = this.trackedEntities.size() - 1; i >= 0; --i) {
                TrackerRegistry trackerRegistry = this.trackedEntities.get(i);
                if (trackerRegistry.update()) continue;
                this.trackedEntities.remove(i);
            }
            GrabHandler.tick(Side.CLIENT);
        }
    }

    public ArrayList<EntityInfo> getOrRegisterEntityTracker(EntityLivingBase ent, int length, Class<? extends IAdditionalTrackerInfo> additionalInfo, boolean persist) {
        ArrayList<EntityInfo> info = null;
        for (TrackerRegistry reg : this.trackedEntities) {
            if (reg.entityToTrack != ent && (!reg.type.equals((Object)TrackerRegistry.EnumTrackerType.PERSISTENT_PLAYER) || !reg.entityToTrack.func_70005_c_().equals(ent.func_70005_c_()) || !(ent instanceof EntityPlayer))) continue;
            if (length > reg.length) {
                reg.length = length;
            }
            reg.addTracker(additionalInfo);
            info = reg.trackedInfo;
            break;
        }
        if (info == null) {
            TrackerRegistry reg = new TrackerRegistry(persist && ent instanceof EntityPlayer ? TrackerRegistry.EnumTrackerType.PERSISTENT_PLAYER : TrackerRegistry.EnumTrackerType.SPECIFIC, ent, length).addTracker(additionalInfo);
            this.trackedEntities.add(reg);
            info = reg.trackedInfo;
        }
        return info;
    }

    public void nudgeHand(float mag) {
        Minecraft.func_71410_x().field_71439_g.field_71155_g += mag;
    }

    public void registerBowAnimationLockedItem(Class<? extends Item> clz) {
        if (!this.bowAnimationLockedItems.contains(clz)) {
            this.bowAnimationLockedItems.add(clz);
        }
    }

    public boolean isItemBowAnimationLocked(Item item) {
        for (Class<? extends Item> clz : this.bowAnimationLockedItems) {
            if (!clz.isInstance(item)) continue;
            return true;
        }
        return false;
    }

    public void registerSwingProofItem(SwingProofHandler handler) {
        for (SwingProofHandler handler1 : this.swingProofItems) {
            if (!handler1.clz.equals(handler.clz)) continue;
            return;
        }
        this.swingProofItems.add(handler);
    }

    public boolean isItemSwingProof(Item item) {
        for (SwingProofHandler handler1 : this.swingProofItems) {
            if (!handler1.clz.isInstance(item)) continue;
            return true;
        }
        return false;
    }

    public void handleSwingProofItemEquip(EntityPlayerSP player, ItemStack stack) {
        for (SwingProofHandler handler1 : this.swingProofItems) {
            if (!handler1.clz.isInstance(stack.func_77973_b())) continue;
            if (handler1.hnd == null) break;
            handler1.hnd.handleEquip(player, stack);
            break;
        }
    }

    public static class SwingProofHandler {
        public final Class<? extends Item> clz;
        public final IItemEquippedHandler hnd;

        public SwingProofHandler(Class<? extends Item> clz, IItemEquippedHandler hnd) {
            this.clz = clz;
            this.hnd = hnd;
        }

        public static interface IItemEquippedHandler {
            public void handleEquip(EntityPlayerSP var1, ItemStack var2);

            public boolean hideName();
        }
    }
}

