/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.client.render;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3i;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.IColoredBakedQuad;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import us.ichun.mods.ichunutil.common.core.util.ResourceHelper;
import us.ichun.mods.ichunutil.common.iChunUtil;

@SideOnly(value=Side.CLIENT)
public class RendererHelper {
    public static ArrayList<Framebuffer> frameBuffers = new ArrayList();

    public static void init() {
        if (iChunUtil.config.enableStencils == 1) {
            Minecraft.func_71410_x().func_147110_a().enableStencil();
        }
    }

    public static void renderBakedModel(IBakedModel model, int color, ItemStack stack) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        if (model.func_177553_d() && stack != null) {
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179091_B();
            TileEntityItemStackRenderer.field_147719_a.func_179022_a(stack);
        } else {
            GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            RendererHelper.renderModel(model, color, stack);
            if (stack != null && stack.func_77973_b() != null && stack.func_77962_s()) {
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179143_c((int)514);
                GlStateManager.func_179140_f();
                GlStateManager.func_179112_b((int)768, (int)1);
                mc.func_110434_K().func_110577_a(ResourceHelper.texGlint);
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
                float f = (float)(Minecraft.func_71386_F() % 3000L) / 3000.0f / 8.0f;
                GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                RendererHelper.renderModel(model, -8372020, null);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
                float f1 = (float)(Minecraft.func_71386_F() % 4873L) / 4873.0f / 8.0f;
                GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                RendererHelper.renderModel(model, -8372020, null);
                GlStateManager.func_179121_F();
                GlStateManager.func_179128_n((int)5888);
                GlStateManager.func_179112_b((int)770, (int)771);
                GlStateManager.func_179145_e();
                GlStateManager.func_179143_c((int)515);
                GlStateManager.func_179132_a((boolean)true);
                mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
            }
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        mc.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
    }

    private static void renderModel(IBakedModel model, int color, ItemStack stack) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_178970_b();
        worldrenderer.func_178967_a(DefaultVertexFormats.field_176599_b);
        for (EnumFacing enumfacing : EnumFacing.values()) {
            RendererHelper.renderQuads(worldrenderer, model.func_177551_a(enumfacing), color, stack);
        }
        RendererHelper.renderQuads(worldrenderer, model.func_177550_a(), color, stack);
        tessellator.func_78381_a();
    }

    private static void renderQuads(WorldRenderer renderer, List quads, int color, ItemStack stack) {
        for (BakedQuad bakedquad : quads) {
            int j = color;
            if (color == -1 && bakedquad.func_178212_b() && stack != null && stack.func_77973_b() != null) {
                j = stack.func_77973_b().func_82790_a(stack, bakedquad.func_178211_c());
                if (EntityRenderer.field_78517_a) {
                    j = TextureUtil.func_177054_c((int)j);
                }
                j |= 0xFF000000;
            }
            RendererHelper.renderQuad(renderer, bakedquad, j);
        }
    }

    private static void renderQuad(WorldRenderer renderer, BakedQuad quad, int color) {
        renderer.func_178981_a(quad.func_178209_a());
        if (quad instanceof IColoredBakedQuad) {
            ForgeHooksClient.putQuadColor((WorldRenderer)renderer, (BakedQuad)quad, (int)color);
        } else {
            renderer.func_178968_d(color);
        }
        RendererHelper.putQuadNormal(renderer, quad);
    }

    private static void putQuadNormal(WorldRenderer renderer, BakedQuad quad) {
        Vec3i vec3i = quad.func_178210_d().func_176730_m();
        renderer.func_178975_e((float)vec3i.func_177958_n(), (float)vec3i.func_177956_o(), (float)vec3i.func_177952_p());
    }

    public static void renderLighting(double x, double y, double z, int randSeed, int bends, int spread, double heightOfBend, int layerCount, double layerSize, float intensity, int clr) {
        float r = (float)(clr >> 16 & 0xFF) / 255.0f;
        float g = (float)(clr >> 8 & 0xFF) / 255.0f;
        float b = (float)(clr & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        double[] adouble = new double[bends];
        double[] adouble1 = new double[bends];
        double d3 = 0.0;
        double d4 = 0.0;
        Random random = new Random(randSeed);
        for (int i = bends - 1; i >= 0; --i) {
            adouble[i] = d3;
            adouble1[i] = d4;
            d3 += (double)(random.nextInt(spread * 2 + 1) - spread);
            d4 += (double)(random.nextInt(spread * 2 + 1) - spread);
        }
        for (int layers = 0; layers < layerCount; ++layers) {
            Random random1 = new Random(randSeed);
            int k = bends - 1;
            int l = 0;
            double d5 = 0.0;
            double d6 = 0.0;
            for (int i1 = k; i1 >= l; --i1) {
                double d7 = d5;
                double d8 = d6;
                d5 += (double)(random1.nextInt(spread * 2 + 1) - spread);
                d6 += (double)(random1.nextInt(spread * 2 + 1) - spread);
                if (i1 == l) {
                    d5 = 0.0;
                    d6 = 0.0;
                }
                worldrenderer.func_178964_a(5);
                worldrenderer.func_178960_a(r * intensity, g * intensity, b * intensity, 0.3f);
                double d9 = 0.1 + (double)layers * layerSize;
                d9 *= (double)i1 * 0.1 + 0.5;
                double d10 = 0.1 + (double)layers * layerSize;
                d10 *= (double)(i1 - 1) * 0.1 + 0.5;
                for (int j1 = 0; j1 < 5; ++j1) {
                    double d11 = x + 0.5 - d9;
                    double d12 = z + 0.5 - d9;
                    if (j1 == 1 || j1 == 2) {
                        d11 += d9 * 2.0;
                    }
                    if (j1 == 2 || j1 == 3) {
                        d12 += d9 * 2.0;
                    }
                    double d13 = x + 0.5 - d10;
                    double d14 = z + 0.5 - d10;
                    if (j1 == 1 || j1 == 2) {
                        d13 += d10 * 2.0;
                    }
                    if (j1 == 2 || j1 == 3) {
                        d14 += d10 * 2.0;
                    }
                    worldrenderer.func_178984_b(d13 + d5, y + (double)i1 * heightOfBend, d14 + d6);
                    worldrenderer.func_178984_b(d11 + d7, y + (double)(i1 + 1) * heightOfBend, d12 + d8);
                }
                tessellator.func_78381_a();
            }
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
    }

    public static void setColorFromInt(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)1.0f);
    }

    public static void drawTextureOnScreen(ResourceLocation resource, double posX, double posY, double width, double height, double zLevel) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resource);
        RendererHelper.drawOnScreen(posX, posY, width, height, zLevel);
    }

    public static void drawOnScreen(double posX, double posY, double width, double height, double zLevel) {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_178970_b();
        worldrenderer.func_178985_a(posX, posY + height, zLevel, 0.0, 1.0);
        worldrenderer.func_178985_a(posX + width, posY + height, zLevel, 1.0, 1.0);
        worldrenderer.func_178985_a(posX + width, posY, zLevel, 1.0, 0.0);
        worldrenderer.func_178985_a(posX, posY, zLevel, 0.0, 0.0);
        tessellator.func_78381_a();
    }

    public static void drawColourOnScreen(int colour, int alpha, double posX, double posY, double width, double height, double zLevel) {
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        RendererHelper.drawColourOnScreen(r, g, b, alpha, posX, posY, width, height, zLevel);
    }

    public static void drawColourOnScreen(int r, int g, int b, int alpha, double posX, double posY, double width, double height, double zLevel) {
        if (width <= 0.0 || height <= 0.0) {
            return;
        }
        GlStateManager.func_179090_x();
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_178970_b();
        worldrenderer.func_178961_b(r, g, b, alpha);
        worldrenderer.func_178984_b(posX, posY + height, zLevel);
        worldrenderer.func_178984_b(posX + width, posY + height, zLevel);
        worldrenderer.func_178984_b(posX + width, posY, zLevel);
        worldrenderer.func_178984_b(posX, posY, zLevel);
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
    }

    public static void startGlScissor(int x, int y, int width, int height) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution reso = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        double scaleW = (double)mc.field_71443_c / reso.func_78327_c();
        double scaleH = (double)mc.field_71440_d / reso.func_78324_d();
        if (width <= 0 || height <= 0) {
            return;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)Math.floor((double)x * scaleW)), (int)((int)Math.floor((double)mc.field_71440_d - (double)(y + height) * scaleH)), (int)((int)Math.floor((double)(x + width) * scaleW) - (int)Math.floor((double)x * scaleW)), (int)((int)Math.floor((double)mc.field_71440_d - (double)y * scaleH) - (int)Math.floor((double)mc.field_71440_d - (double)(y + height) * scaleH)));
    }

    public static void endGlScissor() {
        GL11.glDisable((int)3089);
    }

    public static void renderTestStencil() {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution reso1 = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        GL11.glEnable((int)2960);
        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GlStateManager.func_179132_a((boolean)false);
        GL11.glStencilFunc((int)512, (int)1, (int)255);
        GL11.glStencilOp((int)7681, (int)7680, (int)7680);
        GL11.glStencilMask((int)255);
        GlStateManager.func_179086_m((int)1024);
        RendererHelper.drawColourOnScreen(0xFFFFFF, 255, 0.0, 0.0, 60.0, 60.0, 0.0);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179132_a((boolean)true);
        GL11.glStencilMask((int)0);
        GL11.glStencilFunc((int)514, (int)0, (int)255);
        GL11.glStencilFunc((int)514, (int)1, (int)255);
        RendererHelper.drawColourOnScreen(0xFFFFFF, 255, 0.0, 0.0, reso1.func_78327_c(), reso1.func_78324_d(), 0.0);
        GL11.glDisable((int)2960);
    }

    public static void renderTestScissor() {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution reso1 = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        RendererHelper.startGlScissor(reso1.func_78326_a() / 2 - 50, reso1.func_78328_b() / 2 - 50, 100, 100);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)-15.0f, (float)15.0f, (float)0.0f);
        RendererHelper.drawColourOnScreen(0xFFFFFF, 255, 0.0, 0.0, reso1.func_78327_c(), reso1.func_78324_d(), 0.0);
        GlStateManager.func_179121_F();
        RendererHelper.endGlScissor();
    }

    public static Framebuffer createFrameBuffer(String modId, boolean useDepth) {
        Framebuffer render = new Framebuffer(Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d, useDepth);
        frameBuffers.add(render);
        return render;
    }

    public static void deleteFrameBuffer(Framebuffer buffer) {
        if (buffer.field_147616_f >= 0) {
            buffer.func_147608_a();
        }
        frameBuffers.remove(buffer);
    }
}

