/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.common.core;

import com.google.common.collect.Iterables;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S12PacketEntityVelocity;
import net.minecraft.potion.Potion;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import us.ichun.mods.ichunutil.common.core.util.ObfHelper;
import us.ichun.mods.ichunutil.common.iChunUtil;

public class EntityHelperBase {
    public static final String[] volunteers = new String[]{"0b7509f0-2458-4160-9ce1-2772b9a45ac2", "45438340-ced5-4c4f-82b4-ef1496f0319e", "6993a191-3741-41ec-9f76-ff89025b38b6", "b47935c3-757d-4a3a-9f03-5fe55efb9464", "aeb4e423-0d5d-491f-8d2d-d6b3fe6679a6", "4e532a7f-ad64-4d43-9ee1-a345d0a5eed1", "a32d6e2c-7936-43b1-aa20-396c7a298314", "5e0acde3-e629-4acc-b0c7-f30cb6783b8d", "a5ea0925-0afa-48eb-9512-58027bda77d1", "88d02c0e-c895-40d0-bb1b-16b292b277d9", "f7aea342-2ee0-4980-9358-6b59ec935b0f", "6e8be0ba-e4bb-46af-aea8-2c1f5eec5bc2", "ee64800c-2dd5-468e-9cda-914f07592c4b", "ec167010-a390-42a6-a3a9-ab3ca4996508", "5d40840f-4a08-4559-8d0d-aac28dfbbd26", "fd303402-d627-4de0-8a02-eb8c7fd2acb6", "28b6d151-c2df-46b8-b9e4-2bf453fde455", "9f662928-1078-4fcd-b728-4798db6edf94", "a4e85c95-b704-4637-8559-7f93a7ec5cc6", "78b2adca-ee34-47b6-ac7a-21c239c44815", "6b384367-de1d-4764-aa64-367d98e22c2b", "bfa9edae-6127-4841-bbc1-6fc9347e1273"};
    public static final float[] RARITY = new float[]{0.01f, 0.03f, 0.075f, 0.17f, 0.275f, 0.235f, 0.115f, 0.05f, 0.03f, 10.0f};
    public static final Random infectionRand = new Random();
    private static final UUID uuidExample = UUID.fromString("DEADBEEF-DEAD-BEEF-DEAD-DEADBEEFD00D");
    private static GameProfileRepository profileRepo;
    private static HashMap<String, GameProfile> nameToPartialProfileMap;
    private static HashMap<String, GameProfile> nameToFullProfileMap;

    public static int getImmunityLevel(String uuid) {
        uuid = uuid.replaceAll("-", "");
        for (String s : volunteers) {
            if (!s.replaceAll("-", "").equalsIgnoreCase(uuid)) continue;
            return 0;
        }
        infectionRand.setSeed(Math.abs(uuid.hashCode()));
        float immunity = infectionRand.nextFloat();
        int level = -1;
        int i = 0;
        while (immunity > 0.0f) {
            ++level;
            immunity -= RARITY[i];
            ++i;
        }
        return level;
    }

    @SideOnly(value=Side.CLIENT)
    public static void injectMinecraftPlayerGameProfile() {
        nameToFullProfileMap.put(Minecraft.func_71410_x().func_110432_I().func_111285_a(), Minecraft.func_71410_x().func_110432_I().func_148256_e());
    }

    public static GameProfile getFullGameProfileFromName(String name) {
        GameProfile gameprofile;
        if (nameToFullProfileMap.containsKey(name)) {
            return nameToFullProfileMap.get(name);
        }
        GameProfile gp = new GameProfile(null, name);
        if (!(StringUtils.func_151246_b((String)gp.getName()) || gp.isComplete() && gp.getProperties().containsKey((Object)"textures") || (gameprofile = EntityHelperBase.getPartialGameProfileFromName(gp.getName())) == null)) {
            Property property = (Property)Iterables.getFirst((Iterable)gameprofile.getProperties().get((Object)"textures"), null);
            if (property == null) {
                gameprofile = iChunUtil.proxy.getSessionService().fillProfileProperties(gameprofile, true);
                nameToFullProfileMap.put(gameprofile.getName(), gameprofile);
            }
            return gameprofile;
        }
        return new GameProfile(uuidExample, name);
    }

    public static GameProfile getSimpleGameProfileFromName(String name) {
        return new GameProfile(uuidExample, name);
    }

    public static GameProfile getPartialGameProfileFromName(String name) {
        if (nameToFullProfileMap.containsKey(name)) {
            return nameToFullProfileMap.get(name);
        }
        if (nameToPartialProfileMap.containsKey(name)) {
            return nameToPartialProfileMap.get(name);
        }
        final GameProfile[] agameprofile = new GameProfile[1];
        ProfileLookupCallback profilelookupcallback = new ProfileLookupCallback(){

            public void onProfileLookupSucceeded(GameProfile p_onProfileLookupSucceeded_1_) {
                agameprofile[0] = p_onProfileLookupSucceeded_1_;
            }

            public void onProfileLookupFailed(GameProfile p_onProfileLookupFailed_1_, Exception p_onProfileLookupFailed_2_) {
                agameprofile[0] = null;
            }
        };
        if (profileRepo == null) {
            profileRepo = iChunUtil.proxy.createProfileRepo();
        }
        profileRepo.findProfilesByNames(new String[]{name}, Agent.MINECRAFT, profilelookupcallback);
        if (agameprofile[0] == null) {
            UUID uuid = EntityPlayer.func_146094_a((GameProfile)new GameProfile((UUID)null, name));
            GameProfile gameprofile = new GameProfile(uuid, name);
            profilelookupcallback.onProfileLookupSucceeded(gameprofile);
        } else {
            nameToPartialProfileMap.put(agameprofile[0].getName(), agameprofile[0]);
        }
        return agameprofile[0];
    }

    public static void getUUIDFromUsernames(String ... names) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("\n\nUUIDs from Names\n");
        ArrayList<String> namesList = new ArrayList<String>();
        ArrayList<String> uuidList = new ArrayList<String>();
        for (String s : names) {
            GameProfile gp = EntityHelperBase.getPartialGameProfileFromName(s);
            namesList.add(gp.getName());
            uuidList.add("  \"" + gp.getId().toString() + "\"");
        }
        for (i = 0; i < namesList.size(); ++i) {
            sb.append((String)namesList.get(i)).append("\n");
        }
        for (i = 0; i < uuidList.size(); ++i) {
            sb.append((String)uuidList.get(i)).append("\n");
        }
        System.out.println(sb.toString());
    }

    public static void attackEntityWithItem(EntityLivingBase attacker, Entity targetEntity) {
        if (targetEntity.func_70075_an() && !targetEntity.func_85031_j((Entity)attacker)) {
            float f = (float)attacker.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            int b0 = 0;
            float f1 = 0.0f;
            f1 = targetEntity instanceof EntityLivingBase ? EnchantmentHelper.func_152377_a((ItemStack)attacker.func_70694_bm(), (EnumCreatureAttribute)((EntityLivingBase)targetEntity).func_70668_bt()) : EnchantmentHelper.func_152377_a((ItemStack)attacker.func_70694_bm(), (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED);
            int j = b0 + EnchantmentHelper.func_77501_a((EntityLivingBase)attacker);
            if (attacker.func_70051_ag()) {
                ++j;
            }
            if (f > 0.0f || f1 > 0.0f) {
                boolean flag;
                boolean bl = flag = attacker.field_70143_R > 0.0f && !attacker.field_70122_E && !attacker.func_70617_f_() && !attacker.func_70090_H() && !attacker.func_70644_a(Potion.field_76440_q) && attacker.field_70154_o == null && targetEntity instanceof EntityLivingBase;
                if (flag && f > 0.0f) {
                    f *= 1.5f;
                }
                f += f1;
                boolean flag1 = false;
                int i = EnchantmentHelper.func_90036_a((EntityLivingBase)attacker);
                if (targetEntity instanceof EntityLivingBase && i > 0 && !targetEntity.func_70027_ad()) {
                    flag1 = true;
                    targetEntity.func_70015_d(1);
                }
                double d0 = targetEntity.field_70159_w;
                double d1 = targetEntity.field_70181_x;
                double d2 = targetEntity.field_70179_y;
                boolean flag2 = targetEntity.func_70097_a(attacker instanceof EntityPlayer ? DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)) : DamageSource.func_76358_a((EntityLivingBase)attacker), f);
                if (flag2) {
                    IEntityMultiPart ientitymultipart;
                    if (j > 0) {
                        targetEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)(attacker.field_70177_z * (float)Math.PI / 180.0f)) * (float)j * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(attacker.field_70177_z * (float)Math.PI / 180.0f)) * (float)j * 0.5f));
                        attacker.field_70159_w *= 0.6;
                        attacker.field_70179_y *= 0.6;
                        attacker.func_70031_b(false);
                    }
                    if (targetEntity instanceof EntityPlayerMP && targetEntity.field_70133_I) {
                        ((EntityPlayerMP)targetEntity).field_71135_a.func_147359_a((Packet)new S12PacketEntityVelocity(targetEntity));
                        targetEntity.field_70133_I = false;
                        targetEntity.field_70159_w = d0;
                        targetEntity.field_70181_x = d1;
                        targetEntity.field_70179_y = d2;
                    }
                    EntityPlayer player = null;
                    if (attacker instanceof EntityPlayer) {
                        player = (EntityPlayer)attacker;
                    }
                    if (player != null) {
                        if (flag) {
                            player.func_71009_b(targetEntity);
                        }
                        if (f1 > 0.0f) {
                            player.func_71047_c(targetEntity);
                        }
                        if (f >= 18.0f) {
                            player.func_71029_a((StatBase)AchievementList.field_75999_E);
                        }
                    }
                    attacker.func_130011_c(targetEntity);
                    if (targetEntity instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)targetEntity), (Entity)attacker);
                    }
                    EnchantmentHelper.func_151385_b((EntityLivingBase)attacker, (Entity)targetEntity);
                    ItemStack itemstack = attacker.func_70694_bm();
                    Entity object = targetEntity;
                    if (targetEntity instanceof EntityDragonPart && (ientitymultipart = ((EntityDragonPart)targetEntity).field_70259_a) instanceof EntityLivingBase) {
                        object = (EntityLivingBase)ientitymultipart;
                    }
                    if (player != null) {
                        if (itemstack != null && object instanceof EntityLivingBase) {
                            itemstack.func_77961_a((EntityLivingBase)object, player);
                            if (itemstack.field_77994_a <= 0) {
                                player.func_71028_bD();
                            }
                        }
                        if (targetEntity instanceof EntityLivingBase) {
                            player.func_71064_a(StatList.field_75951_w, Math.round(f * 10.0f));
                            if (i > 0) {
                                targetEntity.func_70015_d(i * 4);
                            }
                        }
                        player.func_71020_j(0.3f);
                    }
                } else if (flag1) {
                    targetEntity.func_70066_B();
                }
            }
        }
    }

    public static MovingObjectPosition getEntityLook(EntityLivingBase ent, double d) {
        return EntityHelperBase.getEntityLook(ent, d, false);
    }

    public static MovingObjectPosition getEntityLook(EntityLivingBase ent, double d, boolean ignoreEntities) {
        return EntityHelperBase.getEntityLook(ent, d, ignoreEntities, 1.0f);
    }

    public static MovingObjectPosition getEntityLook(EntityLivingBase ent, double d, boolean ignoreEntities, float renderTick) {
        double dd2;
        double d1 = d;
        MovingObjectPosition mop = EntityHelperBase.rayTrace(ent, d, renderTick);
        Vec3 vec3d = EntityHelperBase.getEntityPositionEyes((Entity)ent, renderTick);
        if (mop != null) {
            d1 = mop.field_72307_f.func_72438_d(vec3d);
        }
        if (d1 > (dd2 = d)) {
            d1 = dd2;
        }
        d = d1;
        Vec3 vec3d1 = ent.func_70676_i(renderTick);
        Vec3 vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * d, vec3d1.field_72448_b * d, vec3d1.field_72449_c * d);
        if (!ignoreEntities) {
            Entity entity1 = null;
            float f1 = 1.0f;
            List list = ent.field_70170_p.func_72839_b((Entity)ent, ent.func_174813_aQ().func_72321_a(vec3d1.field_72450_a * d, vec3d1.field_72448_b * d, vec3d1.field_72449_c * d).func_72314_b((double)f1, (double)f1, (double)f1));
            double d2 = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                double d3;
                Entity entity = (Entity)list.get(i);
                if (!entity.func_70067_L()) continue;
                float f2 = entity.func_70111_Y();
                AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72314_b((double)f2, (double)f2, (double)f2);
                MovingObjectPosition movingobjectposition = axisalignedbb.func_72327_a(vec3d, vec3d2);
                if (axisalignedbb.func_72318_a(vec3d)) {
                    if (!(0.0 < d2) && d2 != 0.0) continue;
                    entity1 = entity;
                    d2 = 0.0;
                    continue;
                }
                if (movingobjectposition == null || !((d3 = vec3d.func_72438_d(movingobjectposition.field_72307_f)) < d2) && d2 != 0.0) continue;
                entity1 = entity;
                d2 = d3;
            }
            if (entity1 != null) {
                mop = new MovingObjectPosition(entity1);
            }
        }
        return mop;
    }

    public static Vec3 getEntityPositionEyes(Entity ent, float partialTicks) {
        if (partialTicks == 1.0f) {
            return new Vec3(ent.field_70165_t, ent.field_70163_u + (double)ent.func_70047_e(), ent.field_70161_v);
        }
        double d0 = ent.field_70169_q + (ent.field_70165_t - ent.field_70169_q) * (double)partialTicks;
        double d1 = ent.field_70167_r + (ent.field_70163_u - ent.field_70167_r) * (double)partialTicks + (double)ent.func_70047_e();
        double d2 = ent.field_70166_s + (ent.field_70161_v - ent.field_70166_s) * (double)partialTicks;
        return new Vec3(d0, d1, d2);
    }

    public static MovingObjectPosition rayTrace(EntityLivingBase ent, double distance, float par3) {
        Vec3 var4 = EntityHelperBase.getEntityPositionEyes((Entity)ent, par3);
        Vec3 var5 = ent.func_70676_i(par3);
        Vec3 var6 = var4.func_72441_c(var5.field_72450_a * distance, var5.field_72448_b * distance, var5.field_72449_c * distance);
        return ent.field_70170_p.func_147447_a(var4, var6, false, false, true);
    }

    public static MovingObjectPosition rayTrace(World world, Vec3 vec3d, Vec3 vec3d1, boolean flag, boolean flag1, boolean goThroughTransparentBlocks) {
        return EntityHelperBase.rayTrace(world, vec3d, vec3d1, flag, flag1, goThroughTransparentBlocks, 200);
    }

    public static MovingObjectPosition rayTrace(World world, Vec3 vec3d, Vec3 vec3d1, boolean flag, boolean flag1, boolean goThroughTransparentBlocks, int distance) {
        MovingObjectPosition movingobjectposition;
        if (Double.isNaN(vec3d.field_72450_a) || Double.isNaN(vec3d.field_72448_b) || Double.isNaN(vec3d.field_72449_c)) {
            return null;
        }
        if (Double.isNaN(vec3d1.field_72450_a) || Double.isNaN(vec3d1.field_72448_b) || Double.isNaN(vec3d1.field_72449_c)) {
            return null;
        }
        int i = MathHelper.func_76128_c((double)vec3d1.field_72450_a);
        int j = MathHelper.func_76128_c((double)vec3d1.field_72448_b);
        int k = MathHelper.func_76128_c((double)vec3d1.field_72449_c);
        int l = MathHelper.func_76128_c((double)vec3d.field_72450_a);
        int i1 = MathHelper.func_76128_c((double)vec3d.field_72448_b);
        int j1 = MathHelper.func_76128_c((double)vec3d.field_72449_c);
        BlockPos blockpos = new BlockPos(l, i1, j1);
        IBlockState iblockstate = world.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        if ((!flag1 || block.func_180640_a(world, blockpos, iblockstate) != null) && block.func_176209_a(iblockstate, flag) && (movingobjectposition = block.func_180636_a(world, blockpos, vec3d, vec3d1)) != null) {
            return movingobjectposition;
        }
        int l1 = distance;
        while (l1-- >= 0) {
            MovingObjectPosition movingobjectposition1;
            EnumFacing enumfacing;
            if (Double.isNaN(vec3d.field_72450_a) || Double.isNaN(vec3d.field_72448_b) || Double.isNaN(vec3d.field_72449_c)) {
                return null;
            }
            if (l == i && i1 == j && j1 == k) {
                return null;
            }
            boolean flag5 = true;
            boolean flag3 = true;
            boolean flag4 = true;
            double d0 = 999.0;
            double d1 = 999.0;
            double d2 = 999.0;
            if (i > l) {
                d0 = (double)l + 1.0;
            } else if (i < l) {
                d0 = (double)l + 0.0;
            } else {
                flag5 = false;
            }
            if (j > i1) {
                d1 = (double)i1 + 1.0;
            } else if (j < i1) {
                d1 = (double)i1 + 0.0;
            } else {
                flag3 = false;
            }
            if (k > j1) {
                d2 = (double)j1 + 1.0;
            } else if (k < j1) {
                d2 = (double)j1 + 0.0;
            } else {
                flag4 = false;
            }
            double d3 = 999.0;
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = vec3d1.field_72450_a - vec3d.field_72450_a;
            double d7 = vec3d1.field_72448_b - vec3d.field_72448_b;
            double d8 = vec3d1.field_72449_c - vec3d.field_72449_c;
            if (flag5) {
                d3 = (d0 - vec3d.field_72450_a) / d6;
            }
            if (flag3) {
                d4 = (d1 - vec3d.field_72448_b) / d7;
            }
            if (flag4) {
                d5 = (d2 - vec3d.field_72449_c) / d8;
            }
            if (d3 == -0.0) {
                d3 = -1.0E-4;
            }
            if (d4 == -0.0) {
                d4 = -1.0E-4;
            }
            if (d5 == -0.0) {
                d5 = -1.0E-4;
            }
            if (d3 < d4 && d3 < d5) {
                enumfacing = i > l ? EnumFacing.WEST : EnumFacing.EAST;
                vec3d = new Vec3(d0, vec3d.field_72448_b + d7 * d3, vec3d.field_72449_c + d8 * d3);
            } else if (d4 < d5) {
                enumfacing = j > i1 ? EnumFacing.DOWN : EnumFacing.UP;
                vec3d = new Vec3(vec3d.field_72450_a + d6 * d4, d1, vec3d.field_72449_c + d8 * d4);
            } else {
                enumfacing = k > j1 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                vec3d = new Vec3(vec3d.field_72450_a + d6 * d5, vec3d.field_72448_b + d7 * d5, d2);
            }
            l = MathHelper.func_76128_c((double)vec3d.field_72450_a) - (enumfacing == EnumFacing.EAST ? 1 : 0);
            i1 = MathHelper.func_76128_c((double)vec3d.field_72448_b) - (enumfacing == EnumFacing.UP ? 1 : 0);
            j1 = MathHelper.func_76128_c((double)vec3d.field_72449_c) - (enumfacing == EnumFacing.SOUTH ? 1 : 0);
            blockpos = new BlockPos(l, i1, j1);
            IBlockState iblockstate1 = world.func_180495_p(blockpos);
            Block block1 = iblockstate1.func_177230_c();
            if (goThroughTransparentBlocks && EntityHelperBase.isTransparent(block1) || flag1 && block1.func_180640_a(world, blockpos, iblockstate1) == null || !block1.func_176209_a(iblockstate1, flag) || (movingobjectposition1 = block1.func_180636_a(world, blockpos, vec3d, vec3d1)) == null) continue;
            return movingobjectposition1;
        }
        return null;
    }

    public static boolean hasFuel(InventoryPlayer inventory, Item item, int damage, int amount) {
        if (amount <= 0) {
            return true;
        }
        int amountFound = 0;
        for (int var3 = 0; var3 < inventory.field_70462_a.length; ++var3) {
            if (inventory.field_70462_a[var3] == null || inventory.field_70462_a[var3].func_77973_b() != item || inventory.field_70462_a[var3].func_77952_i() != damage || (amountFound += inventory.field_70462_a[var3].field_77994_a) < amount) continue;
            return true;
        }
        return false;
    }

    public static boolean isTransparent(Block block) {
        return block.func_149717_k() != 255;
    }

    public static boolean isLookingAtMoon(World world, EntityLivingBase ent, float renderTick, boolean goThroughTransparentBlocks) {
        float f3;
        if (ent.field_71093_bK == -1 || ent.field_71093_bK == 1) {
            return false;
        }
        double de = 2.71828183;
        float f = world.func_72826_c(1.0f);
        if (!((double)f >= 0.26) || !((double)f <= 0.74)) {
            return false;
        }
        float f2 = f > 0.5f ? f - 0.5f : 0.5f - f;
        float f4 = f3 = ent.field_70177_z > 0.0f ? 270.0f : -90.0f;
        f3 = f > 0.5f ? (ent.field_70177_z > 0.0f ? 90.0f : -270.0f) : f3;
        float f5 = f = f > 0.5f ? 1.0f - f : f;
        if ((double)f <= 0.475) {
            de = 2.71828183;
        } else if ((double)f <= 0.4875) {
            de = 3.88377;
        } else if ((double)f <= 0.4935) {
            de = 4.91616;
        } else if ((double)f <= 0.4965) {
            de = 5.40624;
        } else if ((double)f <= 0.5) {
            de = 9.8;
        }
        boolean yawCheck = (double)(ent.field_70177_z % 360.0f) <= Math.pow(de, 4.92574 * (double)world.func_72826_c(1.0f)) + (double)f3 && (double)(ent.field_70177_z % 360.0f) >= -Math.pow(de, 4.92574 * (double)world.func_72826_c(1.0f)) + (double)f3;
        float ff = world.func_72826_c(1.0f);
        ff = ff > 0.5f ? 1.0f - ff : ff;
        ff -= 0.26f;
        ff = ff / 0.26f * -94.0f - 4.0f;
        boolean pitchCheck = ent.field_70125_A <= ff + 2.5f && ent.field_70125_A >= ff - 2.5f;
        Vec3 vec3d = EntityHelperBase.getEntityPositionEyes((Entity)ent, renderTick);
        Vec3 vec3d1 = ent.func_70676_i(renderTick);
        Vec3 vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * 500.0, vec3d1.field_72448_b * 500.0, vec3d1.field_72449_c * 500.0);
        boolean mopCheck = EntityHelperBase.rayTrace(ent.field_70170_p, vec3d, vec3d2, true, false, goThroughTransparentBlocks, 500) == null;
        return yawCheck && pitchCheck && mopCheck;
    }

    public static boolean consumeInventoryItem(InventoryPlayer inventory, Item item, int damage, int amount) {
        int var3;
        if (amount <= 0) {
            return true;
        }
        int amountFound = 0;
        for (var3 = 0; var3 < inventory.field_70462_a.length && (inventory.field_70462_a[var3] == null || inventory.field_70462_a[var3].func_77973_b() != item || inventory.field_70462_a[var3].func_77952_i() != damage || (amountFound += inventory.field_70462_a[var3].field_77994_a) < amount); ++var3) {
        }
        if (amountFound >= amount) {
            for (var3 = 0; var3 < inventory.field_70462_a.length; ++var3) {
                if (inventory.field_70462_a[var3] == null || inventory.field_70462_a[var3].func_77973_b() != item || inventory.field_70462_a[var3].func_77952_i() != damage) continue;
                while (amount > 0 && inventory.field_70462_a[var3] != null && inventory.field_70462_a[var3].field_77994_a > 0) {
                    --amount;
                    --inventory.field_70462_a[var3].field_77994_a;
                    if (inventory.field_70462_a[var3].field_77994_a <= 0) {
                        inventory.field_70462_a[var3] = null;
                    }
                    if (amount > 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String getDeathSound(Class clz, EntityLivingBase ent) {
        try {
            Method m = clz.getDeclaredMethod(ObfHelper.obfuscation ? "func_70673_aS" : "getDeathSound", new Class[0]);
            m.setAccessible(true);
            return (String)m.invoke((Object)ent, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            if (clz != EntityLivingBase.class) {
                return EntityHelperBase.getDeathSound(clz.getSuperclass(), ent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "game.neutral.die";
    }

    public static String getHurtSound(Class clz, EntityLivingBase ent) {
        try {
            Method m = clz.getDeclaredMethod(ObfHelper.obfuscation ? "func_70621_aR" : "getHurtSound", new Class[0]);
            m.setAccessible(true);
            return (String)m.invoke((Object)ent, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            if (clz != EntityLivingBase.class) {
                return EntityHelperBase.getHurtSound(clz.getSuperclass(), ent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "game.neutral.hurt";
    }

    public static float updateRotation(float oriRot, float intendedRot, float maxChange) {
        float var4 = MathHelper.func_76142_g((float)(intendedRot - oriRot));
        if (var4 > maxChange) {
            var4 = maxChange;
        }
        if (var4 < -maxChange) {
            var4 = -maxChange;
        }
        return oriRot + var4;
    }

    public static float interpolateRotation(float prevRotation, float nextRotation, float partialTick) {
        float f3;
        for (f3 = nextRotation - prevRotation; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return prevRotation + partialTick * f3;
    }

    public static float interpolateValues(float prevVal, float nextVal, float partialTick) {
        return prevVal + partialTick * (nextVal - prevVal);
    }

    public static void faceEntity(Entity facer, Entity faced, float maxYaw, float maxPitch) {
        double d2;
        double d0 = faced.field_70165_t - facer.field_70165_t;
        double d1 = faced.field_70161_v - facer.field_70161_v;
        if (faced instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)faced;
            d2 = entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() - (facer.field_70163_u + (double)facer.func_70047_e());
        } else {
            d2 = (faced.func_174813_aQ().field_72338_b + faced.func_174813_aQ().field_72337_e) / 2.0 - (facer.field_70163_u + (double)facer.func_70047_e());
        }
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        float f2 = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) - 90.0f;
        float f3 = (float)(-(Math.atan2(d2, d3) * 180.0 / Math.PI));
        facer.field_70125_A = EntityHelperBase.updateRotation(facer.field_70125_A, f3, maxPitch);
        facer.field_70177_z = EntityHelperBase.updateRotation(facer.field_70177_z, f2, maxYaw);
    }

    public static void setVelocity(Entity entity, double d, double d1, double d2) {
        entity.field_70159_w = d;
        entity.field_70181_x = d1;
        entity.field_70179_y = d2;
    }

    public static boolean destroyBlocksInAABB(Entity ent, AxisAlignedBB aabb) {
        int i = MathHelper.func_76128_c((double)aabb.field_72340_a);
        int j = MathHelper.func_76128_c((double)aabb.field_72338_b);
        int k = MathHelper.func_76128_c((double)aabb.field_72339_c);
        int l = MathHelper.func_76128_c((double)aabb.field_72336_d);
        int i1 = MathHelper.func_76128_c((double)aabb.field_72337_e);
        int j1 = MathHelper.func_76128_c((double)aabb.field_72334_f);
        boolean flag = false;
        boolean flag1 = false;
        for (int k1 = i; k1 <= l; ++k1) {
            for (int l1 = j; l1 <= i1; ++l1) {
                for (int i2 = k; i2 <= j1; ++i2) {
                    Block block = ent.field_70170_p.func_180495_p(new BlockPos(k1, l1, i2)).func_177230_c();
                    if (block == null) continue;
                    BlockPos blockPos = new BlockPos(k1, l1, i2);
                    if (block.func_176195_g(ent.field_70170_p, blockPos) >= 0.0f && block.canEntityDestroy((IBlockAccess)ent.field_70170_p, new BlockPos(k1, l1, i2), ent) && ent.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                        flag1 = ent.field_70170_p.field_72995_K || ent.field_70170_p.func_175698_g(new BlockPos(k1, l1, i2)) || flag1;
                        continue;
                    }
                    flag = true;
                }
            }
        }
        if (flag1) {
            double d0 = aabb.field_72340_a + (aabb.field_72336_d - aabb.field_72340_a) * (double)ent.field_70170_p.field_73012_v.nextFloat();
            double d1 = aabb.field_72338_b + (aabb.field_72337_e - aabb.field_72338_b) * (double)ent.field_70170_p.field_73012_v.nextFloat();
            double d2 = aabb.field_72339_c + (aabb.field_72334_f - aabb.field_72339_c) * (double)ent.field_70170_p.field_73012_v.nextFloat();
            ent.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
        return flag;
    }

    public static void addPosition(Entity living, double offset, boolean subtract, int axis) {
        if (axis == 0) {
            if (subtract) {
                living.field_70142_S -= offset;
                living.field_70169_q -= offset;
                living.field_70165_t -= offset;
            } else {
                living.field_70142_S += offset;
                living.field_70169_q += offset;
                living.field_70165_t += offset;
            }
        } else if (axis == 1) {
            if (subtract) {
                living.field_70137_T -= offset;
                living.field_70167_r -= offset;
                living.field_70163_u -= offset;
            } else {
                living.field_70137_T += offset;
                living.field_70167_r += offset;
                living.field_70163_u += offset;
            }
        } else if (axis == 2) {
            if (subtract) {
                living.field_70136_U -= offset;
                living.field_70166_s -= offset;
                living.field_70161_v -= offset;
            } else {
                living.field_70136_U += offset;
                living.field_70166_s += offset;
                living.field_70161_v += offset;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static Render getEntityClassRenderObject(Class par1Class) {
        Render render = (Render)Minecraft.func_71410_x().func_175598_ae().field_78729_o.get(par1Class);
        if (render == null && par1Class != Entity.class) {
            render = EntityHelperBase.getEntityClassRenderObject(par1Class.getSuperclass());
        }
        return render;
    }

    public static NBTTagCompound getPlayerPersistentData(EntityPlayer player) {
        NBTTagCompound persistentTag = player.getEntityData().func_74775_l("PlayerPersisted");
        player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)persistentTag);
        return persistentTag;
    }

    public static NBTTagCompound getPlayerPersistentData(EntityPlayer player, String name) {
        NBTTagCompound persistentTag = EntityHelperBase.getPlayerPersistentData(player).func_74775_l(name);
        EntityHelperBase.getPlayerPersistentData(player).func_74782_a(name, (NBTBase)persistentTag);
        return persistentTag;
    }

    static {
        nameToPartialProfileMap = new HashMap();
        nameToFullProfileMap = new HashMap();
    }
}

