/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.common.core.config;

import com.google.common.base.Splitter;
import com.google.common.collect.Ordering;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import us.ichun.mods.ichunutil.client.keybind.KeyBind;
import us.ichun.mods.ichunutil.common.core.config.ConfigHandler;
import us.ichun.mods.ichunutil.common.core.config.annotations.ConfigProp;
import us.ichun.mods.ichunutil.common.core.config.annotations.IntBool;
import us.ichun.mods.ichunutil.common.core.config.annotations.IntMinMax;
import us.ichun.mods.ichunutil.common.core.config.annotations.StringValues;
import us.ichun.mods.ichunutil.common.core.config.types.Colour;
import us.ichun.mods.ichunutil.common.core.config.types.NestedIntArray;
import us.ichun.mods.ichunutil.common.core.packet.mod.PacketSession;
import us.ichun.mods.ichunutil.common.iChunUtil;

public abstract class ConfigBase
implements Comparable {
    private Configuration config;
    public boolean setup;
    public ArrayList<String> propsToReveal = new ArrayList();
    public ArrayList<Field> unchangable = new ArrayList();
    public ArrayList<Field> sessionProp = new ArrayList();
    public TreeMap<CategoryInfo, ArrayList<PropInfo>> categories = new TreeMap(Ordering.natural());
    public HashMap<Field, Object> session = new HashMap();
    public HashMap<Field, Object> configScreen = new HashMap();

    public ConfigBase(File file, String ... unhide) {
        this.config = new Configuration(file);
        this.config.load();
        for (String s : unhide) {
            this.propsToReveal.add(s);
        }
    }

    public abstract String getModId();

    public abstract String getModName();

    public void read() {
        this.readFields(false);
        this.setCategoryComments();
    }

    public void readFields(boolean write) {
        Field[] fields;
        for (Field field : fields = this.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (Modifier.isTransient(field.getModifiers()) || !field.isAnnotationPresent(ConfigProp.class)) continue;
            this.readProperty(field, write);
        }
    }

    public void readProperty(Field field, boolean write) {
        String comment;
        ConfigProp propInfo = field.getAnnotation(ConfigProp.class);
        if (propInfo.hidden() && !this.propsToReveal.contains(field.getName()) || propInfo.side().isClient() && FMLCommonHandler.instance().getSide().isServer()) {
            return;
        }
        Class<?> clz = field.getType();
        CategoryInfo info = new CategoryInfo(clz.equals(KeyBind.class) ? "keybind" : propInfo.category());
        ArrayList<Object> fields = null;
        for (Map.Entry<CategoryInfo, ArrayList<PropInfo>> e : this.categories.entrySet()) {
            CategoryInfo inf = e.getKey();
            if (!inf.category.equals(info.category)) continue;
            info = inf;
            fields = e.getValue();
            break;
        }
        if (fields == null) {
            fields = new ArrayList();
            this.categories.put(info, fields);
        }
        String string = comment = propInfo.comment().equals("undefined") ? StatCollector.func_74838_a((String)(this.getModId().toLowerCase() + ".config.prop." + field.getName() + ".comment")) : StatCollector.func_74838_a((String)propInfo.comment());
        if (Splitter.on((String)".").splitToList((CharSequence)comment).size() >= 2 && !comment.contains(" ") && !this.setup) {
            iChunUtil.logger.warn("Config property " + field.getName() + " from mod " + this.getModName() + " may not be localized!");
        }
        String commentLocal = StatCollector.func_74838_a((String)comment);
        List cms = Splitter.on((String)"\\n").splitToList((CharSequence)commentLocal);
        String cm = "";
        for (int ll = 0; ll < cms.size(); ++ll) {
            cm = cm + cms.get(ll);
            if (ll == cms.size() - 1) continue;
            cm = cm + "\n";
        }
        comment = cm;
        try {
            int min;
            if (clz.equals(Integer.TYPE)) {
                min = Integer.MIN_VALUE;
                int max = Integer.MAX_VALUE;
                if (field.isAnnotationPresent(IntMinMax.class)) {
                    IntMinMax minMax = field.getAnnotation(IntMinMax.class);
                    min = minMax.min();
                    max = minMax.max();
                } else if (field.isAnnotationPresent(IntBool.class)) {
                    min = 0;
                    max = 1;
                }
                if (write) {
                    this.config.get(propInfo.category(), field.getName(), field.getInt(this)).set(field.getInt(this));
                    this.config.get((String)propInfo.category(), (String)field.getName(), (int)field.getInt((Object)this)).comment = comment;
                } else {
                    field.set(this, this.config.getInt(field.getName(), propInfo.category(), field.getInt(this), min, max, comment));
                }
            } else if (clz.equals(int[].class)) {
                min = Integer.MIN_VALUE;
                int max = Integer.MAX_VALUE;
                if (field.isAnnotationPresent(IntMinMax.class)) {
                    IntMinMax minMax = field.getAnnotation(IntMinMax.class);
                    min = minMax.min();
                    max = minMax.max();
                }
                if (write) {
                    this.config.get(propInfo.category(), field.getName(), (int[])field.get(this)).set((int[])field.get(this));
                    this.config.get((String)propInfo.category(), (String)field.getName(), (int[])((int[])field.get((Object)this))).comment = comment;
                } else {
                    field.set(this, this.config.get(propInfo.category(), field.getName(), (int[])field.get(this), comment, min, max).getIntList());
                }
            } else if (clz.equals(NestedIntArray.class)) {
                NestedIntArray nestedIntArray = (NestedIntArray)field.get(this);
                int min2 = Integer.MIN_VALUE;
                int max = Integer.MAX_VALUE;
                int nMin = Integer.MIN_VALUE;
                int nMax = Integer.MAX_VALUE;
                if (field.isAnnotationPresent(IntMinMax.class)) {
                    IntMinMax minMax = field.getAnnotation(IntMinMax.class);
                    min2 = minMax.min();
                    max = minMax.max();
                    nMin = minMax.nestedMin();
                    nMax = minMax.nestedMax();
                }
                if (write) {
                    this.config.get(propInfo.category(), field.getName(), nestedIntArray.serialize()).set(nestedIntArray.serialize());
                    this.config.get((String)propInfo.category(), (String)field.getName(), (String)nestedIntArray.serialize()).comment = comment;
                } else {
                    nestedIntArray.deserialize(this.config.getString(field.getName(), propInfo.category(), nestedIntArray.serialize(), comment), min2, max, nMin, nMax);
                }
            } else if (clz.equals(Colour.class)) {
                Colour clr = (Colour)field.get(this);
                if (write) {
                    this.config.get(propInfo.category(), field.getName(), clr.serialize()).set(clr.serialize());
                    this.config.get((String)propInfo.category(), (String)field.getName(), (String)clr.serialize()).comment = comment;
                } else {
                    clr.deserialize(this.config.getString(field.getName(), propInfo.category(), ((Colour)field.get(this)).serialize(), comment));
                }
            } else if (clz.equals(String.class)) {
                if (write) {
                    this.config.get(propInfo.category(), field.getName(), (String)field.get(this)).set((String)field.get(this));
                    this.config.get((String)propInfo.category(), (String)field.getName(), (String)((String)field.get((Object)this))).comment = comment;
                } else if (field.isAnnotationPresent(StringValues.class)) {
                    StringValues minMax = field.getAnnotation(StringValues.class);
                    field.set(this, this.config.getString(field.getName(), propInfo.category(), (String)field.get(this), comment, minMax.values()));
                } else {
                    field.set(this, this.config.getString(field.getName(), propInfo.category(), (String)field.get(this), comment));
                }
            } else if (clz.equals(String[].class)) {
                if (write) {
                    this.config.get(propInfo.category(), field.getName(), (String[])field.get(this)).set((String[])field.get(this));
                    this.config.get((String)propInfo.category(), (String)field.getName(), (String[])((String[])field.get((Object)this))).comment = comment;
                } else if (field.isAnnotationPresent(StringValues.class)) {
                    StringValues minMax = field.getAnnotation(StringValues.class);
                    field.set(this, this.config.getStringList(field.getName(), propInfo.category(), (String[])field.get(this), comment, minMax.values()));
                } else {
                    field.set(this, this.config.getStringList(field.getName(), propInfo.category(), (String[])field.get(this), comment));
                }
            } else if (clz.equals(KeyBind.class)) {
                KeyBind bind = (KeyBind)field.get(this);
                if (write) {
                    ConfigHandler.configKeybind.get("keybinds", this.getModId().toLowerCase() + "." + field.getName(), bind.serialize()).set(bind.serialize());
                    ConfigHandler.configKeybind.get((String)"keybinds", (String)new StringBuilder().append((String)this.getModId().toLowerCase()).append((String)".").append((String)field.getName()).toString(), (String)bind.serialize()).comment = comment;
                } else {
                    bind.deserialize(ConfigHandler.configKeybind.getString(this.getModId().toLowerCase() + "." + field.getName(), "keybinds", bind.serialize(), comment));
                    bind = iChunUtil.proxy.registerKeyBind(bind, null);
                    field.set(this, bind);
                }
            } else {
                return;
            }
            PropInfo propInfo1 = new PropInfo(!propInfo.nameOverride().isEmpty() ? propInfo.nameOverride() : StatCollector.func_74838_a((String)(this.getModId().toLowerCase() + ".config.prop." + field.getName() + ".name")), comment, field);
            if (!this.setup && !fields.contains(propInfo1)) {
                fields.add(propInfo1);
            }
            if (!propInfo.changeable() && !this.unchangable.contains(field)) {
                this.unchangable.add(field);
            }
            if (propInfo.useSession() && !this.sessionProp.contains(field)) {
                this.sessionProp.add(field);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCategoryComments() {
        for (Map.Entry<CategoryInfo, ArrayList<PropInfo>> e : this.categories.entrySet()) {
            String comment;
            CategoryInfo info = e.getKey();
            String cat = info.category;
            if (cat.equals("general") || cat.equals("gameplay") || cat.equals("globalOptions") || cat.equals("serverOptions") || cat.equals("clientOnly") || cat.equals("keybind") || cat.equals("block")) {
                info.name = StatCollector.func_74838_a((String)String.format("ichunutil.config.cat.%s.name", cat));
                comment = StatCollector.func_74838_a((String)String.format("ichunutil.config.cat.%s.comment", cat));
            } else {
                info.name = StatCollector.func_74838_a((String)(this.getModId().toLowerCase() + ".config.cat." + cat + ".name"));
                comment = StatCollector.func_74838_a((String)(this.getModId().toLowerCase() + ".config.cat." + cat + ".comment"));
            }
            info.comment = comment;
            this.config.setCategoryComment(cat, comment);
        }
    }

    public void storeSession() {
        for (Field field : this.sessionProp) {
            try {
                field.setAccessible(true);
                this.session.put(field, field.get(this));
            }
            catch (Exception exception) {}
        }
    }

    public void resetSession() {
        for (Map.Entry<Field, Object> e : this.session.entrySet()) {
            try {
                e.getKey().setAccessible(true);
                e.getKey().set(this, e.getValue());
            }
            catch (Exception exception) {}
        }
    }

    public void sendPlayerSession(EntityPlayer player) {
        iChunUtil.channel.sendToPlayer(new PacketSession(this), player);
    }

    public void updateSessionToAllPlayers() {
        iChunUtil.channel.sendToAll(new PacketSession(this));
    }

    public void onReceiveSession() {
    }

    public void onSessionChange(Field field, Object original) {
    }

    public void enterConfigScreen() {
        for (Field field : this.sessionProp) {
            try {
                field.setAccessible(true);
                this.configScreen.put(field, field.get(this));
            }
            catch (Exception exception) {}
        }
        this.resetSession();
    }

    public void exitConfigScreen() {
        this.storeSession();
        for (Map.Entry<Field, Object> e : this.configScreen.entrySet()) {
            try {
                e.getKey().setAccessible(true);
                e.getKey().set(this, e.getValue());
            }
            catch (Exception exception) {}
        }
        this.configScreen.clear();
    }

    public void reveal(String ... toReveal) {
        boolean add = false;
        for (String s : toReveal) {
            if (this.propsToReveal.contains(s)) continue;
            this.propsToReveal.add(s);
            add = true;
        }
        if (add) {
            this.read();
            this.save();
        }
    }

    public void onConfigChange(Field field, Object original) {
    }

    public void setup() {
        this.setup = true;
        this.save(false);
    }

    public void save(boolean readFields) {
        if (readFields) {
            this.readFields(true);
        }
        if (this.setup && this.config.hasChanged()) {
            this.config.save();
        }
    }

    public void save() {
        this.save(true);
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof ConfigBase) {
            ConfigBase cfg = (ConfigBase)arg0;
            return this.getModName().compareTo(cfg.getModName());
        }
        return 0;
    }

    public boolean equals(Object o) {
        return o.getClass() == this.getClass() && ((ConfigBase)o).getModName().equals(this.getModName());
    }

    public class PropInfo
    implements Comparable {
        public final String name;
        public final String comment;
        public final Field field;

        public PropInfo(String name, String comment, Field field) {
            this.name = name;
            this.comment = comment;
            this.field = field;
        }

        public boolean equals(Object o) {
            if (o instanceof PropInfo) {
                PropInfo cfg = (PropInfo)o;
                return this.name.equals(cfg.name) && this.comment.equals(cfg.comment) && this.field.equals(cfg.field);
            }
            return false;
        }

        public int compareTo(Object o) {
            if (o instanceof PropInfo) {
                PropInfo cfg = (PropInfo)o;
                return this.name.compareTo(cfg.name);
            }
            return 0;
        }
    }

    public class CategoryInfo
    implements Comparable {
        public final String category;
        public String name;
        public String comment;

        public CategoryInfo(String cat) {
            this.category = this.name = cat;
        }

        public int compareTo(Object arg0) {
            if (arg0 instanceof CategoryInfo) {
                CategoryInfo cfg = (CategoryInfo)arg0;
                return this.category.compareTo(cfg.category);
            }
            return 0;
        }
    }
}

