/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.common.core.packet.mod;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import us.ichun.mods.ichunutil.common.core.config.ConfigBase;
import us.ichun.mods.ichunutil.common.core.config.ConfigHandler;
import us.ichun.mods.ichunutil.common.core.config.types.Colour;
import us.ichun.mods.ichunutil.common.core.config.types.NestedIntArray;
import us.ichun.mods.ichunutil.common.core.network.AbstractPacket;

public class PacketSession
extends AbstractPacket {
    public ConfigBase config;
    public String modId;
    public HashMap<String, Object> vars;

    public PacketSession() {
    }

    public PacketSession(ConfigBase config) {
        this.config = config;
    }

    @Override
    public void writeTo(ByteBuf buffer, Side side) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.config.getModId());
        for (Map.Entry<Field, Object> e : this.config.session.entrySet()) {
            int i;
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)e.getKey().getName());
            Object obj = e.getValue();
            Class<?> clz = obj.getClass();
            if (clz.equals(Integer.TYPE) || clz.equals(Integer.class)) {
                buffer.writeInt(0);
                buffer.writeInt(((Integer)obj).intValue());
                continue;
            }
            if (clz.equals(int[].class)) {
                buffer.writeInt(1);
                int[] ints = (int[])obj;
                buffer.writeInt(ints.length);
                for (i = 0; i < ints.length; ++i) {
                    buffer.writeInt(ints[i]);
                }
                continue;
            }
            if (clz.equals(NestedIntArray.class)) {
                buffer.writeInt(2);
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)((NestedIntArray)obj).serialize());
                continue;
            }
            if (clz.equals(Colour.class)) {
                buffer.writeInt(3);
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)((Colour)obj).serialize());
                continue;
            }
            if (clz.equals(String.class)) {
                buffer.writeInt(4);
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)((String)obj));
                continue;
            }
            if (clz.equals(String[].class)) {
                buffer.writeInt(5);
                String[] strings = (String[])obj;
                buffer.writeInt(strings.length);
                for (i = 0; i < strings.length; ++i) {
                    ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)strings[i]);
                }
                continue;
            }
            throw new RuntimeException("Trying to send an unsupported field for a session: " + clz.getName());
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)"##endPacket");
    }

    @Override
    public void readFrom(ByteBuf buffer, Side side) {
        this.modId = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.vars = new HashMap();
        String var = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        while (!var.equals("##endPacket")) {
            int i;
            Object ints;
            int type = buffer.readInt();
            if (type == 0) {
                this.vars.put(var, buffer.readInt());
            } else if (type == 1) {
                ints = new int[buffer.readInt()];
                for (i = 0; i < ((int[])ints).length; ++i) {
                    ints[i] = buffer.readInt();
                }
                this.vars.put(var, ints);
            } else if (type == 2) {
                ints = new NestedIntArray(new TreeMap<Integer, ArrayList<Integer>>());
                ints.deserialize(ByteBufUtils.readUTF8String((ByteBuf)buffer), Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
                this.vars.put(var, ints);
            } else if (type == 3) {
                Colour clr = new Colour(0);
                clr.deserialize(ByteBufUtils.readUTF8String((ByteBuf)buffer));
                this.vars.put(var, clr);
            } else if (type == 4) {
                this.vars.put(var, ByteBufUtils.readUTF8String((ByteBuf)buffer));
            } else if (type == 5) {
                ints = new String[buffer.readInt()];
                for (i = 0; i < ((int[])ints).length; ++i) {
                    ints[i] = (int)ByteBufUtils.readUTF8String((ByteBuf)buffer);
                }
                this.vars.put(var, ints);
            }
            var = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        }
    }

    @Override
    public void execute(Side side, EntityPlayer player) {
        for (ConfigBase conf : ConfigHandler.configs) {
            if (!conf.getModId().equals(this.modId)) continue;
            for (Field field : conf.sessionProp) {
                try {
                    field.setAccessible(true);
                    if (!this.vars.containsKey(field.getName())) continue;
                    Object ori = field.get(conf);
                    field.set(conf, this.vars.get(field.getName()));
                    conf.onSessionChange(field, ori);
                }
                catch (Exception exception) {}
            }
            conf.onReceiveSession();
            break;
        }
    }
}

