/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.common.module.tabula.common.project;

import com.google.gson.Gson;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.PositionTextureVertex;
import net.minecraft.client.model.TextureOffset;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import us.ichun.mods.ichunutil.client.model.ModelHelper;
import us.ichun.mods.ichunutil.common.iChunUtil;
import us.ichun.mods.ichunutil.common.module.tabula.client.model.ModelBaseDummy;
import us.ichun.mods.ichunutil.common.module.tabula.client.model.ModelInfo;
import us.ichun.mods.ichunutil.common.module.tabula.common.project.components.Animation;
import us.ichun.mods.ichunutil.common.module.tabula.common.project.components.CubeGroup;
import us.ichun.mods.ichunutil.common.module.tabula.common.project.components.CubeInfo;

public class ProjectInfo {
    public static final int IDENTIFIER_LENGTH = 20;
    public static final int PROJ_VERSION = 4;
    public transient String identifier;
    public transient File saveFile;
    public transient String saveFileMd5;
    public transient boolean saved;
    public transient boolean tampered;
    public transient int lastAutosave;
    public transient boolean autosaved;
    public transient float cameraFov = 30.0f;
    public transient float cameraZoom = 1.0f;
    public transient float cameraYaw;
    public transient float cameraPitch;
    public transient float cameraOffsetX;
    public transient float cameraOffsetY;
    public transient boolean ignoreNextImage;
    public transient File textureFile;
    public transient String textureFileMd5;
    public transient BufferedImage bufferedTexture;
    public transient int bufferedTextureId = -1;
    public transient boolean destroyed;
    public transient ArrayList<String> states;
    public transient int lastState;
    public transient int switchState = -1;
    @SideOnly(value=Side.CLIENT)
    public transient ModelBaseDummy model;
    public transient ProjectInfo ghostModel;
    public String modelName = "";
    public String authorName = "";
    public int projVersion;
    public ArrayList<String> metadata;
    public int textureWidth = 64;
    public int textureHeight = 32;
    public double[] scale = new double[]{1.0, 1.0, 1.0};
    public ArrayList<CubeGroup> cubeGroups;
    public ArrayList<CubeInfo> cubes;
    public ArrayList<Animation> anims;
    public int cubeCount;

    public ProjectInfo() {
        this.metadata = new ArrayList();
        this.cubeGroups = new ArrayList();
        this.cubes = new ArrayList();
        this.anims = new ArrayList();
        this.states = new ArrayList();
    }

    public ProjectInfo(String name, String author) {
        this();
        this.modelName = name;
        this.authorName = author;
        this.cubeGroups = new ArrayList();
        this.cubes = new ArrayList();
    }

    public String getAsJson() {
        Gson gson = new Gson();
        return gson.toJson((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void initClient() {
        int i;
        this.model = new ModelBaseDummy(this);
        for (i = 0; i < this.cubeGroups.size(); ++i) {
            this.createGroupCubes(this.cubeGroups.get(i));
        }
        for (i = 0; i < this.cubes.size(); ++i) {
            this.model.cubes.add(this.cubes.get(i).createModel(this.model));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void destroy() {
        if (this.model != null && !this.destroyed) {
            this.destroyed = true;
            for (int i = this.model.cubes.size() - 1; i >= 0; --i) {
                this.model.removeCubeInfo(this.model.cubes.get(i));
            }
            this.model.rotationPoint.destroy();
            this.model.rotationControls.destroy();
            this.model.sizeControls.destroy();
            if (this.bufferedTextureId != -1) {
                TextureUtil.func_147942_a((int)this.bufferedTextureId);
            }
        }
        if (this.ghostModel != null) {
            this.ghostModel.destroy();
        }
    }

    public ArrayList<CubeInfo> getAllCubes() {
        ArrayList<CubeInfo> cubes = new ArrayList<CubeInfo>();
        this.addAllCubes(cubes, this.cubes);
        this.addAllCubesFromGroups(cubes, this.cubeGroups);
        return cubes;
    }

    public void addAllCubes(ArrayList<CubeInfo> list, ArrayList<CubeInfo> cubes) {
        list.addAll(cubes);
        for (CubeInfo cube : cubes) {
            this.addAllCubes(list, cube.getChildren());
        }
    }

    public void addAllCubesFromGroups(ArrayList<CubeInfo> list, ArrayList<CubeGroup> groups) {
        for (CubeGroup group : groups) {
            this.addAllCubes(list, group.cubes);
            this.addAllCubesFromGroups(list, group.cubeGroups);
        }
    }

    public void createNewGroup() {
        this.cubeGroups.add(new CubeGroup("Group"));
    }

    public void createNewCube() {
        ++this.cubeCount;
        this.cubes.add(new CubeInfo("shape" + Integer.toString(this.cubeCount)));
    }

    public void createNewAnimation(String name, boolean loop) {
        Animation anim = new Animation(name);
        anim.loops = loop;
        this.anims.add(anim);
    }

    private void createGroupCubes(CubeGroup group) {
        int i;
        for (i = 0; i < group.cubeGroups.size(); ++i) {
            this.createGroupCubes(group.cubeGroups.get(i));
        }
        for (i = 0; i < group.cubes.size(); ++i) {
            this.model.cubes.add(group.cubes.get(i).createModel(this.model));
        }
    }

    public Object getObjectByIdent(String ident) {
        Object obj = null;
        for (CubeInfo inf : this.cubes) {
            if (obj != null) continue;
            obj = this.findObjectInCube(ident, inf);
        }
        for (CubeGroup group1 : this.cubeGroups) {
            if (obj != null) continue;
            obj = this.findObjectInGroup(ident, group1);
        }
        return obj;
    }

    public Object findObjectInCube(String ident, CubeInfo cube) {
        if (cube.identifier.equals(ident)) {
            return cube;
        }
        Object obj = null;
        for (CubeInfo inf : cube.getChildren()) {
            if (obj != null) continue;
            obj = this.findObjectInCube(ident, inf);
        }
        return obj;
    }

    public Object findObjectInGroup(String ident, CubeGroup group) {
        if (group.identifier.equals(ident)) {
            return group;
        }
        Object obj = null;
        for (CubeInfo inf : group.cubes) {
            if (obj != null) continue;
            obj = this.findObjectInCube(ident, inf);
        }
        for (CubeGroup group1 : group.cubeGroups) {
            if (obj != null) continue;
            obj = this.findObjectInGroup(ident, group1);
        }
        return obj;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean importModel(ModelInfo model, boolean texture) {
        for (Map.Entry<String, ModelRenderer> e : model.modelList.entrySet()) {
            ModelRenderer rend = e.getValue();
            if (this.cubes.isEmpty()) {
                this.textureHeight = (int)rend.field_78799_b;
                this.textureWidth = (int)rend.field_78801_a;
            }
            CubeInfo firstCreated = null;
            if (rend.field_78804_l.isEmpty()) {
                CubeInfo info = new CubeInfo(e.getKey());
                info.dimensions[2] = 0;
                info.dimensions[1] = 0;
                info.dimensions[0] = 0;
                info.scale[2] = 1.0;
                info.scale[1] = 1.0;
                info.scale[0] = 1.0;
                ++this.cubeCount;
                this.cubes.add(info);
                firstCreated = info;
            } else {
                for (int j = 0; j < rend.field_78804_l.size(); ++j) {
                    ModelBox box = (ModelBox)rend.field_78804_l.get(j);
                    CubeInfo info = ModelHelper.createCubeInfoFromModelBox(rend, box, box.field_78247_g != null ? box.field_78247_g.substring(box.field_78247_g.lastIndexOf(".") + 1) : e.getKey() + (rend.field_78804_l.size() == 1 ? "" : " - " + j));
                    ++this.cubeCount;
                    this.cubes.add(info);
                    if (firstCreated != null) continue;
                    firstCreated = info;
                }
            }
            if (firstCreated == null) continue;
            this.createChildren(e.getKey(), rend, firstCreated);
        }
        if (texture) {
            if (model.texture != null) {
                InputStream inputstream = null;
                try {
                    IResource iresource = Minecraft.func_71410_x().field_110451_am.func_110536_a(model.texture);
                    inputstream = iresource.func_110527_b();
                    this.bufferedTexture = ImageIO.read(inputstream);
                    if (this.bufferedTexture != null) {
                        Iterator<Map.Entry<String, ModelRenderer>> iterator = model.modelList.entrySet().iterator();
                        if (iterator.hasNext()) {
                            Map.Entry<String, ModelRenderer> e = iterator.next();
                            ModelRenderer rend = e.getValue();
                            this.textureHeight = (int)rend.field_78799_b;
                            this.textureWidth = (int)rend.field_78801_a;
                        }
                        return true;
                    }
                }
                catch (Exception exception) {}
            } else {
                this.bufferedTexture = null;
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void createChildren(String name, ModelRenderer rend, CubeInfo info) {
        if (rend.field_78805_m == null) {
            return;
        }
        for (int i = 0; i < rend.field_78805_m.size(); ++i) {
            CubeInfo firstCreated = null;
            ModelRenderer rend1 = (ModelRenderer)rend.field_78805_m.get(i);
            for (int j = 0; j < rend1.field_78804_l.size(); ++j) {
                TextureOffset textureoffset;
                String fullName = name + (rend1.field_78804_l.size() == 1 ? "Child" : "Child - " + j);
                ModelBox box = (ModelBox)rend1.field_78804_l.get(j);
                if (box.field_78247_g != null) {
                    fullName = box.field_78247_g.substring(box.field_78247_g.lastIndexOf(".") + 1);
                }
                CubeInfo info1 = new CubeInfo(fullName);
                info1.dimensions[0] = (int)Math.abs(box.field_78248_d - box.field_78252_a);
                info1.dimensions[1] = (int)Math.abs(box.field_78249_e - box.field_78250_b);
                info1.dimensions[2] = (int)Math.abs(box.field_78246_f - box.field_78251_c);
                info1.position[0] = rend1.field_78800_c;
                info1.position[1] = rend1.field_78797_d;
                info1.position[2] = rend1.field_78798_e;
                info1.offset[0] = box.field_78252_a;
                info1.offset[1] = box.field_78250_b;
                info1.offset[2] = box.field_78251_c;
                info1.rotation[0] = Math.toDegrees(rend1.field_78795_f);
                info1.rotation[1] = Math.toDegrees(rend1.field_78796_g);
                info1.rotation[2] = Math.toDegrees(rend1.field_78808_h);
                info1.scale[2] = 1.0;
                info1.scale[1] = 1.0;
                info1.scale[0] = 1.0;
                info1.txOffset[0] = rend1.field_78803_o;
                info1.txOffset[1] = rend1.field_78813_p;
                if (box.field_78247_g != null && (textureoffset = rend1.field_78810_s.func_78084_a(box.field_78247_g)) != null) {
                    info1.txOffset[0] = textureoffset.field_78783_a;
                    info1.txOffset[1] = textureoffset.field_78782_b;
                }
                PositionTextureVertex[] vertices = box.field_78254_i[1].field_78239_a;
                info1.txMirror = (vertices[info1.txMirror ? 1 : 2].field_78243_a.field_72448_b - vertices[info1.txMirror ? 3 : 0].field_78243_a.field_72448_b - (double)info1.dimensions[1]) / 2.0 < 0.0;
                ++this.cubeCount;
                info.addChild(info1);
                if (firstCreated != null) continue;
                firstCreated = info1;
            }
            if (firstCreated == null) continue;
            this.createChildren(name + "Child", rend1, firstCreated);
        }
    }

    public void cloneFrom(ProjectInfo info) {
        this.saveFile = info.saveFile;
        this.saveFileMd5 = info.saveFileMd5;
        this.textureFile = info.textureFile;
        this.ignoreNextImage = info.ignoreNextImage;
        this.bufferedTexture = info.bufferedTexture;
        this.cameraFov = info.cameraFov;
        this.cameraZoom = info.cameraZoom;
        this.cameraYaw = info.cameraYaw;
        this.cameraPitch = info.cameraPitch;
        this.cameraOffsetX = info.cameraOffsetX;
        this.cameraOffsetY = info.cameraOffsetY;
        this.lastAutosave = info.lastAutosave;
    }

    public void inherit(ProjectInfo info) {
        this.cloneFrom(info);
        this.identifier = info.identifier;
        this.textureFileMd5 = info.textureFileMd5;
        this.states = info.states;
        this.lastState = info.lastState;
        this.projVersion = info.projVersion;
        this.textureWidth = info.textureWidth;
        this.textureHeight = info.textureHeight;
        this.switchState = info.switchState;
    }

    public float getMaximumSize() {
        ArrayList<CubeInfo> allCubes = this.getAllCubes();
        double minX = 0.0;
        double minY = 0.0;
        double minZ = 0.0;
        double maxX = 0.0;
        double maxY = 0.0;
        double maxZ = 0.0;
        for (CubeInfo info : allCubes) {
            if ((info.position[0] + info.offset[0]) * info.scale[0] < minX) {
                minX = (info.position[0] + info.offset[0]) * info.scale[0];
            }
            if (((double)info.dimensions[0] + info.position[0] + info.offset[0]) * info.scale[0] > maxX) {
                maxX = ((double)info.dimensions[0] + info.position[0] + info.offset[0]) * info.scale[0];
            }
            if ((info.position[1] + info.offset[1]) * info.scale[1] < minY) {
                minY = (info.position[1] + info.offset[1]) * info.scale[1];
            }
            if (((double)info.dimensions[1] + info.position[1] + info.offset[1]) * info.scale[1] > maxY) {
                maxY = ((double)info.dimensions[1] + info.position[1] + info.offset[1]) * info.scale[1];
            }
            if ((info.position[2] + info.offset[2]) * info.scale[2] < minZ) {
                minZ = (info.position[2] + info.offset[2]) * info.scale[2];
            }
            if (!(((double)info.dimensions[2] + info.position[2] + info.offset[2]) * info.scale[2] > maxZ)) continue;
            maxZ = ((double)info.dimensions[2] + info.position[2] + info.offset[2]) * info.scale[2];
        }
        return (float)Math.max((maxX - minX) / this.scale[0], Math.max((maxY - minY) / (this.scale[1] * 2.0), (maxZ - minZ) / this.scale[2]));
    }

    public ProjectInfo repair() {
        while (this.projVersion < 4) {
            if (this.projVersion == 1) {
                this.scale = new double[]{1.0, 1.0, 1.0};
                for (CubeInfo info : this.getAllCubes()) {
                    info.opacity = 100.0;
                }
            } else if (this.projVersion == 2) {
                this.metadata = new ArrayList();
            } else if (this.projVersion == 3) {
                for (CubeGroup group : this.cubeGroups) {
                    group.metadata = new ArrayList();
                }
                ArrayList<CubeInfo> cubes = this.getAllCubes();
                for (CubeInfo info : cubes) {
                    info.metadata = new ArrayList();
                }
            }
            ++this.projVersion;
        }
        return this;
    }

    public static boolean saveProject(ProjectInfo info, File file) {
        try {
            file.getParentFile().mkdirs();
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(file));
            out.setLevel(9);
            out.putNextEntry(new ZipEntry("model.json"));
            byte[] data = new Gson().toJson((Object)info).getBytes();
            out.write(data, 0, data.length);
            out.closeEntry();
            if (info.bufferedTexture != null) {
                out.putNextEntry(new ZipEntry("texture.png"));
                ImageIO.write((RenderedImage)info.bufferedTexture, "png", out);
                out.closeEntry();
            }
            out.close();
            info.saved = true;
            return true;
        }
        catch (Exception e) {
            iChunUtil.logger.warn("Failed to save model: " + info.modelName);
            e.printStackTrace();
            return false;
        }
    }
}

