/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.common.module.tabula.common.project.components;

import java.util.ArrayList;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.RandomStringUtils;

public class CubeInfo {
    public String name;
    public int[] dimensions = new int[3];
    public double[] position = new double[3];
    public double[] offset = new double[3];
    public double[] rotation = new double[3];
    public double[] scale = new double[3];
    public int[] txOffset = new int[2];
    public boolean txMirror = false;
    public double mcScale = 0.0;
    public double opacity = 100.0;
    public boolean hidden = false;
    public ArrayList<String> metadata = new ArrayList();
    private ArrayList<CubeInfo> children = new ArrayList();
    public String parentIdentifier;
    public String identifier;
    @SideOnly(value=Side.CLIENT)
    public transient ModelRenderer modelCube;

    public CubeInfo(String name) {
        this.name = name;
        this.dimensions = new int[]{1, 1, 1};
        this.scale = new double[]{1.0, 1.0, 1.0};
        this.opacity = 100.0;
        this.identifier = RandomStringUtils.randomAscii((int)20);
    }

    public void addChild(CubeInfo info) {
        this.children.add(info);
        info.scale = new double[]{1.0, 1.0, 1.0};
        info.mcScale = 0.0;
        info.opacity = this.opacity;
        info.parentIdentifier = this.identifier;
        info.hidden = false;
    }

    public void removeChild(CubeInfo info) {
        this.children.remove(info);
        if (info.parentIdentifier != null && info.parentIdentifier.equals(this.identifier)) {
            info.parentIdentifier = null;
        }
    }

    public CubeInfo createModel(ModelBase base) {
        this.modelCube = new ModelRenderer(base, this.txOffset[0], this.txOffset[1]);
        this.modelCube.field_78809_i = this.txMirror;
        this.modelCube.func_78793_a((float)this.position[0], (float)this.position[1], (float)this.position[2]);
        this.modelCube.func_78790_a((float)this.offset[0], (float)this.offset[1], (float)this.offset[2], this.dimensions[0], this.dimensions[1], this.dimensions[2], (float)this.mcScale);
        this.modelCube.field_78795_f = (float)Math.toRadians(this.rotation[0]);
        this.modelCube.field_78796_g = (float)Math.toRadians(this.rotation[1]);
        this.modelCube.field_78808_h = (float)Math.toRadians(this.rotation[2]);
        this.createChildren(base);
        return this;
    }

    public void createChildren(ModelBase base) {
        for (CubeInfo child : this.getChildren()) {
            child.modelCube = new ModelRenderer(base, child.txOffset[0], child.txOffset[1]);
            child.modelCube.field_78809_i = child.txMirror;
            child.modelCube.func_78789_a((float)child.offset[0], (float)child.offset[1], (float)child.offset[2], child.dimensions[0], child.dimensions[1], child.dimensions[2]);
            child.modelCube.func_78793_a((float)child.position[0], (float)child.position[1], (float)child.position[2]);
            child.modelCube.field_78795_f = (float)Math.toRadians(child.rotation[0]);
            child.modelCube.field_78796_g = (float)Math.toRadians(child.rotation[1]);
            child.modelCube.field_78808_h = (float)Math.toRadians(child.rotation[2]);
            this.modelCube.func_78792_a(child.modelCube);
            child.createChildren(base);
        }
    }

    public ArrayList<CubeInfo> getChildren() {
        return this.children;
    }
}

