/*
 * Decompiled with CFR 0.152.
 */
package us.ichun.mods.ichunutil.common.module.worldportals;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import us.ichun.mods.ichunutil.common.module.worldportals.WorldPortalCarrier;

public class WorldPortalInfo {
    public WorldPortalCarrier parent;
    public int orientation = 0;
    public int face = 0;
    public boolean horizontal = false;
    public double height = 3.0;
    public double width = 1.5;
    public double offsetHeight = 1.0;
    public double offsetDepth = 0.1;
    public boolean active = true;
    public boolean project = false;
    public int teleport = 1;
    public String channelName = "Unnamed";
    public WorldPortalInfo link;

    public void setParent(WorldPortalCarrier te) {
        this.parent = te;
    }

    public void update() {
    }

    public void transverseTo(WorldPortalInfo otherPortal) {
    }

    public void write(NBTTagCompound tag) {
        tag.func_74768_a("orientation", this.orientation);
        tag.func_74768_a("face", this.face);
        tag.func_74757_a("horizontal", this.horizontal);
        tag.func_74780_a("height", this.height);
        tag.func_74780_a("width", this.width);
        tag.func_74780_a("offsetHeight", this.offsetHeight);
        tag.func_74780_a("offsetDepth", this.offsetDepth);
        tag.func_74757_a("active", this.active);
        tag.func_74757_a("project", this.project);
        tag.func_74768_a("teleport", this.teleport);
        tag.func_74778_a("channelName", this.channelName);
        if (this.link != null) {
            NBTTagCompound linkTag = new NBTTagCompound();
            this.link.write(linkTag);
            tag.func_74782_a("linkInfo", (NBTBase)linkTag);
        }
    }

    public void readSelfInfo(NBTTagCompound tag) {
        this.orientation = tag.func_74762_e("orientation");
        this.face = tag.func_74762_e("face");
        this.horizontal = tag.func_74767_n("horizontal");
        this.height = tag.func_74769_h("height");
        this.width = tag.func_74769_h("width");
        this.offsetHeight = tag.func_74769_h("offsetHeight");
        this.offsetDepth = tag.func_74769_h("offsetDepth");
        this.active = tag.func_74767_n("active");
        this.project = tag.func_74767_n("project");
        this.teleport = tag.func_74762_e("teleport");
        this.channelName = tag.func_74779_i("channelName");
        if (this.height < 0.1) {
            this.height = 0.1;
        }
        if (this.width < 0.05) {
            this.width = 0.05;
        }
        if (tag.func_74764_b("linkInfo")) {
            this.link = new WorldPortalInfo();
            this.link.read(tag.func_74775_l("linkInfo"));
        }
    }

    public void read(NBTTagCompound tag) {
        this.readSelfInfo(tag);
    }

    public AxisAlignedBB getScanZone() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(World world, double x, double y, double z, float f) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.field_71474_y.field_74330_P || this.active && this.project && this.link == null)) {
            return;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179089_o();
        this.orientPlane();
        if (mc.field_71474_y.field_74330_P) {
            GlStateManager.func_179090_x();
            GlStateManager.func_179133_A();
            GlStateManager.func_179140_f();
            GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
            this.renderPlane();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179145_e();
            GlStateManager.func_179108_z();
            GlStateManager.func_179098_w();
        }
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();
    }

    @SideOnly(value=Side.CLIENT)
    public void orientPlane() {
        GlStateManager.func_179137_b((double)0.0, (double)(0.5 + this.height / 2.0 + this.offsetHeight), (double)0.0);
        if (this.horizontal) {
            GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GlStateManager.func_179114_b((float)((float)this.orientation * 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(-this.offsetDepth));
    }

    public void renderPlane() {
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_178970_b();
        worldRenderer.func_178984_b(-this.width, this.height / 2.0, 0.0);
        worldRenderer.func_178984_b(-this.width, -(this.height / 2.0), 0.0);
        worldRenderer.func_178984_b(this.width, -(this.height / 2.0), 0.0);
        worldRenderer.func_178984_b(this.width, this.height / 2.0, 0.0);
        tessellator.func_78381_a();
    }
}

