/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common;

import buildcraft.api.fuels.BuildcraftFuelRegistry;
import buildcraft.api.fuels.IFuel;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.common.FuelHandler;
import mekanism.common.IModule;
import mekanism.common.Mekanism;
import mekanism.common.Version;
import mekanism.common.item.ItemMekanism;
import mekanism.common.recipe.MekanismRecipe;
import mekanism.generators.common.GeneratorsCommonProxy;
import mekanism.generators.common.GeneratorsGuiHandler;
import mekanism.generators.common.block.BlockGenerator;
import mekanism.generators.common.item.ItemBlockGenerator;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.fluids.FluidRegistry;

@Mod(modid="MekanismGenerators", name="MekanismGenerators", version="7.1.1", dependencies="required-after:Mekanism", guiFactory="mekanism.generators.client.gui.GeneratorsGuiFactory")
public class MekanismGenerators
implements IModule {
    @SidedProxy(clientSide="mekanism.generators.client.GeneratorsClientProxy", serverSide="mekanism.generators.common.GeneratorsCommonProxy")
    public static GeneratorsCommonProxy proxy;
    @Mod.Instance(value="MekanismGenerators")
    public static MekanismGenerators instance;
    public static Version versionNumber;
    public static Item SolarPanel;
    public static Block Generator;
    public static double advancedSolarGeneration;
    public static double bioGeneration;
    public static double heatGeneration;
    public static double heatGenerationLava;
    public static double heatGenerationNether;
    public static double solarGeneration;
    public static double windGenerationMin;
    public static double windGenerationMax;
    public static int windGenerationMinY;
    public static int windGenerationMaxY;

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (ModAPIManager.INSTANCE.hasAPI("BuildCraftAPI|fuels") && BuildcraftFuelRegistry.fuel != null) {
            for (IFuel s : BuildcraftFuelRegistry.fuel.getFuels()) {
                if (s.getFluid() == null || GasRegistry.containsGas((String)s.getFluid().getName())) continue;
                GasRegistry.register((Gas)new Gas(s.getFluid()));
            }
            BuildcraftFuelRegistry.fuel.addFuel(FluidRegistry.getFluid((String)"ethene"), (int)(240.0 * Mekanism.TO_TE), 40000);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Mekanism.modulesLoaded.add(this);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GeneratorsGuiHandler());
        FMLCommonHandler.instance().bus().register((Object)this);
        proxy.loadConfiguration();
        proxy.registerSpecialTileEntities();
        proxy.registerRenderInformation();
        this.addBlocks();
        this.addItems();
        this.addRecipes();
        Mekanism.logger.info("Loaded MekanismGenerators module.");
    }

    public void addRecipes() {
        CraftingManager.func_77594_a().func_77592_b().add(new MekanismRecipe(new ItemStack(Generator, 1, 0), new Object[]{"III", "WOW", "CFC", Character.valueOf('I'), "ingotIron", Character.valueOf('C'), "ingotCopper", Character.valueOf('O'), "ingotOsmium", Character.valueOf('F'), Blocks.field_150460_al, Character.valueOf('W'), Blocks.field_150344_f}));
        CraftingManager.func_77594_a().func_77592_b().add(new MekanismRecipe(new ItemStack(Generator, 1, 1), new Object[]{"SSS", "AIA", "PEP", Character.valueOf('S'), SolarPanel, Character.valueOf('A'), Mekanism.EnrichedAlloy, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('P'), "dustOsmium", Character.valueOf('E'), Mekanism.EnergyTablet.getUnchargedItem()}));
        CraftingManager.func_77594_a().func_77592_b().add(new MekanismRecipe(new ItemStack(Generator, 1, 5), new Object[]{"SES", "SES", "III", Character.valueOf('S'), new ItemStack(Generator, 1, 1), Character.valueOf('E'), Mekanism.EnrichedAlloy, Character.valueOf('I'), Items.field_151042_j}));
        CraftingManager.func_77594_a().func_77592_b().add(new MekanismRecipe(new ItemStack(Generator, 1, 4), new Object[]{"RER", "BCB", "NEN", Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('E'), Mekanism.EnrichedAlloy, Character.valueOf('B'), Mekanism.BioFuel, Character.valueOf('C'), "circuitBasic", Character.valueOf('N'), Items.field_151042_j}));
        CraftingManager.func_77594_a().func_77592_b().add(new MekanismRecipe(new ItemStack(Generator, 1, 3), new Object[]{"PEP", "ICI", "PEP", Character.valueOf('P'), "ingotOsmium", Character.valueOf('E'), Mekanism.EnrichedAlloy, Character.valueOf('I'), new ItemStack(Mekanism.BasicBlock, 1, 8), Character.valueOf('C'), Mekanism.ElectrolyticCore}));
        CraftingManager.func_77594_a().func_77592_b().add(new MekanismRecipe(new ItemStack(SolarPanel), new Object[]{"GGG", "RAR", "PPP", Character.valueOf('G'), Blocks.field_150410_aZ, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('A'), Mekanism.EnrichedAlloy, Character.valueOf('P'), "ingotOsmium"}));
        CraftingManager.func_77594_a().func_77592_b().add(new MekanismRecipe(new ItemStack(Generator, 1, 6), new Object[]{" O ", "OAO", "ECE", Character.valueOf('O'), "ingotOsmium", Character.valueOf('A'), Mekanism.EnrichedAlloy, Character.valueOf('E'), Mekanism.EnergyTablet.getUnchargedItem(), Character.valueOf('C'), "circuitBasic"}));
        FuelHandler.addGas((Gas)GasRegistry.getGas((String)"ethene"), (int)40, (double)(Mekanism.FROM_H2 + bioGeneration * 80.0));
    }

    public void addBlocks() {
        Generator = new BlockGenerator().func_149663_c("Generator");
        GameRegistry.registerBlock((Block)Generator, ItemBlockGenerator.class, (String)"Generator");
    }

    public void addItems() {
        SolarPanel = new ItemMekanism().func_77655_b("SolarPanel");
        GameRegistry.registerItem((Item)SolarPanel, (String)"SolarPanel");
    }

    public Version getVersion() {
        return versionNumber;
    }

    public String getName() {
        return "Generators";
    }

    public void writeConfig(ByteBuf dataStream) throws IOException {
        dataStream.writeDouble(advancedSolarGeneration);
        dataStream.writeDouble(bioGeneration);
        dataStream.writeDouble(heatGeneration);
        dataStream.writeDouble(heatGenerationLava);
        dataStream.writeDouble(heatGenerationNether);
        dataStream.writeDouble(solarGeneration);
        dataStream.writeDouble(windGenerationMin);
        dataStream.writeDouble(windGenerationMax);
        dataStream.writeInt(windGenerationMinY);
        dataStream.writeInt(windGenerationMaxY);
    }

    public void readConfig(ByteBuf dataStream) throws IOException {
        advancedSolarGeneration = dataStream.readDouble();
        bioGeneration = dataStream.readDouble();
        heatGeneration = dataStream.readDouble();
        heatGenerationLava = dataStream.readDouble();
        heatGenerationNether = dataStream.readDouble();
        solarGeneration = dataStream.readDouble();
        windGenerationMin = dataStream.readDouble();
        windGenerationMax = dataStream.readDouble();
        windGenerationMinY = dataStream.readInt();
        windGenerationMaxY = dataStream.readInt();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("MekanismGenerators")) {
            proxy.loadConfiguration();
        }
    }

    static {
        versionNumber = new Version(7, 1, 1);
    }
}

