/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.FuelHandler;
import mekanism.common.ISustainedData;
import mekanism.common.Mekanism;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityGasGenerator
extends TileEntityGenerator
implements IGasHandler,
ITubeConnection,
ISustainedData {
    public int MAX_GAS = 18000;
    public GasTank fuelTank;
    public int burnTicks = 0;
    public double generationRate = 0.0;

    public TileEntityGasGenerator() {
        super("GasGenerator", Mekanism.FROM_H2 * 100.0, Mekanism.FROM_H2 * 2.0);
        this.inventory = new ItemStack[2];
        this.fuelTank = new GasTank(this.MAX_GAS);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.charge((int)1, (TileEntityElectricBlock)this);
            if (this.inventory[0] != null && this.fuelTank.getStored() < this.MAX_GAS) {
                Gas gasType = null;
                if (this.fuelTank.getGas() != null) {
                    gasType = this.fuelTank.getGas().getGas();
                } else if (this.inventory[0] != null && this.inventory[0].func_77973_b() instanceof IGasItem && ((IGasItem)this.inventory[0].func_77973_b()).getGas(this.inventory[0]) != null) {
                    gasType = ((IGasItem)this.inventory[0].func_77973_b()).getGas(this.inventory[0]).getGas();
                }
                if (gasType != null && FuelHandler.getFuel((Gas)gasType) != null) {
                    GasStack removed = GasTransmission.removeGas((ItemStack)this.inventory[0], (Gas)gasType, (int)this.fuelTank.getNeeded());
                    this.fuelTank.receive(removed, true);
                }
            }
            if (this.canOperate()) {
                this.setActive(true);
                if (this.burnTicks > 0) {
                    --this.burnTicks;
                    this.setEnergy(this.electricityStored + this.generationRate);
                } else if (this.fuelTank.getStored() > 0) {
                    FuelHandler.FuelGas fuel = FuelHandler.getFuel((Gas)this.fuelTank.getGas().getGas());
                    if (fuel != null) {
                        this.burnTicks = fuel.burnTicks - 1;
                        this.generationRate = fuel.energyPerTick;
                        this.fuelTank.draw(1, true);
                        this.setEnergy(this.getEnergy() + this.generationRate);
                    }
                } else {
                    this.burnTicks = 0;
                    this.generationRate = 0.0;
                }
            } else {
                this.setActive(false);
            }
        }
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted((ItemStack)itemstack, (boolean)true);
        }
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) == null;
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) != null && FuelHandler.getFuel((Gas)((IGasItem)itemstack.func_77973_b()).getGas(itemstack).getGas()) != null;
        }
        if (slotID == 1) {
            return ChargeUtils.canBeCharged((ItemStack)itemstack);
        }
        return true;
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (ForgeDirection.getOrientation((int)side) == MekanismUtils.getRight((int)this.facing)) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        return nArray;
    }

    @Override
    public boolean canOperate() {
        return this.getEnergy() < this.getMaxEnergy() && this.fuelTank.getStored() > 0 && MekanismUtils.canFunction((TileEntity)this);
    }

    public int getScaledGasLevel(int i) {
        return this.fuelTank.getStored() * i / this.MAX_GAS;
    }

    @Optional.Method(modid="ComputerCraft")
    public String[] getMethodNames() {
        return new String[]{"getStored", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getGas", "getGasNeeded"};
    }

    @Optional.Method(modid="ComputerCraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.output};
            }
            case 2: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 3: {
                return new Object[]{this.getMaxEnergy() - this.getEnergy()};
            }
            case 4: {
                return new Object[]{this.fuelTank.getStored()};
            }
            case 5: {
                return new Object[]{this.fuelTank.getNeeded()};
            }
        }
        Mekanism.logger.error("Attempted to call unknown method with computer ID " + computer.getID());
        return null;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (dataStream.readBoolean()) {
            this.fuelTank.setGas(new GasStack(GasRegistry.getGas((int)dataStream.readInt()), dataStream.readInt()));
        } else {
            this.fuelTank.setGas(null);
        }
        this.generationRate = dataStream.readDouble();
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        if (this.fuelTank.getGas() != null) {
            data.add(true);
            data.add(this.fuelTank.getGas().getGas().getID());
            data.add(this.fuelTank.getStored());
        } else {
            data.add(false);
        }
        data.add(this.generationRate);
        return data;
    }

    public int receiveGas(ForgeDirection side, GasStack stack) {
        if (this.fuelTank.getGas() == null || this.fuelTank.getGas().isGasEqual(stack)) {
            return this.fuelTank.receive(stack, true);
        }
        return 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.fuelTank.read(nbtTags.func_74775_l("fuelTank"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74782_a("fuelTank", (NBTBase)this.fuelTank.write(new NBTTagCompound()));
    }

    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return FuelHandler.getFuel((Gas)type) != null && side != ForgeDirection.getOrientation((int)this.facing);
    }

    public GasStack drawGas(ForgeDirection side, int amount) {
        return null;
    }

    public boolean canDrawGas(ForgeDirection side, Gas type) {
        return false;
    }

    public boolean canTubeConnect(ForgeDirection side) {
        return side != ForgeDirection.getOrientation((int)this.facing);
    }

    public void writeSustainedData(ItemStack itemStack) {
        if (this.fuelTank != null) {
            itemStack.field_77990_d.func_74782_a("fuelTank", (NBTBase)this.fuelTank.write(new NBTTagCompound()));
        }
    }

    public void readSustainedData(ItemStack itemStack) {
        if (itemStack.field_77990_d.func_74764_b("fuelTank")) {
            this.fuelTank.read(itemStack.field_77990_d.func_74775_l("fuelTank"));
        }
    }
}

