/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.client.sound.IHasSound;
import mekanism.common.IActiveState;
import mekanism.common.IRedstoneControl;
import mekanism.common.Mekanism;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.CableUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="dan200.computercraft.api.peripheral.IPeripheral", modid="ComputerCraft")
public abstract class TileEntityGenerator
extends TileEntityElectricBlock
implements IPeripheral,
IActiveState,
IHasSound,
IRedstoneControl {
    public double output;
    public boolean isActive;
    public boolean clientActive;
    public int updateDelay;
    public IRedstoneControl.RedstoneControl controlType;

    public TileEntityGenerator(String name, double maxEnergy, double out) {
        super(name, maxEnergy);
        this.output = out;
        this.isActive = false;
        this.controlType = IRedstoneControl.RedstoneControl.DISABLED;
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K) {
            Mekanism.proxy.registerSound((Object)this);
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    this.isActive = this.clientActive;
                    MekanismUtils.updateBlock((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
                }
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    this.clientActive = this.isActive;
                    Mekanism.packetHandler.sendToReceivers((IMessage)new PacketTileEntity.TileEntityMessage(Coord4D.get((TileEntity)this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get((TileEntity)this)));
                }
            }
            if (MekanismUtils.canFunction((TileEntity)this)) {
                CableUtils.emit((TileEntityElectricBlock)this);
            }
        }
    }

    public double getMaxOutput() {
        return this.output;
    }

    protected EnumSet<ForgeDirection> getConsumingSides() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    public EnumSet<ForgeDirection> getOutputtingSides() {
        return EnumSet.of(ForgeDirection.getOrientation((int)this.facing));
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            Mekanism.proxy.unregisterSound((TileEntity)this);
        }
    }

    public abstract boolean canOperate();

    public boolean getActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            Mekanism.packetHandler.sendToReceivers((IMessage)new PacketTileEntity.TileEntityMessage(Coord4D.get((TileEntity)this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get((TileEntity)this)));
            this.updateDelay = Mekanism.UPDATE_DELAY;
            this.clientActive = active;
        }
    }

    @Optional.Method(modid="ComputerCraft")
    public String getType() {
        return this.func_145825_b();
    }

    @Optional.Method(modid="ComputerCraft")
    public void attach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public void detach(IComputerAccess computer) {
    }

    @Optional.Method(modid="ComputerCraft")
    public boolean equals(IPeripheral other) {
        return this == other;
    }

    public boolean canSetFacing(int side) {
        return side != 0 && side != 1;
    }

    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        this.clientActive = dataStream.readBoolean();
        this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
        if (this.updateDelay == 0 && this.clientActive != this.isActive) {
            this.updateDelay = Mekanism.UPDATE_DELAY;
            this.isActive = this.clientActive;
            MekanismUtils.updateBlock((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        }
    }

    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        data.add(this.controlType.ordinal());
        return data;
    }

    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
    }

    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public String getSoundPath() {
        return this.fullName.replace("Advanced", "") + ".ogg";
    }

    public float getVolumeMultiplier() {
        return 1.0f;
    }

    public boolean renderUpdate() {
        return true;
    }

    public boolean lightUpdate() {
        return true;
    }

    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk((TileEntity)this);
    }
}

